/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.graphic.GraphicCollection3D;
import org.meteoinfo.chart.jogl.pipe.PipeShape;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.geo.drawing.ContourDraw;
import org.meteoinfo.geo.drawing.Draw;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.ImageGraphic;
import org.meteoinfo.geometry.legend.ArrowLineBreak;
import org.meteoinfo.geometry.legend.ArrowPolygonBreak;
import org.meteoinfo.geometry.legend.BarBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.ArcShape;
import org.meteoinfo.geometry.shape.BarShape;
import org.meteoinfo.geometry.shape.CapPolylineShape;
import org.meteoinfo.geometry.shape.CubicShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.CylinderShape;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.RectangleShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindArrow3D;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import wcontour.Contour;
import wcontour.global.Point3D;
import wcontour.global.PointD;
import wcontour.global.PolyLine;
import wcontour.global.PolyLine3D;
import wcontour.global.Polygon;

public class GraphicFactory {
    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
                continue;
            }
            points.add(new org.meteoinfo.common.PointD(x, y));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cb));
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, ColorBreak cb, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        if (xdata.getRank() == 1) {
            Object pls;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    continue;
                }
                points.add(new org.meteoinfo.common.PointD(x, y));
            }
            if (!points.isEmpty()) {
                if (points.size() == 1) {
                    points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                }
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                Object pls;
                points = new ArrayList();
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new org.meteoinfo.common.PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, List<ColorBreak> cbs, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        if (xdata.getRank() == 1) {
            ColorBreak cb;
            Object pls;
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    cb = cbs.get(i);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    ++i;
                    continue;
                }
                points.add(new org.meteoinfo.common.PointD(x, y));
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                cb = cbs.get(i);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                Object pls;
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                ColorBreak cb = cbs.get(j);
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new org.meteoinfo.common.PointD(x, y));
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createLineString(Array xdata, Array ydata, Array zdata, LegendScheme ls, boolean iscurve) {
        GraphicCollection gc = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if (xdata.getRank() == 1) {
            Object pls;
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            ColorBreakCollection cbc = new ColorBreakCollection();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                double z = zIter.getDoubleNext();
                ColorBreak cb = ls.findLegendBreak((Number)z);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                    }
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
                    points = new ArrayList();
                    cbc = new ColorBreakCollection();
                    continue;
                }
                points.add(new org.meteoinfo.common.PointD(x, y));
                cbc.add(cb);
            }
            if (points.size() > 1) {
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
            }
            gc.setLegendScheme(ls);
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                Object pls;
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                ColorBreakCollection cbc = new ColorBreakCollection();
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    double z = zIter.getDoubleNext();
                    ColorBreak cb = ls.findLegendBreak((Number)z);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                        }
                        pls = iscurve ? new CurveLineShape() : new PolylineShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
                        points = new ArrayList();
                        cbc = new ColorBreakCollection();
                        continue;
                    }
                    points.add(new org.meteoinfo.common.PointD(x, y));
                    cbc.add(cb);
                }
                if (points.size() <= 1) continue;
                pls = iscurve ? new CurveLineShape() : new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbc));
            }
            gc.setLegendScheme(ls);
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createLineString(XYListDataset data, List<ColorBreak> cbs) {
        GraphicCollection gc = new GraphicCollection();
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < data.getItemCount(i); ++j) {
                double x = data.getX(i, j);
                double y = data.getY(i, j);
                points.add(new org.meteoinfo.common.PointD(x, y));
            }
            PolylineShape pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cbs.get(i)));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    continue;
                }
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            ColorBreak cb;
            PolylineZShape pls;
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    cb = cbs.get(i);
                    gc.add(new Graphic((Shape)pls, cb));
                    points = new ArrayList();
                    ++i;
                    continue;
                }
                points.add(new PointZ(x, y, z));
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                cb = cbs.get(i);
                gc.add(new Graphic((Shape)pls, cb));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreak cb = cbs.get(j);
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, cb));
                        points = new ArrayList();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
            }
        }
        return gc;
    }

    public static GraphicCollection3D lineString3DToPipe(GraphicCollection3D lines, float radius, int steps) {
        for (Graphic graphic : lines.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            PipeShape pipeShape = new PipeShape(shape, radius, steps);
            graphic.setShape((Shape)pipeShape);
        }
        return lines;
    }

    public static GraphicCollection createLineString3D(Array xdata, Array ydata, Array zdata, Array mdata, LegendScheme ls) {
        GraphicCollection3D gc = new GraphicCollection3D();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        double z = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator mIter = mdata.getIndexIterator();
        boolean fixZ = false;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        if (xdata.getRank() == 1) {
            PolylineZShape pls;
            ColorBreakCollection cbs = new ColorBreakCollection();
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (!fixZ) {
                    z = zIter.getDoubleNext();
                }
                double m = mIter.getDoubleNext();
                ColorBreak cb = ls.findLegendBreak((Number)m);
                if (Double.isNaN(y) || Double.isNaN(x)) {
                    if (points.isEmpty()) continue;
                    if (points.size() == 1) {
                        points.add((PointZ)((PointZ)points.get(0)).clone());
                    }
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                    points = new ArrayList();
                    cbs = new ColorBreakCollection();
                    continue;
                }
                points.add(new PointZ(x, y, z));
                cbs.add(cb);
            }
            if (points.size() > 1) {
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
            }
        } else {
            int[] shape = xdata.getShape();
            int yn = shape[0];
            int xn = shape[1];
            for (int j = 0; j < yn; ++j) {
                PolylineZShape pls;
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int i = 0; i < xn; ++i) {
                    double x = xIter.getDoubleNext();
                    double y = yIter.getDoubleNext();
                    if (!fixZ) {
                        z = zIter.getDoubleNext();
                    }
                    double m = mIter.getDoubleNext();
                    ColorBreak cb = ls.findLegendBreak((Number)m);
                    if (Double.isNaN(y) || Double.isNaN(x)) {
                        if (points.isEmpty()) continue;
                        if (points.size() == 1) {
                            points.add((PointZ)((PointZ)points.get(0)).clone());
                        }
                        pls = new PolylineZShape();
                        pls.setPoints(points);
                        gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                        points = new ArrayList();
                        cbs = new ColorBreakCollection();
                        continue;
                    }
                    points.add(new PointZ(x, y, z));
                    cbs.add(cb);
                }
                if (points.size() <= 1) continue;
                pls = new PolylineZShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cbs));
                points = new ArrayList();
            }
        }
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createErrorLineString(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, PolylineBreak cb, PolylineBreak ecb, float capSize) {
        PolylineShape pls;
        IndexIterator yeuIter;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator xelIter = xErrorLeft == null ? null : xErrorLeft.getIndexIterator();
        IndexIterator xerIter = xErrorRight == null ? null : xErrorRight.getIndexIterator();
        IndexIterator yebIter = yErrorBottom == null ? null : yErrorBottom.getIndexIterator();
        IndexIterator indexIterator = yeuIter = yErrorUp == null ? null : yErrorUp.getIndexIterator();
        while (xIter.hasNext()) {
            CapPolylineShape epls;
            ArrayList<org.meteoinfo.common.PointD> eps;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, (ColorBreak)cb));
                points = new ArrayList();
                if (yebIter != null) {
                    yebIter.next();
                    yeuIter.next();
                }
                if (xelIter == null) continue;
                xelIter.next();
                xerIter.next();
                continue;
            }
            points.add(new org.meteoinfo.common.PointD(x, y));
            if (yebIter != null) {
                double yerrB = yebIter.getDoubleNext();
                double yerrU = yeuIter.getDoubleNext();
                eps = new ArrayList<org.meteoinfo.common.PointD>();
                eps.add(new org.meteoinfo.common.PointD(x, y + yerrU));
                eps.add(new org.meteoinfo.common.PointD(x, y - yerrB));
                epls = new CapPolylineShape();
                epls.setCapLen(capSize);
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, (ColorBreak)ecb));
            }
            if (xelIter == null) continue;
            double xerrL = xelIter.getDoubleNext();
            double xerrR = xerIter.getDoubleNext();
            eps = new ArrayList();
            eps.add(new org.meteoinfo.common.PointD(x - xerrL, y));
            eps.add(new org.meteoinfo.common.PointD(x + xerrR, y));
            epls = new CapPolylineShape();
            epls.setCapLen(capSize);
            epls.setCapAngle(90.0f);
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, (ColorBreak)ecb));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, (ColorBreak)cb));
        }
        gc.setSingleLegend(false);
        PolylineBreak lb = (PolylineBreak)ecb.clone();
        lb.setDrawSymbol(cb.getDrawSymbol());
        gc.setLegendBreak((ColorBreak)lb);
        return gc;
    }

    public static GraphicCollection createErrorLineString_bak1(Array xdata, Array ydata, Array xErrorLeft, Array xErrorRight, Array yErrorBottom, Array yErrorUp, ColorBreak cb, ColorBreak ecb, Double capSize) {
        PolylineShape pls;
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator xelIter = xErrorLeft == null ? null : xErrorLeft.getIndexIterator();
        IndexIterator xerIter = xErrorRight == null ? null : xErrorRight.getIndexIterator();
        IndexIterator yebIter = yErrorBottom == null ? null : yErrorBottom.getIndexIterator();
        IndexIterator yeuIter = yErrorUp == null ? null : yErrorUp.getIndexIterator();
        double width = capSize == null ? (ArrayMath.getMaximum((Array)xdata) - ArrayMath.getMinimum((Array)xdata)) / (double)xdata.getSize() * 0.1 : capSize * 0.5;
        while (xIter.hasNext()) {
            PolylineShape epls;
            ArrayList<org.meteoinfo.common.PointD> eps;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(y) || Double.isNaN(x)) {
                if (points.isEmpty()) continue;
                if (points.size() == 1) {
                    points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                }
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                points = new ArrayList();
                if (yebIter != null) {
                    yebIter.next();
                    yeuIter.next();
                }
                if (xelIter == null) continue;
                xelIter.next();
                xerIter.next();
                continue;
            }
            points.add(new org.meteoinfo.common.PointD(x, y));
            if (yErrorBottom != null) {
                double yerrB = yebIter.getDoubleNext();
                double yerrU = yeuIter.getDoubleNext();
                eps = new ArrayList<org.meteoinfo.common.PointD>();
                eps.add(new org.meteoinfo.common.PointD(x, y + yerrU));
                eps.add(new org.meteoinfo.common.PointD(x, y - yerrB));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
                eps = new ArrayList();
                eps.add(new org.meteoinfo.common.PointD(x - width, y + yerrU));
                eps.add(new org.meteoinfo.common.PointD(x + width, y + yerrU));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
                eps = new ArrayList();
                eps.add(new org.meteoinfo.common.PointD(x - width, y - yerrB));
                eps.add(new org.meteoinfo.common.PointD(x + width, y - yerrB));
                epls = new PolylineShape();
                epls.setPoints(eps);
                gc.add(new Graphic((Shape)epls, ecb));
            }
            if (xErrorLeft == null) continue;
            double xerrL = xelIter.getDoubleNext();
            double xerrR = xerIter.getDoubleNext();
            eps = new ArrayList();
            eps.add(new org.meteoinfo.common.PointD(x - xerrL, y));
            eps.add(new org.meteoinfo.common.PointD(x + xerrR, y));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
            eps = new ArrayList();
            eps.add(new org.meteoinfo.common.PointD(x - xerrL, y - width));
            eps.add(new org.meteoinfo.common.PointD(x - xerrL, y + width));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
            eps = new ArrayList();
            eps.add(new org.meteoinfo.common.PointD(x + xerrR, y - width));
            eps.add(new org.meteoinfo.common.PointD(x + xerrR, y + width));
            epls = new PolylineShape();
            epls.setPoints(eps);
            gc.add(new Graphic((Shape)epls, ecb));
        }
        if (!points.isEmpty()) {
            if (points.size() == 1) {
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
            }
            pls = new PolylineShape();
            pls.setPoints(points);
            gc.add(new Graphic((Shape)pls, cb));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static GraphicCollection createStepLineString(Array xdata, Array ydata, ColorBreak cb, String where) {
        GraphicCollection gc = new GraphicCollection();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        switch (where) {
            case "mid": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y1 = ydata.getDouble(i);
                    double y2 = ydata.getDouble(i + 1);
                    if (Double.isNaN(y1) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        double x = x1 + (x2 - x1) * 0.5;
                        if (i == 0) {
                            points.add(new org.meteoinfo.common.PointD(x1, y1));
                            points.add(new org.meteoinfo.common.PointD(x, y1));
                            points.add(new org.meteoinfo.common.PointD(x, y2));
                        } else if ((long)i == xdata.getSize() - 2L) {
                            points.add(new org.meteoinfo.common.PointD(x, y1));
                            points.add(new org.meteoinfo.common.PointD(x, y2));
                            points.add(new org.meteoinfo.common.PointD(x2, y2));
                        } else {
                            points.add(new org.meteoinfo.common.PointD(x, y1));
                            points.add(new org.meteoinfo.common.PointD(x, y2));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                break;
            }
            case "post": {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        points.add(new org.meteoinfo.common.PointD(x1, y));
                        points.add(new org.meteoinfo.common.PointD(x2, y));
                        if ((long)i == xdata.getSize() - 2L) {
                            points.add(new org.meteoinfo.common.PointD(x2, ydata.getDouble(i + 1)));
                        }
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
                break;
            }
            default: {
                PolylineShape pls;
                int i = 0;
                while ((long)i < xdata.getSize() - 1L) {
                    double x1 = xdata.getDouble(i);
                    double x2 = xdata.getDouble(i + 1);
                    double y = ydata.getDouble(i + 1);
                    if (Double.isNaN(y) || Double.isNaN(x1) || Double.isNaN(x2)) {
                        if (!points.isEmpty() && points.size() > 1) {
                            pls = new PolylineShape();
                            pls.setPoints(points);
                            gc.add(new Graphic((Shape)pls, cb));
                            points = new ArrayList();
                        }
                    } else {
                        if (i == 0) {
                            points.add(new org.meteoinfo.common.PointD(x1, ydata.getDouble(i)));
                        }
                        points.add(new org.meteoinfo.common.PointD(x1, y));
                        points.add(new org.meteoinfo.common.PointD(x2, y));
                    }
                    ++i;
                }
                if (points.size() <= 1) break;
                pls = new PolylineShape();
                pls.setPoints(points);
                gc.add(new Graphic((Shape)pls, cb));
            }
        }
        return gc;
    }

    public static GraphicCollection createGraphics(Array xdata, Array ydata, ColorBreak cb) {
        GraphicCollection graphics = new GraphicCollection();
        if (cb instanceof PolylineBreak) {
            graphics.add((Graphic)GraphicFactory.createLineString(xdata, ydata, cb));
        } else {
            IndexIterator xIter = xdata.getIndexIterator();
            IndexIterator yIter = ydata.getIndexIterator();
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cb));
            }
        }
        return graphics;
    }

    public static Graphic createPoint(float x, float y, PointBreak pb) {
        PointShape ps = new PointShape();
        ps.setPoint(new org.meteoinfo.common.PointD((double)x, (double)y));
        return new Graphic((Shape)ps, (ColorBreak)pb);
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, PointBreak pb) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            PointShape ps = new PointShape();
            ps.setPoint(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
            graphics.add(new Graphic((Shape)ps, (ColorBreak)pb));
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, List<ColorBreak> cbs) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.SINGLE_SYMBOL);
                ls.setShapeType(ShapeTypes.POINT);
                graphics.setLegendScheme(ls);
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints(Array xdata, Array ydata, Array zdata, LegendScheme ls) {
        GraphicCollection graphics = new GraphicCollection();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        while (xIter.hasNext()) {
            PointShape ps = new PointShape();
            ps.setPoint(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
            double z = zIter.getDoubleNext();
            ColorBreak cb = ls.findLegendBreak((Number)z);
            graphics.add(new Graphic((Shape)ps, cb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, ColorBreak cb) {
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        cbs.add(cb);
        return GraphicFactory.createPoints3D(xdata, ydata, zdata, cbs);
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), z));
                } else {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), zIter.getDoubleNext()));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                if (fixZ) {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), z));
                } else {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), zIter.getDoubleNext()));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
                LegendScheme ls = new LegendScheme();
                ls.setLegendBreaks(cbs);
                ls.setLegendType(LegendType.SINGLE_SYMBOL);
                ls.setShapeType(ShapeTypes.POINT);
                graphics.setLegendScheme(ls);
            }
        }
        return graphics;
    }

    public static GraphicCollection createPoints3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        boolean fixZ = false;
        double z = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        while (xIter.hasNext()) {
            PointZShape ps = new PointZShape();
            if (fixZ) {
                ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), z));
            } else {
                ps.setPoint((org.meteoinfo.common.PointD)new PointZ(xIter.getDoubleNext(), yIter.getDoubleNext(), zIter.getDoubleNext()));
            }
            double c = cIter.getDoubleNext();
            ColorBreak cb = ls.findLegendBreak((Number)c);
            graphics.add(new Graphic((Shape)ps, cb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, List<ColorBreak> cbs, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        GraphicCollection3D stemlines = new GraphicCollection3D();
        boolean fixZ = false;
        double z0 = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z0 = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if ((long)cbs.size() == xdata.getSize()) {
            int i = 0;
            while (xIter.hasNext()) {
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                PointZShape ps = new PointZShape();
                ArrayList<PointZ> pzs = new ArrayList<PointZ>();
                if (fixZ) {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z0));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z0));
                } else {
                    double z = zIter.getDoubleNext();
                    if (Double.isNaN(z)) continue;
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(i)));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cbs.get(i).getColor());
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                } else {
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
                }
                ++i;
            }
            graphics.setSingleLegend(false);
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.UNIQUE_VALUE);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        } else {
            while (xIter.hasNext()) {
                PointZShape ps = new PointZShape();
                ArrayList<PointZ> pzs = new ArrayList<PointZ>();
                double x = xIter.getDoubleNext();
                double y = yIter.getDoubleNext();
                if (fixZ) {
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z0));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z0));
                } else {
                    double z = zIter.getDoubleNext();
                    ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z));
                    pzs.add(new PointZ(x, y, bottom));
                    pzs.add(new PointZ(x, y, z));
                }
                graphics.add(new Graphic((Shape)ps, cbs.get(0)));
                PolylineZShape pls = new PolylineZShape();
                pls.setPoints(pzs);
                if (sameStemColor) {
                    PolylineBreak nplb = (PolylineBreak)plb.clone();
                    nplb.setColor(cbs.get(0).getColor());
                    stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                    continue;
                }
                stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
            }
            LegendScheme ls = new LegendScheme();
            ls.setLegendBreaks(cbs);
            ls.setLegendType(LegendType.SINGLE_SYMBOL);
            ls.setShapeType(ShapeTypes.POINT);
            graphics.setLegendScheme(ls);
        }
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static GraphicCollection[] createStems3D(Array xdata, Array ydata, Array zdata, Array cdata, LegendScheme ls, PolylineBreak plb, double bottom, boolean sameStemColor) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        GraphicCollection3D stemlines = new GraphicCollection3D();
        boolean fixZ = false;
        double z0 = 0.0;
        if (zdata.getSize() == 1L && xdata.getSize() > 1L) {
            fixZ = true;
            z0 = zdata.getDouble(0);
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator cIter = cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            PointZShape ps = new PointZShape();
            ArrayList<PointZ> pzs = new ArrayList<PointZ>();
            if (fixZ) {
                ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z0));
                pzs.add(new PointZ(x, y, bottom));
                pzs.add(new PointZ(x, y, z0));
            } else {
                double z = zIter.getDoubleNext();
                if (Double.isNaN(z)) continue;
                ps.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z));
                pzs.add(new PointZ(x, y, bottom));
                pzs.add(new PointZ(x, y, z));
            }
            double c = cIter.getDoubleNext();
            ColorBreak cb = ls.findLegendBreak((Number)c);
            graphics.add(new Graphic((Shape)ps, cb));
            PolylineZShape pls = new PolylineZShape();
            pls.setPoints(pzs);
            if (sameStemColor) {
                PolylineBreak nplb = (PolylineBreak)plb.clone();
                nplb.setColor(cb.getColor());
                stemlines.add(new Graphic((Shape)pls, (ColorBreak)nplb));
                continue;
            }
            stemlines.add(new Graphic((Shape)pls, (ColorBreak)plb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return new GraphicCollection[]{stemlines, graphics};
    }

    public static Graphic createPolygon(Array xa, Array ya, PolygonBreak pgb) {
        int n = (int)xa.getSize();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xa.getIndexIterator();
        IndexIterator yIter = ya.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            org.meteoinfo.common.PointD p = new org.meteoinfo.common.PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            return graphic;
        }
        return null;
    }

    public static Graphic createPolygon(Array xy, PolygonBreak pgb) {
        int n = xy.getShape()[0];
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator iter = xy.getIndexIterator();
        while (iter.hasNext()) {
            double x = iter.getDoubleNext();
            double y = iter.getDoubleNext();
            org.meteoinfo.common.PointD p = new org.meteoinfo.common.PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            return graphic;
        }
        return null;
    }

    public static GraphicCollection createPolygons(Array xa, Array ya, PolygonBreak pgb) {
        Graphic aGraphic;
        PolygonShape pgs;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xa.getSize();
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = xa.getIndexIterator();
        IndexIterator yIter = ya.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x)) {
                if (points.size() > 2) {
                    pgs = new PolygonShape();
                    pgs.setPoints(points);
                    aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
                    graphics.add(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            org.meteoinfo.common.PointD p = new org.meteoinfo.common.PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            pgs = new PolygonShape();
            pgs.setPoints(points);
            aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            graphics.add(aGraphic);
        }
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, PolylineBreak pb) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        if (!xa.getIndexPrivate().isFastIterator()) {
            xa = xa.copy();
        }
        if (!ya.getIndexPrivate().isFastIterator()) {
            ya = ya.copy();
        }
        if (!za.getIndexPrivate().isFastIterator()) {
            za = za.copy();
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        return graphics;
    }

    public static GraphicCollection createWireframe(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        if (!xa.getIndexPrivate().isFastIterator()) {
            xa = xa.copy();
        }
        if (!ya.getIndexPrivate().isFastIterator()) {
            ya = ya.copy();
        }
        if (!za.getIndexPrivate().isFastIterator()) {
            za = za.copy();
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                PolylineZShape ps = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                ps.setPoints(points);
                double z = (z1 + z3) * 0.5;
                ps.setValue(z);
                PolylineBreak pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                ps.setPoints(points);
                z = (z3 + z4) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                ps.setPoints(points);
                z = (z4 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
                ps = new PolylineZShape();
                points = new ArrayList();
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                ps.setPoints(points);
                z = (z1 + z2) * 0.5;
                ps.setValue(z);
                pb = (PolylineBreak)ls.findLegendBreak((Number)z);
                graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createMeshPolygons(Array xa, Array ya, Array za, LegendScheme ls) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                int idx1 = i * colNum + j;
                int idx2 = i * colNum + j + 1;
                int idx3 = (i + 1) * colNum + j;
                int idx4 = (i + 1) * colNum + j + 1;
                double z1 = za.getDouble(idx1);
                double z2 = za.getDouble(idx2);
                double z3 = za.getDouble(idx3);
                double z4 = za.getDouble(idx4);
                double z = (z1 + z2 + z3 + z4) / 4.0;
                PolygonZShape ps = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                points.add(new PointZ(xa.getDouble(idx1), ya.getDouble(idx1), z1));
                points.add(new PointZ(xa.getDouble(idx3), ya.getDouble(idx3), z3));
                points.add(new PointZ(xa.getDouble(idx4), ya.getDouble(idx4), z4));
                points.add(new PointZ(xa.getDouble(idx2), ya.getDouble(idx2), z2));
                points.add((PointZ)((PointZ)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = z;
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak((Number)z);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                graphics.add(graphic);
            }
        }
        graphics.setAllQuads(true);
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createGraphicsFromLayer(VectorLayer layer, double offset, double xshift) {
        LegendScheme ls;
        GraphicCollection3D graphics;
        block25: {
            graphics = new GraphicCollection3D();
            graphics.setFixZ(true);
            graphics.setZValue(offset);
            ShapeTypes shapeType = layer.getShapeType();
            ls = layer.getLegendScheme();
            switch (shapeType) {
                case POINT: {
                    for (PointShape shape : layer.getShapes()) {
                        PointZShape s = new PointZShape();
                        org.meteoinfo.common.PointD pd = shape.getPoint();
                        PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                        s.setPoint(pz);
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                        graphics.add(new Graphic((Shape)s, cb));
                    }
                    break;
                }
                case POLYLINE: {
                    for (PolylineShape shape : layer.getShapes()) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                        for (Polyline pl : shape.getPolylines()) {
                            PolylineZShape s = new PolylineZShape();
                            ArrayList<PointZ> plist = new ArrayList<PointZ>();
                            for (org.meteoinfo.common.PointD pd : pl.getPointList()) {
                                PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                                plist.add(pz);
                            }
                            s.setPoints(plist);
                            graphics.add(new Graphic((Shape)s, cb));
                        }
                    }
                    break;
                }
                case POLYGON: {
                    for (PolygonShape shape : layer.getShapes()) {
                        PolygonZShape s = new PolygonZShape();
                        ArrayList<PointZ> plist = new ArrayList<PointZ>();
                        for (org.meteoinfo.common.PointD pd : shape.getPoints()) {
                            PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                            plist.add(pz);
                        }
                        s.setPartNum(shape.getPartNum());
                        s.setParts(shape.getParts());
                        s.setPoints(plist);
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                        graphics.add(new Graphic((Shape)s, cb));
                    }
                    break;
                }
                case POINT_Z: 
                case POLYLINE_Z: 
                case POLYGON_Z: {
                    graphics.setFixZ(false);
                    if (xshift == 0.0) {
                        for (Shape shape : layer.getShapes()) {
                            ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                            graphics.add(new Graphic(shape, cb));
                        }
                        break;
                    }
                    switch (shapeType) {
                        case POINT_Z: {
                            for (PointZShape shape : layer.getShapes()) {
                                PointZShape s = new PointZShape();
                                PointZ pd = (PointZ)shape.getPoint();
                                PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z, pd.M);
                                s.setPoint(pz);
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                                graphics.add(new Graphic((Shape)s, cb));
                            }
                            break block25;
                        }
                        case POLYLINE_Z: {
                            for (PolylineZShape shape : layer.getShapes()) {
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                                for (PolylineZ pl : shape.getPolylines()) {
                                    PolylineZShape s = new PolylineZShape();
                                    ArrayList<PointZ> plist = new ArrayList<PointZ>();
                                    for (PointZ pd : pl.getPointList()) {
                                        PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z, pd.M);
                                        plist.add(pz);
                                    }
                                    s.setPoints(plist);
                                    graphics.add(new Graphic((Shape)s, cb));
                                }
                            }
                            break block25;
                        }
                        case POLYGON_Z: {
                            for (PolygonZShape shape : layer.getShapes()) {
                                PolygonZShape s = new PolygonZShape();
                                ArrayList<PointZ> plist = new ArrayList<PointZ>();
                                for (PointZ pd : shape.getPoints()) {
                                    PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z, pd.M);
                                    plist.add(pz);
                                }
                                s.setPartNum(shape.getPartNum());
                                s.setParts(shape.getParts());
                                s.setPoints(plist);
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(shape.getLegendIndex());
                                graphics.add(new Graphic((Shape)s, cb));
                            }
                        }
                    }
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static Graphic createRectangle(List<Number> pos, List<Number> curvature, PolygonBreak pgb) {
        RectangleShape rect = new RectangleShape(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue(), pos.get(3).doubleValue());
        if (curvature != null) {
            rect.setRoundX(curvature.get(0).doubleValue());
            rect.setRoundY(curvature.get(1).doubleValue());
        }
        Graphic graphic = new Graphic((Shape)rect, (ColorBreak)pgb);
        return graphic;
    }

    public static GraphicCollection createBars(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            pList.add(new org.meteoinfo.common.PointD(x, miny));
            pList.add(new org.meteoinfo.common.PointD(x, y));
            pList.add(new org.meteoinfo.common.PointD(x + width, y));
            pList.add(new org.meteoinfo.common.PointD(x + width, miny));
            pList.add(new org.meteoinfo.common.PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.5, y - e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.5, y + e));
                PolylineShape pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.25, y - e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.75, y - e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.25, y + e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.75, y + e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createHBars(Array ydata, Array xdata, boolean autoHeight, Array heights, boolean drawError, Array error, boolean drawLeft, Array left, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double height = heights.getDouble(0);
        if (autoHeight && ydata.getSize() > 1L) {
            height = (ydata.getDouble(1) - ydata.getDouble(0)) * height;
        }
        double bot = 0.0;
        if (drawLeft) {
            bot = left.getDouble(0);
        }
        double minx = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawLeft) {
                if (left.getSize() > (long)i) {
                    bot = left.getDouble(i);
                }
                minx = bot;
                x += minx;
            }
            if (heights.getSize() > 1L && heights.getSize() > (long)i) {
                height = heights.getDouble(i);
            }
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            pList.add(new org.meteoinfo.common.PointD(minx, y));
            pList.add(new org.meteoinfo.common.PointD(x, y));
            pList.add(new org.meteoinfo.common.PointD(x, y + height));
            pList.add(new org.meteoinfo.common.PointD(minx, y + height));
            pList.add(new org.meteoinfo.common.PointD(minx, y));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x - e, y + height * 0.5));
                pList.add(new org.meteoinfo.common.PointD(x + e, y + height * 0.5));
                PolylineShape pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x - e, y + height * 0.25));
                pList.add(new org.meteoinfo.common.PointD(x - e, y + height * 0.75));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + e, y + height * 0.25));
                pList.add(new org.meteoinfo.common.PointD(x + e, y + height * 0.75));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createBars1(Array xdata, Array ydata, boolean autoWidth, Array widths, boolean drawError, Array error, boolean drawBottom, Array bottom, List<BarBreak> bbs) {
        ArrayList<org.meteoinfo.common.PointD> pList;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        PolylineBreak ebreak = new PolylineBreak();
        ebreak.setColor(bb.getErrorColor());
        ebreak.setWidth(bb.getErrorSize());
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        if (drawBottom) {
            bot = bottom.getDouble(0);
        }
        double miny = 0.0;
        boolean baseLine = false;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double x1;
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (drawBottom) {
                if (bottom.getSize() > (long)i) {
                    bot = bottom.getDouble(i);
                }
                miny = bot;
                y += miny;
            }
            if (y < miny) {
                baseLine = true;
            }
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
            }
            pList = new ArrayList();
            pList.add(new org.meteoinfo.common.PointD(x, miny));
            for (x1 = x; x1 < x + width; x1 += width / 100.0) {
                pList.add(new org.meteoinfo.common.PointD(x1, y));
            }
            pList.add(new org.meteoinfo.common.PointD(x + width, y));
            for (x1 = x + width; x1 > x; x1 -= width / 20.0) {
                pList.add(new org.meteoinfo.common.PointD(x1, miny));
            }
            pList.add(new org.meteoinfo.common.PointD(x, miny));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)pgs, (ColorBreak)bb));
            if (drawError) {
                double e = error.getDouble(i);
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.5, y - e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.5, y + e));
                PolylineShape pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.25, y - e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.75, y - e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.25, y + e));
                pList.add(new org.meteoinfo.common.PointD(x + width * 0.75, y + e));
                pls = new PolylineShape();
                pls.setPoints(pList);
                graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
            }
            ++i;
        }
        if (baseLine) {
            pList = new ArrayList<org.meteoinfo.common.PointD>();
            double x1 = xdata.getDouble(0);
            double x2 = xdata.getDouble((int)xdata.getSize() - 1);
            x1 -= x2 - x1;
            x2 += x2 - x1;
            pList.add(new org.meteoinfo.common.PointD(x1, miny));
            pList.add(new org.meteoinfo.common.PointD(x2, miny));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            ebreak = new PolylineBreak();
            ebreak.setColor(Color.black);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)ebreak));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createBars3D(Array xdata, Array ydata, Array zdata, boolean autoWidth, Array widths, Array bottom, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            if (Double.isNaN(z)) continue;
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x + hw, y + hw, minz));
            pList.add(new PointZ(x + hw, y - hw, minz));
            pList.add(new PointZ(x + hw, y + hw, z));
            pList.add(new PointZ(x + hw, y - hw, z));
            pList.add(new PointZ(x - hw, y + hw, minz));
            pList.add(new PointZ(x - hw, y - hw, minz));
            pList.add(new PointZ(x - hw, y + hw, z));
            pList.add(new PointZ(x - hw, y - hw, z));
            CubicShape cs = new CubicShape();
            cs.setPoints(pList);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createCylinderBars3D(Array xdata, Array ydata, Array zdata, boolean autoWidth, Array widths, Array bottom, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        BarBreak bb = bbs.get(0);
        double width = widths.getDouble(0);
        if (autoWidth && xdata.getSize() > 1L) {
            width = (xdata.getDouble(1) - xdata.getDouble(0)) * width;
        }
        double bot = 0.0;
        double minz = 0.0;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        int i = 0;
        double hw = width * 0.5;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double z = zIter.getDoubleNext();
            if (widths.getSize() > 1L && widths.getSize() > (long)i) {
                width = widths.getDouble(i);
                hw = width * 0.5;
            }
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            pList.add(new PointZ(x, y, minz));
            pList.add(new PointZ(x, y, z));
            CylinderShape cs = new CylinderShape(pList, hw);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)cs, (ColorBreak)bb));
            ++i;
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createHistBars(Array data, int bins, List<BarBreak> bbs) {
        List r = ArrayUtil.histogram((Array)data, (int)bins);
        Array xdata = (Array)r.get(1);
        Array ydata = (Array)r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array bins, List<BarBreak> bbs) {
        List r = ArrayUtil.histogram((Array)data, (Array)bins);
        Array xdata = (Array)r.get(1);
        Array ydata = (Array)r.get(0);
        return GraphicFactory.createHistBars(data, xdata, ydata, bbs);
    }

    public static GraphicCollection createHistBars(Array data, Array xdata, Array ydata, List<BarBreak> bbs) {
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)ydata.getSize();
        BarBreak bb = bbs.get(0);
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        for (int i = 0; i < n; ++i) {
            double x = (xdata.getDouble(i + 1) + xdata.getDouble(i)) * 0.5;
            double width = xdata.getDouble(i + 1) - xdata.getDouble(i);
            double y = ydata.getDouble(i);
            BarShape bs = new BarShape();
            bs.setPoint(new org.meteoinfo.common.PointD(x, y));
            bs.setAutoWidth(false);
            bs.setWidth(width);
            bs.setDrawBottom(false);
            if (bbs.size() > i) {
                bb = bbs.get(i);
            }
            graphics.add(new Graphic((Shape)bs, (ColorBreak)bb));
        }
        if (bbs.size() == 1) {
            graphics.setSingleLegend(true);
        } else {
            graphics.setSingleLegend(false);
        }
        return graphics;
    }

    public static GraphicCollection createStems(Array xdata, Array ydata, PolylineBreak plb, PointBreak pb, PolylineBreak bplb, double bottom) {
        ArrayList<org.meteoinfo.common.PointD> pList;
        GraphicCollection graphics = new GraphicCollection();
        int n = (int)xdata.getSize();
        double miny = bottom;
        boolean baseLine = false;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            if (y < miny) {
                baseLine = true;
            }
            pList = new ArrayList();
            pList.add(new org.meteoinfo.common.PointD(x, miny));
            pList.add(new org.meteoinfo.common.PointD(x, y));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)plb));
            PointShape ps = new PointShape();
            ps.setPoint(new org.meteoinfo.common.PointD(x, y));
            graphics.add(new Graphic((Shape)ps, (ColorBreak)pb));
        }
        if (baseLine) {
            pList = new ArrayList<org.meteoinfo.common.PointD>();
            Index xIdx = xdata.getIndex();
            xIdx.setCurrentCounter(0);
            double x1 = xdata.getDouble(xIdx);
            xIdx.setCurrentCounter((int)xdata.getSize() - 1);
            double x2 = xdata.getDouble(xIdx);
            pList.add(new org.meteoinfo.common.PointD(x1, miny));
            pList.add(new org.meteoinfo.common.PointD(x2, miny));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            graphics.add(new Graphic((Shape)pls, (ColorBreak)bplb));
        }
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static Graphic createImage(BufferedImage image) {
        ImageShape ishape = new ImageShape();
        ishape.setPoint(new org.meteoinfo.common.PointD(0.0, 0.0));
        ishape.setImage(image);
        ishape.setExtent(new Extent(0.0, (double)image.getWidth(), 0.0, (double)image.getHeight()));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(Array gdata, List<Number> extent) {
        return GraphicFactory.createImage(gdata, extent, false);
    }

    public static Graphic createImage(Array gdata, List<Number> extent, boolean yReverse) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        boolean isAlpha;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        boolean bl = isAlpha = gdata.getShape()[2] == 4;
        if (gdata.getDataType() == DataType.FLOAT || gdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = gdata.getFloat(index.set(i, j, 0));
                        float g = gdata.getFloat(index.set(i, j, 1));
                        float b = gdata.getFloat(index.set(i, j, 2));
                        float a = gdata.getFloat(index.set(i, j, 3));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        if (yReverse) {
                            aImage.setRGB(j, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = gdata.getFloat(index.set(i, j2, 0));
                        float g = gdata.getFloat(index.set(i, j2, 1));
                        float b = gdata.getFloat(index.set(i, j2, 2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        if (yReverse) {
                            aImage.setRGB(j2, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = gdata.getInt(index.set(i, j, 0));
                    int g = gdata.getInt(index.set(i, j, 1));
                    int b = gdata.getInt(index.set(i, j, 2));
                    int a = gdata.getInt(index.set(i, j, 3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    if (yReverse) {
                        aImage.setRGB(j, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = gdata.getInt(index.set(i, j3, 0));
                    int g = gdata.getInt(index.set(i, j3, 1));
                    int b = gdata.getInt(index.set(i, j3, 2));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    if (yReverse) {
                        aImage.setRGB(j3, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.common.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(List<Array> data, List<Number> extent) {
        return GraphicFactory.createImage(data, extent, false);
    }

    public static Graphic createImage(List<Array> data, List<Number> extent, boolean yReverse) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int j;
        Index aindex;
        int width = data.get(0).getShape()[1];
        int height = data.get(0).getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        boolean isAlpha = data.size() == 4;
        Array rdata = data.get(0);
        Array gdata = data.get(1);
        Array bdata = data.get(2);
        Index rindex = rdata.getIndex();
        Index gindex = gdata.getIndex();
        Index bindex = bdata.getIndex();
        if (rdata.getDataType() == DataType.FLOAT || rdata.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                Array adata = data.get(3);
                aindex = adata.getIndex();
                for (int i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        float r = rdata.getFloat(rindex.set(i, j));
                        float g = gdata.getFloat(gindex.set(i, j));
                        float b = bdata.getFloat(bindex.set(i, j));
                        float a = adata.getFloat(aindex.set(i, j));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        if (yReverse) {
                            aImage.setRGB(j, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        float r = rdata.getFloat(rindex.set(i, j2));
                        float g = gdata.getFloat(gindex.set(i, j2));
                        float b = bdata.getFloat(bindex.set(i, j2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        if (yReverse) {
                            aImage.setRGB(j2, i, color.getRGB());
                            continue;
                        }
                        aImage.setRGB(j2, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            Array adata = data.get(3);
            aindex = adata.getIndex();
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    int r = rdata.getInt(rindex.set(i, j));
                    int g = gdata.getInt(gindex.set(i, j));
                    int b = bdata.getInt(bindex.set(i, j));
                    int a = adata.getInt(aindex.set(i, j));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    if (yReverse) {
                        aImage.setRGB(j, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j3 = 0; j3 < width; ++j3) {
                    int r = rdata.getInt(rindex.set(i, j3));
                    int g = gdata.getInt(gindex.set(i, j3));
                    int b = bdata.getInt(bindex.set(i, j3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    if (yReverse) {
                        aImage.setRGB(j3, i, color.getRGB());
                        continue;
                    }
                    aImage.setRGB(j3, height - i - 1, color.getRGB());
                }
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.common.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static GraphicCollection createImage(Array x, Array y, List<Array> data, double offset, String zdir, String interpolation) {
        Graphic gg = GraphicFactory.createImage(data, null);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = shape.getExtent();
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent((Extent)ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.add(gg);
        return graphics;
    }

    public static Graphic createImage(Array gdata, LegendScheme ls, List<Number> extent) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        int width = gdata.getShape()[1];
        int height = gdata.getShape()[0];
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = gdata.getIndex();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                index.set(i, j);
                double oneValue = gdata.getDouble(index);
                if (Double.isNaN(oneValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            minx = 0.0;
            maxx = width;
            miny = 0.0;
            maxy = height;
        } else {
            minx = extent.get(0).doubleValue();
            maxx = extent.get(1).doubleValue();
            miny = extent.get(2).doubleValue();
            maxy = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.common.PointD(minx, miny));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(minx, maxx, miny, maxy));
        return new Graphic((Shape)ishape, new ColorBreak());
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls) {
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDoubleValue(i, j);
                if (Double.isNaN(oneValue) || MIMath.doubleEquals((double)oneValue, (double)gdata.missingValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        double xdelta = BigDecimalUtil.mul((double)gdata.getXDelt(), (double)0.5);
        double xmin = BigDecimalUtil.sub((double)gdata.xArray[0], (double)xdelta);
        double xmax = BigDecimalUtil.add((double)gdata.getXMax(), (double)xdelta);
        double ydelta = BigDecimalUtil.mul((double)gdata.getYDelt(), (double)0.5);
        double ymin = BigDecimalUtil.sub((double)gdata.yArray[0], (double)ydelta);
        double ymax = BigDecimalUtil.add((double)gdata.getYMax(), (double)ydelta);
        ishape.setPoint(new org.meteoinfo.common.PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new ImageGraphic(ishape, ls);
    }

    public static Graphic createImage(GridArray gdata, LegendScheme ls, List<Number> extent) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        int width = gdata.getXNum();
        int height = gdata.getYNum();
        int breakNum = ls.getBreakNum();
        double[] breakValue = new double[breakNum];
        Color[] breakColor = new Color[breakNum];
        Color undefColor = Color.white;
        for (int i = 0; i < breakNum; ++i) {
            breakValue[i] = Double.parseDouble(((ColorBreak)ls.getLegendBreaks().get(i)).getEndValue().toString());
            breakColor[i] = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
            if (!((ColorBreak)ls.getLegendBreaks().get(i)).isNoData()) continue;
            undefColor = ((ColorBreak)ls.getLegendBreaks().get(i)).getColor();
        }
        Color defaultColor = breakColor[breakNum - 1];
        BufferedImage aImage = new BufferedImage(width, height, 2);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color oneColor;
                double oneValue = gdata.getDoubleValue(i, j);
                if (Double.isNaN(oneValue) || MIMath.doubleEquals((double)oneValue, (double)gdata.missingValue)) {
                    oneColor = undefColor;
                } else {
                    int k;
                    oneColor = defaultColor;
                    if (ls.getLegendType() == LegendType.GRADUATED_COLOR) {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (!(oneValue < breakValue[k])) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    } else {
                        for (k = 0; k < breakNum - 1; ++k) {
                            if (oneValue != breakValue[k]) continue;
                            oneColor = breakColor[k];
                            break;
                        }
                    }
                }
                aImage.setRGB(j, height - i - 1, oneColor.getRGB());
            }
        }
        ImageShape ishape = new ImageShape();
        if (extent == null) {
            double xdelta = BigDecimalUtil.mul((double)gdata.getXDelt(), (double)0.5);
            xmin = BigDecimalUtil.sub((double)gdata.xArray[0], (double)xdelta);
            xmax = BigDecimalUtil.add((double)gdata.getXMax(), (double)xdelta);
            double ydelta = BigDecimalUtil.mul((double)gdata.getYDelt(), (double)0.5);
            ymin = BigDecimalUtil.sub((double)gdata.yArray[0], (double)ydelta);
            ymax = BigDecimalUtil.add((double)gdata.getYMax(), (double)ydelta);
        } else {
            xmin = extent.get(0).doubleValue();
            xmax = extent.get(1).doubleValue();
            ymin = extent.get(2).doubleValue();
            ymax = extent.get(3).doubleValue();
        }
        ishape.setPoint(new org.meteoinfo.common.PointD(xmin, ymin));
        ishape.setImage(aImage);
        ishape.setExtent(new Extent(xmin, xmax, ymin, ymax));
        return new ImageGraphic(ishape, ls);
    }

    public static GraphicCollection createImage(GridArray gdata, LegendScheme ls, double offset, String zdir, List<Number> sePoint, String interpolation) {
        Graphic gg = GraphicFactory.createImage(gdata, ls);
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        ImageShape shape = (ImageShape)gg.getShape();
        Extent extent = shape.getExtent();
        Extent3D ex3 = new Extent3D();
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        switch (zdir.toLowerCase()) {
            case "x": {
                ex3 = new Extent3D(offset, offset, extent.minX, extent.maxX, extent.minY, extent.maxY);
                coords.add(new PointZ(offset, extent.minX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.minY));
                coords.add(new PointZ(offset, extent.maxX, extent.maxY));
                coords.add(new PointZ(offset, extent.minX, extent.maxY));
                break;
            }
            case "y": {
                ex3 = new Extent3D(extent.minX, extent.maxX, offset, offset, extent.minY, extent.maxY);
                coords.add(new PointZ(extent.minX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.minY));
                coords.add(new PointZ(extent.maxX, offset, extent.maxY));
                coords.add(new PointZ(extent.minX, offset, extent.maxY));
                break;
            }
            case "xy": {
                ex3 = new Extent3D(sePoint.get(0).doubleValue(), sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), sePoint.get(3).doubleValue(), extent.minY, extent.maxY);
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(1).doubleValue(), extent.minY));
                coords.add(new PointZ(sePoint.get(2).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                coords.add(new PointZ(sePoint.get(0).doubleValue(), sePoint.get(3).doubleValue(), extent.maxY));
                break;
            }
            case "z": {
                ex3 = new Extent3D(extent.minX, extent.maxX, extent.minY, extent.maxY, offset, offset);
                coords.add(new PointZ(extent.minX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.minY, offset));
                coords.add(new PointZ(extent.maxX, extent.maxY, offset));
                coords.add(new PointZ(extent.minX, extent.maxY, offset));
            }
        }
        shape.setExtent((Extent)ex3);
        shape.setCoords(coords);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir(zdir);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        graphics.add(gg);
        graphics.setLegendScheme(ls);
        graphics.setSingleLegend(false);
        return graphics;
    }

    public static GraphicCollection createImage(ImageLayer layer, double offset, double xshift, String interpolation) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        ImageShape ishape = new ImageShape();
        ishape.setImage(layer.getImage());
        Extent extent = layer.getExtent();
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent((Extent)ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic((Shape)ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static GraphicCollection createContourLines(Array xa, Array ya, Array va, LegendScheme ls, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double missingValue = -9999.0;
        double[][] data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < ContourLines.size(); ++i) {
            int j;
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j2 = 0; j2 < ls.getBreakNum(); ++j2) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j2);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, LegendScheme ls, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] x = gridData.getXArray();
        double[] y = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])x);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])y);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])x, (double[])y, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < ContourLines.size(); ++i) {
            int j;
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j2 = 0; j2 < ls.getBreakNum(); ++j2) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j2);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] x = gridData.getXArray();
        double[] y = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])x);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])y);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])x, (double[])y, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourLines(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        Object[] cbs;
        List ContourLines;
        ls = ls.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double v = aLine.Value;
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = offset;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.Y = offset;
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Z = ((PointD)aLine.PointList.get((int)j)).Y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        double x = ((PointD)aLine.PointList.get((int)j)).X;
                        double y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    PointZ aPoint;
                    int j;
                    for (j = 0; j < aLine.PointList.size(); ++j) {
                        aPoint = new PointZ();
                        aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                        aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(v);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolyline, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static List<GraphicCollection3D> contourSlice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        ColorBreak cb;
        ArrayList<PointZ> points;
        PolylineZShape shape;
        GraphicCollection3D graphics;
        int[][] S1;
        double[][] grid;
        Object[] cbs;
        List contourLines;
        Array r;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        int dim1 = (int)za.getSize();
        int dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            double x = xSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])yy, (double[])zz, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList<PointZ>();
                for (PointD p : line.PointList) {
                    points.add(new PointZ(x, p.X, p.Y));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            double y = ySlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])xx, (double[])zz, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList();
                for (PointD p : line.PointList) {
                    points.add(new PointZ(p.X, y, p.Y));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)ya.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            double z = zSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null || (contourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])(grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r)), (double[])cValues, (double[])xx, (double[])yy, (double)Double.NaN, (int[][])(S1 = new int[dim1][dim2])))[0]).isEmpty()) continue;
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            graphics = new GraphicCollection3D();
            for (PolyLine line : contourLines) {
                shape = new PolylineZShape();
                points = new ArrayList();
                for (PointD p : line.PointList) {
                    points.add(new PointZ(p.X, p.Y, z));
                }
                shape.setPoints(points);
                shape.setValue(line.Value);
                cb = ls.findLegendBreak((Number)line.Value);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static List<GraphicCollection3D> contourfSlice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls, boolean isSmooth) throws InvalidRangeException {
        ColorBreak cb;
        int valueIdx;
        ArrayList<PointZ> points;
        PolygonZShape shape;
        GraphicCollection3D graphics;
        List contourPolygons;
        List borders;
        List contourLines;
        Object[] cbs;
        int[][] S1;
        double[][] grid;
        double maxData;
        double minData;
        Array r;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] xx = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double[] zz = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)za);
        double missingValue = -9999.0;
        int dim1 = (int)za.getSize();
        int dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            double x = xSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])yy, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList<PointZ>();
                for (PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(x, p.X, p.Y));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (PointD p : holeLine.PointList) {
                            points.add(new PointZ(x, p.X, p.Y));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            double y = ySlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])zz, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList();
                for (PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(p.X, y, p.Y));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (PointD p : holeLine.PointList) {
                            points.add(new PointZ(p.X, y, p.Y));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)ya.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            double z = zSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null) continue;
            minData = ArrayMath.getMinimum((Array)r);
            maxData = ArrayMath.getMaximum((Array)r);
            grid = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)r, (double)missingValue);
            cbs = ContourDraw.tracingContourLines((double[][])grid, (double[])cValues, (double[])xx, (double[])yy, (double)missingValue, (int[][])(S1 = new int[dim1][dim2]));
            contourLines = (List)cbs[0];
            if (contourLines.isEmpty()) continue;
            borders = (List)cbs[1];
            if (isSmooth) {
                contourLines = Contour.smoothLines((List)contourLines);
            }
            contourPolygons = ContourDraw.tracingPolygons((double[][])grid, (List)contourLines, (List)borders, (double[])cValues);
            graphics = new GraphicCollection3D();
            for (Polygon polygon : contourPolygons) {
                shape = new PolygonZShape();
                points = new ArrayList();
                for (PointD p : polygon.OutLine.PointList) {
                    points.add(new PointZ(p.X, p.Y, z));
                }
                if (!GeoComputation.isClockwise(points)) {
                    Collections.reverse(points);
                }
                shape.setPoints(points);
                shape.lowValue = polygon.LowValue;
                shape.highValue = polygon.HighValue;
                if (polygon.HasHoles()) {
                    for (PolyLine holeLine : polygon.HoleLines) {
                        points = new ArrayList();
                        for (PointD p : holeLine.PointList) {
                            points.add(new PointZ(p.X, p.Y, z));
                        }
                        shape.addHole(points, 0);
                    }
                }
                if ((valueIdx = Arrays.binarySearch(cValues, polygon.LowValue)) < 0) {
                    valueIdx = -valueIdx;
                }
                shape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
                if (!polygon.IsHighCenter && polygon.HighValue == polygon.LowValue) {
                    shape.highValue = polygon.LowValue;
                    shape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
                }
                cb = ls.findLegendBreak((Number)shape.lowValue);
                graphics.add(new Graphic((Shape)shape, cb));
            }
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            org.meteoinfo.common.PointD aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)pointList).X;
                aPoint.Y = ((PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.common.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(Array xa, Array ya, Array va, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double minData = ArrayMath.min((Array)va).doubleValue();
        double maxData = ArrayMath.max((Array)va).doubleValue();
        int[] shape = va.getShape();
        int[][] S1 = new int[shape[0]][shape[1]];
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        double missingValue = -9999.0;
        double[][] data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        ColorBreak cbb = ls.findLegendBreak((Number)0);
        GraphicCollection graphics = new GraphicCollection();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            org.meteoinfo.common.PointD aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)pointList).X;
                aPoint.Y = ((PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.common.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            block0 : switch (ls.getLegendType()) {
                case UNIQUE_VALUE: {
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
                case GRADUATED_COLOR: {
                    int blNum = 0;
                    for (int j = 0; j < ls.getBreakNum(); ++j) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(j);
                        if (!(MIMath.doubleEquals((double)v, (double)Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        cbb = cb;
                        break block0;
                    }
                    break;
                }
            }
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createContourPolygons(GridData gridData, double offset, String zdir, LegendScheme ls, boolean isSmooth, List<Number> sePoint) {
        ls = ls.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors((LegendScheme)ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List contourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        List contourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)contourLines, (List)borders, (double[])cValues);
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZValue(offset);
        graphics.setSEPoint(sePoint);
        zdir = zdir.toLowerCase();
        graphics.setZDir(zdir);
        double xs = sePoint.get(0).doubleValue();
        double ys = sePoint.get(1).doubleValue();
        double xe = sePoint.get(2).doubleValue();
        double ye = sePoint.get(3).doubleValue();
        for (int i = 0; i < contourPolygons.size(); ++i) {
            int valueIdx;
            PointZ aPoint;
            Polygon poly = (Polygon)contourPolygons.get(i);
            double v = poly.LowValue;
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.Y = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.X = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "y": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Z = pointList.Y;
                        aPoint.Y = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "xy": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        double x = pointList.X;
                        double y = pointList.Y;
                        aPoint = new PointZ();
                        aPoint.X = x;
                        aPoint.Y = ys + (ye - ys) * (x - xs) / (xe - xs);
                        aPoint.Z = y;
                        pList.add(aPoint);
                    }
                    break;
                }
                case "z": {
                    for (PointD pointList : poly.OutLine.PointList) {
                        aPoint = new PointZ();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        aPoint.Z = offset;
                        pList.add(aPoint);
                    }
                    break;
                }
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonZShape aPolygonShape = new PolygonZShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = v;
            if (poly.HasHoles()) {
                switch (zdir) {
                    case "x": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.Y = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.X = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "y": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Z = pointList.Y;
                                aPoint.Y = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                    case "z": {
                        for (PolyLine holeLine : poly.HoleLines) {
                            pList = new ArrayList();
                            for (PointD pointList : holeLine.PointList) {
                                aPoint = new PointZ();
                                aPoint.X = pointList.X;
                                aPoint.Y = pointList.Y;
                                aPoint.Z = offset;
                                pList.add(aPoint);
                            }
                            aPolygonShape.addHole(pList, 0);
                        }
                        break;
                    }
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, v)) < 0) {
                valueIdx = -valueIdx;
            }
            aPolygonShape.highValue = valueIdx == cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!poly.IsHighCenter && poly.HighValue == poly.LowValue) {
                aPolygonShape.highValue = v;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            v = aPolygonShape.lowValue;
            ColorBreak cbb = ls.findLegendBreak((Number)v);
            graphics.add(new Graphic((Shape)aPolygonShape, cbb));
        }
        graphics.setSingleLegend(false);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createPColorPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        if (!x_s.getIndexPrivate().isFastIterator()) {
            x_s = x_s.copy();
        }
        if (!y_s.getIndexPrivate().isFastIterator()) {
            y_s = y_s.copy();
        }
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                points.add(new org.meteoinfo.common.PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new org.meteoinfo.common.PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                ps.setPoints(points);
                double v = a.getDouble(i * colNum + j);
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak((Number)v);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    public static GraphicCollection createGridPolygons(Array x_s, Array y_s, Array a, LegendScheme ls) {
        GraphicCollection gc = new GraphicCollection();
        if (!x_s.getIndexPrivate().isFastIterator()) {
            x_s = x_s.copy();
        }
        if (!y_s.getIndexPrivate().isFastIterator()) {
            y_s = y_s.copy();
        }
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        int colNum = (int)x_s.getSize();
        int rowNum = (int)y_s.getSize();
        double x1 = 0.0;
        double y1 = 0.0;
        for (int i = 0; i < rowNum; ++i) {
            double yd;
            double y2;
            if (i == 0) {
                y1 = y_s.getDouble(i);
            }
            double y = y_s.getDouble(i);
            if (i < rowNum - 1) {
                y2 = y_s.getDouble(i + 1);
                yd = y2 - y;
            } else {
                y2 = y_s.getDouble(i - 1);
                yd = y - y2;
            }
            if (i == 0) {
                y1 -= yd * 0.5;
            }
            y2 = y + yd * 0.5;
            for (int j = 0; j < colNum; ++j) {
                double xd;
                double x2;
                if (j == 0) {
                    x1 = x_s.getDouble(j);
                }
                double x = x_s.getDouble(j);
                if (j < colNum - 1) {
                    x2 = x_s.getDouble(j + 1);
                    xd = x2 - x;
                } else {
                    x2 = x_s.getDouble(j - 1);
                    xd = x - x2;
                }
                if (j == 0) {
                    x1 -= xd * 0.5;
                }
                x2 = x + xd * 0.5;
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                points.add(new org.meteoinfo.common.PointD(x1, y1));
                points.add(new org.meteoinfo.common.PointD(x1, y2));
                points.add(new org.meteoinfo.common.PointD(x2, y2));
                points.add(new org.meteoinfo.common.PointD(x2, y1));
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                ps.setPoints(points);
                double v = a.getDouble(i * colNum + j);
                PolygonBreak pb = (PolygonBreak)ls.findLegendBreak((Number)v);
                Graphic graphic = new Graphic((Shape)ps, (ColorBreak)pb);
                gc.add(graphic);
                x1 = x2;
            }
            y1 = y2;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)y1data) || ArrayMath.containsNaN((Array)y2data))) {
            void var11_8;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = y1data.getDouble((int)var11_8);
                double v2 = y2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new org.meteoinfo.common.PointD(xdata.getDouble(i), y1data.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new org.meteoinfo.common.PointD(xdata.getDouble(i), y2data.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new org.meteoinfo.common.PointD(xdata.getDouble(ii), y1data.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new org.meteoinfo.common.PointD(xdata.getDouble(ii), y2data.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygonsX(Array ydata, Array x1data, Array x2data, Array where, PolygonBreak pb) {
        GraphicCollection gc = new GraphicCollection();
        int len = (int)ydata.getSize();
        if (!ydata.getIndexPrivate().isFastIterator()) {
            ydata = ydata.copy();
        }
        if (!x1data.getIndexPrivate().isFastIterator()) {
            x1data = x1data.copy();
        }
        if (!x2data.getIndexPrivate().isFastIterator()) {
            x2data = x2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)x1data) || ArrayMath.containsNaN((Array)x2data))) {
            void var11_8;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var11_8 < len) {
                double v1 = x1data.getDouble((int)var11_8);
                double v2 = x2data.getDouble((int)var11_8);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var11_8, false);
                } else {
                    where.setBoolean((int)var11_8, true);
                }
                ++var11_8;
            }
        }
        if (where == null) {
            int i;
            PolygonShape pgs = new PolygonShape();
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            for (i = 0; i < len; ++i) {
                points.add(new org.meteoinfo.common.PointD(x1data.getDouble(i), ydata.getDouble(i)));
            }
            for (i = len - 1; i >= 0; --i) {
                points.add(new org.meteoinfo.common.PointD(x2data.getDouble(i), ydata.getDouble(i)));
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int ii;
                int j;
                int nn = list.size();
                if (nn < 2) continue;
                PolygonShape pgs = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(j);
                    points.add(new org.meteoinfo.common.PointD(x1data.getDouble(ii), ydata.getDouble(ii)));
                }
                for (j = 0; j < nn; ++j) {
                    ii = (Integer)list.get(nn - j - 1);
                    points.add(new org.meteoinfo.common.PointD(x2data.getDouble(ii), ydata.getDouble(ii)));
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null && (ArrayMath.containsNaN((Array)y1data) || ArrayMath.containsNaN((Array)y2data))) {
            void var14_10;
            where = Array.factory((DataType)DataType.BOOLEAN, (int[])new int[]{len});
            boolean bl = false;
            while (var14_10 < len) {
                double v1 = y1data.getDouble((int)var14_10);
                double v2 = y2data.getDouble((int)var14_10);
                if (Double.isNaN(v1) || Double.isNaN(v2)) {
                    where.setBoolean((int)var14_10, false);
                } else {
                    where.setBoolean((int)var14_10, true);
                }
                ++var14_10;
            }
        }
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var14_14;
                    void var14_12;
                    boolean bl = false;
                    while (var14_12 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_12), y1data.getDouble((int)var14_12)));
                        ++var14_12;
                    }
                    int n = len - 1;
                    while (var14_14 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var14_14), y2data.getDouble((int)var14_14)));
                        --var14_14;
                    }
                    break;
                }
                case "y": {
                    void var14_18;
                    void var14_16;
                    boolean bl = false;
                    while (var14_16 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_16), offset, y1data.getDouble((int)var14_16)));
                        ++var14_16;
                    }
                    int n = len - 1;
                    while (var14_18 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_18), offset, y2data.getDouble((int)var14_18)));
                        --var14_18;
                    }
                    break;
                }
                case "z": {
                    void var14_22;
                    void var14_20;
                    boolean bl = false;
                    while (var14_20 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var14_20), y1data.getDouble((int)var14_20), offset));
                        ++var14_20;
                    }
                    int n = len - 1;
                    while (var14_22 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var14_22), y2data.getDouble((int)var14_22), offset));
                        --var14_22;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            if (!where.getIndexPrivate().isFastIterator()) {
                where = where.copy();
            }
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                    idx = new ArrayList();
                }
                ob = where.getInt(j) == 1;
            }
            if (!idx.isEmpty()) {
                idxs.add(idx);
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    /*
     * WARNING - void declaration
     */
    public static GraphicCollection createFillBetweenPolygons(Array xdata, Array ydata, Array y1data, Array y2data, Array where, PolygonBreak pb, double offset, String zdir) {
        GraphicCollection3D gc = new GraphicCollection3D();
        gc.setFixZ(true);
        gc.setZValue(offset);
        gc.setZDir(zdir);
        int len = (int)xdata.getSize();
        if (!xdata.getIndexPrivate().isFastIterator()) {
            xdata = xdata.copy();
        }
        if (!y1data.getIndexPrivate().isFastIterator()) {
            y1data = y1data.copy();
        }
        if (!y2data.getIndexPrivate().isFastIterator()) {
            y2data = y2data.copy();
        }
        if (where == null) {
            PolygonZShape pgs = new PolygonZShape();
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            switch (zdir) {
                case "x": {
                    void var15_22;
                    void var15_20;
                    boolean bl = false;
                    while (var15_20 < len) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_20), y1data.getDouble((int)var15_20)));
                        ++var15_20;
                    }
                    int n = len - 1;
                    while (var15_22 >= 0) {
                        points.add(new PointZ(offset, xdata.getDouble((int)var15_22), y2data.getDouble((int)var15_22)));
                        --var15_22;
                    }
                    break;
                }
                case "y": {
                    void var15_26;
                    void var15_24;
                    boolean bl = false;
                    while (var15_24 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_24), offset, y1data.getDouble((int)var15_24)));
                        ++var15_24;
                    }
                    int n = len - 1;
                    while (var15_26 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_26), offset, y2data.getDouble((int)var15_26)));
                        --var15_26;
                    }
                    break;
                }
                case "xy": {
                    void var15_30;
                    void var15_28;
                    if (!ydata.getIndexPrivate().isFastIterator()) {
                        ydata = ydata.copy();
                    }
                    boolean bl = false;
                    while (var15_28 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_28), ydata.getDouble((int)var15_28), y1data.getDouble((int)var15_28)));
                        ++var15_28;
                    }
                    int n = len - 1;
                    while (var15_30 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_30), ydata.getDouble((int)var15_30), y2data.getDouble((int)var15_30)));
                        --var15_30;
                    }
                    break;
                }
                case "z": {
                    void var15_34;
                    void var15_32;
                    boolean bl = false;
                    while (var15_32 < len) {
                        points.add(new PointZ(xdata.getDouble((int)var15_32), y1data.getDouble((int)var15_32), offset));
                        ++var15_32;
                    }
                    int n = len - 1;
                    while (var15_34 >= 0) {
                        points.add(new PointZ(xdata.getDouble((int)var15_34), y2data.getDouble((int)var15_34), offset));
                        --var15_34;
                    }
                    break;
                }
            }
            pgs.setPoints(points);
            Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
            gc.add(graphic);
        } else {
            boolean ob = false;
            ArrayList idxs = new ArrayList();
            ArrayList<Integer> idx = new ArrayList<Integer>();
            for (int j = 0; j < len; ++j) {
                if (where.getInt(j) == 1) {
                    if (!ob) {
                        idx = new ArrayList();
                    }
                    idx.add(j);
                } else if (ob) {
                    idxs.add(idx);
                }
                ob = where.getInt(j) == 1;
            }
            for (List list : idxs) {
                int nn = list.size();
                if (nn < 2) continue;
                PolygonZShape pgs = new PolygonZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                switch (zdir) {
                    case "x": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(offset, xdata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "y": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), offset, y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "xy": {
                        int ii;
                        int j;
                        if (!ydata.getIndexPrivate().isFastIterator()) {
                            ydata = ydata.copy();
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y1data.getDouble(ii)));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), ydata.getDouble(ii), y2data.getDouble(ii)));
                        }
                        break;
                    }
                    case "z": {
                        int ii;
                        int j;
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(j);
                            points.add(new PointZ(xdata.getDouble(ii), y1data.getDouble(ii), offset));
                        }
                        for (j = 0; j < nn; ++j) {
                            ii = (Integer)list.get(nn - j - 1);
                            points.add(new PointZ(xdata.getDouble(ii), y2data.getDouble(ii), offset));
                        }
                        break;
                    }
                }
                pgs.setPoints(points);
                Graphic graphic = new Graphic((Shape)pgs, (ColorBreak)pb);
                gc.add(graphic);
            }
        }
        return gc;
    }

    public static GraphicCollection createBarbs(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        IndexIterator cIter;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds((Array)udata, (Array)vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double windDir = wdIter.getDoubleNext();
            double windSpeed = wsIter.getDoubleNext();
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                ColorBreak cb;
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                WindBarb aWB = Draw.calWindBarb((float)((float)windDir), (float)((float)windSpeed), (double)0.0, (float)10.0f, (org.meteoinfo.common.PointD)aPoint);
                if (cdata == null) {
                    cb = (ColorBreak)ls.getLegendBreaks().get(0);
                } else {
                    double v = cIter.getDoubleNext();
                    aWB.setValue(v);
                    cb = ls.findLegendBreak((Number)v);
                }
                Graphic graphic = new Graphic((Shape)aWB, cb);
                gc.add(graphic);
                continue;
            }
            xIter.next();
            yIter.next();
            if (cIter == null) continue;
            cIter.next();
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static Graphic createArrow(double x, double y, double dx, double dy, ArrowPolygonBreak ab) {
        double[] r = MeteoMath.uv2ds((double)dx, (double)dy);
        double length = r[1];
        if (ab.isLengthIncludesHead()) {
            length -= (double)ab.getHeadLength();
        }
        AffineTransform atf = new AffineTransform();
        atf.translate(x, y);
        atf.rotate(dx, dy);
        float width = ab.getWidth();
        float headLength = ab.getHeadLength();
        float overhang = ab.getOverhang();
        float lenShift = headLength * overhang;
        double[] srcPts = new double[]{0.0, (double)(-width) * 0.5, 0.0, (double)width * 0.5, length + (double)lenShift, (double)width * 0.5, length, (double)ab.getHeadWidth() * 0.5, length + (double)ab.getHeadLength(), 0.0, length, (double)(-ab.getHeadWidth()) * 0.5, length + (double)lenShift, (double)(-width) * 0.5, 0.0, (double)(-width) * 0.5};
        atf.transform(srcPts, 0, srcPts, 0, 8);
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        for (int i = 0; i < srcPts.length; i += 2) {
            points.add(new org.meteoinfo.common.PointD(srcPts[i], srcPts[i + 1]));
        }
        PolygonShape pgs = new PolygonShape();
        pgs.setPoints(points);
        return new Graphic((Shape)pgs, (ColorBreak)ab);
    }

    public static Graphic createArrowLine(double x, double y, double dx, double dy, ArrowLineBreak ab) {
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        points.add(new org.meteoinfo.common.PointD(x, y));
        points.add(new org.meteoinfo.common.PointD(x + dx, y + dy));
        PolylineShape pls = new PolylineShape();
        pls.setPoints(points);
        return new Graphic((Shape)pls, (ColorBreak)ab);
    }

    public static Graphic createArrowLine(Array x, Array y, ArrowLineBreak ab, boolean iscurve) {
        ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            points.add(new org.meteoinfo.common.PointD(xIter.getDoubleNext(), yIter.getDoubleNext()));
        }
        Object pls = iscurve ? new CurveLineShape() : new PolylineShape();
        pls.setPoints(points);
        return new Graphic((Shape)pls, (ColorBreak)ab);
    }

    public static GraphicCollection createArrows(Array xdata, Array ydata, Array udata, Array vdata, Array cdata, LegendScheme ls, boolean isUV) {
        IndexIterator cIter;
        Array windSpeedData;
        Array windDirData;
        GraphicCollection gc = new GraphicCollection();
        if (isUV) {
            Array[] wwData = MeteoMath.uv2ds((Array)udata, (Array)vdata);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = udata;
            windSpeedData = vdata;
        }
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        double v = 0.0;
        float size = 6.0f;
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            ColorBreak cb;
            double windDir = wdIter.getDoubleNext();
            double windSpeed = wsIter.getDoubleNext();
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (cdata != null) {
                v = cIter.getDoubleNext();
            }
            if (Double.isNaN(windDir) || Double.isNaN(windSpeed)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = x;
            aPoint.Y = y;
            WindArrow wa = new WindArrow();
            wa.angle = windDir;
            wa.length = (float)windSpeed;
            wa.size = size;
            wa.setPoint(aPoint);
            if (cdata == null) {
                cb = (ColorBreak)ls.getLegendBreaks().get(0);
            } else {
                wa.setValue(v);
                cb = ls.findLegendBreak((Number)v);
            }
            Graphic graphic = new Graphic((Shape)wa, cb);
            gc.add(graphic);
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection createArrows3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, float scale, float headWidth, float headLength, Array cdata, LegendScheme ls) {
        IndexIterator cIter;
        GraphicCollection gc = new GraphicCollection();
        ShapeTypes sts = ls.getShapeType();
        ls = ls.convertTo(ShapeTypes.POINT);
        if (sts != ShapeTypes.POINT) {
            for (int i = 0; i < ls.getBreakNum(); ++i) {
                ((PointBreak)ls.getLegendBreaks().get(i)).setSize(10.0f);
            }
        }
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        IndexIterator uIter = udata.getIndexIterator();
        IndexIterator vIter = vdata.getIndexIterator();
        IndexIterator wIter = wdata.getIndexIterator();
        IndexIterator indexIterator = cIter = cdata == null ? null : cdata.getIndexIterator();
        while (xIter.hasNext()) {
            double u = uIter.getDoubleNext();
            double v = vIter.getDoubleNext();
            double w = wIter.getDoubleNext();
            if (!(Double.isNaN(u) || Double.isNaN(v) || Double.isNaN(w))) {
                ColorBreak cb;
                PointZ aPoint = new PointZ();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                aPoint.Z = zIter.getDoubleNext();
                WindArrow3D wa = new WindArrow3D();
                wa.u = u;
                wa.v = v;
                wa.w = w;
                wa.scale = scale;
                wa.setHeadWith(headWidth);
                wa.setHeadLength(headLength);
                wa.setPoint(aPoint);
                if (cdata == null) {
                    cb = (ColorBreak)ls.getLegendBreaks().get(0);
                } else {
                    double value = cIter.getDoubleNext();
                    wa.setValue(value);
                    cb = ls.findLegendBreak((Number)value);
                }
                Graphic graphic = new Graphic((Shape)wa, cb);
                gc.add(graphic);
                continue;
            }
            xIter.next();
            yIter.next();
            zIter.next();
            if (cdata == null) continue;
            cIter.next();
        }
        gc.setLegendScheme(ls);
        if (cdata != null) {
            gc.setSingleLegend(false);
        }
        return gc;
    }

    public static GraphicCollection3D createStreamlines3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, Array cdata, int density, LegendScheme ls, int minPoints, int loopLimit) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][][] u = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][][] v = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[][][] w = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)wdata);
        if (xdata.getRank() == 1) {
            double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[] z = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[])x, (double[])y, (double[])z, (int)density, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[])x, (double[])y, (double[])z, (int)density, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        } else {
            double[][][] x = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[][][] y = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[][][] z = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D createStreamlines3D(Array xdata, Array ydata, Array zdata, Array udata, Array vdata, Array wdata, Array cdata, int density, LegendScheme ls, int minPoints, int loopLimit, Array startX, Array startY, Array startZ) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][][] u = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][][] v = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[][][] w = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)wdata);
        double[] sX = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startX);
        double[] sY = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startY);
        double[] sZ = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)startZ);
        if (xdata.getRank() == 1) {
            double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[] z = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[])x, (double[])y, (double[])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[])x, (double[])y, (double[])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        } else {
            double[][][] x = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
            double[][][] y = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
            double[][][] z = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)zdata);
            if (cdata == null) {
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, null, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                ColorBreak cb = ls.getLegendBreak(0);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, cb));
                }
            } else {
                double[][][] m = (double[][][])ArrayUtil.copyToNDJavaArray_Double((Array)cdata);
                List streamLines = Contour.tracingStreamline3D((double[][][])u, (double[][][])v, (double[][][])w, (double[][][])m, (double[][][])x, (double[][][])y, (double[][][])z, (int)density, (double[])sX, (double[])sY, (double[])sZ, (int)loopLimit);
                for (PolyLine3D line : streamLines) {
                    if (line.PointList.size() < minPoints) continue;
                    PolylineZShape shape = new PolylineZShape();
                    ArrayList<PointZ> points = new ArrayList<PointZ>();
                    ColorBreakCollection cbs = new ColorBreakCollection();
                    for (Point3D point : line.PointList) {
                        points.add(new PointZ(point.X, point.Y, point.Z));
                        ColorBreak cb = ls.findLegendBreak((Number)point.M);
                        cbs.add(cb);
                    }
                    shape.setPoints(points);
                    graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection createStreamlines(Array xdata, Array ydata, Array udata, Array vdata, int density, StreamlineBreak slb, boolean isUV) {
        GraphicCollection gc = new GraphicCollection();
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        for (int i = 0; i < streamlines.size() - 1; ++i) {
            PolyLine line = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < line.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)line.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)line.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            gc.add(new Graphic((Shape)aPolyline, (ColorBreak)slb));
        }
        return gc;
    }

    public static GraphicCollection3D streamLines(Array xa, Array ya, double z, Array ua, Array va, Array data, int density, String zDir, LegendScheme ls) {
        List streamlines;
        Object y;
        Object x;
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ua);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va);
        if (xa.getRank() == 1) {
            x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        } else {
            xa = xa.copyIfView();
            ya = ya.copyIfView();
            x = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[][])x, (double[][])y, (int)density);
        }
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        if (data == null) {
            for (PolyLine line : streamlines) {
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                if (zDir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((PointD)line.PointList.get((int)j)).X;
                        p.Z = ((PointD)line.PointList.get((int)j)).Y;
                        p.X = z;
                        points.add(p);
                    }
                } else if (zDir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((PointD)line.PointList.get((int)j)).X;
                        p.Z = ((PointD)line.PointList.get((int)j)).Y;
                        p.Y = z;
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((PointD)line.PointList.get((int)j)).X;
                        p.Y = ((PointD)line.PointList.get((int)j)).Y;
                        p.Z = z;
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            data = data.copyIfView();
            for (PolyLine line : streamlines) {
                int xi;
                int yi;
                int[] idx;
                PointZ p;
                int j;
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                if (zDir.equals("x")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.Y = ((PointD)line.PointList.get((int)j)).X;
                        p.Z = ((PointD)line.PointList.get((int)j)).Y;
                        p.X = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.Y, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else if (zDir.equals("y")) {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((PointD)line.PointList.get((int)j)).X;
                        p.Z = ((PointD)line.PointList.get((int)j)).Y;
                        p.Y = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Z);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                } else {
                    for (j = 0; j < line.PointList.size(); ++j) {
                        p = new PointZ();
                        p.X = ((PointD)line.PointList.get((int)j)).X;
                        p.Y = ((PointD)line.PointList.get((int)j)).Y;
                        p.Z = z;
                        idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Y);
                        if (idx != null) {
                            yi = idx[0];
                            xi = idx[1];
                            p.M = data.getDouble(yi * nx + xi);
                        }
                        cb = ls.findLegendBreak((Number)p.M);
                        cbs.add(cb);
                        points.add(p);
                    }
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection3D streamLines(Array xa, Array ya, Array za, Array ua, Array va, Array data, int density, LegendScheme ls) {
        List streamlines;
        Object y;
        Object x;
        GraphicCollection3D graphics = new GraphicCollection3D();
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ua);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va);
        if (xa.getRank() == 1) {
            x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        } else {
            xa = xa.copyIfView();
            ya = ya.copyIfView();
            x = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
            y = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
            streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[][])x, (double[][])y, (int)density);
        }
        int ny = u.length;
        int nx = u[0].length;
        ColorBreak cb = ls.getLegendBreak(0);
        if (data == null) {
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((PointD)line.PointList.get((int)j)).X;
                    p.Y = ((PointD)line.PointList.get((int)j)).Y;
                    int[] idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.Y, (double)p.Z);
                    if (idx != null) {
                        int yi = idx[0];
                        int xi = idx[1];
                        p.Z = za.getDouble(yi * nx + xi);
                    }
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, cb));
            }
        } else {
            data = data.copyIfView();
            for (PolyLine line : streamlines) {
                PolylineZShape shape = new PolylineZShape();
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                ColorBreakCollection cbs = new ColorBreakCollection();
                for (int j = 0; j < line.PointList.size(); ++j) {
                    PointZ p = new PointZ();
                    p.X = ((PointD)line.PointList.get((int)j)).X;
                    p.Y = ((PointD)line.PointList.get((int)j)).Y;
                    int[] idx = ArrayUtil.gridIndex((Array)xa, (Array)ya, (double)p.X, (double)p.Y);
                    if (idx != null) {
                        int yi = idx[0];
                        int xi = idx[1];
                        p.Z = za.getDouble(yi * nx + xi);
                        p.M = data.getDouble(yi * nx + xi);
                    }
                    cb = ls.findLegendBreak((Number)p.M);
                    cbs.add(cb);
                    points.add(p);
                }
                shape.setPoints(points);
                graphics.add(new Graphic((Shape)shape, (ColorBreak)cbs));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static List<GraphicCollection3D> streamSlice(Array xa, Array ya, Array za, Array ua, Array va, Array wa, Array data, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, int density, LegendScheme ls) throws InvalidRangeException {
        Array xxa;
        GraphicCollection3D graphics;
        Array zza;
        Array r;
        Array xva;
        Array xua;
        int[] shape;
        Array aa;
        int i;
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        for (i = 0; i < xSlice.size(); ++i) {
            double x = xSlice.get(i).doubleValue();
            aa = xa;
            if (xa.getRank() == 3) {
                shape = xa.getShape();
                aa = xa.section(new int[]{0, 0, 0}, new int[]{1, 1, shape[2]});
            }
            xua = ArrayUtil.slice((Array)va, (int)2, (Array)aa, (double)x);
            xva = ArrayUtil.slice((Array)wa, (int)2, (Array)aa, (double)x);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)2, (Array)aa, (double)x);
            Array yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)2, (Array)aa, (double)x);
            zza = za.getRank() == 1 ? za : ArrayUtil.slice((Array)za, (int)2, (Array)aa, (double)x);
            graphics = GraphicFactory.streamLines(yya, zza, x, xua, xva, r, density, "x", ls);
            sgs.add(graphics);
        }
        for (i = 0; i < ySlice.size(); ++i) {
            double y = ySlice.get(i).doubleValue();
            aa = ya;
            if (ya.getRank() == 3) {
                shape = ya.getShape();
                aa = ya.section(new int[]{0, 0, 0}, new int[]{1, shape[1], 1});
            }
            xua = ArrayUtil.slice((Array)ua, (int)1, (Array)aa, (double)y);
            xva = ArrayUtil.slice((Array)wa, (int)1, (Array)aa, (double)y);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)1, (Array)aa, (double)y);
            xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)1, (Array)aa, (double)y);
            zza = za.getRank() == 1 ? za : ArrayUtil.slice((Array)za, (int)1, (Array)aa, (double)y);
            graphics = GraphicFactory.streamLines(xxa, zza, y, xua, xva, r, density, "y", ls);
            sgs.add(graphics);
        }
        for (i = 0; i < zSlice.size(); ++i) {
            double z = zSlice.get(i).doubleValue();
            aa = za;
            if (za.getRank() == 3) {
                shape = za.getShape();
                aa = za.section(new int[]{0, 0, 0}, new int[]{shape[0], 1, 1});
            }
            xua = ArrayUtil.slice((Array)ua, (int)0, (Array)aa, (double)z);
            xva = ArrayUtil.slice((Array)va, (int)0, (Array)aa, (double)z);
            r = data == null ? null : ArrayUtil.slice((Array)data, (int)0, (Array)aa, (double)z);
            xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)0, (Array)aa, (double)z);
            Array yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)0, (Array)aa, (double)z);
            graphics = GraphicFactory.streamLines(xxa, yya, z, xua, xva, r, density, "z", ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static List<GraphicCollection3D> streamSlice(Array xa, Array ya, Array za, Array ua, Array va, Array wa, Array data, List<Integer> zSliceIndex, int density, LegendScheme ls) throws InvalidRangeException {
        ArrayList<GraphicCollection3D> sgs = new ArrayList<GraphicCollection3D>();
        for (int i = 0; i < zSliceIndex.size(); ++i) {
            GraphicCollection3D graphics;
            Array yya;
            int zIdx = zSliceIndex.get(i);
            Array aa = za;
            Array xua = ArrayUtil.slice((Array)ua, (int)0, (int)zIdx);
            Array xva = ArrayUtil.slice((Array)va, (int)0, (int)zIdx);
            Array r = data == null ? null : ArrayUtil.slice((Array)data, (int)0, (int)zIdx);
            Array xxa = xa.getRank() == 1 ? xa : ArrayUtil.slice((Array)xa, (int)0, (int)zIdx);
            Array array = yya = ya.getRank() == 1 ? ya : ArrayUtil.slice((Array)ya, (int)0, (int)zIdx);
            if (za.getRank() == 1) {
                double z = za.getDouble(zIdx);
                graphics = GraphicFactory.streamLines(xxa, yya, z, xua, xva, r, density, "z", ls);
            } else {
                Array zza = ArrayUtil.slice((Array)za, (int)0, (int)zIdx);
                zza = zza.copyIfView();
                graphics = GraphicFactory.streamLines(xxa, yya, zza, xua, xva, r, density, ls);
            }
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection[] createPieArcs(Array xdata, List<Color> colors, List<String> labels, float startAngle, List<Number> explode, Font labelFont, Color labelColor, float labelDis, String autopct, float pctDis, float radius, HashMap wedgeprops) {
        double dx;
        GraphicCollection gc = new GraphicCollection();
        GraphicCollection lgc = new GraphicCollection();
        GraphicCollection pgc = new GraphicCollection();
        double sum = ArrayMath.sum((Array)xdata).doubleValue();
        String pct = null;
        LegendScheme ls = new LegendScheme(ShapeTypes.POLYGON);
        Boolean drawEdge = wedgeprops.get("drawedge") == null ? null : (Boolean)wedgeprops.get("drawedge");
        Color edgeColor = wedgeprops.get("edgecolor") == null ? null : (Color)wedgeprops.get("edgecolor");
        Float lineWidth = wedgeprops.get("linewidth") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("linewidth"))));
        Float wedgeWidth = wedgeprops.get("width") == null ? null : Float.valueOf(Float.parseFloat(String.valueOf(wedgeprops.get("width"))));
        IndexIterator xIter = xdata.getIndexIterator();
        int i = 0;
        while (xIter.hasNext()) {
            double ldy;
            double ldx;
            ChartText ps;
            String label;
            double dy;
            double v = xIter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            if (sum > 1.0) {
                v /= sum;
            }
            float sweepAngle = (float)(360.0 * v);
            ArcShape aShape = new ArcShape();
            aShape.setStartAngle(startAngle);
            aShape.setSweepAngle(sweepAngle);
            float angle = startAngle + sweepAngle / 2.0f;
            if (explode == null) {
                dx = 0.0;
                dy = 0.0;
            } else {
                float ex = explode.get(i).floatValue();
                aShape.setExplode(ex);
                dx = (double)(radius * ex) * Math.cos((double)angle * Math.PI / 180.0);
                dy = (double)(radius * ex) * Math.sin((double)angle * Math.PI / 180.0);
            }
            ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
            points.add(new org.meteoinfo.common.PointD((double)(-radius) + dx, (double)(-radius) + dy));
            points.add(new org.meteoinfo.common.PointD((double)(-radius) + dx, (double)radius + dy));
            points.add(new org.meteoinfo.common.PointD((double)radius + dx, (double)radius + dy));
            points.add(new org.meteoinfo.common.PointD((double)radius + dx, (double)(-radius) + dy));
            points.add(new org.meteoinfo.common.PointD(dx, dy));
            aShape.setPoints(points);
            if (wedgeWidth != null) {
                aShape.setWedgeWidth(wedgeWidth);
            }
            PolygonBreak pgb = new PolygonBreak();
            pgb.setColor(colors.get(i));
            if (drawEdge != null) {
                pgb.setDrawOutline(drawEdge.booleanValue());
            }
            if (edgeColor != null) {
                pgb.setOutlineColor(edgeColor);
            }
            if (lineWidth != null) {
                pgb.setOutlineSize(lineWidth.floatValue());
            }
            if (labels == null) {
                label = autopct == null ? "" : String.format(autopct, v * 100.0);
            } else {
                label = labels.get(i);
                if (autopct != null) {
                    pct = String.format(autopct, v * 100.0);
                }
            }
            pgb.setCaption(label);
            Graphic graphic = new Graphic((Shape)aShape, (ColorBreak)pgb);
            gc.add(graphic);
            ls.addLegendBreak((ColorBreak)pgb);
            if (!label.isEmpty()) {
                ps = new ChartText();
                ldx = dx + (double)(radius * labelDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * labelDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(label);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                if (angle > 90.0f && angle < 270.0f) {
                    ps.setXAlign(XAlign.RIGHT);
                }
                if (angle > 180.0f && angle < 360.0f) {
                    ps.setYAlign(YAlign.TOP);
                }
                if (angle == 0.0f || angle == 180.0f) {
                    ps.setYAlign(YAlign.CENTER);
                } else if (angle == 90.0f || angle == 270.0f) {
                    ps.setXAlign(XAlign.CENTER);
                }
                lgc.add(new Graphic((Shape)ps, new ColorBreak()));
            }
            if (pct != null) {
                ps = new ChartText();
                ldx = dx + (double)(radius * pctDis) * Math.cos((double)angle * Math.PI / 180.0);
                ldy = dy + (double)(radius * pctDis) * Math.sin((double)angle * Math.PI / 180.0);
                ps.setPoint(ldx, ldy);
                ps.setText(pct);
                ps.setFont(labelFont);
                ps.setColor(labelColor);
                ps.setXAlign(XAlign.CENTER);
                ps.setYAlign(YAlign.CENTER);
                pgc.add(new Graphic((Shape)ps, new ColorBreak()));
            }
            startAngle += sweepAngle;
            ++i;
        }
        gc.setSingleLegend(false);
        gc.setLegendScheme(ls);
        gc.getLabelSet().setLabelFont(labelFont);
        gc.getLabelSet().setLabelColor(labelColor);
        dx = (double)radius * 0.1;
        if (labels != null || autopct != null) {
            Extent ext = gc.getExtent().extend(dx, dx);
            gc.setExtent(ext);
        }
        if (pct == null) {
            if (lgc.isEmpty()) {
                return new GraphicCollection[]{gc};
            }
            return new GraphicCollection[]{gc, lgc};
        }
        if (lgc.isEmpty()) {
            return new GraphicCollection[]{gc, pgc};
        }
        return new GraphicCollection[]{gc, lgc, pgc};
    }

    public static GraphicCollection createBox(List<Array> xdata, List<Number> positions, List<Number> widths, boolean showcaps, boolean showfliers, boolean showmeans, boolean showmedians, PolygonBreak boxBreak, ColorBreak medianBreak, PolylineBreak whiskerBreak, PolylineBreak capBreak, ColorBreak meanBreak, PointBreak flierBreak) {
        int i;
        GraphicCollection gc = new GraphicCollection();
        int n = xdata.size();
        if (positions == null) {
            positions = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                positions.add(i + 1);
            }
        }
        if (widths == null) {
            widths = new ArrayList<Number>();
            for (i = 0; i < n; ++i) {
                widths.add(0.5);
            }
        }
        if (boxBreak == null) {
            boxBreak = new PolygonBreak();
            boxBreak.setDrawFill(false);
            boxBreak.setOutlineColor(Color.blue);
        }
        if (medianBreak == null) {
            medianBreak = new PolylineBreak();
            medianBreak.setColor(Color.red);
        }
        if (whiskerBreak == null) {
            whiskerBreak = new PolylineBreak();
            whiskerBreak.setColor(Color.black);
            whiskerBreak.setStyle(LineStyles.DASH);
        }
        if (capBreak == null) {
            capBreak = new PolylineBreak();
            capBreak.setColor(Color.black);
        }
        if (flierBreak == null) {
            flierBreak = new PointBreak();
            flierBreak.setStyle(PointStyle.PLUS);
        }
        if (meanBreak == null) {
            meanBreak = new PointBreak();
            ((PointBreak)meanBreak).setStyle(PointStyle.SQUARE);
            ((PointBreak)meanBreak).setColor(Color.red);
            ((PointBreak)meanBreak).setOutlineColor(Color.black);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            Array a = xdata.get(i2);
            if (Double.isNaN(ArrayMath.min((Array)a).doubleValue())) continue;
            double v = positions.get(i2).doubleValue();
            double width = widths.get(i2).doubleValue();
            double q1 = Statistics.quantile((Array)a, (int)1);
            double q3 = Statistics.quantile((Array)a, (int)3);
            double median = Statistics.quantile((Array)a, (int)2);
            double mind = ArrayMath.getMinimum((Array)a);
            double maxd = ArrayMath.getMaximum((Array)a);
            double mino = q1 - (q3 - q1) * 1.5;
            double maxo = q3 + (q3 - q1) * 1.5;
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            pList.add(new org.meteoinfo.common.PointD(v - width * 0.5, q1));
            pList.add(new org.meteoinfo.common.PointD(v - width * 0.5, q3));
            pList.add(new org.meteoinfo.common.PointD(v + width * 0.5, q3));
            pList.add(new org.meteoinfo.common.PointD(v + width * 0.5, q1));
            pList.add(new org.meteoinfo.common.PointD(v - width * 0.5, q1));
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(pList);
            gc.add(new Graphic((Shape)pgs, (ColorBreak)boxBreak));
            if (showmedians) {
                if (medianBreak.getBreakType() == BreakTypes.POLYLINE_BREAK) {
                    pList = new ArrayList();
                    pList.add(new org.meteoinfo.common.PointD(v - width * 0.5, median));
                    pList.add(new org.meteoinfo.common.PointD(v + width * 0.5, median));
                    PolylineShape pls = new PolylineShape();
                    pls.setPoints(pList);
                    gc.add(new Graphic((Shape)pls, medianBreak));
                } else {
                    PointShape ps = new PointShape();
                    ps.setPoint(new org.meteoinfo.common.PointD(v, median));
                    gc.add(new Graphic((Shape)ps, medianBreak));
                }
            }
            double min = Math.max(mino, mind);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.common.PointD(v, q1));
            pList.add(new org.meteoinfo.common.PointD(v, min));
            PolylineShape pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(v - width * 0.25, min));
                pList.add(new org.meteoinfo.common.PointD(v + width * 0.25, min));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && mino > mind) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) < mino) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new org.meteoinfo.common.PointD(v, a.getDouble(j)));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            double max = Math.min(maxo, maxd);
            pList = new ArrayList();
            pList.add(new org.meteoinfo.common.PointD(v, q3));
            pList.add(new org.meteoinfo.common.PointD(v, max));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, (ColorBreak)whiskerBreak));
            if (showcaps) {
                pList = new ArrayList();
                pList.add(new org.meteoinfo.common.PointD(v - width * 0.25, max));
                pList.add(new org.meteoinfo.common.PointD(v + width * 0.25, max));
                pls = new PolylineShape();
                pls.setPoints(pList);
                gc.add(new Graphic((Shape)pls, (ColorBreak)capBreak));
            }
            if (showfliers && maxo < maxd) {
                int j = 0;
                while ((long)j < a.getSize()) {
                    if (a.getDouble(j) > maxo) {
                        PointShape ps = new PointShape();
                        ps.setPoint(new org.meteoinfo.common.PointD(v, a.getDouble(j)));
                        gc.add(new Graphic((Shape)ps, (ColorBreak)flierBreak));
                    }
                    ++j;
                }
            }
            if (!showmeans) continue;
            double mean = ArrayMath.mean((Array)a);
            if (meanBreak.getBreakType() == BreakTypes.POINT_BREAK) {
                PointShape ps = new PointShape();
                ps.setPoint(new org.meteoinfo.common.PointD(v, mean));
                gc.add(new Graphic((Shape)ps, meanBreak));
                continue;
            }
            pList = new ArrayList();
            pList.add(new org.meteoinfo.common.PointD(v - width * 0.5, mean));
            pList.add(new org.meteoinfo.common.PointD(v + width * 0.5, mean));
            pls = new PolylineShape();
            pls.setPoints(pList);
            gc.add(new Graphic((Shape)pls, meanBreak));
        }
        gc.setSingleLegend(false);
        return gc;
    }

    public static void polarToCartesian(GraphicCollection graphics) {
        for (int m = 0; m < graphics.getNumGraphics(); ++m) {
            Graphic graphic = graphics.get(m);
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                for (org.meteoinfo.common.PointD p : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian((double)p.X, (double)p.Y);
                    points.add(new org.meteoinfo.common.PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
            }
        }
        graphics.updateExtent();
    }

    public static void polarToCartesian(GraphicCollection graphics, double bottom) {
        for (int m = 0; m < graphics.getNumGraphics(); ++m) {
            Graphic graphic = graphics.get(m);
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                Shape shape = gg.getShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                for (org.meteoinfo.common.PointD p : shape.getPoints()) {
                    double[] xy = MIMath.polarToCartesian((double)p.X, (double)(p.Y + bottom));
                    points.add(new org.meteoinfo.common.PointD(xy[0], xy[1]));
                }
                shape.setPoints(points);
            }
        }
        graphics.updateExtent();
    }

    private static int findIndex(double[] values, double v) {
        int idx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (i == values.length - 1) {
                if (v != values[i]) continue;
                idx = i;
                break;
            }
            if (v != values[i] && !(v < values[i + 1])) continue;
            idx = i;
            break;
        }
        return idx;
    }
}

