/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.graphic.GraphicCollection3D;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class SurfaceGraphics
extends GraphicCollection3D {
    private PointZ[][] vertices;
    private int[][] legendIndex;
    private boolean faceInterp;
    private boolean edgeInterp;
    private boolean mesh;
    private Transform transform;
    private Vector3f[][] tVertices;
    private Vector3f[][] normals;

    public SurfaceGraphics() {
        this.allQuads = true;
        this.singleLegend = false;
        this.faceInterp = false;
        this.edgeInterp = false;
        this.mesh = false;
        this.usingLight = true;
    }

    public PointZ[][] getVertices() {
        return this.vertices;
    }

    public void setVertices(PointZ[][] value) {
        this.vertices = value;
        double zmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmin = Double.MAX_VALUE;
        double zmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        double xmax = Double.MIN_VALUE;
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                PointZ p = value[i][j];
                xmin = xmin > p.X ? p.X : xmin;
                ymin = ymin > p.Y ? p.Y : ymin;
                zmin = zmin > p.Z ? p.Z : zmin;
                xmax = xmax < p.X ? p.X : xmax;
                ymax = ymax < p.Y ? p.Y : ymax;
                zmax = zmax < p.Z ? p.Z : zmax;
            }
        }
        Extent3D extent = new Extent3D(xmin, xmax, ymin, ymax, zmin, zmax);
        this.setExtent((Extent)extent);
    }

    public PointZ getVertex(int i, int j) {
        return this.vertices[i][j];
    }

    public Vector3f getTVertex(int i, int j) {
        return this.tVertices[i][j];
    }

    public Vector3f getNormal(int i, int j) {
        return this.normals[i][j];
    }

    public boolean isFaceInterp() {
        return this.faceInterp;
    }

    public void setFaceInterp(boolean value) {
        this.faceInterp = value;
    }

    public boolean isEdgeInterp() {
        return this.edgeInterp;
    }

    public void setEdgeInterp(boolean value) {
        this.edgeInterp = value;
    }

    public boolean isMesh() {
        return this.mesh;
    }

    public void setMesh(boolean value) {
        this.mesh = value;
    }

    public int getDim1() {
        return this.vertices.length;
    }

    public int getDim2() {
        return this.vertices[0].length;
    }

    public void setLegendScheme(LegendScheme value) {
        this.legendScheme = value;
        this.updateLegendIndex();
    }

    public boolean isMultiColors() {
        return this.getLegendScheme().getBreakNum() > 1;
    }

    public void updateLegendIndex() {
        int dim1 = this.getDim1();
        int dim2 = this.getDim2();
        this.legendIndex = new int[dim1][dim2];
        if (this.legendScheme.getBreakNum() > 1) {
            for (int i = 0; i < dim1; ++i) {
                for (int j = 0; j < dim2; ++j) {
                    this.legendIndex[i][j] = this.legendScheme.legendBreakIndex(this.vertices[i][j].M);
                }
            }
        }
    }

    public ColorBreak getLegendBreak(int i, int j) {
        return this.legendScheme.getLegendBreak(this.legendIndex[i][j]);
    }

    public float[] getRGBA(int i, int j) {
        return this.legendScheme.getLegendBreak(this.legendIndex[i][j]).getColor().getRGBComponents(null);
    }

    public float[] getEdgeRGBA(int i, int j) {
        PolygonBreak pb = (PolygonBreak)this.legendScheme.getLegendBreak(this.legendIndex[i][j]);
        return pb.getOutlineColor().getRGBComponents(null);
    }

    public LegendScheme getLegendScheme() {
        if (this.mesh) {
            LegendScheme ls = this.legendScheme.convertTo(ShapeTypes.IMAGE, true);
            return ls;
        }
        return this.legendScheme;
    }

    public void transform(Transform transform) {
        if (this.transform != null && this.transform.equals(transform)) {
            return;
        }
        this.transform = (Transform)transform.clone();
        int dim1 = this.getDim1();
        int dim2 = this.getDim2();
        this.tVertices = new Vector3f[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                PointZ p = this.vertices[i][j];
                this.tVertices[i][j] = new Vector3f(transform.transform_x((float)p.X), transform.transform_y((float)p.Y), transform.transform_z((float)p.Z));
            }
        }
        this.normals = new Vector3f[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                Vector3f normal;
                Vector3f v = this.tVertices[i][j];
                Vector3f left = j > 0 ? this.tVertices[i][j - 1] : null;
                Vector3f right = j < dim2 - 1 ? this.tVertices[i][j + 1] : null;
                Vector3f down = i > 0 ? this.tVertices[i - 1][j] : null;
                Vector3f up = i < dim1 - 1 ? this.tVertices[i + 1][j] : null;
                Vector3f nLeftUp = left == null || up == null ? new Vector3f() : left.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)up.sub((Vector3fc)v, new Vector3f()));
                Vector3f nLeftDown = left == null || down == null ? new Vector3f() : down.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)left.sub((Vector3fc)v, new Vector3f()));
                Vector3f nRightUp = right == null || up == null ? new Vector3f() : up.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)right.sub((Vector3fc)v, new Vector3f()));
                Vector3f nRightDown = right == null || down == null ? new Vector3f() : right.sub((Vector3fc)v, new Vector3f()).cross((Vector3fc)down.sub((Vector3fc)v, new Vector3f()));
                this.normals[i][j] = normal = nLeftUp.add((Vector3fc)nLeftDown).add((Vector3fc)nRightUp).add((Vector3fc)nRightDown).normalize();
            }
        }
    }
}

