/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import com.jogamp.common.nio.Buffers;
import java.awt.Color;
import java.nio.Buffer;
import java.util.List;
import org.joml.Math;
import org.meteoinfo.chart.graphic.GraphicCollection3D;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;

public class VolumeGraphics
extends GraphicCollection3D {
    public static Buffer buffer = null;
    final int width;
    final int height;
    final int depth;
    final byte[] data;
    final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public static byte[] colors;
    private byte[] originalColors;
    public static float[] opacityLevels;
    public static float[] opacityNodes;
    public static float[] colorRange;
    private float[] aabbMin = new float[]{-1.0f, -1.0f, -1.0f};
    private float[] aabbMax = new float[]{1.0f, 1.0f, 1.0f};
    boolean hasChanges = true;
    final float[] vertexBufferData = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f};

    public VolumeGraphics(byte[] data, int width, int height, int depth, byte[] colors) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.data = data;
        buffer = Buffers.newDirectByteBuffer((byte[])this.data);
        VolumeGraphics.colors = colors;
        Extent3D extent = new Extent3D();
        extent.maxX = width;
        extent.maxY = height;
        extent.maxZ = depth;
        this.setExtent((Extent)extent);
    }

    public VolumeGraphics(Array value, ColorMap colorMap, double vMin, double vMax) {
        value = value.copyIfView();
        int[] shape = value.getShape();
        this.depth = shape[0];
        this.height = shape[1];
        this.width = shape[2];
        this.data = new byte[this.width * this.height * this.depth];
        double range = vMax - vMin;
        int i = 0;
        while ((long)i < value.getSize()) {
            this.data[i] = (byte)((value.getDouble(i) - vMin) / range * 255.0);
            ++i;
        }
        buffer = Buffers.newDirectByteBuffer((byte[])this.data);
        Color[] oColors = colorMap.getColors();
        int n = oColors.length;
        this.originalColors = new byte[n * 3];
        for (int i2 = 0; i2 < n; ++i2) {
            int color = oColors[i2].getRGB();
            this.originalColors[i2 * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i2 * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i2 * 3 + 2] = (byte)(color & 0xFF);
        }
        double[] values = MIMath.getIntervalValues((double)vMin, (double)vMax, (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme((double[])values, (Color[])oColors, (ShapeTypes)ShapeTypes.POLYGON, (double)vMin, (double)vMax);
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public VolumeGraphics(Array value, LegendScheme ls) {
        value = value.copyIfView();
        int[] shape = value.getShape();
        this.depth = shape[0];
        this.height = shape[1];
        this.width = shape[2];
        this.data = new byte[this.width * this.height * this.depth];
        List oColors = ls.getColors();
        int n = oColors.size();
        int i = 0;
        while ((long)i < value.getSize()) {
            this.data[i] = (byte)((double)ls.legendBreakIndex(value.getDouble(i)) * 255.0 / (double)n);
            ++i;
        }
        buffer = Buffers.newDirectByteBuffer((byte[])this.data);
        this.originalColors = new byte[n * 3];
        for (i = 0; i < n; ++i) {
            int color = ((Color)oColors.get(i)).getRGB();
            this.originalColors[i * 3 + 0] = (byte)(color >> 16 & 0xFF);
            this.originalColors[i * 3 + 1] = (byte)(color >> 8 & 0xFF);
            this.originalColors[i * 3 + 2] = (byte)(color & 0xFF);
        }
        this.setLegendScheme(ls);
        this.setSingleLegend(false);
    }

    public void updateColors() {
        float cRange = colorRange[1] - colorRange[0];
        float min = opacityLevels[0] * opacityLevels[0];
        float max = opacityLevels[1] * opacityLevels[1];
        float opacityNodeRange = opacityNodes[1] - opacityNodes[0];
        int n = this.originalColors.length / 3;
        colors = new byte[n * 4];
        for (int i = 0; i < n; ++i) {
            float a;
            float px = (float)i / (float)n;
            if (px <= opacityNodes[0]) {
                a = opacityNodes[0];
            } else if (px > opacityNodes[1]) {
                a = opacityNodes[1];
            } else {
                float ratio = (px - opacityNodes[0]) / opacityNodeRange;
                a = min * (1.0f - ratio) + max * ratio;
            }
            int colorI = 0;
            if (px > colorRange[1] * 255.0f) {
                colorI = 255;
            } else if (px > colorRange[0]) {
                colorI = Math.clamp((int)0, (int)255, (int)java.lang.Math.round(((float)i / 255.0f - colorRange[0]) * (1.0f / cRange) * 255.0f));
            }
            float r = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 0]) / 255.0f;
            float g = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 1]) / 255.0f;
            float b = (float)Byte.toUnsignedInt(this.originalColors[colorI * 3 + 2]) / 255.0f;
            r = r * r * a;
            g = g * g * a;
            b = b * b * a;
            VolumeGraphics.colors[i * 4 + 0] = (byte)java.lang.Math.round(r * 255.0f);
            VolumeGraphics.colors[i * 4 + 1] = (byte)java.lang.Math.round(g * 255.0f);
            VolumeGraphics.colors[i * 4 + 2] = (byte)java.lang.Math.round(b * 255.0f);
            VolumeGraphics.colors[i * 4 + 3] = (byte)java.lang.Math.round(a * 255.0f);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public byte[] getData() {
        return this.data;
    }

    public float[] getScale() {
        return this.scale;
    }

    public float getScale(int i) {
        return this.scale[i];
    }

    public int getColorNum() {
        return colors.length / 4;
    }

    public float[] getAabbMin() {
        return this.aabbMin;
    }

    public float[] getAabbMax() {
        return this.aabbMax;
    }

    public float[] getVertexBufferData() {
        return this.vertexBufferData;
    }

    public float[] getVertexBufferData(Transform transform) {
        Extent3D extent = (Extent3D)this.getExtent();
        float xMin = (float)extent.minX;
        float xMax = (float)extent.maxX;
        float yMin = (float)extent.minY;
        float yMax = (float)extent.maxY;
        float zMin = (float)extent.minZ;
        float zMax = (float)extent.maxZ;
        float[] p0 = transform.transform(xMin, yMin, zMin);
        float[] p1 = transform.transform(xMax, yMin, zMin);
        float[] p2 = transform.transform(xMax, yMax, zMin);
        float[] p3 = transform.transform(xMin, yMax, zMin);
        float[] p4 = transform.transform(xMin, yMin, zMax);
        float[] p5 = transform.transform(xMax, yMin, zMax);
        float[] p6 = transform.transform(xMax, yMax, zMax);
        float[] p7 = transform.transform(xMin, yMax, zMax);
        this.aabbMin = p0;
        this.aabbMax = p6;
        return new float[]{p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p4[0], p4[1], p4[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p1[0], p1[1], p1[2], p1[0], p1[1], p1[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p5[0], p5[1], p5[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p2[0], p2[1], p2[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p6[0], p6[1], p6[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p3[0], p3[1], p3[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p7[0], p7[1], p7[2], p0[0], p0[1], p0[2], p4[0], p4[1], p4[2], p0[0], p0[1], p0[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p1[0], p1[1], p1[2], p3[0], p3[1], p3[2], p2[0], p2[1], p2[2], p4[0], p4[1], p4[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p5[0], p5[1], p5[2], p7[0], p7[1], p7[2], p6[0], p6[1], p6[2]};
    }

    static {
        opacityLevels = new float[]{0.0f, 1.0f};
        opacityNodes = new float[]{0.0f, 1.0f};
        colorRange = new float[]{0.0f, 1.0f};
    }
}

