/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.jogl.Plot3DGL;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.image.ImageUtil;
import org.w3c.dom.Element;

public class GLChartPanel
extends GLJPanel
implements IChartPanel {
    private Plot3DGL plot3DGL;
    private boolean sampleBuffers = false;
    private final Point mouseDownPoint = new Point(0, 0);
    private Point mouseLastPos = new Point(0, 0);
    private boolean dragMode = false;
    private JPopupMenu popupMenu;
    private MouseMode mouseMode;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;
    private FPSAnimator animator;

    public GLChartPanel() {
        this.setDoubleBuffered(true);
    }

    public GLChartPanel(Plot3DGL pltGL) {
        this();
        this.init(pltGL);
    }

    public GLChartPanel(GLCapabilities cap) {
        super((GLCapabilitiesImmutable)cap);
        this.sampleBuffers = cap.getSampleBuffers();
    }

    public static GLCapabilities createCapabilities(boolean doubleBuffered, boolean sampleBuffers, int numSamples) {
        GLProfile profile = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(profile);
        cap.setDoubleBuffered(doubleBuffered);
        cap.setSampleBuffers(sampleBuffers);
        cap.setNumSamples(numSamples);
        return cap;
    }

    public GLChartPanel(GLCapabilities cap, Plot3DGL pltGL) {
        super((GLCapabilitiesImmutable)cap);
        this.sampleBuffers = cap.getSampleBuffers();
        this.init(pltGL);
    }

    public static GLChartPanel factory(boolean doubleBuffered, boolean sampleBuffers, int numSamples, Plot3DGL pltGL) {
        GLProfile profile = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(profile);
        cap.setDoubleBuffered(doubleBuffered);
        cap.setSampleBuffers(sampleBuffers);
        cap.setNumSamples(numSamples);
        return new GLChartPanel(cap, pltGL);
    }

    public static GLChartPanel factory(Plot3DGL pltGL) {
        return GLChartPanel.factory(true, true, 4, pltGL);
    }

    public static GLChartPanel factory() {
        return GLChartPanel.factory(true, true, 4, new Plot3DGL());
    }

    private void init(Plot3DGL pltGL) {
        this.plot3DGL = pltGL;
        this.addGLEventListener(pltGL);
        this.plot3DGL.setSampleBuffers(this.sampleBuffers);
        this.setMouseMode(MouseMode.ROTATE);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GLChartPanel.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GLChartPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                GLChartPanel.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GLChartPanel.this.onMouseWheelMoved(e);
            }
        });
    }

    public Plot3DGL getPlot() {
        return this.plot3DGL;
    }

    public void setPlot(Plot3DGL plot) {
        this.init(plot);
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    @Override
    public final void setMouseMode(MouseMode value) {
        this.mouseMode = value;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (this.mouseMode) {
            case SELECT: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case ZOOM_IN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case ZOOM_OUT: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case PAN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case IDENTIFIER: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case ROTATE: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/rotate.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
            }
        }
        this.setCursor(customCursor);
    }

    void onComponentResized(ComponentEvent e) {
        this.display();
    }

    void onMousePressed(MouseEvent e) {
        this.mouseDownPoint.x = e.getX();
        this.mouseDownPoint.y = e.getY();
        this.mouseLastPos = (Point)this.mouseDownPoint.clone();
    }

    void onMouseDragged(MouseEvent e) {
        this.dragMode = true;
        int x = e.getX();
        int y = e.getY();
        switch (this.mouseMode) {
            case SELECT: 
            case ZOOM_IN: {
                this.repaint();
                break;
            }
            case PAN: {
                Dimension size = e.getComponent().getSize();
                float dx = (float)(x - this.mouseLastPos.x) / (float)size.width;
                float dy = (float)(this.mouseLastPos.y - y) / (float)size.height;
                Extent3D extent = this.plot3DGL.getExtent();
                float rotation = this.plot3DGL.getAngleY();
                if (rotation < 90.0f || rotation > 270.0f) {
                    dx = -dx;
                    dy = -dy;
                }
                extent = extent.shift(extent.getWidth() * (double)dx, extent.getHeight() * (double)dy, 0.0);
                this.plot3DGL.setExtent(extent);
                this.repaint();
                break;
            }
            case ROTATE: {
                if (e.isShiftDown()) {
                    Dimension size = e.getComponent().getSize();
                    float dx = (float)(x - this.mouseLastPos.x) / (float)size.width;
                    float dy = (float)(this.mouseLastPos.y - y) / (float)size.height;
                    Extent3D extent = this.plot3DGL.getExtent();
                    float rotation = this.plot3DGL.getAngleY();
                    if (rotation < 90.0f || rotation > 270.0f) {
                        dx = -dx;
                        dy = -dy;
                    }
                    extent = extent.shift(extent.getWidth() * (double)dx, extent.getHeight() * (double)dy, 0.0);
                    this.plot3DGL.setExtent(extent);
                } else {
                    Dimension size = e.getComponent().getSize();
                    float thetaY = 360.0f * ((float)(x - this.mouseLastPos.x) / (float)size.width);
                    float thetaX = 360.0f * ((float)(this.mouseLastPos.y - y) / (float)size.height);
                    float elevation = this.plot3DGL.getAngleX() - thetaX;
                    if (elevation > 0.0f) {
                        elevation = 0.0f;
                    }
                    if (elevation < -180.0f) {
                        elevation = -180.0f;
                    }
                    this.plot3DGL.setAngleX(elevation);
                    float rotation = this.plot3DGL.getAngleY() + thetaY;
                    if (rotation >= 360.0f) {
                        rotation -= 360.0f;
                    }
                    if (rotation < 0.0f) {
                        rotation += 360.0f;
                    }
                    this.plot3DGL.setAngleY(rotation);
                }
                this.repaint();
            }
        }
        this.mouseLastPos.x = x;
        this.mouseLastPos.y = y;
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        Extent3D extent = this.plot3DGL.getExtent();
        float zoomF = (float)e.getWheelRotation() / 10.0f;
        double dx = extent.getWidth() * (double)zoomF;
        double dy = extent.getHeight() * (double)zoomF;
        extent = extent.extend(dx, dy, 0.0);
        this.plot3DGL.setExtent(extent);
        this.repaint();
    }

    public GL2 getGL2() {
        return this.getGL().getGL2();
    }

    public BufferedImage paintViewImage() {
        this.plot3DGL.setDoScreenShot(true);
        this.display();
        return this.plot3DGL.getScreenImage();
    }

    public BufferedImage paintViewImage(int width, int height) {
        GLProfile glp = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        caps.setRedBits(8);
        caps.setBlueBits(8);
        caps.setGreenBits(8);
        caps.setOnscreen(false);
        caps.setPBuffer(true);
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)glp);
        GLOffscreenAutoDrawable drawable = factory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)caps, null, width, height);
        drawable.addGLEventListener((GLEventListener)this.plot3DGL);
        this.plot3DGL.setDoScreenShot(true);
        drawable.display();
        BufferedImage image = this.plot3DGL.getScreenImage();
        drawable.destroy();
        return image;
    }

    public BufferedImage paintViewImage_bak(int width, int height) {
        this.paintGraphics();
        GLProfile.initSingleton();
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        caps.setRedBits(8);
        caps.setBlueBits(8);
        caps.setGreenBits(8);
        caps.setOnscreen(false);
        caps.setPBuffer(true);
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)glp);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)window);
        window.setSize(width, height);
        GLWindow glWindow = GLWindow.create((Window)window);
        Assert.assertNotNull((Object)glWindow);
        glWindow.setVisible(true);
        glWindow.addGLEventListener((GLEventListener)this.plot3DGL);
        this.plot3DGL.setDoScreenShot(true);
        glWindow.display();
        BufferedImage image = this.plot3DGL.getScreenImage();
        if (null != glWindow) {
            glWindow.destroy();
        }
        if (null != window) {
            window.destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
        return image;
    }

    public BufferedImage paintViewImage(int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        width = (int)((double)width * scaleFactor);
        height = (int)((double)height * scaleFactor);
        this.plot3DGL.setDpiScale((float)scaleFactor);
        BufferedImage image = this.paintViewImage(width, height);
        this.plot3DGL.setDpiScale(1.0f);
        return image;
    }

    @Override
    public void saveImage(String fn) {
        try {
            this.saveImage(fn, null);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveImage(final String fn, Integer sleep) throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage image = GLChartPanel.this.paintViewImage();
                if (image != null) {
                    String extension = fn.substring(fn.lastIndexOf(46) + 1);
                    try {
                        ImageIO.write((RenderedImage)image, extension, new File(fn));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    public void saveImage(final String fn, final int width, final int height, Integer sleep) throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage image = GLChartPanel.this.paintViewImage(width, height);
                if (image != null) {
                    String extension = fn.substring(fn.lastIndexOf(46) + 1);
                    try {
                        ImageIO.write((RenderedImage)image, extension, new File(fn));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                GLChartPanel.this.plot3DGL.reshape((GLAutoDrawable)GLChartPanel.this, 0, 0, GLChartPanel.this.getWidth(), GLChartPanel.this.getHeight());
            }
        });
    }

    public void saveImage(String fn, int dpi, Integer sleep) throws InterruptedException, IOException {
        this.saveImage(fn, dpi, this.getWidth(), this.getHeight(), sleep);
    }

    public void saveImage(final String fn, final int dpi, final int width, final int height, final Integer sleep) throws InterruptedException, IOException {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                String formatName = fn.substring(fn.lastIndexOf(46) + 1);
                if (formatName.equals("jpg")) {
                    formatName = "jpeg";
                    GLChartPanel.this.saveImage_Jpeg(fn, width, height, dpi);
                    return;
                }
                BufferedImage image = GLChartPanel.this.paintViewImage(width, height, dpi);
                if (image != null) {
                    try {
                        File output = new File(fn);
                        output.delete();
                        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
                        while (iw.hasNext()) {
                            ImageWriter writer = iw.next();
                            ImageWriteParam writeParam = writer.getDefaultWriteParam();
                            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                            if (metadata == null) {
                                metadata = writer.getDefaultImageMetadata(typeSpecifier, null);
                            }
                            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                            ImageUtil.setDPI((IIOMetadata)metadata, (float)dpi);
                            if (sleep != null) {
                                Thread.sleep(sleep * 1000);
                            }
                            try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                                writer.setOutput(stream);
                                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GLChartPanel.this.plot3DGL.reshape((GLAutoDrawable)GLChartPanel.this, 0, 0, GLChartPanel.this.getWidth(), GLChartPanel.this.getHeight());
            }
        });
    }

    private void saveImage_Jpeg(String file, int width, int height, int dpi) {
        BufferedImage bufferedImage = this.paintViewImage(width, height, dpi);
        if (bufferedImage != null) {
            try {
                ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
                imageWriter.setOutput(ios);
                JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality(0.85f);
                IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
                Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
                Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                jfif.setAttribute("Xdensity", Integer.toString(dpi));
                jfif.setAttribute("Ydensity", Integer.toString(dpi));
                jfif.setAttribute("resUnits", "1");
                data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
                imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
                ios.close();
                imageWriter.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.plot3DGL.reshape((GLAutoDrawable)this, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void onUndoZoomClick() {
    }

    @Override
    public void paintGraphics() {
        this.repaint();
    }

    public void repaint() {
        super.repaint();
    }

    public void animator_start() {
        this.animator = new FPSAnimator((GLAutoDrawable)this, 300, true);
        this.animator.start();
    }

    public void animator_stop() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }
}

