/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.SwingUtilities;
import org.joml.Vector3f;
import org.meteoinfo.chart.graphic.GraphicCollection3D;
import org.meteoinfo.chart.graphic.IsosurfaceGraphics;
import org.meteoinfo.chart.graphic.ParticleGraphics;
import org.meteoinfo.chart.graphic.SurfaceGraphics;
import org.meteoinfo.chart.graphic.VolumeGraphics;
import org.meteoinfo.chart.jogl.GLChartPanel;
import org.meteoinfo.chart.jogl.Plot3DGL;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.MarchingCubes;
import org.meteoinfo.chart.shape.TextureShape;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.w3c.dom.Element;

public class JOGLUtil {
    public static void diff3(float[] a, float[] b, float[] c) {
        c[0] = a[0] - b[0];
        c[1] = a[1] - b[1];
        c[2] = a[2] - b[2];
    }

    public static void crossprod(float[] v1, float[] v2, float[] prod) {
        float[] p = new float[]{v1[1] * v2[2] - v2[1] * v1[2], v1[2] * v2[0] - v2[2] * v1[0], v1[0] * v2[1] - v2[0] * v1[1]};
        prod[0] = p[0];
        prod[1] = p[1];
        prod[2] = p[2];
    }

    public static void normalize(float[] v) {
        float d = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        if ((double)d == 0.0) {
            d = 1.0f;
            v[0] = 1.0f;
        }
        d = 1.0f / d;
        v[0] = v[0] * d;
        v[1] = v[1] * d;
        v[2] = v[2] * d;
    }

    public static float[] normalize(float[] n1, float[] n2, float[] n3) {
        float[] q0 = new float[3];
        float[] q1 = new float[3];
        JOGLUtil.diff3(n1, n2, q0);
        JOGLUtil.diff3(n2, n3, q1);
        JOGLUtil.crossprod(q0, q1, q1);
        JOGLUtil.normalize(q1);
        return q1;
    }

    private static void recordItem(GL2 gl, float[] n1, float[] n2, float[] n3, int shadeType) {
        float[] q0 = new float[3];
        float[] q1 = new float[3];
        JOGLUtil.diff3(n1, n2, q0);
        JOGLUtil.diff3(n2, n3, q1);
        JOGLUtil.crossprod(q0, q1, q1);
        JOGLUtil.normalize(q1);
        gl.glBegin(shadeType);
        gl.glNormal3fv(q1, 0);
        gl.glVertex3fv(n1, 0);
        gl.glVertex3fv(n2, 0);
        gl.glVertex3fv(n3, 0);
        gl.glEnd();
    }

    private static void subdivide(GL2 gl, float[] v0, float[] v1, float[] v2, int shadeType) {
        float[] w0 = new float[3];
        float[] w1 = new float[3];
        float[] w2 = new float[3];
        int depth = 1;
        for (int i = 0; i < depth; ++i) {
            int j = 0;
            while (i + j < depth) {
                int k = depth - i - j;
                for (int n = 0; n < 3; ++n) {
                    w0[n] = ((float)i * v0[n] + (float)j * v1[n] + (float)k * v2[n]) / (float)depth;
                    w1[n] = ((float)(i + 1) * v0[n] + (float)j * v1[n] + (float)(k - 1) * v2[n]) / (float)depth;
                    w2[n] = ((float)i * v0[n] + (float)(j + 1) * v1[n] + (float)(k - 1) * v2[n]) / (float)depth;
                }
                float l = (float)Math.sqrt(w0[0] * w0[0] + w0[1] * w0[1] + w0[2] * w0[2]);
                w0[0] = w0[0] / l;
                w0[1] = w0[1] / l;
                w0[2] = w0[2] / l;
                l = (float)Math.sqrt(w1[0] * w1[0] + w1[1] * w1[1] + w1[2] * w1[2]);
                w1[0] = w1[0] / l;
                w1[1] = w1[1] / l;
                w1[2] = w1[2] / l;
                l = (float)Math.sqrt(w2[0] * w2[0] + w2[1] * w2[1] + w2[2] * w2[2]);
                w2[0] = w2[0] / l;
                w2[1] = w2[1] / l;
                w2[2] = w2[2] / l;
                JOGLUtil.recordItem(gl, w1, w0, w2, shadeType);
                ++j;
            }
        }
    }

    public static void drawTriangle(GL2 gl, float[] x0, float[] x1, float[] x2) {
        JOGLUtil.recordItem(gl, x0, x1, x2, 4);
    }

    public static float[] getRGBA(ColorBreak cb) {
        return cb.getColor().getRGBComponents(null);
    }

    public static GraphicCollection createTexture(ImageLayer layer, double offset, double xshift, String interpolation) throws IOException {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        TextureShape ishape = new TextureShape();
        ishape.setFileName(layer.getFileName());
        Extent extent = layer.getExtent();
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent((Extent)ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic((Shape)ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static SurfaceGraphics surface(Array xa, Array ya, Array za, LegendScheme ls) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        SurfaceGraphics graphics = new SurfaceGraphics();
        int[] shape = xa.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        PointZ[][] vertices = new PointZ[rowNum][colNum];
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                int idx = i * colNum + j;
                vertices[i][j] = new PointZ(xa.getDouble(idx), ya.getDouble(idx), za.getDouble(idx), za.getDouble(idx));
            }
        }
        graphics.setVertices(vertices);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static List<SurfaceGraphics> slice(Array data, Array xa, Array ya, Array za, List<Number> xSlice, List<Number> ySlice, List<Number> zSlice, LegendScheme ls) throws InvalidRangeException {
        double y;
        int j;
        double z;
        int i;
        PointZ[][] vertices;
        SurfaceGraphics graphics;
        Index index;
        Array r;
        double x;
        int s;
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ArrayList<SurfaceGraphics> sgs = new ArrayList<SurfaceGraphics>();
        int dim1 = (int)za.getSize();
        int dim2 = (int)ya.getSize();
        for (s = 0; s < xSlice.size(); ++s) {
            x = xSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)2, (Array)xa, (double)x);
            if (r == null) continue;
            index = r.getIndex();
            graphics = new SurfaceGraphics();
            vertices = new PointZ[dim1][dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getDouble(i);
                for (j = 0; j < dim2; ++j) {
                    y = ya.getDouble(j);
                    vertices[i][j] = new PointZ(x, y, z, r.getDouble(index.set(i, j)));
                }
            }
            graphics.setVertices(vertices);
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)za.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < ySlice.size(); ++s) {
            y = ySlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)1, (Array)ya, (double)y);
            if (r == null) continue;
            index = r.getIndex();
            graphics = new SurfaceGraphics();
            vertices = new PointZ[dim1][dim2];
            for (i = 0; i < dim1; ++i) {
                z = za.getDouble(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getDouble(j);
                    vertices[i][j] = new PointZ(x, y, z, r.getDouble(index.set(i, j)));
                }
            }
            graphics.setVertices(vertices);
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        dim1 = (int)ya.getSize();
        dim2 = (int)xa.getSize();
        for (s = 0; s < zSlice.size(); ++s) {
            z = zSlice.get(s).doubleValue();
            r = ArrayUtil.slice((Array)data, (int)0, (Array)za, (double)z);
            if (r == null) continue;
            index = r.getIndex();
            graphics = new SurfaceGraphics();
            vertices = new PointZ[dim1][dim2];
            for (i = 0; i < dim1; ++i) {
                y = ya.getDouble(i);
                for (j = 0; j < dim2; ++j) {
                    x = xa.getDouble(j);
                    vertices[i][j] = new PointZ(x, y, z, r.getDouble(index.set(i, j)));
                }
            }
            graphics.setVertices(vertices);
            graphics.setLegendScheme(ls);
            sgs.add(graphics);
        }
        return sgs;
    }

    public static GraphicCollection isosurface(Array data, Array x, Array y, Array z, float isoLevel, PolygonBreak pb) {
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        data = data.copyIfView();
        ArrayList<float[]> vertices = MarchingCubes.marchingCubes(data, x, y, z, isoLevel);
        IsosurfaceGraphics graphics = new IsosurfaceGraphics();
        graphics.setLegendBreak((ColorBreak)pb);
        for (int i = 0; i < vertices.size(); i += 3) {
            PointZ[] points = new PointZ[3];
            float[] v1 = (float[])vertices.get(i);
            float[] v2 = (float[])vertices.get(i + 1);
            float[] v3 = (float[])vertices.get(i + 2);
            points[0] = new PointZ((double)v1[0], (double)v1[1], (double)v1[2]);
            points[1] = new PointZ((double)v2[0], (double)v2[1], (double)v2[2]);
            points[2] = new PointZ((double)v3[0], (double)v3[1], (double)v3[2]);
            graphics.addTriangle(points);
        }
        return graphics;
    }

    public static GraphicCollection isosurface(final Array data, final Array x, final Array y, final Array z, final float isoLevel, PolygonBreak pb, int nThreads) {
        int i;
        ArrayList<2> threads = new ArrayList<2>();
        final ArrayList results = new ArrayList();
        int nz = (int)z.getSize();
        int remainder = nz % nThreads;
        int segment = nz / nThreads;
        int zAxisOffset = 0;
        for (i = 0; i < nThreads; ++i) {
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
            final CallbackMC callback = new CallbackMC(){

                @Override
                public void run() {
                    results.add(this.getVertices());
                }
            };
            final int finalZAxisOffset = zAxisOffset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    MarchingCubes.marchingCubes(data, x, y, z, isoLevel, paddedSegmentSize, finalZAxisOffset, callback);
                }
            };
            threads.add(t);
            t.start();
            zAxisOffset += segmentSize;
        }
        for (i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IsosurfaceGraphics graphics = new IsosurfaceGraphics();
        graphics.setLegendBreak((ColorBreak)pb);
        for (List vertices : results) {
            for (int i2 = 0; i2 < vertices.size(); i2 += 3) {
                PointZ[] points = new PointZ[3];
                float[] v1 = (float[])vertices.get(i2);
                float[] v2 = (float[])vertices.get(i2 + 1);
                float[] v3 = (float[])vertices.get(i2 + 2);
                points[0] = new PointZ((double)v1[0], (double)v1[1], (double)v1[2]);
                points[1] = new PointZ((double)v2[0], (double)v2[1], (double)v2[2]);
                points[2] = new PointZ((double)v3[0], (double)v3[1], (double)v3[2]);
                graphics.addTriangle(points);
            }
        }
        return graphics;
    }

    public static GraphicCollection particles(Array data, Array xa, Array ya, Array za, LegendScheme ls, float alphaMin, float alphaMax, int density) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        ParticleGraphics graphics = new ParticleGraphics();
        Random random = new Random();
        float dx = xa.getFloat(1) - xa.getFloat(0);
        float dy = ya.getFloat(1) - ya.getFloat(0);
        float dz = za.getFloat(1) - za.getFloat(0);
        int n = ls.getBreakNum();
        float[] alphas = new float[n];
        float dd = (alphaMax - alphaMin) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            alphas[i] = alphaMin + (float)i * dd;
        }
        double vMin = ls.getMinValue();
        double vMax = ls.getMaxValue();
        Index index = data.getIndex();
        if (za.getRank() == 1) {
            int i = 0;
            while ((long)i < za.getSize()) {
                int j = 0;
                while ((long)j < ya.getSize()) {
                    int k = 0;
                    while ((long)k < xa.getSize()) {
                        int level;
                        index.set(i, j, k);
                        double v = data.getDouble(index);
                        if (!(Double.isNaN(v) || v < vMin || v > vMax || (level = ls.legendBreakIndex(v)) < 0)) {
                            ColorBreak cb = ls.getLegendBreak(level);
                            float[] rgba = cb.getColor().getRGBComponents(null);
                            rgba[3] = alphas[level];
                            for (int l = 0; l <= level * density; ++l) {
                                ParticleGraphics.Particle particle = new ParticleGraphics.Particle();
                                particle.x = xa.getFloat(k) + (random.nextFloat() - 0.5f) * dx * 2.0f;
                                particle.y = ya.getFloat(j) + (random.nextFloat() - 0.5f) * dy * 2.0f;
                                particle.z = za.getFloat(i) + (random.nextFloat() - 0.5f) * dz * 2.0f;
                                particle.rgba = rgba;
                                graphics.addParticle(level, particle);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int zn = za.getShape()[0];
            Index zIndex = za.getIndex();
            for (int i = 0; i < zn; ++i) {
                int j = 0;
                while ((long)j < ya.getSize()) {
                    int k = 0;
                    while ((long)k < xa.getSize()) {
                        index.set(i, j, k);
                        double v = data.getDouble(index);
                        if (!(Double.isNaN(v) || v < vMin || v > vMax)) {
                            int level = ls.legendBreakIndex(v);
                            zIndex.set(i, j, k);
                            float z = za.getFloat(zIndex);
                            if (i == 0) {
                                zIndex.set(1, j, k);
                            } else {
                                zIndex.set(i - 1, j, k);
                            }
                            dz = Math.abs(z - za.getFloat(zIndex));
                            if (level >= 0) {
                                ColorBreak cb = ls.getLegendBreak(level);
                                float[] rgba = cb.getColor().getRGBComponents(null);
                                rgba[3] = alphas[level];
                                for (int l = 0; l <= level * density; ++l) {
                                    ParticleGraphics.Particle particle = new ParticleGraphics.Particle();
                                    particle.x = xa.getFloat(k) + (random.nextFloat() - 0.5f) * dx * 2.0f;
                                    particle.y = ya.getFloat(j) + (random.nextFloat() - 0.5f) * dy * 2.0f;
                                    particle.z = z + (random.nextFloat() - 0.5f) * dz * 2.0f;
                                    particle.rgba = rgba;
                                    graphics.addParticle(level, particle);
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
        }
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, ColorMap colorMap, double vMin, double vMax, float alphaMin, float alphaMax) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphics graphics = new VolumeGraphics(data, colorMap, vMin, vMax);
        VolumeGraphics.opacityNodes[0] = alphaMin;
        VolumeGraphics.opacityNodes[1] = alphaMax;
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static GraphicCollection volume(Array data, Array xa, Array ya, Array za, LegendScheme ls, float alphaMin, float alphaMax) {
        data = data.copyIfView();
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        VolumeGraphics graphics = new VolumeGraphics(data, ls);
        VolumeGraphics.opacityNodes[0] = alphaMin;
        VolumeGraphics.opacityNodes[1] = alphaMax;
        graphics.updateColors();
        Extent3D extent3D = new Extent3D();
        extent3D.minX = xa.getDouble(0);
        extent3D.maxX = xa.getDouble((int)xa.getSize() - 1);
        extent3D.minY = ya.getDouble(0);
        extent3D.maxY = ya.getDouble((int)ya.getSize() - 1);
        extent3D.minZ = za.getDouble(0);
        extent3D.maxZ = za.getDouble((int)za.getSize() - 1);
        graphics.setExtent((Extent)extent3D);
        return graphics;
    }

    public static BufferedImage paintViewImage(Plot3DGL plot3DGL, int width, int height) {
        GLProfile glp = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        caps.setRedBits(8);
        caps.setBlueBits(8);
        caps.setGreenBits(8);
        caps.setOnscreen(false);
        caps.setPBuffer(true);
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)glp);
        GLOffscreenAutoDrawable drawable = factory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)caps, null, width, height);
        drawable.addGLEventListener((GLEventListener)plot3DGL);
        plot3DGL.setDoScreenShot(true);
        drawable.display();
        BufferedImage image = plot3DGL.getScreenImage();
        drawable.destroy();
        return image;
    }

    public static BufferedImage paintViewImage_bak(Plot3DGL plot3DGL, int width, int height) {
        GLProfile glp = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        caps.setRedBits(8);
        caps.setBlueBits(8);
        caps.setGreenBits(8);
        caps.setOnscreen(false);
        caps.setPBuffer(true);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)caps);
        window.setSize(width, height);
        GLWindow glWindow = GLWindow.create((Window)window);
        glWindow.setVisible(true);
        glWindow.addGLEventListener((GLEventListener)plot3DGL);
        plot3DGL.setDoScreenShot(true);
        glWindow.display();
        BufferedImage image = plot3DGL.getScreenImage();
        if (null != glWindow) {
            glWindow.destroy();
        }
        if (null != window) {
            window.destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
        return image;
    }

    public static BufferedImage paintViewImage(Plot3DGL plot3DGL, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        width = (int)((double)width * scaleFactor);
        height = (int)((double)height * scaleFactor);
        plot3DGL.setDpiScale((float)scaleFactor);
        BufferedImage image = JOGLUtil.paintViewImage(plot3DGL, width, height);
        plot3DGL.setDpiScale(1.0f);
        return image;
    }

    public static void saveImage(Plot3DGL plot3DGL, String fn, int width, int height) throws InterruptedException {
        BufferedImage image = JOGLUtil.paintViewImage(plot3DGL, width, height);
        if (image != null) {
            String extension = fn.substring(fn.lastIndexOf(46) + 1);
            try {
                ImageIO.write((RenderedImage)image, extension, new File(fn));
            }
            catch (IOException ex) {
                Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void saveImage_bak(final Plot3DGL plot3DGL, final String fn, final int width, final int height) throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage image = JOGLUtil.paintViewImage(plot3DGL, width, height);
                if (image != null) {
                    String extension = fn.substring(fn.lastIndexOf(46) + 1);
                    try {
                        ImageIO.write((RenderedImage)image, extension, new File(fn));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveImage(Plot3DGL plot3DGL, String fn, int width, int height, int dpi) throws InterruptedException, IOException {
        String formatName = fn.substring(fn.lastIndexOf(46) + 1);
        if (formatName.equals("jpg")) {
            formatName = "jpeg";
            JOGLUtil.saveImage_Jpeg(plot3DGL, fn, width, height, dpi);
            return;
        }
        BufferedImage image = JOGLUtil.paintViewImage(plot3DGL, width, height, dpi);
        if (image == null) return;
        try {
            File output = new File(fn);
            output.delete();
            Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
            while (iw.hasNext()) {
                ImageWriter writer = iw.next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                if (metadata == null) {
                    metadata = writer.getDefaultImageMetadata(typeSpecifier, null);
                }
                if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                ImageUtil.setDPI((IIOMetadata)metadata, (float)dpi);
                ImageOutputStream stream = ImageIO.createImageOutputStream(output);
                try {
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                    return;
                }
                finally {
                    stream.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveImage_bak(final Plot3DGL plot3DGL, final String fn, final int width, final int height, final int dpi) throws InterruptedException, IOException {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                String formatName = fn.substring(fn.lastIndexOf(46) + 1);
                if (formatName.equals("jpg")) {
                    formatName = "jpeg";
                    JOGLUtil.saveImage_Jpeg(plot3DGL, fn, width, height, dpi);
                    return;
                }
                BufferedImage image = JOGLUtil.paintViewImage(plot3DGL, width, height, dpi);
                if (image == null) return;
                try {
                    File output = new File(fn);
                    output.delete();
                    Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
                    while (iw.hasNext()) {
                        ImageWriter writer = iw.next();
                        ImageWriteParam writeParam = writer.getDefaultWriteParam();
                        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                        if (metadata == null) {
                            metadata = writer.getDefaultImageMetadata(typeSpecifier, null);
                        }
                        if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                        ImageUtil.setDPI((IIOMetadata)metadata, (float)dpi);
                        ImageOutputStream stream = ImageIO.createImageOutputStream(output);
                        try {
                            writer.setOutput(stream);
                            writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                            return;
                        }
                        finally {
                            stream.close();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void saveImage_Jpeg(Plot3DGL plot3DGL, String file, int width, int height, int dpi) {
        BufferedImage bufferedImage = JOGLUtil.paintViewImage(plot3DGL, width, height, dpi);
        if (bufferedImage != null) {
            try {
                ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
                imageWriter.setOutput(ios);
                JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality(0.85f);
                IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
                Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
                Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                jfif.setAttribute("Xdensity", Integer.toString(dpi));
                jfif.setAttribute("Ydensity", Integer.toString(dpi));
                jfif.setAttribute("resUnits", "1");
                data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
                imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
                ios.close();
                imageWriter.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static float[] toArray(Vector3f v) {
        return new float[]{v.x, v.y, v.z};
    }
}

