/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.ChartColorBar;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartText3D;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.graphic.GraphicCollection3D;
import org.meteoinfo.chart.graphic.IsosurfaceGraphics;
import org.meteoinfo.chart.graphic.ParticleGraphics;
import org.meteoinfo.chart.graphic.SurfaceGraphics;
import org.meteoinfo.chart.graphic.VolumeGraphics;
import org.meteoinfo.chart.jogl.GLChartPanel;
import org.meteoinfo.chart.jogl.JOGLUtil;
import org.meteoinfo.chart.jogl.Lighting;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.jogl.pipe.Pipe;
import org.meteoinfo.chart.jogl.pipe.PipeShape;
import org.meteoinfo.chart.jogl.tessellator.Primitive;
import org.meteoinfo.chart.jogl.tessellator.TessPolygon;
import org.meteoinfo.chart.plot.GridLine;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.shape.TextureShape;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.BarBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.CubicShape;
import org.meteoinfo.geometry.shape.CylinderShape;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonZ;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.WindArrow3D;
import org.meteoinfo.math.meteo.MeteoMath;

public class Plot3DGL
extends Plot
implements GLEventListener {
    private boolean sampleBuffers = false;
    private Color background = Color.white;
    private boolean doScreenShot = false;
    private BufferedImage screenImage;
    private final GLU glu = new GLU();
    private final GLUT glut = new GLUT();
    private int startList = 2;
    private GraphicCollection3D graphics;
    private Extent3D extent;
    private ChartText title;
    private GridLine gridLine;
    private List<ChartLegend> legends;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;
    private float xmin;
    private float xmax = 1.0f;
    private float ymin;
    private float ymax = 1.0f;
    private float zmin;
    private float zmax = 1.0f;
    private Transform transform = new Transform();
    private boolean clipPlane = true;
    private Color boxColor = Color.getHSBColor(0.0f, 0.0f, 0.95f);
    private boolean boxed;
    private boolean mesh;
    private boolean scaleBox;
    private boolean displayXY;
    private boolean displayZ;
    private boolean drawBoundingBox;
    private boolean hideOnDrag;
    private boolean drawBase;
    int[] viewport = new int[4];
    float[] mvmatrix = new float[16];
    float[] projmatrix = new float[16];
    Matrix4f viewProjMatrix = new Matrix4f();
    private float angleX = -45.0f;
    private float angleY = 45.0f;
    private AspectType aspectType = AspectType.AUTO;
    TessCallback tessCallback;
    private int width;
    private int height;
    float tickSpace = 5.0f;
    private final float lenScale = 0.01f;
    private Lighting lighting = new Lighting();
    private boolean antialias;
    private float dpiScale;

    public Plot3DGL() {
        this.legends = new ArrayList<ChartLegend>();
        this.xAxis = new Axis();
        this.xAxis.setTickLength(8.0f);
        this.yAxis = new Axis();
        this.yAxis.setTickLength(8.0f);
        this.zAxis = new Axis();
        this.zAxis.setTickLength(8.0f);
        this.graphics = new GraphicCollection3D();
        this.hideOnDrag = false;
        this.boxed = true;
        this.gridLine = new GridLine(true);
        this.drawBase = true;
        this.displayXY = true;
        this.displayZ = true;
        this.drawBoundingBox = false;
        this.antialias = false;
        this.dpiScale = 1.0f;
    }

    public boolean isSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setSampleBuffers(boolean value) {
        this.sampleBuffers = value;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    public GraphicCollection3D getGraphics() {
        return this.graphics;
    }

    public void setGraphics(GraphicCollection3D value) {
        this.graphics = value;
    }

    public int getGraphicNumber() {
        return this.graphics.size();
    }

    public boolean isDoScreenShot() {
        return this.doScreenShot;
    }

    public void setDoScreenShot(boolean value) {
        this.doScreenShot = value;
    }

    public BufferedImage getScreenImage() {
        return this.screenImage;
    }

    public Extent3D getExtent() {
        return this.extent;
    }

    public void setExtent(Extent3D value) {
        this.extent = value;
        this.xmin = (float)this.extent.minX;
        this.xmax = (float)this.extent.maxX;
        this.ymin = (float)this.extent.minY;
        this.ymax = (float)this.extent.maxY;
        this.zmin = (float)this.extent.minZ;
        this.zmax = (float)this.extent.maxZ;
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
        this.transform.setExtent(this.extent);
    }

    public float getAspectRatio() {
        return (float)this.width / (float)this.height;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setBoxColor(Color value) {
        this.boxColor = value;
    }

    public boolean isDrawBase() {
        return this.drawBase;
    }

    public void setDrawBase(boolean value) {
        this.drawBase = value;
    }

    public boolean isDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public void setDrawBoundingBox(boolean value) {
        this.drawBoundingBox = value;
    }

    public void setDisplayXY(boolean value) {
        this.displayXY = value;
    }

    public void setDisplayZ(boolean value) {
        this.displayZ = value;
    }

    public GridLine getGridLine() {
        return this.gridLine;
    }

    public void setBoxed(boolean value) {
        this.boxed = value;
    }

    public float getAngleX() {
        return this.angleX;
    }

    public void setAngleX(float value) {
        this.angleX = value;
    }

    public float getAngleY() {
        return this.angleY;
    }

    public void setAngleY(float value) {
        this.angleY = value;
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public void setTitle(String text) {
        if (this.title == null) {
            this.title = new ChartText(text);
        } else {
            this.title.setText(text);
        }
    }

    public List<ChartLegend> getLegends() {
        return this.legends;
    }

    public ChartLegend getLegend(int idx) {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(idx);
    }

    public ChartLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(this.legends.size() - 1);
    }

    public void setLegend(ChartLegend value) {
        this.legends.clear();
        this.legends.add(value);
    }

    public void setLegends(List<ChartLegend> value) {
        this.legends = value;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public Axis getZAxis() {
        return this.zAxis;
    }

    public AspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(AspectType value) {
        this.aspectType = value;
        this.transform.setAspectType(this.aspectType);
    }

    public float getXMin() {
        return this.xmin;
    }

    public void setXMin(float value) {
        this.xmin = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public float getXMax() {
        return this.xmax;
    }

    public void setXMax(float value) {
        this.xmax = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public void setXMinMax(float min, float max) {
        this.xmin = min;
        this.xmax = max;
        this.updateExtent();
        this.xAxis.setMinMaxValue(min, max);
    }

    public float getYMin() {
        return this.ymin;
    }

    public void setYMin(float value) {
        this.ymin = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public float getYMax() {
        return this.ymax;
    }

    public void setYMax(float value) {
        this.ymax = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public void setYMinMax(float min, float max) {
        this.ymin = min;
        this.ymax = max;
        this.updateExtent();
        this.yAxis.setMinMaxValue(min, max);
    }

    public float getZMin() {
        return this.zmin;
    }

    public void setZMin(float value) {
        this.zmin = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public float getZMax() {
        return this.zmax;
    }

    public void setZMax(float value) {
        this.zmax = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public void setZMinMax(float min, float max) {
        this.zmin = min;
        this.zmax = max;
        this.updateExtent();
        this.zAxis.setMinMaxValue(min, max);
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public void setLighting(Lighting value) {
        this.lighting = value;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    public float getDpiScale() {
        return this.dpiScale;
    }

    public void setDpiScale(float value) {
        this.dpiScale = value;
    }

    public void addLegend(ChartLegend legend) {
        this.legends.clear();
        this.legends.add(legend);
    }

    public void removeLegend(ChartLegend legend) {
        this.legends.remove(legend);
    }

    public void removeLegend(int idx) {
        this.legends.remove(idx);
    }

    @Override
    public Rectangle2D getOuterPositionArea(Rectangle2D area) {
        Rectangle2D rect = this.getOuterPosition();
        double x = area.getWidth() * rect.getX() + area.getX();
        double y = area.getHeight() * (1.0 - rect.getHeight() - rect.getY()) + area.getY();
        double w = area.getWidth() * rect.getWidth();
        double h = area.getHeight() * rect.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XYZ;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
    }

    private void updateExtent() {
        this.extent = new Extent3D((double)this.xmin, (double)this.xmax, (double)this.ymin, (double)this.ymax, (double)this.zmin, (double)this.zmax);
        this.transform.setExtent(this.extent);
    }

    public void setAxisTickFont(Font font) {
        this.xAxis.setTickLabelFont(font);
        this.yAxis.setTickLabelFont(font);
        this.zAxis.setTickLabelFont(font);
    }

    public void addGraphic(Graphic g) {
        this.graphics.add(g);
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        this.setExtent((Extent3D)ex);
    }

    public void removeGraphic(int idx) {
        this.graphics.remove(idx);
    }

    public void removeLastGraphic() {
        this.graphics.remove(this.graphics.size() - 1);
    }

    public void setAutoExtent() {
    }

    public void display(GLAutoDrawable drawable) {
        Graphic graphic;
        int m;
        GL2 gl = drawable.getGL().getGL2();
        float[] rgba = this.background.getRGBComponents(null);
        if (this.background == Color.black) {
            rgba[3] = 0.0f;
        }
        gl.glClearColor(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glClear(16640);
        gl.glLoadIdentity();
        this.lighting.setPosition(gl);
        gl.glPushMatrix();
        gl.glShadeModel(7425);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        if (this.antialias) {
            if (this.sampleBuffers) {
                gl.glEnable(32925);
            } else {
                gl.glEnable(2848);
                gl.glHint(3154, 4354);
                gl.glEnable(2832);
                gl.glHint(3153, 4354);
            }
        } else if (this.sampleBuffers) {
            gl.glDisable(32925);
        } else {
            gl.glDisable(2848);
            gl.glHint(3154, 4353);
            gl.glDisable(2832);
            gl.glHint(3153, 4353);
        }
        gl.glRotatef(this.angleX, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.angleY, 0.0f, 0.0f, 1.0f);
        this.updateMatrix(gl);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        this.drawBoxGrids(gl);
        this.drawTitle();
        this.setLight(gl);
        if (this.clipPlane) {
            float s = 1.01f;
            gl.glClipPlane(12288, new double[]{1.0, 0.0, 0.0, s}, 0);
            gl.glEnable(12288);
            gl.glClipPlane(12289, new double[]{-1.0, 0.0, 0.0, s}, 0);
            gl.glEnable(12289);
            gl.glClipPlane(12290, new double[]{0.0, -1.0, 0.0, s}, 0);
            gl.glEnable(12290);
            gl.glClipPlane(12291, new double[]{0.0, 1.0, 0.0, s}, 0);
            gl.glEnable(12291);
            gl.glClipPlane(12292, new double[]{0.0, 0.0, 1.0, s}, 0);
            gl.glEnable(12292);
            gl.glClipPlane(12293, new double[]{0.0, 0.0, -1.0, s}, 0);
            gl.glEnable(12293);
        }
        for (m = 0; m < this.graphics.getNumGraphics(); ++m) {
            graphic = this.graphics.get(m);
            this.drawGraphics(gl, graphic);
        }
        if (this.clipPlane) {
            gl.glDisable(12288);
            gl.glDisable(12289);
            gl.glDisable(12290);
            gl.glDisable(12291);
            gl.glDisable(12292);
            gl.glDisable(12293);
        }
        for (m = 0; m < this.graphics.getNumGraphics(); ++m) {
            graphic = this.graphics.get(m);
            if (graphic.getNumGraphics() == 1) {
                Shape shape = graphic.getGraphicN(0).getShape();
                if (shape.getShapeType() != ShapeTypes.TEXT) continue;
                this.drawText(gl, (ChartText3D)shape);
                continue;
            }
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Shape shape = graphic.getGraphicN(i).getShape();
                if (shape.getShapeType() != ShapeTypes.TEXT) continue;
                this.drawText(gl, (ChartText3D)shape);
            }
        }
        if (this.lighting.isEnable()) {
            this.lighting.stop(gl);
        }
        this.drawAxis(gl);
        gl.glPopMatrix();
        this.updateMatrix(gl);
        this.drawLegend(gl);
        gl.glFlush();
        if (this.doScreenShot) {
            AWTGLReadBufferUtil glReadBufferUtil = new AWTGLReadBufferUtil(drawable.getGLProfile(), false);
            this.screenImage = glReadBufferUtil.readPixelsToBufferedImage(drawable.getGL(), true);
            this.doScreenShot = false;
        }
    }

    private void setLight(GL2 gl) {
        if (this.lighting.isEnable()) {
            this.lighting.start(gl);
            gl.glColorMaterial(1032, 5634);
            gl.glEnable(2903);
            gl.glLightModeli(2898, 1);
        }
    }

    private void setCamera(GL2 gl, GLU glu, float distance) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        float widthHeightRatio = (float)this.viewport[2] / (float)this.viewport[3];
        glu.gluPerspective(45.0f, widthHeightRatio, 1.0f, 1000.0f);
        glu.gluLookAt(0.0f, 0.0f, distance, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public boolean isClipPlane() {
        return this.clipPlane;
    }

    public void setClipPlane(boolean value) {
        this.clipPlane = value;
    }

    private void drawBase(GL2 gl) {
        float[] rgba = this.gridLine.getColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
        gl.glBegin(3);
        float xMin = this.transform.transform_x(this.xmin);
        float xMax = this.transform.transform_x(this.xmax);
        float yMin = this.transform.transform_y(this.ymin);
        float yMax = this.transform.transform_y(this.ymax);
        float zMin = this.transform.transform_z(this.zmin);
        gl.glVertex3f(xMin, yMax, zMin);
        gl.glVertex3f(xMin, yMin, zMin);
        gl.glVertex3f(xMax, yMin, zMin);
        gl.glVertex3f(xMax, yMax, zMin);
        gl.glVertex3f(xMin, yMax, zMin);
        gl.glEnd();
    }

    private Matrix4f toMatrix(float[] data) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.set(data);
        return matrix4f;
    }

    private void updateMatrix(GL2 gl) {
        gl.glGetIntegerv(2978, this.viewport, 0);
        gl.glGetFloatv(2982, this.mvmatrix, 0);
        gl.glGetFloatv(2983, this.projmatrix, 0);
        this.viewProjMatrix = this.toMatrix(this.projmatrix).mul((Matrix4fc)this.toMatrix(this.mvmatrix));
    }

    private float[] toScreen(float vx, float vy, float vz) {
        float[] coord = new float[4];
        this.glu.gluProject(vx, vy, vz, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, coord, 0);
        if (this.viewport[0] != 0) {
            coord[0] = coord[0] - (float)this.viewport[0];
        }
        if (this.viewport[1] != 0) {
            coord[1] = coord[1] - (float)this.viewport[1];
        }
        return coord;
    }

    private float toScreenLength(float x1, float y1, float z1, float x2, float y2, float z2) {
        float[] coord = this.toScreen(x1, y1, z1);
        float sx1 = coord[0];
        float sy1 = coord[1];
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord[0];
        float sy2 = coord[1];
        return (float)Math.sqrt(Math.pow(sx2 - sx1, 2.0) + Math.pow(sy2 - sy1, 2.0));
    }

    private float toScreenAngle(float x1, float y1, float z1, float x2, float y2, float z2) {
        float[] coord = this.toScreen(x1, y1, z1);
        float sx1 = coord[0];
        float sy1 = coord[1];
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord[0];
        float sy2 = coord[1];
        return (float)MeteoMath.uv2ds((double)(sx2 - sx1), (double)(sy2 - sy1))[0];
    }

    private int getLabelGap(Font font, List<ChartText> labels, double len) {
        TextRenderer textRenderer = new TextRenderer(font);
        int n = labels.size();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private int getLegendTickGap(ChartColorBar legend, double len) {
        if (legend.getTickLabelAngle() != 0.0f) {
            return 1;
        }
        Font font = legend.getTickLabelFont();
        if (this.dpiScale != 1.0f) {
            font = new Font(font.getFontName(), font.getStyle(), (int)((float)font.getSize() * this.dpiScale));
        }
        TextRenderer textRenderer = new TextRenderer(font);
        int n = legend.getLegendScheme().getBreakNum();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private void drawBoxGrids(GL2 gl) {
        float x;
        float v;
        int i;
        int skip;
        float axisLen;
        List<ChartText> tlabs;
        float y;
        float[] rgba;
        if (this.drawBase) {
            this.drawBase(gl);
        }
        float xMin = this.transform.transform_x(this.xmin);
        float xMax = this.transform.transform_x(this.xmax);
        float yMin = this.transform.transform_y(this.ymin);
        float yMax = this.transform.transform_y(this.ymax);
        float zMin = this.transform.transform_z(this.zmin);
        float zMax = this.transform.transform_z(this.zmax);
        if (this.boxed) {
            if (this.angleY >= 180.0f && this.angleY < 360.0f) {
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(3);
                gl.glVertex3f(xMin, yMax, zMin);
                gl.glVertex3f(xMin, yMin, zMin);
                gl.glVertex3f(xMin, yMin, zMax);
                gl.glVertex3f(xMin, yMax, zMax);
                gl.glVertex3f(xMin, yMax, zMin);
                gl.glEnd();
            } else {
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(3);
                gl.glVertex3f(xMax, yMax, zMin);
                gl.glVertex3f(xMax, yMin, zMin);
                gl.glVertex3f(xMax, yMin, zMax);
                gl.glVertex3f(xMax, yMax, zMax);
                gl.glVertex3f(xMax, yMax, zMin);
                gl.glEnd();
            }
            if (this.angleY >= 90.0f && this.angleY < 270.0f) {
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(3);
                gl.glVertex3f(xMin, yMin, zMin);
                gl.glVertex3f(xMax, yMin, zMin);
                gl.glVertex3f(xMax, yMin, zMax);
                gl.glVertex3f(xMin, yMin, zMax);
                gl.glVertex3f(xMin, yMin, zMin);
                gl.glEnd();
            } else {
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(3);
                gl.glVertex3f(xMin, yMax, zMin);
                gl.glVertex3f(xMax, yMax, zMin);
                gl.glVertex3f(xMax, yMax, zMax);
                gl.glVertex3f(xMin, yMax, zMax);
                gl.glVertex3f(xMin, yMax, xMin);
                gl.glEnd();
            }
        }
        if (this.displayXY) {
            y = this.angleY >= 90.0f && this.angleY < 270.0f ? yMax : yMin;
            this.xAxis.updateTickLabels();
            tlabs = this.xAxis.getTickLabels();
            axisLen = this.toScreenLength(-1.0f, y, -1.0f, 1.0f, y, -1.0f);
            skip = this.getLabelGap(this.xAxis.getTickLabelFont(), tlabs, axisLen);
            for (i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                v = (float)this.xAxis.getTickValues()[i];
                if (v < this.xmin || v > this.xmax) continue;
                v = this.transform.transform_x(v);
                if (i == tlabs.size()) break;
                if (!this.gridLine.isDrawXLine() || v == -1.0f || v == 1.0f) continue;
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(v, y, zMin);
                gl.glVertex3f(v, -y, zMin);
                gl.glEnd();
                if (!this.displayZ || !this.boxed) continue;
                gl.glBegin(1);
                gl.glVertex3f(v, -y, zMin);
                gl.glVertex3f(v, -y, zMax);
                gl.glEnd();
            }
            x = this.angleY >= 180.0f && this.angleY < 360.0f ? xMax : xMin;
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            axisLen = this.toScreenLength(x, -1.0f, -1.0f, x, 1.0f, -1.0f);
            skip = this.getLabelGap(this.yAxis.getTickLabelFont(), tlabs, axisLen);
            for (i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                v = (float)this.yAxis.getTickValues()[i];
                if (v < this.ymin || v > this.ymax) continue;
                v = this.transform.transform_y(v);
                if (i == tlabs.size()) break;
                if (!this.gridLine.isDrawYLine() || v == -1.0f || v == 1.0f) continue;
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, v, zMin);
                gl.glVertex3f(-x, v, zMin);
                gl.glEnd();
                if (!this.displayZ || !this.boxed) continue;
                gl.glBegin(1);
                gl.glVertex3f(-x, v, zMin);
                gl.glVertex3f(-x, v, zMax);
                gl.glEnd();
            }
        }
        if (this.displayZ) {
            if (this.angleY < 90.0f) {
                x = xMin;
                y = yMax;
            } else if (this.angleY < 180.0f) {
                x = xMax;
                y = yMax;
            } else if (this.angleY < 270.0f) {
                x = xMax;
                y = yMin;
            } else {
                x = xMin;
                y = yMin;
            }
            this.zAxis.updateTickLabels();
            tlabs = this.zAxis.getTickLabels();
            axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
            skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
            for (i = 0; i < this.zAxis.getTickValues().length; i += skip) {
                v = (float)this.zAxis.getTickValues()[i];
                if (v < this.zmin || v > this.zmax) continue;
                v = this.transform.transform_z(v);
                if (i == tlabs.size()) break;
                if (!this.gridLine.isDrawZLine() || !this.boxed || v == zMin || v == zMax) continue;
                rgba = this.gridLine.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.gridLine.getSize() * this.dpiScale);
                gl.glBegin(3);
                gl.glVertex3f(x, y, v);
                if (x < 0.0f) {
                    if (y > 0.0f) {
                        gl.glVertex3f(-x, y, v);
                        gl.glVertex3f(-x, -y, v);
                    } else {
                        gl.glVertex3f(x, -y, v);
                        gl.glVertex3f(-x, -y, v);
                    }
                } else if (y > 0.0f) {
                    gl.glVertex3f(x, -y, v);
                    gl.glVertex3f(-x, -y, v);
                } else {
                    gl.glVertex3f(-x, y, v);
                    gl.glVertex3f(-x, -y, v);
                }
                gl.glEnd();
            }
        }
    }

    void drawAxis(GL2 gl) {
        float x;
        Rectangle2D rect;
        float v;
        float strWidth;
        YAlign yAlign;
        XAlign xAlign;
        float y1;
        int skip;
        float[] rgba;
        float y;
        float xMin = this.transform.transform_x(this.xmin);
        float xMax = this.transform.transform_x(this.xmax);
        float yMin = this.transform.transform_y(this.ymin);
        float yMax = this.transform.transform_y(this.ymax);
        float zMin = this.transform.transform_z(this.zmin);
        float zMax = this.transform.transform_z(this.zmax);
        if (this.displayXY) {
            ChartText label;
            y = this.angleY >= 90.0f && this.angleY < 270.0f ? yMax : yMin;
            rgba = this.xAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(xMin, y, zMin);
            gl.glVertex3f(xMax, y, zMin);
            gl.glEnd();
            float tickLen = this.xAxis.getTickLength() * this.lenScale;
            this.xAxis.updateTickLabels();
            List<ChartText> tlabs = this.xAxis.getTickLabels();
            float axisLen = this.toScreenLength(xMin, y, zMin, xMax, y, zMin);
            skip = this.getLabelGap(this.xAxis.getTickLabelFont(), tlabs, axisLen);
            y1 = y > 0.0f ? y + tickLen : y - tickLen;
            xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.LEFT : XAlign.RIGHT;
            yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
            strWidth = 0.0f;
            float strHeight = 0.0f;
            for (int i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                v = (float)this.xAxis.getTickValues()[i];
                if (v < this.xmin || v > this.xmax) continue;
                v = this.transform.transform_x(v);
                if (i == tlabs.size()) break;
                rgba = this.xAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(v, y, zMin);
                gl.glVertex3f(v, y1, zMin);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), v, y1, zMin, xAlign, yAlign);
                if ((double)strWidth < rect.getWidth()) {
                    strWidth = (float)rect.getWidth();
                }
                if (!((double)strHeight < rect.getHeight())) continue;
                strHeight = (float)rect.getHeight();
            }
            if ((label = this.xAxis.getLabel()) != null) {
                float angle = this.toScreenAngle(xMin, y, zMin, xMax, y, zMin);
                angle = y < 0.0f ? 270.0f - angle : 90.0f - angle;
                float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                if (this.angleX <= -120.0f) {
                    yShift = -yShift;
                }
                this.drawString(gl, label, 0.0f, y1, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
            }
            x = this.angleY >= 180.0f && this.angleY < 360.0f ? xMax : xMin;
            rgba = this.yAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x, yMin, zMin);
            gl.glVertex3f(x, yMax, zMin);
            gl.glEnd();
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            axisLen = this.toScreenLength(x, yMin, zMin, x, yMax, zMin);
            skip = this.getLabelGap(this.yAxis.getTickLabelFont(), tlabs, axisLen);
            tickLen = this.yAxis.getTickLength() * this.lenScale;
            float x1 = x > 0.0f ? x + tickLen : x - tickLen;
            xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.RIGHT : XAlign.LEFT;
            yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
            strWidth = 0.0f;
            strHeight = 0.0f;
            for (int i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                v = (float)this.yAxis.getTickValues()[i];
                if (v < this.ymin || v > this.ymax) continue;
                v = this.transform.transform_y(v);
                if (i == tlabs.size()) break;
                rgba = this.yAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, v, zMin);
                gl.glVertex3f(x1, v, zMin);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), x1, v, zMin, xAlign, yAlign);
                if ((double)strWidth < rect.getWidth()) {
                    strWidth = (float)rect.getWidth();
                }
                if (!((double)strHeight < rect.getHeight())) continue;
                strHeight = (float)rect.getHeight();
            }
            if ((label = this.yAxis.getLabel()) != null) {
                float angle = this.toScreenAngle(x, yMin, zMin, x, yMax, xMin);
                angle = x > 0.0f ? 270.0f - angle : 90.0f - angle;
                float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                if (this.angleX <= -120.0f) {
                    yShift = -yShift;
                }
                this.drawString(gl, label, x1, 0.0f, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
            }
        }
        if (this.displayZ) {
            ChartText label;
            if (this.angleY < 90.0f) {
                x = xMin;
                y = yMax;
            } else if (this.angleY < 180.0f) {
                x = xMax;
                y = yMax;
            } else if (this.angleY < 270.0f) {
                x = xMax;
                y = yMin;
            } else {
                x = xMin;
                y = yMin;
            }
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x, y, zMin);
            gl.glVertex3f(x, y, zMax);
            gl.glEnd();
            this.zAxis.updateTickLabels();
            List<ChartText> tlabs = this.zAxis.getTickLabels();
            float axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
            skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
            float x1 = x;
            y1 = y;
            float tickLen = this.zAxis.getTickLength() * this.lenScale;
            if (x < 0.0f) {
                if (y > 0.0f) {
                    y1 += tickLen;
                } else {
                    x1 -= tickLen;
                }
            } else if (y > 0.0f) {
                x1 += tickLen;
            } else {
                y1 -= tickLen;
            }
            xAlign = XAlign.RIGHT;
            yAlign = YAlign.CENTER;
            strWidth = 0.0f;
            for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
                v = (float)this.zAxis.getTickValues()[i];
                if (v < this.zmin || v > this.zmax) continue;
                v = this.transform.transform_z(v);
                if (i == tlabs.size()) break;
                rgba = this.zAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, y, v);
                gl.glVertex3f(x1, y1, v);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), x1, y1, v, xAlign, yAlign, -this.tickSpace, 0.0f);
                if (!((double)strWidth < rect.getWidth())) continue;
                strWidth = (float)rect.getWidth();
            }
            if ((label = this.zAxis.getLabel()) != null) {
                float yShift = strWidth + this.tickSpace * 3.0f;
                this.drawString(gl, label, x1, y1, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
            }
        }
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, text, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, xShift, yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        float[] coord = this.toScreen(vx, vy, vz);
        float x = coord[0];
        float y = coord[1];
        TextRenderer textRenderer = this.dpiScale == 1.0f ? new TextRenderer(font, true, true) : new TextRenderer(new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * (1.0 + (double)(this.dpiScale - 1.0f) * 0.8))), true, true);
        textRenderer.beginRendering(this.width, this.height);
        textRenderer.setColor(color);
        textRenderer.setSmoothing(true);
        Rectangle2D rect = textRenderer.getBounds(str.subSequence(0, str.length()));
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.3);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        textRenderer.draw(str, (int)(x + xShift), (int)(y + yShift));
        textRenderer.endRendering();
        return rect;
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, xShift, yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, angle, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        float[] coord = this.toScreen(vx, vy, vz);
        float x = coord[0];
        float y = coord[1];
        TextRenderer textRenderer = this.dpiScale == 1.0f ? new TextRenderer(font, true, true) : new TextRenderer(new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * (1.0 + (double)(this.dpiScale - 1.0f) * 0.8))), true, true);
        textRenderer.beginRendering(this.width, this.height);
        textRenderer.setColor(color);
        textRenderer.setSmoothing(true);
        Rectangle2D rect = textRenderer.getBounds(str.subSequence(0, str.length()));
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glTranslatef(x, y, 0.0f);
        if (angle != 0.0f) {
            gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        }
        x = 0.0f;
        y = 0.0f;
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.5);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        textRenderer.draw(str, (int)(x += xShift), (int)(y += yShift));
        textRenderer.endRendering();
        gl.glPopMatrix();
        return rect;
    }

    void drawTitle() {
        if (this.title != null) {
            Font font = this.title.getFont();
            TextRenderer textRenderer = this.dpiScale == 1.0f ? new TextRenderer(font, true, true) : new TextRenderer(new Font(font.getFontName(), font.getStyle(), (int)((float)font.getSize() * this.dpiScale)), true, true);
            textRenderer.beginRendering(this.width, this.height);
            textRenderer.setColor(this.title.getColor());
            textRenderer.setSmoothing(true);
            Rectangle2D rect = textRenderer.getBounds(this.title.getText().subSequence(0, this.title.getText().length()));
            float x = (float)this.width / 2.0f - (float)rect.getWidth() / 2.0f;
            float y = (float)this.height - (float)rect.getHeight();
            textRenderer.draw(this.title.getText(), (int)x, (int)y);
            textRenderer.endRendering();
        }
    }

    private void drawGraphics(GL2 gl, Graphic graphic) {
        boolean lightEnabled = this.lighting.isEnable();
        if (graphic instanceof GraphicCollection3D) {
            boolean usingLight;
            boolean bl = usingLight = lightEnabled && ((GraphicCollection3D)graphic).isUsingLight();
            if (lightEnabled && !((GraphicCollection3D)graphic).isUsingLight()) {
                this.lighting.stop(gl);
            }
        }
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawGraphic(gl, gg);
        } else if (graphic instanceof SurfaceGraphics) {
            this.drawSurface(gl, (SurfaceGraphics)graphic);
        } else if (graphic instanceof IsosurfaceGraphics) {
            this.drawIsosurface(gl, (IsosurfaceGraphics)graphic);
        } else if (graphic instanceof ParticleGraphics) {
            this.drawParticles(gl, (ParticleGraphics)graphic);
        } else if (graphic instanceof VolumeGraphics) {
            try {
                this.drawVolume(gl, (VolumeGraphics)graphic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean isDraw = true;
            if (graphic instanceof GraphicCollection3D) {
                GraphicCollection3D gg = (GraphicCollection3D)graphic;
                if (gg.isAllQuads()) {
                    this.drawQuadsPolygons(gl, gg);
                    isDraw = false;
                } else if (gg.isAllTriangle()) {
                    this.drawTrianglePolygons(gl, gg);
                    isDraw = false;
                }
            }
            if (isDraw) {
                switch (graphic.getGraphicN(0).getShape().getShapeType()) {
                    case POINT_Z: {
                        this.drawPoints(gl, graphic);
                        break;
                    }
                    default: {
                        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                            Graphic gg = graphic.getGraphicN(i);
                            this.drawGraphic(gl, gg);
                        }
                    }
                }
            }
        }
        if (graphic instanceof GraphicCollection3D && lightEnabled && !((GraphicCollection3D)graphic).isUsingLight()) {
            this.lighting.start(gl);
        }
    }

    private void drawGraphic(GL2 gl, Graphic graphic) {
        Shape shape = graphic.getGraphicN(0).getShape();
        switch (shape.getShapeType()) {
            case POINT_Z: 
            case POINT: {
                this.drawPoint(gl, graphic);
                break;
            }
            case TEXT: {
                break;
            }
            case POLYLINE: 
            case POLYLINE_Z: {
                ColorBreak cb = graphic.getLegend();
                if (cb instanceof StreamlineBreak) {
                    if (shape instanceof PipeShape) {
                        this.drawPipeStreamline(gl, graphic);
                        break;
                    }
                    this.drawStreamline(gl, graphic);
                    break;
                }
                if (cb instanceof ColorBreakCollection) {
                    if (((ColorBreakCollection)cb).get(0) instanceof StreamlineBreak) {
                        if (shape instanceof PipeShape) {
                            this.drawPipeStreamline(gl, graphic);
                            break;
                        }
                        this.drawStreamline(gl, graphic);
                        break;
                    }
                    if (shape instanceof PipeShape) {
                        this.drawPipe(gl, graphic);
                        break;
                    }
                    this.drawLineString(gl, graphic);
                    break;
                }
                if (shape instanceof PipeShape) {
                    this.drawPipe(gl, graphic);
                    break;
                }
                this.drawLineString(gl, graphic);
                break;
            }
            case POLYGON: 
            case POLYGON_Z: {
                this.drawPolygonShape(gl, graphic);
                break;
            }
            case WIND_ARROW: {
                this.drawWindArrow(gl, graphic);
                break;
            }
            case CUBIC: {
                this.drawCubic(gl, graphic);
                break;
            }
            case CYLINDER: {
                this.drawCylinder(gl, graphic);
                break;
            }
            case IMAGE: {
                this.drawImage(gl, graphic);
                break;
            }
            case TEXTURE: {
                this.drawTexture(gl, graphic);
            }
        }
    }

    private void drawText(GL2 gl, ChartText3D text) {
        float x = this.transform.transform_x((float)text.getX());
        float y = this.transform.transform_y((float)text.getY());
        float z = this.transform.transform_z((float)text.getZ());
        this.drawString(gl, text, x, y, z, text.getXAlign(), text.getYAlign());
    }

    private void drawPoint(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glPointSize(pb.getSize() * this.dpiScale);
            gl.glBegin(0);
            PointZ p = (PointZ)shape.getPoint();
            gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            gl.glEnd();
        }
    }

    private void drawPoints(GL2 gl, Graphic graphic) {
        PointBreak pb = (PointBreak)graphic.getGraphicN(0).getLegend();
        gl.glPointSize(pb.getSize() * this.dpiScale);
        gl.glBegin(0);
        for (Graphic gg : graphic.getGraphics()) {
            PointZShape shape = (PointZShape)gg.getShape();
            pb = (PointBreak)gg.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            PointZ p = (PointZ)shape.getPoint();
            gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
        }
        gl.glEnd();
    }

    private void drawParticles(GL2 gl, ParticleGraphics particles) {
        for (Map.Entry<Integer, List> map : particles.getParticleList()) {
            gl.glPointSize(particles.getPointSize() * this.dpiScale);
            gl.glBegin(0);
            for (ParticleGraphics.Particle p : map.getValue()) {
                float[] rgba = p.rgba;
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glVertex3f(this.transform.transform_x(p.x), this.transform.transform_y(p.y), this.transform.transform_z(p.z));
            }
            gl.glEnd();
        }
    }

    private int getTextureID(GL2 gl) {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl.glGenTextures(1, intBuffer);
        return intBuffer.get(0);
    }

    private void drawVolume(GL2 gl, VolumeGraphics volume) throws Exception {
        gl.glActiveTexture(33985);
        gl.glBindTexture(3553, this.getTextureID(gl));
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glTexImage2D(3553, 0, 6408, 1, 1, 0, 6408, 5121, (Buffer)Buffers.newDirectByteBuffer((byte[])VolumeGraphics.colors));
        int idData = this.getTextureID(gl);
        gl.glActiveTexture(33984);
        gl.glBindTexture(32879, idData);
        gl.glTexParameteri(32879, 33084, 0);
        gl.glTexParameteri(32879, 10241, 9729);
        gl.glTexParameteri(32879, 10240, 9729);
        gl.glTexParameteri(32879, 10242, 33071);
        gl.glTexParameteri(32879, 10243, 33071);
        gl.glTexParameteri(32879, 32882, 33071);
        String vertexShaderCode = Utils.loadResource("/shaders/volume/volume.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/volume/volume.frag");
        Program program = new Program("volume", vertexShaderCode, fragmentShaderCode);
        try {
            program.init(gl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl.glGenBuffers(1, intBuffer);
        int vertexBuffer = intBuffer.get(0);
        gl.glBindBuffer(34962, vertexBuffer);
        float[] vertexBufferData = volume.getVertexBufferData(this.transform);
        gl.glBufferData(34962, (long)(vertexBufferData.length * 4), (Buffer)Buffers.newDirectFloatBuffer((float[])vertexBufferData), 35044);
        program.allocateUniform(gl, "MVP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.viewProjMatrix.get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "iV", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "iP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.projmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        program.allocateUniform(gl, "viewSize", (gl2, loc) -> gl2.glUniform2f(loc.intValue(), (float)this.width, (float)this.height));
        int sampleCount = 512;
        program.allocateUniform(gl, "depthSampleCount", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), sampleCount));
        program.allocateUniform(gl, "tex", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 0));
        program.allocateUniform(gl, "colorMap", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 1));
        float[] aabbMin = volume.getAabbMin();
        float[] aabbMax = volume.getAabbMax();
        program.allocateUniform(gl, "aabbMin", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMin[0], aabbMin[1], aabbMin[2]));
        program.allocateUniform(gl, "aabbMax", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMax[0], aabbMax[1], aabbMax[2]));
        program.use(gl);
        program.setUniforms(gl);
        gl.glActiveTexture(33985);
        gl.glTexImage2D(3553, 0, 6408, volume.getColorNum(), 1, 0, 6408, 5121, (Buffer)Buffers.newDirectByteBuffer((byte[])VolumeGraphics.colors).rewind());
        gl.glActiveTexture(33984);
        gl.glBindTexture(32879, idData);
        gl.glPixelStorei(3317, 1);
        gl.glTexImage3D(32879, 0, 6409, volume.getWidth(), volume.getHeight(), volume.getDepth(), 0, 6409, 5121, VolumeGraphics.buffer.rewind());
        gl.glEnableVertexAttribArray(0);
        gl.glBindBuffer(34962, vertexBuffer);
        gl.glVertexAttribPointer(0, 3, 5126, false, 12, 0L);
        gl.glDrawArrays(4, 0, vertexBufferData.length / 3);
        gl.glDisableVertexAttribArray(0);
        Program.destroyAllPrograms(gl);
        gl.glUseProgram(0);
    }

    private void drawLineString(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                Polyline line = (Polyline)shape.getPolylines().get(0);
                List ps = line.getPointList();
                gl.glLineWidth(((PolylineBreak)cbc.get(0)).getWidth() * this.dpiScale);
                gl.glBegin(3);
                for (int i = 0; i < ps.size(); ++i) {
                    PolylineBreak plb = (PolylineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(plb.getWidth() * this.dpiScale);
                    PointZ p = (PointZ)ps.get(i);
                    gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                }
                gl.glEnd();
            } else {
                PolylineBreak pb = (PolylineBreak)cb;
                float[] rgba = pb.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(pb.getWidth() * this.dpiScale);
                gl.glBegin(3);
                for (Polyline line : shape.getPolylines()) {
                    List ps = line.getPointList();
                    for (PointZ p : ps) {
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                }
                gl.glEnd();
            }
        }
    }

    private void drawPipe(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PipeShape shape = (PipeShape)graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            shape.transform(this.transform);
            Pipe pipe = shape.getPipe();
            int count = pipe.getContourCount();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                for (int i = 0; i < count - 1; ++i) {
                    PolylineBreak plb = (PolylineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    Vector<Vector3f> c1 = pipe.getContour(i);
                    Vector<Vector3f> c2 = pipe.getContour(i + 1);
                    Vector<Vector3f> n1 = pipe.getNormal(i);
                    Vector<Vector3f> n2 = pipe.getNormal(i + 1);
                    gl.glBegin(5);
                    for (int j = 0; j < c2.size(); ++j) {
                        gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                    }
                    gl.glEnd();
                }
                gl.glEnd();
            } else {
                PolylineBreak pb = (PolylineBreak)cb;
                float[] rgba = pb.getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                for (int i = 0; i < count - 1; ++i) {
                    Vector<Vector3f> c1 = pipe.getContour(i);
                    Vector<Vector3f> c2 = pipe.getContour(i + 1);
                    Vector<Vector3f> n1 = pipe.getNormal(i);
                    Vector<Vector3f> n2 = pipe.getNormal(i + 1);
                    gl.glBegin(5);
                    for (int j = 0; j < c2.size(); ++j) {
                        gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                    }
                    gl.glEnd();
                }
            }
        }
    }

    private void drawStreamline(GL2 gl, Graphic graphic) {
        block7: {
            float[] p;
            List ps;
            ColorBreak cb;
            PolylineZShape shape;
            block8: {
                if (!this.extent.intersects(graphic.getExtent())) break block7;
                shape = (PolylineZShape)graphic.getShape();
                cb = graphic.getLegend();
                if (cb.getBreakType() != BreakTypes.COLOR_BREAK_COLLECTION) break block8;
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                Polyline line = (Polyline)shape.getPolylines().get(0);
                List ps2 = line.getPointList();
                gl.glLineWidth(((PolylineBreak)cbc.get(0)).getWidth() * this.dpiScale);
                gl.glBegin(3);
                for (int i = 0; i < ps2.size(); ++i) {
                    PolylineBreak plb = (PolylineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(plb.getWidth() * this.dpiScale);
                    PointZ p2 = (PointZ)ps2.get(i);
                    gl.glVertex3f(this.transform.transform_x((float)p2.X), this.transform.transform_y((float)p2.Y), this.transform.transform_z((float)p2.Z));
                }
                gl.glEnd();
                StreamlineBreak slb = (StreamlineBreak)cbc.get(0);
                int interval = slb.getInterval();
                if (!(slb.getArrowHeadLength() > 0.0f) && !(slb.getArrowHeadWidth() > 0.0f)) break block7;
                for (int i = 0; i < ps2.size(); ++i) {
                    slb = (StreamlineBreak)cbc.get(i);
                    PointZ pp = (PointZ)ps2.get(i);
                    float[] p2 = new float[]{this.transform.transform_x((float)pp.X), this.transform.transform_y((float)pp.Y), this.transform.transform_z((float)pp.Z)};
                    if (i <= 0 || i % interval != 0) continue;
                    pp = (PointZ)ps2.get(i - 1);
                    float[] p1 = new float[]{this.transform.transform_x((float)pp.X), this.transform.transform_y((float)pp.Y), this.transform.transform_z((float)pp.Z)};
                    this.drawArrow(gl, p2, p1, slb);
                }
                break block7;
            }
            StreamlineBreak slb = (StreamlineBreak)cb;
            int interval = slb.getInterval() * 3;
            float[] rgba = slb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(slb.getWidth() * this.dpiScale);
            gl.glBegin(3);
            for (Polyline line : shape.getPolylines()) {
                ps = line.getPointList();
                for (int i = 0; i < ps.size(); ++i) {
                    PointZ pp = (PointZ)ps.get(i);
                    p = new float[]{this.transform.transform_x((float)pp.X), this.transform.transform_y((float)pp.Y), this.transform.transform_z((float)pp.Z)};
                    gl.glVertex3f(p[0], p[1], p[2]);
                }
            }
            gl.glEnd();
            if (slb.getArrowHeadLength() > 0.0f || slb.getArrowHeadWidth() > 0.0f) {
                for (Polyline line : shape.getPolylines()) {
                    ps = line.getPointList();
                    for (int i = 0; i < ps.size(); ++i) {
                        PointZ pp = (PointZ)ps.get(i);
                        p = new float[]{this.transform.transform_x((float)pp.X), this.transform.transform_y((float)pp.Y), this.transform.transform_z((float)pp.Z)};
                        if (i <= 0 || i % interval != 0) continue;
                        pp = (PointZ)ps.get(i - 1);
                        float[] p1 = new float[]{this.transform.transform_x((float)pp.X), this.transform.transform_y((float)pp.Y), this.transform.transform_z((float)pp.Z)};
                        this.drawArrow(gl, p, p1, slb);
                    }
                }
            }
        }
    }

    private void drawPipeStreamline(GL2 gl, Graphic graphic) {
        block7: {
            int count;
            Pipe pipe;
            ColorBreak cb;
            block8: {
                if (!this.extent.intersects(graphic.getExtent())) break block7;
                PipeShape shape = (PipeShape)graphic.getShape();
                cb = graphic.getLegend();
                shape.transform(this.transform);
                pipe = shape.getPipe();
                count = pipe.getContourCount();
                if (cb.getBreakType() != BreakTypes.COLOR_BREAK_COLLECTION) break block8;
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                for (int i = 0; i < count - 1; ++i) {
                    StreamlineBreak plb = (StreamlineBreak)cbc.get(i);
                    float[] rgba = plb.getColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    Vector<Vector3f> c1 = pipe.getContour(i);
                    Vector<Vector3f> c2 = pipe.getContour(i + 1);
                    Vector<Vector3f> n1 = pipe.getNormal(i);
                    Vector<Vector3f> n2 = pipe.getNormal(i + 1);
                    gl.glBegin(5);
                    for (int j = 0; j < c2.size(); ++j) {
                        gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                    }
                    gl.glEnd();
                }
                Vector<Vector3f> path = pipe.getPath();
                StreamlineBreak slb = (StreamlineBreak)cbc.get(0);
                int interval = slb.getInterval();
                if (!(slb.getArrowHeadLength() > 0.0f) && !(slb.getArrowHeadWidth() > 0.0f)) break block7;
                for (int i = 0; i < path.size(); ++i) {
                    slb = (StreamlineBreak)cbc.get(i);
                    Vector3f pp = path.get(i);
                    float[] p2 = new float[]{pp.x, pp.y, pp.z};
                    if (i <= 0 || i % interval != 0) continue;
                    pp = path.get(i - 1);
                    float[] p1 = new float[]{pp.x, pp.y, pp.z};
                    this.drawArrow(gl, p2, p1, slb);
                }
                break block7;
            }
            StreamlineBreak slb = (StreamlineBreak)cb;
            int interval = slb.getInterval() * 3;
            float[] rgba = slb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            for (int i = 0; i < count - 1; ++i) {
                Vector<Vector3f> c1 = pipe.getContour(i);
                Vector<Vector3f> c2 = pipe.getContour(i + 1);
                Vector<Vector3f> n1 = pipe.getNormal(i);
                Vector<Vector3f> n2 = pipe.getNormal(i + 1);
                gl.glBegin(5);
                for (int j = 0; j < c2.size(); ++j) {
                    gl.glNormal3fv(JOGLUtil.toArray(n2.get(j)), 0);
                    gl.glVertex3fv(JOGLUtil.toArray(c2.get(j)), 0);
                    gl.glNormal3fv(JOGLUtil.toArray(n1.get(j)), 0);
                    gl.glVertex3fv(JOGLUtil.toArray(c1.get(j)), 0);
                }
                gl.glEnd();
            }
            Vector<Vector3f> path = pipe.getPath();
            if (slb.getArrowHeadLength() > 0.0f || slb.getArrowHeadWidth() > 0.0f) {
                for (int i = 0; i < path.size(); ++i) {
                    Vector3f pp = path.get(i);
                    float[] p2 = new float[]{pp.x, pp.y, pp.z};
                    if (i <= 0 || i % interval != 0) continue;
                    pp = path.get(i - 1);
                    float[] p1 = new float[]{pp.x, pp.y, pp.z};
                    this.drawArrow(gl, p2, p1, slb);
                }
            }
        }
    }

    private void drawPolygonShape(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolygonZShape shape = (PolygonZShape)graphic.getShape();
            PolygonBreak pb = (PolygonBreak)graphic.getLegend();
            List polygonZS = shape.getPolygons();
            for (int i = 0; i < polygonZS.size(); ++i) {
                PolygonZ polygonZ = (PolygonZ)shape.getPolygons().get(i);
                if (pb.isDrawFill()) {
                    if (polygonZ instanceof TessPolygon) {
                        this.drawTessPolygon(gl, (TessPolygon)polygonZ, pb);
                        continue;
                    }
                    if (polygonZ.getOutLine().size() <= 5) {
                        this.drawConvexPolygon(gl, polygonZ, pb);
                        continue;
                    }
                    TessPolygon tessPolygon = new TessPolygon(polygonZ);
                    this.drawTessPolygon(gl, tessPolygon, pb);
                    polygonZS.set(i, tessPolygon);
                    continue;
                }
                this.drawPolygon(gl, polygonZ, pb);
            }
        }
    }

    private void drawTessPolygon(GL2 gl, TessPolygon tessPolygon, PolygonBreak aPGB) {
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            try {
                for (Primitive primitive : tessPolygon.getPrimitives()) {
                    gl.glBegin(primitive.type);
                    for (PointZ p : primitive.vertices) {
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                    gl.glEnd();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aPGB.isDrawOutline()) {
            PointZ p;
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < tessPolygon.getOutLine().size(); ++i) {
                p = (PointZ)tessPolygon.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
            if (tessPolygon.hasHole()) {
                for (int h = 0; h < tessPolygon.getHoleLines().size(); ++h) {
                    gl.glBegin(3);
                    List newPList = (List)tessPolygon.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                    gl.glEnd();
                }
            }
            gl.glDisable(32823);
        }
    }

    private void drawPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            try {
                TessPolygon tessPolygon = new TessPolygon(aPG);
                for (Primitive primitive : tessPolygon.getPrimitives()) {
                    gl.glBegin(primitive.type);
                    for (PointZ p : primitive.vertices) {
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                    gl.glEnd();
                }
                aPG = tessPolygon;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aPGB.isDrawOutline()) {
            PointZ p;
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
            if (aPG.hasHole()) {
                gl.glBegin(3);
                for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                    List newPList = (List)aPG.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                }
                gl.glEnd();
            }
            gl.glDisable(32823);
        }
    }

    private void drawPolygon_bak(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            try {
                double[] v;
                int i;
                Plot3DGL plot3DGL = this;
                GLUtessellator tobj = plot3DGL.glu.gluNewTess();
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100101, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100100, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100102, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100103, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessBeginPolygon((GLUtessellator)tobj, null);
                GLU.gluTessBeginContour((GLUtessellator)tobj);
                for (i = 0; i < aPG.getOutLine().size() - 1; ++i) {
                    p = (PointZ)aPG.getOutLine().get(i);
                    v = this.transform.transform(p);
                    GLU.gluTessVertex((GLUtessellator)tobj, (double[])v, (int)0, (Object)v);
                }
                GLU.gluTessEndContour((GLUtessellator)tobj);
                if (aPG.hasHole()) {
                    for (i = 0; i < aPG.getHoleLineNumber(); ++i) {
                        GLU.gluTessBeginContour((GLUtessellator)tobj);
                        for (int j = 0; j < aPG.getHoleLine(i).size() - 1; ++j) {
                            p = (PointZ)aPG.getHoleLine(i).get(j);
                            v = this.transform.transform(p);
                            GLU.gluTessVertex((GLUtessellator)tobj, (double[])v, (int)0, (Object)v);
                        }
                        GLU.gluTessEndContour((GLUtessellator)tobj);
                    }
                }
                GLU.gluTessEndPolygon((GLUtessellator)tobj);
                GLU.gluDeleteTess((GLUtessellator)tobj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
            if (aPG.hasHole()) {
                gl.glBegin(3);
                for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                    List newPList = (List)aPG.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                }
                gl.glEnd();
            }
            gl.glDisable(32823);
        }
    }

    private void drawConvexPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba;
        if (aPGB.isDrawFill()) {
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(9);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawQuadsPolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            if (!this.extent.intersects(gg.getExtent())) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ poly : shape.getPolygons()) {
                this.drawQuads(gl, poly, pb);
            }
        }
    }

    private void drawQuads(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawTrianglePolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            if (!this.extent.intersects(gg.getExtent())) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ poly : shape.getPolygons()) {
                this.drawTriangle(gl, poly, pb);
            }
        }
    }

    private void drawTriangle(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(4);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawTriangle(GL2 gl, PointZ[] points, PolygonBreak aPGB) {
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            float[] x0 = this.transform.transformf(points[0]);
            float[] x1 = this.transform.transformf(points[1]);
            float[] x2 = this.transform.transformf(points[2]);
            gl.glBegin(4);
            if (this.lighting.isEnable()) {
                float[] normal = JOGLUtil.normalize(x0, x1, x2);
                gl.glNormal3fv(normal, 0);
            }
            gl.glVertex3fv(x0, 0);
            gl.glVertex3fv(x1, 0);
            gl.glVertex3fv(x2, 0);
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize() * this.dpiScale);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(3);
            for (int i = 0; i < 3; ++i) {
                PointZ p = points[i];
                gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawSurface(GL2 gl, SurfaceGraphics surface) {
        float[] rgba;
        int j;
        int i;
        boolean usingLight;
        PolygonBreak pgb = (PolygonBreak)surface.getLegendBreak(0, 0);
        int dim1 = surface.getDim1();
        int dim2 = surface.getDim2();
        boolean lightEnabled = this.lighting.isEnable();
        boolean bl = usingLight = lightEnabled && surface.isUsingLight();
        if (lightEnabled && !surface.isUsingLight()) {
            this.lighting.stop(gl);
        }
        surface.transform(this.transform);
        if (pgb.isDrawOutline()) {
            int i2;
            gl.glLineWidth(pgb.getOutlineSize() * this.dpiScale);
            if (surface.isEdgeInterp()) {
                for (i = 0; i < dim1; ++i) {
                    gl.glBegin(3);
                    for (j = 0; j < dim2; ++j) {
                        rgba = surface.getEdgeRGBA(i, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i, j)), 0);
                    }
                    gl.glEnd();
                }
                for (int j2 = 0; j2 < dim2; ++j2) {
                    gl.glBegin(3);
                    for (i2 = 0; i2 < dim1; ++i2) {
                        rgba = surface.getEdgeRGBA(i2, j2);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i2, j2)), 0);
                    }
                    gl.glEnd();
                }
            } else {
                float[] vertex;
                Vector3f p;
                for (i2 = 0; i2 < dim1; ++i2) {
                    p = surface.getTVertex(i2, 0);
                    vertex = JOGLUtil.toArray(p);
                    for (int j3 = 0; j3 < dim2 - 1; ++j3) {
                        rgba = surface.getEdgeRGBA(i2, j3);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glBegin(1);
                        gl.glVertex3fv(vertex, 0);
                        p = surface.getTVertex(i2, j3 + 1);
                        vertex = JOGLUtil.toArray(p);
                        gl.glVertex3fv(vertex, 0);
                        gl.glEnd();
                    }
                }
                for (j = 0; j < dim2; ++j) {
                    p = surface.getTVertex(0, j);
                    vertex = JOGLUtil.toArray(p);
                    for (int i3 = 0; i3 < dim1 - 1; ++i3) {
                        p = surface.getTVertex(i3, j);
                        rgba = surface.getEdgeRGBA(i3, j);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glBegin(1);
                        gl.glVertex3fv(vertex, 0);
                        p = surface.getTVertex(i3 + 1, j);
                        vertex = JOGLUtil.toArray(p);
                        gl.glVertex3fv(vertex, 0);
                        gl.glEnd();
                    }
                }
            }
        }
        if (pgb.isDrawFill()) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            if (surface.isFaceInterp()) {
                for (i = 0; i < dim1 - 1; ++i) {
                    for (j = 0; j < dim2 - 1; ++j) {
                        gl.glBegin(7);
                        rgba = surface.getRGBA(i, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i, j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i, j)), 0);
                        rgba = surface.getRGBA(i + 1, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i + 1, j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i + 1, j)), 0);
                        rgba = surface.getRGBA(i + 1, j + 1);
                        gl.glColor4fv(rgba, 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i + 1, j + 1)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i + 1, j + 1)), 0);
                        rgba = surface.getRGBA(i, j + 1);
                        gl.glColor4fv(rgba, 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i, j + 1)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i, j + 1)), 0);
                        gl.glEnd();
                    }
                }
            } else {
                for (i = 0; i < dim1 - 1; ++i) {
                    for (j = 0; j < dim2 - 1; ++j) {
                        gl.glBegin(7);
                        rgba = surface.getRGBA(i, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i, j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i, j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i + 1, j)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i + 1, j)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i + 1, j + 1)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i + 1, j + 1)), 0);
                        gl.glNormal3fv(JOGLUtil.toArray(surface.getNormal(i, j + 1)), 0);
                        gl.glVertex3fv(JOGLUtil.toArray(surface.getTVertex(i, j + 1)), 0);
                        gl.glEnd();
                    }
                }
            }
            gl.glDisable(32823);
        }
        if (lightEnabled && !surface.isUsingLight()) {
            this.lighting.start(gl);
        }
    }

    private void drawSurface_bak(GL2 gl, SurfaceGraphics surface) {
        float[] rgba;
        boolean usingLight;
        PolygonBreak pgb = (PolygonBreak)surface.getLegendBreak(0, 0);
        int dim1 = surface.getDim1();
        int dim2 = surface.getDim2();
        boolean lightEnabled = this.lighting.isEnable();
        boolean bl = usingLight = lightEnabled && surface.isUsingLight();
        if (lightEnabled && !surface.isUsingLight()) {
            this.lighting.stop(gl);
        }
        if (pgb.isDrawOutline()) {
            int i;
            PointZ p;
            int j;
            gl.glLineWidth(pgb.getOutlineSize() * this.dpiScale);
            if (surface.isEdgeInterp()) {
                for (int i2 = 0; i2 < dim1; ++i2) {
                    gl.glBegin(3);
                    for (j = 0; j < dim2; ++j) {
                        p = surface.getVertex(i2, j);
                        rgba = surface.getEdgeRGBA(i2, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                    gl.glEnd();
                }
                for (int j2 = 0; j2 < dim2; ++j2) {
                    gl.glBegin(3);
                    for (i = 0; i < dim1; ++i) {
                        p = surface.getVertex(i, j2);
                        rgba = surface.getEdgeRGBA(i, j2);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glVertex3f(this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z));
                    }
                    gl.glEnd();
                }
            } else {
                float[] vertex;
                for (i = 0; i < dim1; ++i) {
                    p = surface.getVertex(i, 0);
                    vertex = this.transform.transformf(p);
                    for (int j3 = 0; j3 < dim2 - 1; ++j3) {
                        rgba = surface.getEdgeRGBA(i, j3);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glBegin(1);
                        gl.glVertex3fv(vertex, 0);
                        p = surface.getVertex(i, j3 + 1);
                        vertex = this.transform.transformf(p);
                        gl.glVertex3fv(vertex, 0);
                        gl.glEnd();
                    }
                }
                for (j = 0; j < dim2; ++j) {
                    p = surface.getVertex(0, j);
                    vertex = this.transform.transformf(p);
                    for (int i3 = 0; i3 < dim1 - 1; ++i3) {
                        p = surface.getVertex(i3, j);
                        rgba = surface.getEdgeRGBA(i3, j);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glBegin(1);
                        gl.glVertex3fv(vertex, 0);
                        p = surface.getVertex(i3 + 1, j);
                        vertex = this.transform.transformf(p);
                        gl.glVertex3fv(vertex, 0);
                        gl.glEnd();
                    }
                }
            }
        }
        if (pgb.isDrawFill()) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            if (surface.isFaceInterp()) {
                for (int i = 0; i < dim1 - 1; ++i) {
                    for (int j = 0; j < dim2 - 1; ++j) {
                        float[] p1 = this.transform.transformf(surface.getVertex(i, j));
                        float[] p2 = this.transform.transformf(surface.getVertex(i + 1, j));
                        float[] p3 = this.transform.transformf(surface.getVertex(i + 1, j + 1));
                        float[] p4 = this.transform.transformf(surface.getVertex(i, j + 1));
                        gl.glBegin(7);
                        if (usingLight) {
                            float[] normal = JOGLUtil.normalize(p1, p2, p3);
                            gl.glNormal3fv(normal, 0);
                        }
                        rgba = surface.getRGBA(i, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(p1, 0);
                        rgba = surface.getRGBA(i + 1, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(p2, 0);
                        rgba = surface.getRGBA(i + 1, j + 1);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(p3, 0);
                        rgba = surface.getRGBA(i, j + 1);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(p4, 0);
                        gl.glEnd();
                    }
                }
            } else {
                for (int i = 0; i < dim1 - 1; ++i) {
                    for (int j = 0; j < dim2 - 1; ++j) {
                        float[] p1 = this.transform.transformf(surface.getVertex(i, j));
                        float[] p2 = this.transform.transformf(surface.getVertex(i + 1, j));
                        float[] p3 = this.transform.transformf(surface.getVertex(i + 1, j + 1));
                        float[] p4 = this.transform.transformf(surface.getVertex(i, j + 1));
                        gl.glBegin(7);
                        if (usingLight) {
                            float[] normal = JOGLUtil.normalize(p1, p2, p3);
                            gl.glNormal3fv(normal, 0);
                        }
                        rgba = surface.getRGBA(i, j);
                        gl.glColor4fv(rgba, 0);
                        gl.glVertex3fv(p1, 0);
                        gl.glVertex3fv(p2, 0);
                        gl.glVertex3fv(p3, 0);
                        gl.glVertex3fv(p4, 0);
                        gl.glEnd();
                    }
                }
            }
            gl.glDisable(32823);
        }
        if (lightEnabled && !surface.isUsingLight()) {
            this.lighting.start(gl);
        }
    }

    private void drawIsosurface(GL2 gl, IsosurfaceGraphics isosurface) {
        List<PointZ[]> triangles = isosurface.getTriangles();
        PolygonBreak pgb = (PolygonBreak)isosurface.getLegendBreak();
        for (PointZ[] triangle : triangles) {
            this.drawTriangle(gl, triangle, pgb);
        }
    }

    private void drawImage(GL2 gl, Graphic graphic) {
        ImageShape ishape = (ImageShape)graphic.getShape();
        BufferedImage image = ishape.getImage();
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = texture.getTextureObject();
        List coords = ishape.getCoords();
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)0)).X), this.transform.transform_y((float)((PointZ)coords.get((int)0)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)0)).Z));
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)1)).X), this.transform.transform_y((float)((PointZ)coords.get((int)1)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)1)).Z));
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)2)).X), this.transform.transform_y((float)((PointZ)coords.get((int)2)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)2)).Z));
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)3)).X), this.transform.transform_y((float)((PointZ)coords.get((int)3)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)3)).Z));
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    private void drawImage(GL2 gl) throws IOException {
        File im = new File("D:\\Temp\\image\\lenna.jpg ");
        BufferedImage image = ImageIO.read(im);
        Texture t = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = t.getTextureObject((GL)gl);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    private void drawTexture(GL2 gl, Graphic graphic) {
        TextureShape ishape = (TextureShape)graphic.getShape();
        Texture texture = ishape.getTexture();
        if (texture == null) {
            try {
                ishape.loadTexture();
                texture = ishape.getTexture();
            }
            catch (IOException ex) {
                Logger.getLogger(Plot3DGL.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (texture == null) {
            return;
        }
        int idTexture = texture.getTextureObject((GL)gl);
        List coords = ishape.getCoords();
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9987);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)0)).X), this.transform.transform_y((float)((PointZ)coords.get((int)0)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)0)).Z));
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)1)).X), this.transform.transform_y((float)((PointZ)coords.get((int)1)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)1)).Z));
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)2)).X), this.transform.transform_y((float)((PointZ)coords.get((int)2)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)2)).Z));
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(this.transform.transform_x((float)((PointZ)coords.get((int)3)).X), this.transform.transform_y((float)((PointZ)coords.get((int)3)).Y), this.transform.transform_z((float)((PointZ)coords.get((int)3)).Z));
        gl.glEnd();
        gl.glFlush();
        gl.glBindTexture(3553, 0);
    }

    void drawArrow(GL2 gl, float[] p1, float[] p2, StreamlineBreak slb) {
        float[] v = new float[]{p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]};
        float norm_of_v = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        float coneRadius = slb.getArrowHeadLength() * 0.02f;
        float coneHgt = slb.getArrowHeadWidth() * 0.02f;
        float[] vConeLocation = p2;
        float[] mat44 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] dVec = new float[]{v[0], v[1], v[2]};
        float[] norm_startVec = VectorUtil.normalizeVec3((float[])dVec);
        float[] zaxis = new float[]{0.0f, 0.0f, 1.0f};
        float[] norm_endVec = VectorUtil.normalizeVec3((float[])zaxis);
        if (Float.isNaN(norm_endVec[0]) || Float.isNaN(norm_endVec[1]) || Float.isNaN(norm_endVec[2])) {
            norm_endVec[0] = 0.0f;
            norm_endVec[1] = 0.0f;
            norm_endVec[2] = 0.0f;
        }
        if ((double)(norm_startVec[0] - norm_endVec[0]) > 1.0E-14 && (double)(norm_startVec[1] - norm_endVec[1]) > 1.0E-14 && (double)(norm_startVec[2] - norm_endVec[2]) > 1.0E-14) {
            mat44[0] = 1.0f;
            mat44[5] = 1.0f;
            mat44[10] = 1.0f;
            mat44[15] = 1.0f;
        } else {
            float[] axb = new float[3];
            VectorUtil.crossVec3((float[])axb, (float[])norm_startVec, (float[])norm_endVec);
            float[] norm_axb = VectorUtil.normalizeVec3((float[])axb);
            if (Float.isNaN(norm_axb[0]) || Float.isNaN(norm_axb[1]) || Float.isNaN(norm_axb[2])) {
                norm_axb[0] = 0.0f;
                norm_axb[1] = 0.0f;
                norm_axb[2] = 0.0f;
            }
            float ac = (float)Math.acos(VectorUtil.dotVec3((float[])norm_startVec, (float[])norm_endVec));
            float s = (float)Math.sin(ac);
            float c = (float)Math.cos(ac);
            float t = 1.0f - c;
            float x = norm_axb[0];
            float y = norm_axb[1];
            float z = norm_axb[2];
            mat44[0] = t * x * x + c;
            mat44[1] = t * x * y - s * z;
            mat44[2] = t * x * z + s * y;
            mat44[4] = t * x * y + s * z;
            mat44[5] = t * y * y + c;
            mat44[6] = t * y * z - s * x;
            mat44[8] = t * x * z - s * y;
            mat44[9] = t * y * z + s * x;
            mat44[10] = t * z * z + c;
            mat44[15] = 1.0f;
        }
        gl.glPushMatrix();
        gl.glPushAttrib(8);
        gl.glDisable(2884);
        gl.glTranslatef(vConeLocation[0], vConeLocation[1], vConeLocation[2]);
        gl.glMultMatrixf(mat44, 0);
        float[] rgba = slb.getColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        GLUquadric cone_obj = this.glu.gluNewQuadric();
        this.glu.gluCylinder(cone_obj, 0.0, (double)coneHgt, (double)coneRadius, 8, 1);
        gl.glPopAttrib();
        gl.glPopMatrix();
    }

    void drawWindArrow(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            WindArrow3D shape = (WindArrow3D)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            PointZ sp = (PointZ)shape.getPoint();
            PointZ ep = shape.getEndPoint();
            float x1 = this.transform.transform_x((float)sp.X);
            float y1 = this.transform.transform_y((float)sp.Y);
            float z1 = this.transform.transform_z((float)sp.Z);
            float x2 = this.transform.transform_x((float)ep.X);
            float y2 = this.transform.transform_y((float)ep.Y);
            float z2 = this.transform.transform_z((float)ep.Z);
            gl.glPushMatrix();
            gl.glPushAttrib(8);
            gl.glDisable(2884);
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(pb.getOutlineSize() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x1, y1, z1);
            gl.glVertex3f(x2, y2, z2);
            gl.glEnd();
            float[] v = new float[]{x1 - x2, y1 - y2, z1 - z2};
            float norm_of_v = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
            float coneRadius = shape.getHeadLength() * 0.02f;
            float coneHgt = shape.getHeadWith() * 0.02f;
            float[] vConeLocation = new float[]{x2, y2, z2};
            float[] mat44 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            float[] dVec = new float[]{v[0], v[1], v[2]};
            float[] norm_startVec = VectorUtil.normalizeVec3((float[])dVec);
            float[] zaxis = new float[]{0.0f, 0.0f, 1.0f};
            float[] norm_endVec = VectorUtil.normalizeVec3((float[])zaxis);
            if (Float.isNaN(norm_endVec[0]) || Float.isNaN(norm_endVec[1]) || Float.isNaN(norm_endVec[2])) {
                norm_endVec[0] = 0.0f;
                norm_endVec[1] = 0.0f;
                norm_endVec[2] = 0.0f;
            }
            if ((double)(norm_startVec[0] - norm_endVec[0]) > 1.0E-14 && (double)(norm_startVec[1] - norm_endVec[1]) > 1.0E-14 && (double)(norm_startVec[2] - norm_endVec[2]) > 1.0E-14) {
                mat44[0] = 1.0f;
                mat44[5] = 1.0f;
                mat44[10] = 1.0f;
                mat44[15] = 1.0f;
            } else {
                float[] axb = new float[3];
                VectorUtil.crossVec3((float[])axb, (float[])norm_startVec, (float[])norm_endVec);
                float[] norm_axb = VectorUtil.normalizeVec3((float[])axb);
                if (Float.isNaN(norm_axb[0]) || Float.isNaN(norm_axb[1]) || Float.isNaN(norm_axb[2])) {
                    norm_axb[0] = 0.0f;
                    norm_axb[1] = 0.0f;
                    norm_axb[2] = 0.0f;
                }
                float ac = (float)Math.acos(VectorUtil.dotVec3((float[])norm_startVec, (float[])norm_endVec));
                float s = (float)Math.sin(ac);
                float c = (float)Math.cos(ac);
                float t = 1.0f - c;
                float x = norm_axb[0];
                float y = norm_axb[1];
                float z = norm_axb[2];
                mat44[0] = t * x * x + c;
                mat44[1] = t * x * y - s * z;
                mat44[2] = t * x * z + s * y;
                mat44[4] = t * x * y + s * z;
                mat44[5] = t * y * y + c;
                mat44[6] = t * y * z - s * x;
                mat44[8] = t * x * z - s * y;
                mat44[9] = t * y * z + s * x;
                mat44[10] = t * z * z + c;
                mat44[15] = 1.0f;
            }
            gl.glTranslatef(vConeLocation[0], vConeLocation[1], vConeLocation[2]);
            gl.glMultMatrixf(mat44, 0);
            GLUquadric cone_obj = this.glu.gluNewQuadric();
            this.glu.gluCylinder(cone_obj, 0.0, (double)coneHgt, (double)coneRadius, 8, 1);
            gl.glPopAttrib();
            gl.glPopMatrix();
        }
    }

    void drawCircle(GL2 gl, float z, float radius, PolygonBreak bb) {
        this.drawCircle(gl, z, radius, bb, false);
    }

    void drawCircle(GL2 gl, float z, float radius, PolygonBreak bb, boolean clockwise) {
        int i;
        int i2;
        int points = 100;
        ArrayList<float[]> vertex = new ArrayList<float[]>();
        double angle = 0.0;
        if (clockwise) {
            for (i2 = points - 1; i2 >= 0; --i2) {
                angle = Math.PI * 2 * (double)i2 / (double)points;
                vertex.add(new float[]{(float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z});
            }
        } else {
            for (i2 = 0; i2 < points; ++i2) {
                angle = Math.PI * 2 * (double)i2 / (double)points;
                vertex.add(new float[]{(float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z});
            }
        }
        if (bb.isDrawFill()) {
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(6);
            if (this.lighting.isEnable()) {
                int ii = points / 4;
                float[] normal = JOGLUtil.normalize((float[])vertex.get(0), (float[])vertex.get(ii), (float[])vertex.get(ii * 2));
                gl.glNormal3fv(normal, 0);
            }
            for (i = 0; i < points; ++i) {
                gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
            }
            gl.glEnd();
        }
        if (bb.isDrawOutline()) {
            float[] rgba = bb.getOutlineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(bb.getOutlineSize() * this.dpiScale);
            gl.glBegin(2);
            for (i = 0; i < points; ++i) {
                gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
            }
            gl.glEnd();
        }
    }

    void drawCubic(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            CubicShape cubic = (CubicShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List ps = cubic.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z)});
            }
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            int[][] index = cubic.getIndex();
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(7);
            for (int[] ii : index) {
                if (this.lighting.isEnable()) {
                    float[] normal = JOGLUtil.normalize((float[])vertex.get(ii[0]), (float[])vertex.get(ii[1]), (float[])vertex.get(ii[2]));
                    gl.glNormal3fv(normal, 0);
                }
                for (int i2 : ii) {
                    gl.glVertex3f(((float[])vertex.get(i2))[0], ((float[])vertex.get(i2))[1], ((float[])vertex.get(i2))[2]);
                }
            }
            gl.glEnd();
            gl.glDisable(32823);
            if (bb.isDrawOutline()) {
                rgba = bb.getOutlineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(bb.getOutlineSize() * this.dpiScale);
                gl.glBegin(1);
                int[][] nArray = cubic.getLineIndex();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] ii;
                    for (int i2 : ii = nArray[i]) {
                        gl.glVertex3f(((float[])vertex.get(i2))[0], ((float[])vertex.get(i2))[1], ((float[])vertex.get(i2))[2]);
                    }
                }
                gl.glEnd();
            }
        }
    }

    void drawCylinder(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            CylinderShape cylinder = (CylinderShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List ps = cylinder.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{this.transform.transform_x((float)p.X), this.transform.transform_y((float)p.Y), this.transform.transform_z((float)p.Z)});
            }
            double height = ((float[])vertex.get(1))[2] - ((float[])vertex.get(0))[2];
            gl.glPushMatrix();
            gl.glPushAttrib(8);
            gl.glDisable(2884);
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glTranslatef(((float[])vertex.get(0))[0], ((float[])vertex.get(0))[1], ((float[])vertex.get(0))[2]);
            GLUquadric cone_obj = this.glu.gluNewQuadric();
            this.glu.gluCylinder(cone_obj, cylinder.getRadius(), cylinder.getRadius(), height, 100, 1);
            bb.setDrawOutline(false);
            this.drawCircle(gl, (float)height, (float)cylinder.getRadius(), (PolygonBreak)bb);
            this.drawCircle(gl, 0.0f, (float)cylinder.getRadius(), (PolygonBreak)bb, true);
            gl.glPopAttrib();
            gl.glPopMatrix();
        }
    }

    void drawLegend(GL2 gl) {
        if (!this.legends.isEmpty()) {
            ChartColorBar legend = (ChartColorBar)this.legends.get(0);
            LegendScheme ls = legend.getLegendScheme();
            int bNum = ls.getBreakNum();
            if (((ColorBreak)ls.getLegendBreaks().get(bNum - 1)).isNoData()) {
                --bNum;
            }
            float x = 1.6f;
            x += legend.getXShift() * this.lenScale;
            float y = -1.0f;
            float lHeight = 2.0f;
            float lWidth = lHeight / (float)legend.getAspect();
            ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
            ArrayList<String> tLabels = new ArrayList<String>();
            if (legend.isAutoTick()) {
                float legendLen = this.toScreenLength(x, y, 0.0f, x, y + lHeight, 0.0f);
                int tickGap = this.getLegendTickGap(legend, legendLen);
                int sIdx = bNum % tickGap / 2;
                int labNum = bNum - 1;
                if (ls.getLegendType() == LegendType.UNIQUE_VALUE) {
                    ++labNum;
                } else if (legend.isDrawMinLabel()) {
                    sIdx = 0;
                    labNum = bNum;
                }
                while (sIdx < labNum) {
                    labelIdxs.add(sIdx);
                    sIdx += tickGap;
                }
            } else {
                for (int i = 0; i < bNum; ++i) {
                    ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(i);
                    double v = Double.parseDouble(cb.getEndValue().toString());
                    if (!legend.getTickLocations().contains(v)) continue;
                    labelIdxs.add(i);
                    int tickIdx = legend.getTickLocations().indexOf(v);
                    tLabels.add(legend.getTickLabels().get(tickIdx).getText());
                }
            }
            float barHeight = lHeight / (float)bNum;
            float yy = y;
            for (int i = 0; i < bNum; ++i) {
                float[] rgba = ls.getLegendBreak(i).getColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glBegin(7);
                gl.glVertex2f(x, yy);
                gl.glVertex2f(x + lWidth, yy);
                gl.glVertex2f(x + lWidth, yy + barHeight);
                gl.glVertex2f(x, yy + barHeight);
                gl.glEnd();
                yy += barHeight;
            }
            float[] rgba = Color.black.getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(legend.getNeatLineSize() * this.dpiScale);
            gl.glBegin(3);
            gl.glVertex2f(x, y);
            gl.glVertex2f(x, y + lHeight);
            gl.glVertex2f(x + lWidth, y + lHeight);
            gl.glVertex2f(x + lWidth, y);
            gl.glVertex2f(x, y);
            gl.glEnd();
            int idx = 0;
            yy = y;
            float tickLen = legend.getTickLength() * this.lenScale;
            float labelX = x + lWidth;
            if (legend.isInsideTick()) {
                if (tickLen > lWidth) {
                    tickLen = lWidth;
                }
            } else {
                labelX += tickLen;
            }
            float strWidth = 0.0f;
            float xShift = this.tickSpace * this.dpiScale;
            for (int i = 0; i < bNum; ++i) {
                if (labelIdxs.contains(i)) {
                    Rectangle2D rect;
                    ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(i);
                    String caption = legend.isAutoTick() ? (ls.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
                    if (ls.getLegendType() == LegendType.UNIQUE_VALUE) {
                        rect = this.drawString(gl, caption, legend.getTickLabelFont(), legend.getTickLabelColor(), x + lWidth, yy + barHeight * 0.5f, 0.0f, XAlign.LEFT, YAlign.CENTER, xShift, 0.0f);
                    } else {
                        rgba = Color.black.getRGBComponents(null);
                        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                        gl.glLineWidth(legend.getTickWidth() * this.dpiScale);
                        gl.glBegin(1);
                        if (legend.isInsideTick()) {
                            gl.glVertex2f(x + lWidth - tickLen, yy + barHeight);
                        } else {
                            gl.glVertex2f(x + lWidth + tickLen, yy + barHeight);
                        }
                        gl.glVertex2f(x + lWidth, yy + barHeight);
                        gl.glEnd();
                        rect = this.drawString(gl, caption, legend.getTickLabelFont(), legend.getTickLabelColor(), labelX, yy + barHeight, 0.0f, XAlign.LEFT, YAlign.CENTER, xShift, 0.0f);
                    }
                    if ((double)strWidth < rect.getWidth()) {
                        strWidth = (float)rect.getWidth();
                    }
                    ++idx;
                }
                yy += barHeight;
            }
            ChartText label = legend.getLabel();
            if (label != null) {
                float yShift = this.tickSpace * this.dpiScale;
                switch (legend.getLabelLocation()) {
                    case "top": {
                        float sx = x + lWidth * 0.5f;
                        float sy = y + lHeight;
                        this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 0.0f, 0.0f, yShift);
                        break;
                    }
                    case "bottom": {
                        float sx = x + lWidth * 0.5f;
                        float sy = y;
                        yShift = -yShift;
                        this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 0.0f, 0.0f, yShift);
                        break;
                    }
                    case "left": 
                    case "in": {
                        float sx = x;
                        float sy = y + lHeight * 0.5f;
                        this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
                        break;
                    }
                    default: {
                        float sx = labelX;
                        float sy = y + lHeight * 0.5f;
                        yShift = -strWidth - yShift;
                        this.drawString(gl, label, sx, sy, 0.0f, XAlign.CENTER, YAlign.TOP, 90.0f, 0.0f, yShift);
                    }
                }
            }
        }
    }

    public LegendScheme getLegendScheme() {
        LegendScheme ls = null;
        int n = this.graphics.getNumGraphics();
        for (int i = n - 1; i >= 0; --i) {
            Graphic g = this.graphics.getGraphicN(i);
            if (!(g instanceof GraphicCollection)) continue;
            ls = ((GraphicCollection)g).getLegendScheme();
            break;
        }
        if (ls == null) {
            ShapeTypes stype = ShapeTypes.POLYLINE;
            ls = new LegendScheme(stype);
            for (Graphic g : this.graphics.getGraphics()) {
                ls.getLegendBreaks().add(g.getLegend());
            }
        }
        return ls;
    }

    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        Program.destroyAllPrograms(gl);
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glEnable(2832);
        gl.glEnable(2929);
        gl.glShadeModel(7425);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glEnable(3553);
        this.tessCallback = new TessCallback(gl, this.glu);
        this.positionArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.positionArea = this.getPositionArea(new Rectangle2D.Double(0.0, 0.0, width, height));
        GL2 gl = drawable.getGL().getGL2();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        switch (this.aspectType) {
            case EQUAL: {
                int diff;
                if (h > 1.0f) {
                    diff = width - height;
                    gl.glViewport(diff / 2, 0, width - diff, height);
                    this.width = width - diff;
                    break;
                }
                if (h < 1.0f) {
                    diff = height - width;
                    gl.glViewport(0, diff / 2, width, height - diff);
                    this.height = height - diff;
                    break;
                }
                gl.glViewport(0, 0, width, height);
                break;
            }
            default: {
                gl.glViewport(0, 0, width, height);
            }
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        float v = 2.0f;
        gl.glOrthof(-v, v, -v, v, -5.0f, 5.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        return null;
    }

    public Object clone() {
        Plot3DGL plot3DGL = new Plot3DGL();
        plot3DGL.graphics = this.graphics;
        plot3DGL.angleX = this.angleX;
        plot3DGL.angleY = this.angleY;
        plot3DGL.background = this.background;
        plot3DGL.sampleBuffers = this.sampleBuffers;
        plot3DGL.antialias = this.antialias;
        plot3DGL.boxColor = this.boxColor;
        plot3DGL.boxed = this.boxed;
        plot3DGL.clipPlane = this.clipPlane;
        plot3DGL.displayXY = this.displayXY;
        plot3DGL.displayZ = this.displayZ;
        plot3DGL.dpiScale = this.dpiScale;
        plot3DGL.drawBase = this.drawBase;
        plot3DGL.drawBoundingBox = this.drawBoundingBox;
        plot3DGL.setExtent((Extent3D)this.extent.clone());
        plot3DGL.gridLine = this.gridLine;
        plot3DGL.legends = this.legends;
        plot3DGL.hideOnDrag = this.hideOnDrag;
        plot3DGL.lighting = this.lighting;
        plot3DGL.title = this.title;
        return plot3DGL;
    }

    public static void main(String[] args) {
        GLProfile gp = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(gp);
        GLChartPanel gc = new GLChartPanel(cap, new Plot3DGL());
        gc.setSize(400, 400);
        JFrame frame = new JFrame("JOGL Line");
        frame.add((Component)((Object)gc));
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    public static class TessCallback
    extends GLUtessellatorCallbackAdapter {
        GL2 gl;
        GLU glu;

        public TessCallback(GL2 gl, GLU glu) {
            this.gl = gl;
            this.glu = glu;
        }

        public void begin(int type) {
            this.gl.glBegin(type);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object data) {
            if (data instanceof double[]) {
                double[] d = (double[])data;
                if (d.length == 6) {
                    this.gl.glColor3dv(d, 3);
                }
                this.gl.glVertex3dv(d, 0);
            }
        }

        public void error(int errnum) {
            String estring = this.glu.gluErrorString(errnum);
            System.out.println("Tessellation Error: " + estring);
            throw new RuntimeException();
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[6];
            vertex[0] = coords[0];
            vertex[1] = coords[1];
            vertex[2] = coords[2];
            for (int i = 3; i < 6; ++i) {
                vertex[i] = (double)weight[0] * ((double[])data[0])[i] + (double)weight[1] * ((double[])data[1])[i] + (double)weight[2] * ((double[])data[2])[i] + (double)weight[3] * ((double[])data[3])[i];
            }
            outData[0] = vertex;
        }
    }
}

