/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import org.joml.Vector3f;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.shape.PointZ;

public class Transform {
    private AspectType aspectType = AspectType.AUTO;
    private float xmin;
    private float xmax = 1.0f;
    private float ymin;
    private float ymax = 1.0f;
    private float zmin;
    private float zmax = 1.0f;

    public Transform() {
    }

    public Transform(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.setExtent(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    public Transform(Extent3D extent3D) {
        this.setExtent(extent3D);
    }

    public void setExtent(Extent3D extent3D) {
        this.setExtent((float)extent3D.minX, (float)extent3D.maxX, (float)extent3D.minY, (float)extent3D.maxY, (float)extent3D.minZ, (float)extent3D.maxZ);
    }

    public void setExtent(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
        if (this.aspectType != AspectType.AUTO) {
            float xRange = xmax - xmin;
            float yRange = ymax - ymin;
            float zRange = zmax - zmin;
            float maxXYRange = xRange > yRange ? xRange : yRange;
            float xRatio = xRange / maxXYRange;
            float yRatio = yRange / maxXYRange;
            if (this.aspectType == AspectType.EQUAL) {
                float maxRange = zRange > maxXYRange ? zRange : maxXYRange;
                xRatio = xRange / maxRange;
                yRatio = yRange / maxRange;
                float zRatio = zRange / maxRange;
                if (zRatio != 1.0f) {
                    this.zmin = zmin / zRatio;
                    this.zmax = zmax / zRatio;
                }
            }
            if (xRatio != 1.0f) {
                this.xmin = xmin / xRatio;
                this.xmax = xmax / xRatio;
            }
            if (yRatio != 1.0f) {
                this.ymin = ymin / yRatio;
                this.ymax = ymax / yRatio;
            }
        }
    }

    public AspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(AspectType value) {
        this.aspectType = value;
    }

    public boolean equals(Transform other) {
        if (this.aspectType != other.aspectType) {
            return false;
        }
        if (this.xmin != other.xmin) {
            return false;
        }
        if (this.xmax != other.xmax) {
            return false;
        }
        if (this.ymin != other.ymin) {
            return false;
        }
        if (this.ymax != other.ymax) {
            return false;
        }
        if (this.zmin != other.zmin) {
            return false;
        }
        return this.zmax == other.zmax;
    }

    public float transform_x(float v) {
        return (v - this.xmin) / (this.xmax - this.xmin) * 2.0f - 1.0f;
    }

    public double transform_x(double v) {
        return (v - (double)this.xmin) / (double)(this.xmax - this.xmin) * 2.0 - 1.0;
    }

    public float transform_y(float v) {
        return (v - this.ymin) / (this.ymax - this.ymin) * 2.0f - 1.0f;
    }

    public double transform_y(double v) {
        return (v - (double)this.ymin) / (double)(this.ymax - this.ymin) * 2.0 - 1.0;
    }

    public float transform_z(float v) {
        return (v - this.zmin) / (this.zmax - this.zmin) * 2.0f - 1.0f;
    }

    public double transform_z(double v) {
        return (v - (double)this.zmin) / (double)(this.zmax - this.zmin) * 2.0 - 1.0;
    }

    public float transformXDis(float len) {
        return this.transform_x(len) - this.transform_x(0.0f);
    }

    public float transformYDis(float len) {
        return this.transform_y(len) - this.transform_y(0.0f);
    }

    public float[] transform(float x, float y, float z) {
        return new float[]{this.transform_x(x), this.transform_y(y), this.transform_z(z)};
    }

    public float[] transformf(PointZ p) {
        return new float[]{this.transform_x((float)p.X), this.transform_y((float)p.Y), this.transform_z((float)p.Z)};
    }

    public double[] transform(PointZ p) {
        return new double[]{this.transform_x(p.X), this.transform_y(p.Y), this.transform_z(p.Z)};
    }

    public float[] transform(Vector3f p) {
        return this.transform(p.x, p.y, p.z);
    }

    public Object clone() {
        return new Transform(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }
}

