/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.pipe;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Matrix4f
extends org.joml.Matrix4f {
    final float EPSILON = 1.0E-5f;

    public Matrix4f() {
    }

    public Matrix4f(org.joml.Matrix4f m) {
        this.m00(m.m00()).m01(m.m01()).m02(m.m02()).m03(m.m03()).m10(m.m10()).m11(m.m11()).m12(m.m12()).m13(m.m13()).m20(m.m20()).m21(m.m21()).m22(m.m22()).m23(m.m23()).m30(m.m30()).m31(m.m31()).m32(m.m32()).m33(m.m33());
    }

    public Matrix4f setRow(int row, Vector3f src) throws IndexOutOfBoundsException {
        switch (row) {
            case 0: {
                this.m00(src.x()).m10(src.y()).m20(src.z());
                return this;
            }
            case 1: {
                this.m01(src.x()).m11(src.y()).m21(src.z());
                return this;
            }
            case 2: {
                this.m02(src.x()).m12(src.y()).m22(src.z());
                return this;
            }
            case 3: {
                this.m03(src.x()).m13(src.y()).m23(src.z());
                return this;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix4f setColumn(int column, Vector3f src) throws IndexOutOfBoundsException {
        switch (column) {
            case 0: {
                this.m00(src.x()).m01(src.y()).m02(src.z());
                return this;
            }
            case 1: {
                this.m10(src.x()).m11(src.y()).m12(src.z());
                return this;
            }
            case 2: {
                this.m20(src.x()).m21(src.y()).m22(src.z());
                return this;
            }
            case 3: {
                this.m30(src.x()).m31(src.y()).m32(src.z());
                return this;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix4f lookAt(Vector3f target) {
        Vector3f position = new Vector3f(this.m30(), this.m31(), this.m32());
        Vector3f forward = target.sub((Vector3fc)position, new Vector3f());
        forward.normalize();
        Vector3f up = new Vector3f();
        if (Math.abs(forward.x) < 1.0E-5f && Math.abs(forward.z) < 1.0E-5f) {
            if (forward.y > 0.0f) {
                up.set(0.0f, 0.0f, -1.0f);
            } else {
                up.set(0.0f, 0.0f, 1.0f);
            }
        } else {
            up.set(0.0f, 1.0f, 0.0f);
        }
        Vector3f left = up.cross((Vector3fc)forward, new Vector3f());
        left.normalize();
        up = forward.cross((Vector3fc)left, new Vector3f());
        this.setColumn(0, left);
        this.setColumn(1, up);
        this.setColumn(2, forward);
        return this;
    }

    public Vector3f mul(Vector3f rhs) {
        return new Vector3f(this.m00() * rhs.x + this.m10() * rhs.y + this.m20() * rhs.z + this.m30(), this.m01() * rhs.x + this.m11() * rhs.y + this.m21() * rhs.z + this.m31(), this.m02() * rhs.x + this.m12() * rhs.y + this.m22() * rhs.z + this.m32());
    }

    public Matrix4f translate(float x, float y, float z) {
        this.m00(this.m00() + this.m03() * x);
        this.m10(this.m10() + this.m13() * x);
        this.m20(this.m20() + this.m23() * x);
        this.m30(this.m30() + this.m33() * x);
        this.m01(this.m01() + this.m03() * y);
        this.m11(this.m11() + this.m13() * y);
        this.m21(this.m21() + this.m23() * y);
        this.m31(this.m31() + this.m33() * y);
        this.m02(this.m02() + this.m03() * z);
        this.m12(this.m12() + this.m13() * z);
        this.m22(this.m22() + this.m23() * z);
        this.m32(this.m32() + this.m33() * z);
        return this;
    }

    public Matrix4f translate(Vector3f offset) {
        return this.translate(offset.x, offset.y, offset.z);
    }
}

