/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.pipe;

import java.util.Vector;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.jogl.pipe.Line;
import org.meteoinfo.chart.jogl.pipe.Matrix4f;
import org.meteoinfo.chart.jogl.pipe.Plane;

public class Pipe {
    private Vector<Vector3f> path;
    private Vector<Vector3f> contour;
    private Vector<Vector<Vector3f>> contours;
    private Vector<Vector<Vector3f>> normals;

    public Pipe() {
    }

    public Pipe(Vector<Vector3f> pathPoints, Vector<Vector3f> contourPoints) {
        this.path = pathPoints;
        this.contour = contourPoints;
        this.generateContours();
    }

    public Pipe(Vector<Vector3f> pathPoint, float radius, int steps) {
        this.path = pathPoint;
        this.contour = new Vector();
        for (int i = 0; i <= steps; ++i) {
            float a = (float)(Math.PI * 2 / (double)steps * (double)i);
            float x = (float)((double)radius * Math.cos(a));
            float y = (float)((double)radius * Math.sin(a));
            this.contour.add(new Vector3f(x, y, 0.0f));
        }
        this.generateContours();
    }

    public Vector<Vector3f> getPath() {
        return this.path;
    }

    public void setPath(Vector<Vector3f> pathPoints) {
        this.path = pathPoints;
        this.generateContours();
    }

    public Vector<Vector3f> getContour() {
        return this.contour;
    }

    public Vector<Vector3f> getContour(int idx) {
        return this.contours.get(idx);
    }

    public void setContour(Vector<Vector3f> contourPoints) {
        this.contour = contourPoints;
        this.generateContours();
    }

    public int getPathCount() {
        return this.path.size();
    }

    public int getContourCount() {
        return this.contours.size();
    }

    public Vector<Vector3f> getNormal(int idx) {
        return this.normals.get(idx);
    }

    public void addPathPoint(Vector3f point) {
        this.path.add(point);
        int count = this.path.size();
        if (count == 1) {
            this.transformFirstContour();
            this.normals.add(this.computeContourNormal(0));
        } else if (count == 2) {
            this.contours.add(this.projectContour(0, 1));
            this.normals.add(this.computeContourNormal(1));
        } else {
            Vector dummy = new Vector();
            this.contours.add(dummy);
            this.normals.add(dummy);
            this.contours.set(count - 2, this.projectContour(count - 3, count - 2));
            this.normals.set(count - 2, this.computeContourNormal(count - 2));
            this.contours.set(count - 1, this.projectContour(count - 2, count - 1));
            this.normals.set(count - 1, this.computeContourNormal(count - 1));
        }
    }

    void generateContours() {
        this.contours = new Vector();
        this.normals = new Vector();
        if (this.path.size() < 1) {
            return;
        }
        this.transformFirstContour();
        this.contours.add(this.contour);
        this.normals.add(this.computeContourNormal(0));
        int count = this.path.size();
        for (int i = 1; i < count; ++i) {
            this.contours.add(this.projectContour(i - 1, i));
            this.normals.add(this.computeContourNormal(i));
        }
    }

    void transformFirstContour() {
        int pathCount = this.path.size();
        int vertexCount = this.contour.size();
        Matrix4f matrix = new Matrix4f();
        if (pathCount > 0) {
            if (pathCount > 1) {
                matrix.lookAt(this.path.get(1).sub((Vector3fc)this.path.get(0), new Vector3f()));
            }
            matrix.translate(this.path.get(0));
            for (int i = 0; i < vertexCount; ++i) {
                this.contour.set(i, matrix.mul(this.contour.get(i)));
            }
        }
    }

    Vector<Vector3f> projectContour(int fromIndex, int toIndex) {
        Line line = new Line();
        Vector3f dir1 = this.path.get(toIndex).sub((Vector3fc)this.path.get(fromIndex), new Vector3f());
        Vector3f dir2 = toIndex == this.path.size() - 1 ? dir1 : this.path.get(toIndex + 1).sub((Vector3fc)this.path.get(toIndex), new Vector3f());
        Vector3f normal = dir1.add((Vector3fc)dir2, new Vector3f());
        Plane plane = new Plane(normal, this.path.get(toIndex));
        Vector<Vector3f> fromContour = this.contours.get(fromIndex);
        Vector<Vector3f> toContour = new Vector<Vector3f>();
        int count = fromContour.size();
        for (int i = 0; i < count; ++i) {
            line.set(dir1, fromContour.get(i));
            toContour.add(plane.intersect(line));
        }
        return toContour;
    }

    Vector<Vector3f> computeContourNormal(int pathIndex) {
        Vector<Vector3f> contour = this.contours.get(pathIndex);
        Vector3f center = this.path.get(pathIndex);
        Vector<Vector3f> contourNormal = new Vector<Vector3f>();
        for (int i = 0; i < contour.size(); ++i) {
            Vector3f normal = contour.get(i).sub((Vector3fc)center, new Vector3f()).normalize();
            contourNormal.add(normal);
        }
        return contourNormal;
    }
}

