/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.tessellator;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.jogl.Triangle;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonZ;

public class TriangleTessellator {
    private final GLU glu = new GLU();
    private final GLUtessellator tobj;
    private final TessellationCallback tessCallback;
    private TesselationException err;
    private boolean done;
    private TessellatorListener listener;

    public TriangleTessellator() {
        TriangleTessellator triangleTessellator = this;
        this.tobj = triangleTessellator.glu.gluNewTess();
        this.tessCallback = new TessellationCallback();
        this.done = false;
    }

    public List<Triangle> getTriangles(PolygonZ polygon) throws TesselationException {
        this.makeTriangles(polygon);
        try {
            while (!this.done) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.err == null) {
            return this.tessCallback.triangles;
        }
        throw this.err;
    }

    public void getTriangles(PolygonZ polygon, TessellatorListener listener) {
        this.listener = listener;
        this.makeTriangles(polygon);
    }

    private void makeTriangles(PolygonZ polygon) {
        double[] v;
        PointZ p;
        int i;
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100100, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100101, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100102, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100103, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessBeginPolygon((GLUtessellator)this.tobj, null);
        GLU.gluTessBeginContour((GLUtessellator)this.tobj);
        for (i = 0; i < polygon.getOutLine().size() - 1; ++i) {
            p = (PointZ)polygon.getOutLine().get(i);
            v = p.toArray();
            GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])v, (int)0, (Object)v);
        }
        GLU.gluTessEndContour((GLUtessellator)this.tobj);
        if (polygon.hasHole()) {
            for (i = 0; i < polygon.getHoleLineNumber(); ++i) {
                GLU.gluTessBeginContour((GLUtessellator)this.tobj);
                for (int j = 0; j < polygon.getHoleLine(i).size() - 1; ++j) {
                    p = (PointZ)polygon.getHoleLine(i).get(j);
                    v = p.toArray();
                    GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])v, (int)0, (Object)v);
                }
                GLU.gluTessEndContour((GLUtessellator)this.tobj);
            }
        }
        GLU.gluTessEndPolygon((GLUtessellator)this.tobj);
        GLU.gluDeleteTess((GLUtessellator)this.tobj);
    }

    protected void sendSuccess() {
        this.done = true;
        this.err = null;
        if (this.listener != null) {
            this.listener.onTesselationDone(this.tessCallback.triangles);
        }
    }

    protected void sendError(String message) {
        this.done = true;
        this.err = new TesselationException(message);
        if (this.listener != null) {
            this.listener.onTesselationError(this.err);
        }
    }

    class TessellationCallback
    extends GLUtessellatorCallbackAdapter {
        protected List<Triangle> triangles = new ArrayList<Triangle>();
        private PointZ p1;
        private PointZ p2;
        private PointZ p3;
        private int geometricPrimitiveType;

        TessellationCallback() {
        }

        public void begin(int type) {
            this.geometricPrimitiveType = type;
        }

        public void end() {
            TriangleTessellator.this.sendSuccess();
        }

        public void vertex(Object vertexData) {
            PointZ thisPoint = new PointZ((double[])vertexData);
            switch (this.geometricPrimitiveType) {
                case 6: {
                    if (this.p1 == null) {
                        this.p1 = thisPoint;
                        break;
                    }
                    if (this.p2 == null) {
                        this.p2 = thisPoint;
                        break;
                    }
                    this.triangles.add(new Triangle(this.p1, this.p2, thisPoint));
                    this.p2 = thisPoint;
                    break;
                }
                case 5: {
                    if (this.p3 == null) {
                        this.p3 = thisPoint;
                        break;
                    }
                    this.p1 = this.p2;
                    this.p2 = this.p3;
                    this.p3 = thisPoint;
                    if (this.p1 == null) break;
                    this.triangles.add(new Triangle(this.p1, this.p2, this.p3));
                    break;
                }
                default: {
                    TriangleTessellator.this.sendError("Geometric Primitive Type #" + this.geometricPrimitiveType + " not implemented. See http://www.glprogramming.com/red/chapter02.html#name2 for more.");
                }
            }
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            TriangleTessellator.this.sendError("Self-intersecting polygons not supported");
        }

        public void error(int errnum) {
            TriangleTessellator.this.sendError("Opengl error: " + TriangleTessellator.this.glu.gluErrorString(errnum));
        }
    }

    public class TesselationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TesselationException(String message) {
            super(message);
        }
    }

    public static interface TessellatorListener {
        public void onTesselationDone(List<Triangle> var1);

        public void onTesselationError(TesselationException var1);
    }
}

