/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.ChartNorthArrow;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.ChartScaleBar;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.LonLatAxis;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.geo.drawing.Draw;
import org.meteoinfo.geo.layer.LayerCollection;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.legend.MapFrame;
import org.meteoinfo.geo.mapview.MapView;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapPlot
extends AbstractPlot2D
implements IWebMapPanel {
    private MapFrame mapFrame;
    private MapView mapView;
    private boolean antialias = false;
    private MapLayer selectedLayer;
    private final TileLoadListener tileLoadListener = new TileLoadListener((IWebMapPanel)this);
    private ChartPanel parent;
    private float[] lonLim;
    private float[] latLim;
    private Graphic boundary;
    private ChartScaleBar scaleBar;
    private ChartNorthArrow northArrow;
    private boolean degreeSpace = false;

    public MapPlot() {
        this.aspectType = AspectType.EQUAL;
        try {
            this.setXAxis(new LonLatAxis("Longitude", true));
            this.setYAxis(new LonLatAxis("Latitude", false));
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(MapPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getAxis(Location.TOP).setDrawTickLabel(false);
        this.getAxis(Location.RIGHT).setDrawTickLabel(false);
        this.setDrawNeatLine(true);
        this.getGridLine().setTop(true);
    }

    public MapPlot(MapView mapView) {
        this();
        this.setMapView(mapView, true);
        this.mapFrame = new MapFrame();
        this.mapFrame.setMapView(mapView);
    }

    public MapPlot(MapFrame mapFrame) {
        this();
        this.mapFrame = mapFrame;
        this.setMapView(mapFrame.getMapView(), true);
    }

    public void setParent(ChartPanel value) {
        this.parent = value;
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void setMapView(MapView value, boolean isGeoMap) {
        this.mapView = value;
        this.mapView.setGeoMap(isGeoMap);
        this.mapView.setMultiGlobalDraw(isGeoMap);
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
        PolygonShape bvs = this.mapView.getProjection().getProjInfo().getBoundary();
        if (bvs != null) {
            this.setBoundary(bvs);
        }
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XY2D;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    @Override
    public Color getBackground() {
        return this.mapView.getBackground();
    }

    @Override
    public void setBackground(Color value) {
        this.mapView.setBackground(value);
    }

    public MapFrame getMapFrame() {
        return this.mapFrame;
    }

    public void setMapFrame(MapFrame value) {
        this.mapFrame = value;
        this.setMapView(this.mapFrame.getMapView(), true);
    }

    public ProjectionInfo getProjInfo() {
        return this.getMapView().getProjection().getProjInfo();
    }

    public void setProjInfo(ProjectionInfo proj) {
        this.getMapView().getProjection().setProjInfo(proj);
        if (proj.getBoundary() != null) {
            this.setBoundary(proj.getBoundary());
        }
    }

    public boolean isLonLatMap() {
        return this.getMapView().getProjection().isLonLatMap();
    }

    public MapLayer getSelectedLayer() {
        if (this.selectedLayer != null) {
            return this.selectedLayer;
        }
        if (this.mapView.getLastAddedLayer() != null) {
            return this.mapView.getLastAddedLayer();
        }
        return null;
    }

    public void setSelectedLayer(MapLayer value) {
        this.selectedLayer = value;
    }

    public float[] getLonLim() {
        return this.lonLim;
    }

    public void setLonLim(float[] value) {
        this.lonLim = value;
    }

    public void setLonLim(float lon1, float lon2) {
        this.lonLim = new float[]{lon1, lon2};
    }

    public float[] getLatLim() {
        return this.latLim;
    }

    public void setLatLim(float[] value) {
        this.latLim = value;
    }

    public void setLatLim(float lat1, float lat2) {
        this.latLim = new float[]{lat1, lat2};
    }

    public Graphic getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Graphic value) {
        this.boundary = value;
    }

    public void setBoundary(PolygonShape value) {
        PolygonBreak pb = new PolygonBreak();
        pb.setOutlineSize(1.5f);
        pb.setDrawFill(false);
        this.boundary = new Graphic((Shape)value, (ColorBreak)pb);
    }

    public void setBoundaryProp(PolygonBreak pb) {
        if (this.boundary != null) {
            this.boundary = new Graphic(this.boundary.getShape(), (ColorBreak)pb);
        }
    }

    public ChartScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public void setScaleBar(ChartScaleBar value) {
        this.scaleBar = value;
    }

    public ChartNorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public void setNorthArrow(ChartNorthArrow value) {
        this.northArrow = value;
    }

    public boolean isDegreeSpace() {
        return this.degreeSpace;
    }

    public void setDegreeSpace(boolean value) {
        this.degreeSpace = value;
    }

    public boolean hasWebMapLayer() {
        return this.mapView.hasWebMapLayer();
    }

    public int getWebMapZoom() {
        return this.mapView.getWebMapZoom();
    }

    public void reDraw() {
        if (this.parent != null) {
            this.parent.paintGraphics();
        }
    }

    @Override
    public void draw(Graphics2D g, Rectangle2D area) {
        float y;
        float x;
        super.draw(g, area);
        if (this.scaleBar != null) {
            x = (float)(area.getWidth() * (double)this.scaleBar.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.scaleBar.getY()));
            this.scaleBar.draw(g, x, y);
        }
        if (this.northArrow != null) {
            x = (float)(area.getWidth() * (double)this.northArrow.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.northArrow.getY()));
            this.northArrow.draw(g, x, y);
        }
    }

    @Override
    void drawGraph(Graphics2D g, Rectangle2D area) {
        PolygonBreak pb;
        this.mapView.setAntiAlias(this.antialias);
        this.mapView.setViewExtent((Extent)this.getDrawExtent().clone());
        if (this.boundary != null && (pb = (PolygonBreak)this.boundary.getLegend().clone()).isDrawFill()) {
            pb.setDrawOutline(false);
            this.mapView.drawGraphic(g, new Graphic(this.boundary.getShape(), (ColorBreak)pb), area.getBounds());
        }
        this.mapView.paintGraphics(g, area, this.tileLoadListener);
        if (this.boundary != null) {
            pb = (PolygonBreak)this.boundary.getLegend().clone();
            pb.setDrawFill(false);
            this.mapView.drawGraphic(g, new Graphic(this.boundary.getShape(), (ColorBreak)pb), area.getBounds());
        }
    }

    @Override
    public Extent getAutoExtent() {
        return this.mapView.getLayersWholeExtent();
    }

    @Override
    public void setAutoExtent() {
    }

    @Override
    public void updateLegendScheme() {
    }

    public void addGraphic(Graphic graphic) {
        this.getMapView().addGraphic(graphic);
    }

    public void addGraphics(GraphicCollection graphics) {
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            this.getMapView().addGraphic(graphics.getGraphicN(i));
        }
    }

    public Graphic addGraphic(Graphic graphic, ProjectionInfo proj) {
        ProjectionInfo toProj = this.getMapView().getProjection().getProjInfo();
        if (proj.equals(toProj)) {
            this.getMapView().addGraphic(graphic);
            return graphic;
        }
        Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphic, (ProjectionInfo)proj, (ProjectionInfo)toProj);
        this.getMapView().addGraphic(nGraphic);
        return nGraphic;
    }

    public GraphicCollection addGraphics(GraphicCollection graphics, ProjectionInfo proj) {
        ProjectionInfo toProj = this.getMapView().getProjection().getProjInfo();
        if (proj.equals(toProj)) {
            for (int i = 0; i < graphics.getNumGraphics(); ++i) {
                this.getMapView().addGraphic(graphics.getGraphicN(i));
            }
            return graphics;
        }
        GraphicCollection nGraphics = new GraphicCollection();
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphics.getGraphicN(i), (ProjectionInfo)proj, (ProjectionInfo)toProj);
            nGraphics.add(nGraphic);
            this.getMapView().addGraphic(nGraphic);
        }
        return nGraphics;
    }

    public void addLayer(MapLayer layer) {
        this.mapView.addLayer(layer);
        this.setDrawExtent(layer.getExtent());
    }

    public void addLayer(int idx, MapLayer layer) {
        this.mapView.addLayer(idx, layer);
        this.setDrawExtent(layer.getExtent());
    }

    public void removeLastLayer() {
        this.mapView.removeLayer(this.mapView.getLastAddedLayer());
    }

    @Override
    public void setAxisOn(boolean value) {
        super.setAxisOn(value);
        this.mapFrame.setDrawGridTickLine(value);
        this.mapFrame.setDrawGridLabel(value);
    }

    public Extent getFullExtent() {
        Extent ext = this.mapView.getExtent();
        if (this.boundary != null) {
            ext = ext.union(this.boundary.getExtent().extend(0.01));
        }
        return ext;
    }

    public void setLonLatExtent(Extent extent) {
        if (this.getMapView().getProjection().isLonLatMap()) {
            super.setDrawExtent(extent);
        } else {
            this.getMapView().zoomToExtentLonLatEx(extent);
            super.setDrawExtent1(this.getMapView().getViewExtent());
            this.setAxisExtent(extent);
        }
    }

    public void setAxisExtent(Extent extent) {
        this.getAxis(Location.BOTTOM).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.TOP).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.LEFT).setMinMaxValue(extent.minY, extent.maxY);
        this.getAxis(Location.RIGHT).setMinMaxValue(extent.minY, extent.maxY);
    }

    @Override
    public void addText(ChartText text) {
        this.addText(text, true);
    }

    public void addText(ChartText text, boolean isLonLat) {
        if (isLonLat && !this.getMapView().getProjection().isLonLatMap()) {
            PointD xyp = Reproject.reprojectPoint((double)text.getX(), (double)text.getY(), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
            text.setX(xyp.X);
            text.setY(xyp.Y);
        }
        super.addText(text);
    }

    public void addPoint(double lat, double lon, PointBreak pb) {
        PointShape ps = new PointShape();
        PointD lonlatp = new PointD(lon, lat);
        if (this.getMapView().getProjection().isLonLatMap()) {
            ps.setPoint(lonlatp);
        } else {
            PointD xyp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
            ps.setPoint(xyp);
        }
        Graphic aGraphic = new Graphic((Shape)ps, (ColorBreak)pb);
        this.getMapView().addGraphic(aGraphic);
    }

    public Graphic addPoint(List<Number> lat, List<Number> lon, PointBreak pb) {
        int i = 0;
        if (i < lat.size()) {
            PointShape ps = new PointShape();
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            PointD lonlatp = new PointD(x, y);
            if (this.getMapView().getProjection().isLonLatMap()) {
                ps.setPoint(lonlatp);
            } else {
                PointD xyp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
                ps.setPoint(xyp);
            }
            Graphic aGraphic = new Graphic((Shape)ps, (ColorBreak)pb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic((Shape)pls, (ColorBreak)plb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic((Shape)pls, (ColorBreak)plb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb, boolean iscurve) {
        Object pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic((Shape)pls, (ColorBreak)plb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = iscurve ? new CurveLineShape() : new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic((Shape)pls, (ColorBreak)plb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolygon(List<Number> lat, List<Number> lon, PolygonBreak pgb) {
        PolygonShape pgs;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() > 2) {
                    pgs = new PolygonShape();
                    pgs.setPoints(points);
                    Graphic aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint((PointD)lonlatp, (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() > 2) {
            pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic aGraphic = new Graphic((Shape)pgs, (ColorBreak)pgb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addCircle(float x, float y, float radius, PolygonBreak pgb) {
        CircleShape aPGS = ShapeUtil.createCircleShape((float)x, (float)y, (float)radius);
        Graphic graphic = new Graphic((Shape)aPGS, (ColorBreak)pgb);
        this.mapView.addGraphic(graphic);
        return graphic;
    }

    @Override
    public Rectangle2D getPositionArea(Rectangle2D area) {
        Rectangle2D plotArea = super.getPositionArea(area);
        if (this.aspectType != AspectType.AUTO) {
            MapView mv = this.mapFrame.getMapView();
            mv.setViewExtent((Extent)this.getDrawExtent().clone());
            Extent extent = mv.getViewExtent();
            double width = extent.getWidth();
            double height = extent.getHeight();
            double scaleFactor = mv.getXYScaleFactor();
            if (width / height / scaleFactor > plotArea.getWidth() / plotArea.getHeight()) {
                double h = plotArea.getWidth() * height * scaleFactor / width;
                double delta = plotArea.getHeight() - h;
                plotArea.setRect(plotArea.getX(), plotArea.getY() + delta / 2.0, plotArea.getWidth(), h);
            } else {
                double w = width * plotArea.getHeight() / height / scaleFactor;
                double delta = plotArea.getWidth() - w;
                plotArea.setRect(plotArea.getX() + delta / 2.0, plotArea.getY(), w, plotArea.getHeight());
            }
        }
        return plotArea;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    void drawAxis(Graphics2D g, Rectangle2D area) {
        block37: {
            if (this.mapFrame.getMapView().getProjection().isLonLatMap()) {
                super.drawAxis(g, area);
                return;
            }
            if (!this.mapFrame.isDrawGridLabel()) break block37;
            shift = 5.0f;
            extentList = new ArrayList<Extent>();
            maxExtent = new Extent();
            g.setColor(this.mapFrame.getGridLineColor());
            g.setStroke(new BasicStroke(this.mapFrame.getGridLineSize()));
            sP = new PointF(0.0f, 0.0f);
            eP = new PointF(0.0f, 0.0f);
            font = this.getXAxis().getTickLabelFont();
            g.setFont(font);
            len = this.mapFrame.getTickLineLength();
            space = len + this.mapFrame.getGridLabelShift();
            if (this.mapFrame.isInsideTickLine()) {
                space = this.mapFrame.getGridLabelShift();
            }
            block24: for (i = 0; i < this.mapFrame.getMapView().getGridLabels().size(); ++i) {
                aGL = (GridLabel)this.mapFrame.getMapView().getGridLabels().get(i);
                switch (1.$SwitchMap$org$meteoinfo$geo$legend$GridLabelPosition[this.mapFrame.getGridLabelPosition().ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 2: {
                                continue block24;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 3: {
                                continue block24;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 2: 
                            case 4: {
                                continue block24;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 4: {
                        switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                            case 3: 
                            case 4: {
                                continue block24;
                            }
                        }
                    }
lbl40:
                    // 5 sources

                    default: {
                        labX = (float)aGL.getLabPoint().X;
                        labY = (float)aGL.getLabPoint().Y;
                        sP.X = labX += (float)area.getX();
                        sP.Y = labY += (float)area.getY();
                        drawStr = aGL.getLabString();
                        drawStr = drawStr.endsWith("E") || drawStr.endsWith("W") || drawStr.endsWith("N") || drawStr.endsWith("S") ? (this.degreeSpace ? drawStr.substring(0, drawStr.length() - 1) + String.valueOf('\u00ba') + " " + drawStr.substring(drawStr.length() - 1) : drawStr.substring(0, drawStr.length() - 1) + String.valueOf('\u00ba') + drawStr.substring(drawStr.length() - 1)) : drawStr + String.valueOf('\u00ba');
                        aSF = Draw.getStringDimension((String)drawStr, (Graphics2D)g);
                        ifDraw = true;
                        aExtent = new Extent();
                        aExtent.minX = labX;
                        aExtent.maxX = labX + (float)aSF.width;
                        aExtent.minY = labY - (float)aSF.height;
                        aExtent.maxY = labY;
                        if (extentList.isEmpty()) {
                            maxExtent = (Extent)aExtent.clone();
                            extentList.add((Extent)aExtent.clone());
                        } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                            extentList.add((Extent)aExtent.clone());
                            maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                        } else {
                            for (j = 0; j < extentList.size(); ++j) {
                                if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(j))).booleanValue()) continue;
                                ifDraw = false;
                                break;
                            }
                            if (ifDraw) {
                                extentList.add(aExtent);
                                maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                            }
                        }
                        if (!ifDraw) continue block24;
                        if (aGL.isBorder()) {
                            switch (1.$SwitchMap$org$meteoinfo$common$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: {
                                    labX -= (float)(aSF.width / 2);
                                    labY = labY + (float)(aSF.height * 3 / 4) + (float)space;
                                    eP.X = sP.X;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y - (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y + (float)len;
                                    break;
                                }
                                case 4: {
                                    labX = labX - (float)aSF.width - (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.X = sP.X + (float)len;
                                        break;
                                    }
                                    eP.X = sP.X - (float)len;
                                    break;
                                }
                                case 2: {
                                    labX -= (float)(aSF.width / 2);
                                    labY -= (float)space;
                                    eP.X = sP.X;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y + (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y - (float)len;
                                    break;
                                }
                                case 1: {
                                    labX += (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    eP.X = this.mapFrame.isInsideTickLine() != false ? sP.X - (float)len : sP.X + (float)len;
                                }
                            }
                            g.setColor(this.mapFrame.getGridLineColor());
                            g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                            g.setColor(this.getXAxis().getTickLabelColor());
                            g.drawString(drawStr, labX, labY);
                            continue block24;
                        }
                        g.setColor(this.getXAxis().getTickLabelColor());
                        objs = this.getProjInfo().checkGridLabel(aGL, 5.0f);
                        xShift = ((Float)objs[0]).floatValue();
                        yShift = ((Float)objs[1]).floatValue();
                        xAlign = (XAlign)objs[2];
                        yAlign = (YAlign)objs[3];
                        Draw.drawString((Graphics2D)g, (float)(labX + xShift), (float)(labY + yShift), (String)drawStr, (XAlign)xAlign, (YAlign)yAlign, (boolean)false);
                    }
                }
            }
        }
    }

    @Override
    int getXAxisHeight(Graphics2D g) {
        if (this.isLonLatMap()) {
            return super.getXAxisHeight(g);
        }
        int space = 4;
        if (this.mapFrame.isDrawGridLabel()) {
            int height = space;
            height += this.mapFrame.getTickLineLength() + this.mapFrame.getGridLabelShift();
            FontMetrics m = g.getFontMetrics(this.mapFrame.getGridFont());
            return height += m.getHeight();
        }
        return 0;
    }

    @Override
    int getYAxisWidth(Graphics2D g) {
        if (this.isLonLatMap()) {
            return super.getYAxisWidth(g);
        }
        int space = 4;
        if (this.mapFrame.isDrawGridLabel()) {
            int width = space;
            width += this.mapFrame.getTickLineLength() + this.mapFrame.getGridLabelShift();
            FontMetrics m = g.getFontMetrics(this.mapFrame.getGridFont());
            List labels = this.mapFrame.getMapView().getGridLabels();
            int labWidth = 0;
            for (int i = 0; i < labels.size(); ++i) {
                int w = m.stringWidth(((GridLabel)labels.get(i)).getLabString());
                if (w <= labWidth) continue;
                labWidth = w;
            }
            return width += labWidth;
        }
        return 0;
    }

    public int getLayerNum() {
        return this.mapView.getLayerNum();
    }

    public LayerCollection getLayers() {
        return this.mapView.getLayers();
    }

    public MapLayer getLayer(int i) {
        return (MapLayer)this.mapView.getLayers().get(i);
    }

    public MapLayer getLayer(String name) {
        return this.mapView.getLayer(name);
    }

    public LegendScheme getLegendScheme() {
        MapLayer layer = this.mapView.getLastAddedLayer();
        return layer == null ? null : layer.getLegendScheme();
    }

    public void loadMIProjectFile(String fn, int mfidx) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(fn);
        String userDir = System.getProperty("user.dir");
        System.setProperty("user.dir", file.getParent());
        String pPath = file.getParent();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(fn));
        Element root = doc.getDocumentElement();
        Element mapFrames = (Element)root.getElementsByTagName("MapFrames").item(0);
        if (mapFrames == null) {
            this.mapFrame.importProjectXML(pPath, root);
        } else {
            NodeList mfNodes = mapFrames.getElementsByTagName("MapFrame");
            Node mfNode = mfNodes.item(mfidx);
            this.mapFrame.importProjectXML(pPath, (Element)mfNode);
        }
        this.setDrawExtent(this.mapView.getViewExtent());
        this.setExtent(this.mapView.getViewExtent());
        System.setProperty("user.dir", userDir);
    }

    public void loadMIProjectFile(String fn) throws SAXException, IOException, ParserConfigurationException {
        this.loadMIProjectFile(fn, 0);
    }
}

