/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.LogAxis;
import org.meteoinfo.chart.axis.TimeAxis;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.shape.PolylineErrorShape;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.geo.drawing.Draw;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.ImageGraphic;
import org.meteoinfo.geometry.legend.ArrowBreak;
import org.meteoinfo.geometry.legend.BarBreak;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.HatchStyle;
import org.meteoinfo.geometry.legend.LabelBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ArcShape;
import org.meteoinfo.geometry.shape.BarShape;
import org.meteoinfo.geometry.shape.CapPolylineShape;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.EllipseShape;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.RectangleShape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindBarb;

public class Plot2D
extends AbstractPlot2D {
    private GraphicCollection graphics = new GraphicCollection();
    private float barsWidth = 0.8f;

    public GraphicCollection getGraphics() {
        return this.graphics;
    }

    public int getGraphicNumber() {
        return this.graphics.size();
    }

    public void setGraphics(GraphicCollection value) {
        this.graphics = value;
    }

    public float getBarsWidth() {
        return this.barsWidth;
    }

    public void setBarsWidth(float value) {
        this.barsWidth = value;
    }

    public void addGraphic(Graphic g) {
        this.graphics.add(g);
    }

    public void addGraphic(int idx, Graphic g) {
        this.graphics.add(idx, g);
    }

    public void removeGraphic(Graphic g) {
        this.graphics.remove(g);
    }

    public void removeGraphic(int idx) {
        this.graphics.remove(idx);
    }

    public void removeLastGraphic() {
        this.graphics.remove(this.graphics.size() - 1);
    }

    public void addGraphics(List<Graphic> gs) {
        this.graphics.addAll(gs);
    }

    @Override
    void drawGraph(Graphics2D g, Rectangle2D area) {
        if (this.isPiePlot()) {
            this.plotPie(g, area);
        } else {
            this.plotGraphics(g, area);
        }
    }

    private boolean isPiePlot() {
        boolean isPie = false;
        int n = 0;
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            Graphic graphic = this.graphics.get(m).getGraphicN(0);
            ShapeTypes st = graphic.getShape().getShapeType();
            switch (st) {
                case ARC: {
                    isPie = true;
                    ++n;
                }
            }
        }
        return isPie;
    }

    void plotPie(Graphics2D g, Rectangle2D area) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(area.getX(), area.getY());
        if (this.background != null) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Double(0.0, 0.0, area.getWidth(), area.getHeight()));
        }
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            GraphicCollection gc;
            Graphic graphic = this.graphics.get(m);
            ColorBreak cb = graphic.getLegend();
            block12: for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                if (!graphic.isSingleLegend()) {
                    cb = gg.getLegend();
                }
                org.meteoinfo.geometry.shape.Shape shape = gg.getShape();
                switch (shape.getShapeType()) {
                    case POINT: 
                    case POINT_M: 
                    case POINT_Z: {
                        this.drawPoint(g, (PointShape)shape, (PointBreak)cb, area);
                        continue block12;
                    }
                    case TEXT: {
                        this.drawText((ChartText)shape, g, area);
                        continue block12;
                    }
                    case POLYLINE: 
                    case POLYLINE_Z: {
                        if (cb instanceof PointBreak) {
                            this.drawPolyline(g, (PolylineShape)shape, (PointBreak)cb, area);
                            continue block12;
                        }
                        this.drawPolyline(g, (PolylineShape)shape, (PolylineBreak)cb, area);
                        continue block12;
                    }
                    case POLYGON: 
                    case POLYGON_Z: {
                        for (Polygon poly : ((PolygonShape)shape).getPolygons()) {
                            this.drawPolygon(g, poly, (PolygonBreak)cb, false, area);
                        }
                        continue block12;
                    }
                    case RECTANGLE: {
                        this.drawRectangle(g, (RectangleShape)shape, (PolygonBreak)cb, false, area);
                        continue block12;
                    }
                    case ARC: {
                        this.drawArc(g, (ArcShape)shape, (PolygonBreak)cb, area);
                        continue block12;
                    }
                    case WIND_BARB: {
                        this.drawWindBarb(g, (WindBarb)shape, (PointBreak)cb, area);
                        continue block12;
                    }
                    case WIND_ARROW: {
                        this.drawWindArrow(g, (WindArrow)shape, (ArrowBreak)cb, area);
                        continue block12;
                    }
                    case IMAGE: {
                        this.drawImage(g, gg, area);
                    }
                }
            }
            if (!(graphic instanceof GraphicCollection) || !(gc = (GraphicCollection)graphic).getLabelSet().isDrawLabels()) continue;
            this.drawLabels(g, gc, area);
        }
        g.setTransform(oldMatrix);
    }

    void plotGraphics(Graphics2D g, Rectangle2D area) {
        AffineTransform oldMatrix = g.getTransform();
        Shape oldRegion = g.getClip();
        if (this.clip) {
            g.setClip(area);
        }
        g.translate(area.getX(), area.getY());
        int barIdx = 0;
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            GraphicCollection gc;
            Graphic graphic = this.graphics.get(m);
            ColorBreak cb = graphic.getLegend();
            ShapeTypes shapeType = graphic.getGraphicN(0).getShape().getShapeType();
            switch (shapeType) {
                case BAR: {
                    this.drawBars(g, (GraphicCollection)graphic, barIdx, area);
                    ++barIdx;
                }
            }
            block24: for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                if (!graphic.isSingleLegend()) {
                    cb = gg.getLegend();
                }
                org.meteoinfo.geometry.shape.Shape shape = gg.getShape();
                switch (shape.getShapeType()) {
                    case POINT: 
                    case POINT_M: 
                    case POINT_Z: {
                        this.drawPoint(g, (PointShape)shape, (PointBreak)cb, area);
                        continue block24;
                    }
                    case TEXT: {
                        this.drawText((ChartText)shape, g, area);
                        continue block24;
                    }
                    case POLYLINE: 
                    case POLYLINE_Z: {
                        if (shape instanceof CapPolylineShape) {
                            this.drawCapPolyline(g, (CapPolylineShape)shape, (PolylineBreak)cb, area);
                            continue block24;
                        }
                        switch (cb.getBreakType()) {
                            case POINT_BREAK: {
                                this.drawPolyline(g, (PolylineShape)shape, (PointBreak)cb, area);
                                break;
                            }
                            case POLYLINE_BREAK: {
                                this.drawPolyline(g, (PolylineShape)shape, (PolylineBreak)cb, area);
                                break;
                            }
                            case COLOR_BREAK_COLLECTION: {
                                this.drawPolyline(g, (PolylineShape)shape, (ColorBreakCollection)cb, area);
                            }
                        }
                        continue block24;
                    }
                    case CURVE_LINE: {
                        this.drawCurveline(g, (CurveLineShape)shape, (PolylineBreak)cb, area);
                        continue block24;
                    }
                    case POLYLINE_ERROR: {
                        if (cb instanceof PointBreak) {
                            this.drawPolylineError(g, (PolylineErrorShape)shape, (PointBreak)cb, area);
                            continue block24;
                        }
                        this.drawPolylineError(g, (PolylineErrorShape)shape, (PolylineBreak)cb, area);
                        continue block24;
                    }
                    case POLYGON: 
                    case POLYGON_Z: {
                        for (Polygon poly : ((PolygonShape)shape).getPolygons()) {
                            this.drawPolygon(g, poly, (PolygonBreak)cb, false, area);
                        }
                        continue block24;
                    }
                    case RECTANGLE: {
                        this.drawRectangle(g, (RectangleShape)shape, (PolygonBreak)cb, false, area);
                        continue block24;
                    }
                    case CIRCLE: {
                        this.drawCircle(g, (CircleShape)shape, (PolygonBreak)cb, false, area);
                        continue block24;
                    }
                    case ELLIPSE: {
                        this.drawEllipse(g, (EllipseShape)shape, (PolygonBreak)cb, false, area);
                        continue block24;
                    }
                    case ARC: {
                        this.drawArc(g, (ArcShape)shape, (PolygonBreak)cb, area);
                        continue block24;
                    }
                    case WIND_BARB: {
                        this.drawWindBarb(g, (WindBarb)shape, (PointBreak)cb, area);
                        continue block24;
                    }
                    case WIND_ARROW: {
                        this.drawWindArrow(g, (WindArrow)shape, (ArrowBreak)cb, area);
                        continue block24;
                    }
                    case IMAGE: {
                        this.drawImage(g, gg, area);
                    }
                }
            }
            if (!(graphic instanceof GraphicCollection) || !(gc = (GraphicCollection)graphic).getLabelSet().isDrawLabels()) continue;
            this.drawLabels(g, gc, area);
        }
        g.setTransform(oldMatrix);
        if (this.clip) {
            g.setClip(oldRegion);
        }
    }

    private void drawPoint(Graphics2D g, PointShape aPS, PointBreak aPB, Rectangle2D area) {
        PointD p = aPS.getPoint();
        double[] sXY = this.projToScreen(p.X, p.Y, area);
        PointF pf = new PointF((float)sXY[0], (float)sXY[1]);
        RenderingHints rend = g.getRenderingHints();
        boolean rc = false;
        if (this.symbolAntialias && rend.get(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_ON) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rc = true;
        }
        Draw.drawPoint((PointF)pf, (PointBreak)aPB, (Graphics2D)g);
        if (rc) {
            g.setRenderingHints(rend);
        }
    }

    void drawText(ChartText text, Graphics2D g, Rectangle2D area) {
        switch (text.getCoordinates()) {
            case AXES: {
                float x = (float)(area.getWidth() * text.getX());
                float y = (float)(area.getHeight() * (1.0 - text.getY()));
                this.drawText(g, text, x, y);
                break;
            }
            case FIGURE: {
                float x = (float)(area.getWidth() * text.getX());
                float y = (float)(area.getHeight() * (1.0 - text.getY()));
                this.drawText(g, text, x, y);
                break;
            }
            case DATA: {
                double[] xy = this.projToScreen(text.getX(), text.getY(), area);
                float x = (float)xy[0];
                float y = (float)xy[1];
                this.drawText(g, text, x, y);
            }
        }
    }

    private void drawText(Graphics2D g, ChartText text, float x, float y) {
        g.setFont(text.getFont());
        g.setColor(text.getColor());
        switch (text.getYAlign()) {
            case TOP: {
                y += (float)g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case CENTER: {
                y += (float)(g.getFontMetrics(g.getFont()).getAscent() / 2);
            }
        }
        String s = text.getText();
        switch (text.getXAlign()) {
            case RIGHT: {
                x -= (float)g.getFontMetrics(g.getFont()).stringWidth(s);
                break;
            }
            case CENTER: {
                x -= (float)g.getFontMetrics(g.getFont()).stringWidth(s) * 0.5f;
            }
        }
        Draw.drawString((Graphics2D)g, (String)s, (float)x, (float)y, (boolean)text.isUseExternalFont());
    }

    private void drawWindBarb(Graphics2D g, WindBarb aPS, PointBreak aPB, Rectangle2D area) {
        PointD p = aPS.getPoint();
        double[] sXY = this.projToScreen(p.X, p.Y, area);
        PointF pf = new PointF((float)sXY[0], (float)sXY[1]);
        Draw.drawWindBarb((PointF)pf, (WindBarb)aPS, (PointBreak)aPB, (Graphics2D)g);
    }

    private void drawWindArrow(Graphics2D g, WindArrow aPS, ArrowBreak aPB, Rectangle2D area) {
        PointD p = aPS.getPoint();
        double[] sXY = this.projToScreen(p.X, p.Y, area);
        PointF pf = new PointF((float)sXY[0], (float)sXY[1]);
        float zoom = aPB.getSize() / 10.0f;
        Draw.drawArraw((PointF)pf, (WindArrow)aPS, (ArrowBreak)aPB, (Graphics2D)g, (double)zoom);
    }

    private void drawPolyline(Graphics2D g, PolylineShape aPLS, PointBreak aPB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                PointF p = new PointF((float)sXY[0], (float)sXY[1]);
                Draw.drawPoint((PointF)p, (PointBreak)aPB, (Graphics2D)g);
            }
        }
    }

    private void drawPolyline(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            PointF[] points = new PointF[aline.getPointList().size()];
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                points[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawPolyline((PointF[])points, (PolylineBreak)aPLB, (Graphics2D)g);
        }
    }

    private void drawPolyline(Graphics2D g, PolylineShape aPLS, ColorBreakCollection cpc, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            PointF[] points = new PointF[aline.getPointList().size()];
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                points[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawPolyline((PointF[])points, (ColorBreakCollection)cpc, (Graphics2D)g);
        }
    }

    private void drawCapPolyline(Graphics2D g, CapPolylineShape aPLS, PolylineBreak aPLB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            PointF[] ps;
            PointF[] points = new PointF[aline.getPointList().size()];
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                points[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawPolyline((PointF[])points, (PolylineBreak)aPLB, (Graphics2D)g);
            float capLen = aPLS.getCapLen();
            int idx = points.length - 1;
            if (aPLS.getCapAngle() == 0.0f) {
                ps = new PointF[]{new PointF(points[0].X - capLen / 2.0f, points[0].Y), new PointF(points[0].X + capLen / 2.0f, points[0].Y)};
                Draw.drawPolyline((PointF[])ps, (PolylineBreak)aPLB, (Graphics2D)g);
                ps = new PointF[]{new PointF(points[idx].X - capLen / 2.0f, points[idx].Y), new PointF(points[idx].X + capLen / 2.0f, points[idx].Y)};
                Draw.drawPolyline((PointF[])ps, (PolylineBreak)aPLB, (Graphics2D)g);
                continue;
            }
            ps = new PointF[]{new PointF(points[0].X, points[0].Y - capLen / 2.0f), new PointF(points[0].X, points[0].Y + capLen / 2.0f)};
            Draw.drawPolyline((PointF[])ps, (PolylineBreak)aPLB, (Graphics2D)g);
            ps = new PointF[]{new PointF(points[idx].X, points[idx].Y - capLen / 2.0f), new PointF(points[idx].X, points[idx].Y + capLen / 2.0f)};
            Draw.drawPolyline((PointF[])ps, (PolylineBreak)aPLB, (Graphics2D)g);
        }
    }

    private void drawCurveline(Graphics2D g, CurveLineShape aPLS, PolylineBreak aPLB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            PointF[] points = new PointF[aline.getPointList().size()];
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                points[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawCurveLine((PointF[])points, (PolylineBreak)aPLB, (Graphics2D)g);
        }
    }

    private void drawPolylineError(Graphics2D g, PolylineErrorShape aPLS, PointBreak aPB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            double elen = 6.0;
            g.setColor(aPB.getColor());
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                double error;
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                PointF p = new PointF((float)sXY[0], (float)sXY[1]);
                if (aPLS.getYerror() != null) {
                    error = aPLS.getYerror(i);
                    error = this.projYLength(error, area);
                    g.draw(new Line2D.Double(p.X, (double)p.Y - error, p.X, (double)p.Y + error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y - error, (double)p.X + elen * 0.5, (double)p.Y - error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y + error, (double)p.X + elen * 0.5, (double)p.Y + error));
                }
                if (aPLS.getXerror() != null) {
                    error = aPLS.getXerror(i);
                    error = this.projXLength(error, area);
                    g.draw(new Line2D.Double((double)p.X - error, p.Y, (double)p.X + error, p.Y));
                    g.draw(new Line2D.Double((double)p.X - error, (double)p.Y - elen * 0.5, (double)p.X - error, (double)p.Y + elen * 0.5));
                    g.draw(new Line2D.Double((double)p.X + error, (double)p.Y - elen * 0.5, (double)p.X + error, (double)p.Y + elen * 0.5));
                }
                Draw.drawPoint((PointF)p, (PointBreak)aPB, (Graphics2D)g);
            }
        }
    }

    private void drawPolylineError(Graphics2D g, PolylineErrorShape aPLS, PolylineBreak aPLB, Rectangle2D area) {
        for (Polyline aline : aPLS.getPolylines()) {
            PointF[] points = new PointF[aline.getPointList().size()];
            double elen = 6.0;
            g.setColor(aPLB.getColor());
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                double error;
                PointF p;
                PointD wPoint = (PointD)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                points[i] = p = new PointF((float)sXY[0], (float)sXY[1]);
                if (aPLS.getYerror() != null) {
                    error = aPLS.getYerror(i);
                    error = this.projYLength(error, area);
                    g.draw(new Line2D.Double(p.X, (double)p.Y - error, p.X, (double)p.Y + error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y - error, (double)p.X + elen * 0.5, (double)p.Y - error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y + error, (double)p.X + elen * 0.5, (double)p.Y + error));
                }
                if (aPLS.getXerror() == null) continue;
                error = aPLS.getXerror(i);
                error = this.projXLength(error, area);
                g.draw(new Line2D.Double((double)p.X - error, p.Y, (double)p.X + error, p.Y));
                g.draw(new Line2D.Double((double)p.X - error, (double)p.Y - elen * 0.5, (double)p.X - error, (double)p.Y + elen * 0.5));
                g.draw(new Line2D.Double((double)p.X + error, (double)p.Y - elen * 0.5, (double)p.X + error, (double)p.Y + elen * 0.5));
            }
            Draw.drawPolyline((PointF[])points, (PolylineBreak)aPLB, (Graphics2D)g);
        }
    }

    private void drawLabels(Graphics2D g, GraphicCollection graphics, Rectangle2D area) {
        Extent drawExtent;
        Extent lExtent = graphics.getExtent();
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)(drawExtent = this.getDrawExtent())).booleanValue()) {
            return;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        List LabelPoints = graphics.getLabelPoints();
        PointF aPoint = new PointF();
        for (int i = 0; i < LabelPoints.size(); ++i) {
            Graphic aLP = (Graphic)LabelPoints.get(i);
            PointShape aPS = (PointShape)aLP.getShape();
            LabelBreak aLB = (LabelBreak)aLP.getLegend();
            aPS.setVisible(true);
            String LabelStr = aLB.getText();
            aPoint.X = (float)aPS.getPoint().X;
            aPoint.Y = (float)aPS.getPoint().Y;
            Font drawFont = aLB.getFont();
            if ((double)aPoint.X < drawExtent.minX || (double)aPoint.X > drawExtent.maxX || (double)aPoint.Y < drawExtent.minY || (double)aPoint.Y > drawExtent.maxY) continue;
            double[] xy = this.projToScreen(aPoint.X, aPoint.Y, area);
            aPoint.X = (float)xy[0];
            aPoint.Y = (float)xy[1];
            FontMetrics metrics = g.getFontMetrics(drawFont);
            Dimension labSize = new Dimension(metrics.stringWidth(LabelStr), metrics.getHeight());
            switch (aLB.getAlignType()) {
                case CENTER: {
                    aPoint.X = (float)xy[0] - (float)(labSize.width / 2);
                    break;
                }
                case LEFT: {
                    aPoint.X = (float)xy[0] - (float)labSize.width;
                }
            }
            aPoint.Y += (float)(labSize.height / 2);
            aPoint.Y -= aLB.getYShift();
            aPoint.X += aLB.getXShift();
            AffineTransform tempTrans = g.getTransform();
            if (aLB.getAngle() != 0.0f) {
                AffineTransform myTrans = (AffineTransform)tempTrans.clone();
                myTrans.translate(aPoint.X, aPoint.Y);
                myTrans.rotate((double)aLB.getAngle() * Math.PI / 180.0);
                g.setTransform(myTrans);
                aPoint.X = 0.0f;
                aPoint.Y = 0.0f;
            }
            boolean ifDraw = true;
            Rectangle rect = this.getGraphicRectangle(g, aLP, area);
            Extent aExtent = new Extent();
            aExtent.minX = rect.x;
            aExtent.maxX = rect.x + rect.width;
            aExtent.minY = rect.y;
            aExtent.maxY = rect.y + rect.height;
            if (graphics.getLabelSet().isAvoidCollision()) {
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (int j = 0; j < extentList.size(); ++j) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(j))).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    } else {
                        aPS.setVisible(false);
                    }
                }
            }
            if (ifDraw) {
                if (graphics.getLabelSet().isDrawShadow()) {
                    g.setColor(graphics.getLabelSet().getShadowColor());
                    g.fill(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
                g.setFont(drawFont);
                g.setColor(aLP.getLegend().getColor());
                g.drawString(LabelStr, aPoint.X, aPoint.Y);
                if (aPS.isSelected()) {
                    float[] dashPattern = new float[]{2.0f, 1.0f};
                    g.setColor(Color.cyan);
                    g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
                    g.draw(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
            }
            if (aLB.getAngle() == 0.0f) continue;
            g.setTransform(tempTrans);
        }
    }

    public Rectangle getGraphicRectangle(Graphics2D g, Graphic aGraphic, Rectangle2D area) {
        Rectangle rect = new Rectangle();
        switch (aGraphic.getShape().getShapeType()) {
            case POINT: 
            case POINT_M: {
                PointShape aPS = (PointShape)aGraphic.getShape();
                double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, area);
                float aX = (float)sXY[0];
                float aY = (float)sXY[1];
                switch (aGraphic.getLegend().getBreakType()) {
                    case POINT_BREAK: {
                        PointBreak aPB = (PointBreak)aGraphic.getLegend();
                        int buffer = (int)aPB.getSize() + 2;
                        rect.x = (int)aX - buffer / 2;
                        rect.y = (int)aY - buffer / 2;
                        rect.width = buffer;
                        rect.height = buffer;
                        break;
                    }
                    case LABEL_BREAK: {
                        LabelBreak aLB = (LabelBreak)aGraphic.getLegend();
                        g.setFont(aLB.getFont());
                        Dimension labSize = Draw.getStringDimension((String)aLB.getText(), (Graphics2D)g);
                        switch (aLB.getAlignType()) {
                            case CENTER: {
                                aX -= (float)(labSize.width / 2);
                                break;
                            }
                            case LEFT: {
                                aX -= (float)labSize.width;
                            }
                        }
                        aY -= aLB.getYShift();
                        rect.x = (int)aX;
                        rect.y = (int)(aY -= (float)(labSize.height / 3));
                        rect.width = labSize.width;
                        rect.height = labSize.height;
                    }
                }
                break;
            }
            case POLYLINE: 
            case POLYGON: 
            case RECTANGLE: 
            case CURVE_LINE: 
            case CIRCLE: 
            case ELLIPSE: 
            case CURVE_POLYGON: {
                List newPList = aGraphic.getShape().getPoints();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointD wPoint : newPList) {
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                    float aX = (float)sXY[0];
                    float aY = (float)sXY[1];
                    points.add(new PointD((double)aX, (double)aY));
                }
                Extent aExtent = GeometryUtil.getPointsExtent(points);
                rect.x = (int)aExtent.minX;
                rect.y = (int)aExtent.minY;
                rect.width = (int)(aExtent.maxX - aExtent.minX);
                rect.height = (int)(aExtent.maxY - aExtent.minY);
            }
        }
        return rect;
    }

    private List<PointF> drawPolygon(Graphics2D g, Polygon aPG, PolygonBreak aPGB, boolean isSelected, Rectangle2D area) {
        double[] sXY;
        PointD wPoint;
        int len = aPG.getOutLine().size();
        GeneralPath path = new GeneralPath(0, len);
        ArrayList<PointF> rPoints = new ArrayList<PointF>();
        for (int i = 0; i < aPG.getOutLine().size(); ++i) {
            wPoint = (PointD)aPG.getOutLine().get(i);
            sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
            if (i == 0) {
                path.moveTo(sXY[0], sXY[1]);
            } else {
                path.lineTo(sXY[0], sXY[1]);
            }
            rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
        }
        if (aPG.hasHole()) {
            for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                List newPList = (List)aPG.getHoleLines().get(h);
                for (int j = 0; j < newPList.size(); ++j) {
                    wPoint = (PointD)newPList.get(j);
                    sXY = this.projToScreen(wPoint.X, wPoint.Y, area);
                    if (j == 0) {
                        path.moveTo(sXY[0], sXY[1]);
                        continue;
                    }
                    path.lineTo(sXY[0], sXY[1]);
                }
            }
        }
        path.closePath();
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this.getSelectedColor();
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage((HatchStyle)aPGB.getStyle(), (int)size, (Color)aPGB.getColor(), (Color)aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.setColor(aColor);
                g.fill(path);
            }
        } else if (isSelected) {
            g.setColor(this.getSelectedColor());
            g.fill(path);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(path);
        }
        return rPoints;
    }

    private void drawRectangle(Graphics2D g, RectangleShape rs, PolygonBreak aPGB, boolean isSelected, Rectangle2D area) {
        Extent extent = rs.getExtent();
        double[] sXY = this.projToScreen(extent.minX, extent.minY + extent.getHeight(), area);
        double x = sXY[0];
        double y = sXY[1];
        double width = this.projXLength(extent.getWidth(), area);
        double height = this.projYLength(extent.getHeight(), area);
        RectangularShape rshape = rs.isRound() ? new RoundRectangle2D.Double(x, y, width, height, width * rs.getRoundX(), height * rs.getRoundY()) : new Rectangle2D.Double(x, y, width, height);
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this.getSelectedColor();
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage((HatchStyle)aPGB.getStyle(), (int)size, (Color)aPGB.getColor(), (Color)aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(rshape);
            } else {
                g.setColor(aColor);
                g.fill(rshape);
            }
        } else if (isSelected) {
            g.setColor(this.getSelectedColor());
            g.fill(rshape);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(rshape);
        }
    }

    private void drawCircle(Graphics2D g, CircleShape rs, PolygonBreak aPGB, boolean isSelected, Rectangle2D area) {
        Extent extent = rs.getExtent();
        double[] sXY = this.projToScreen(extent.minX, extent.minY + extent.getHeight(), area);
        double x = sXY[0];
        double y = sXY[1];
        double width = this.projXLength(extent.getWidth(), area);
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, width, width);
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this.getSelectedColor();
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage((HatchStyle)aPGB.getStyle(), (int)size, (Color)aPGB.getColor(), (Color)aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(shape);
            } else {
                g.setColor(aColor);
                g.fill(shape);
            }
        } else if (isSelected) {
            g.setColor(this.getSelectedColor());
            g.fill(shape);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(shape);
        }
    }

    private void drawEllipse(Graphics2D g, EllipseShape rs, PolygonBreak aPGB, boolean isSelected, Rectangle2D area) {
        Extent extent = rs.getExtent();
        double[] sXY = this.projToScreen(extent.minX, extent.minY + extent.getHeight(), area);
        double x = sXY[0];
        double y = sXY[1];
        double width = this.projXLength(extent.getWidth(), area);
        double height = this.projYLength(extent.getHeight(), area);
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, width, height);
        AffineTransform atf = g.getTransform();
        if (rs.getAngle() != 0.0f) {
            AffineTransform newATF = (AffineTransform)atf.clone();
            newATF.translate(x + width / 2.0, y + height / 2.0);
            newATF.rotate(Math.toRadians(rs.getAngle()));
            g.setTransform(newATF);
            shape = new Ellipse2D.Double(-width * 0.5, -height * 0.5, width, height);
        }
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this.getSelectedColor();
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage((HatchStyle)aPGB.getStyle(), (int)size, (Color)aPGB.getColor(), (Color)aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(shape);
            } else {
                g.setColor(aColor);
                g.fill(shape);
            }
        } else if (isSelected) {
            g.setColor(this.getSelectedColor());
            g.fill(shape);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(shape);
        }
        if (rs.getAngle() != 0.0f) {
            g.setTransform(atf);
        }
    }

    private void drawArc(Graphics2D g, ArcShape aShape, PolygonBreak aPGB, Rectangle2D area, float dist, float ex, Font labelFont, Color labelColor) {
        float startAngle = aShape.getStartAngle();
        float sweepAngle = aShape.getSweepAngle();
        float angle = startAngle + sweepAngle / 2.0f;
        float space = 20.0f;
        Rectangle2D.Double rect = new Rectangle2D.Double(area.getX() + (double)ex + (double)space, area.getY() + (double)ex + (double)space, area.getWidth() - (double)ex - (double)space, area.getHeight() - (double)ex - (double)space);
        double dx = 0.0;
        double dy = 0.0;
        if (aShape.getExplode() > 0.0f) {
            dx = (double)ex * Math.cos((double)(360.0f - angle) * Math.PI / 180.0);
            dy = (double)ex * Math.sin((double)(360.0f - angle) * Math.PI / 180.0);
            ((Rectangle2D)rect).setRect(((RectangularShape)rect).getX() + dx, ((RectangularShape)rect).getY() + dy, ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight());
        }
        float sx = (float)(((RectangularShape)rect).getX() - area.getX());
        float sy = (float)(((RectangularShape)rect).getY() - area.getY());
        Draw.drawPie((PointF)new PointF(sx, sy), (float)((float)((RectangularShape)rect).getWidth()), (float)((float)((RectangularShape)rect).getHeight()), (float)startAngle, (float)sweepAngle, (PolygonBreak)aPGB, (Graphics2D)g);
        PointF sPoint = new PointF((float)(((RectangularShape)rect).getWidth() * 0.5 + (double)sx), (float)(((RectangularShape)rect).getHeight() * 0.5 + (double)sy));
        String label = aPGB.getCaption();
        if (angle > 360.0f) {
            angle -= 360.0f;
        }
        float r = (float)(((RectangularShape)rect).getWidth() * 0.5) + dist;
        PointF lPoint = Draw.getPieLabelPoint((PointF)sPoint, (float)r, (float)angle);
        float x = lPoint.X;
        float y = lPoint.Y;
        Dimension dim = Draw.getStringDimension((String)label, (Graphics2D)g);
        float h = dim.height;
        float w = dim.width;
        if (angle >= 0.0f && angle < 45.0f) {
            y -= h;
        } else if (!(angle >= 45.0f) || !(angle < 90.0f)) {
            if (angle >= 90.0f && angle < 135.0f) {
                x -= w;
            } else if (angle >= 135.0f && angle < 225.0f) {
                x = x - w - 3.0f;
                y += h / 2.0f;
            } else if (angle >= 225.0f && angle < 270.0f) {
                x -= w / 2.0f;
                y += h;
            } else {
                y = angle >= 270.0f && angle < 315.0f ? (y += h) : (y += h / 2.0f);
            }
        }
        g.setFont(labelFont);
        g.setColor(labelColor);
        g.drawString(label, x, y);
    }

    private void drawArc(Graphics2D g, ArcShape aShape, PolygonBreak aPGB, Rectangle2D area) {
        float startAngle = aShape.getStartAngle();
        float sweepAngle = aShape.getSweepAngle();
        Extent extent = aShape.getExtent();
        double[] sXY = this.projToScreen(extent.minX, extent.minY + extent.getHeight(), area);
        double x = sXY[0];
        double y = sXY[1];
        double width = this.projXLength(extent.getWidth(), area);
        double height = this.projYLength(extent.getHeight(), area);
        Float wedgeWidth = aShape.getWedgeWidth();
        if (wedgeWidth == null) {
            Draw.drawPie((PointF)new PointF((float)x, (float)y), (float)((float)width), (float)((float)height), (float)startAngle, (float)sweepAngle, (PolygonBreak)aPGB, (Graphics2D)g);
        } else {
            wedgeWidth = Float.valueOf((float)this.projXLength(wedgeWidth.floatValue(), area));
            Draw.drawPie((PointF)new PointF((float)x, (float)y), (float)((float)width), (float)((float)height), (float)startAngle, (float)sweepAngle, (PolygonBreak)aPGB, (float)wedgeWidth.floatValue(), (Graphics2D)g);
        }
    }

    private void drawBar(Graphics2D g, BarShape bar, BarBreak bb, float width, Rectangle2D area) {
        double[] xy = this.projToScreen(0.0, 0.0, area);
        float y0 = (float)xy[1];
        width = (float)this.projXLength(width, area);
        xy = this.projToScreen(bar.getPoint().X, bar.getPoint().Y, area);
        double x = xy[0];
        double y = xy[1];
        float height = Math.abs((float)(y - (double)y0));
        float yb = y0;
        if (y >= (double)y0) {
            yb += height;
        }
        Draw.drawBar((PointF)new PointF((float)x, yb), (float)width, (float)height, (PolygonBreak)bb, (Graphics2D)g, (boolean)false, (int)5);
    }

    private int getBarSeriesNum() {
        int n = 0;
        for (Graphic g : this.graphics.getGraphics()) {
            if (g.getGraphicN(0).getShape().getShapeType() != ShapeTypes.BAR) continue;
            ++n;
        }
        return n;
    }

    private void drawBars(Graphics2D g, GraphicCollection bars, int barIdx, Rectangle2D area) {
        boolean drawBaseline;
        float height;
        double[] xy = this.projToScreen(0.0, 0.0, area);
        float y0 = (float)xy[1];
        int len = bars.getNumGraphics();
        PointF[] points = new PointF[len];
        for (int i = 0; i < len; ++i) {
            BarShape bs = (BarShape)bars.getGraphicN(i).getShape();
            xy = this.projToScreen(bs.getPoint().X, bs.getPoint().Y, area);
            points[i] = new PointF((float)xy[0], (float)xy[1]);
        }
        int barSeriesN = this.getBarSeriesNum();
        BarShape bs1 = (BarShape)bars.getGraphicN(0).getShape();
        if (bs1.isAutoWidth()) {
            float width = len > 1 ? (points[1].X - points[0].X) * this.barsWidth / (float)barSeriesN : (float)(area.getWidth() / 10.0) / (float)barSeriesN;
            for (int i = 0; i < len; ++i) {
                BarShape bs = (BarShape)bars.getGraphicN(i).getShape();
                BarBreak bb = (BarBreak)bars.getGraphicN(i).getLegend();
                height = Math.abs(points[i].Y - y0);
                float yBottom = y0;
                if (bs.isDrawBottom()) {
                    xy = this.projToScreen(bs.getPoint().X, bs.getBottom(), area);
                    yBottom = (float)xy[1];
                }
                float yb = yBottom;
                if (points[i].Y >= y0) {
                    yb += height;
                }
                Draw.drawBar((PointF)new PointF(points[i].X - width * (float)barSeriesN / 2.0f + (float)barIdx * width, yb), (float)width, (float)height, (PolygonBreak)bb, (Graphics2D)g, (boolean)false, (int)5);
                if (!bs.isDrawError()) continue;
                PointF p = (PointF)points[i].clone();
                p.Y -= y0 - yBottom;
                double elen = 6.0;
                double error = bs.getError();
                error = this.projYLength(error, area);
                double x = p.X - width * (float)barSeriesN / 2.0f + (float)barIdx * width + width / 2.0f;
                g.setColor(bb.getErrorColor());
                g.draw(new Line2D.Double(x, (double)p.Y - error, x, (double)p.Y + error));
                g.draw(new Line2D.Double(x - elen * 0.5, (double)p.Y - error, x + elen * 0.5, (double)p.Y - error));
                g.draw(new Line2D.Double(x - elen * 0.5, (double)p.Y + error, x + elen * 0.5, (double)p.Y + error));
            }
        } else {
            float width = (float)this.projXLength(bs1.getWidth(), area);
            for (int i = 0; i < len; ++i) {
                BarShape bs = (BarShape)bars.getGraphicN(i).getShape();
                BarBreak bb = (BarBreak)bars.getGraphicN(i).getLegend();
                height = Math.abs(points[i].Y - y0);
                float yBottom = y0;
                if (bs.isDrawBottom()) {
                    xy = this.projToScreen(bs.getPoint().X, bs.getBottom(), area);
                    yBottom = (float)xy[1];
                }
                float yb = yBottom;
                if (points[i].Y >= y0) {
                    yb += height;
                }
                Draw.drawBar((PointF)new PointF(points[i].X, yb), (float)width, (float)height, (PolygonBreak)bb, (Graphics2D)g, (boolean)false, (int)5);
                if (!bs.isDrawError()) continue;
                PointF p = (PointF)points[i].clone();
                p.Y -= y0 - yBottom;
                double elen = 6.0;
                double error = bs.getError();
                error = this.projYLength(error, area);
                double x = p.X + width / 2.0f;
                g.setColor(bb.getErrorColor());
                g.draw(new Line2D.Double(x, (double)p.Y - error, x, (double)p.Y + error));
                g.draw(new Line2D.Double(x - elen * 0.5, (double)p.Y - error, x + elen * 0.5, (double)p.Y - error));
                g.draw(new Line2D.Double(x - elen * 0.5, (double)p.Y + error, x + elen * 0.5, (double)p.Y + error));
            }
        }
        if (drawBaseline = true) {
            g.setColor(Color.black);
            g.draw(new Line2D.Double(0.0, y0, area.getWidth(), y0));
        }
    }

    private double getBarXInterval(int idx) {
        Graphic gg = this.graphics.get(idx);
        if (gg.getNumGraphics() == 1) {
            if (((PointD)gg.getGraphicN((int)0).getShape().getPoints().get((int)0)).X == 0.0) {
                return 1.0;
            }
            return ((PointD)gg.getGraphicN((int)0).getShape().getPoints().get((int)0)).X / 10.0;
        }
        return ((PointD)gg.getGraphicN((int)1).getShape().getPoints().get((int)0)).X - ((PointD)gg.getGraphicN((int)0).getShape().getPoints().get((int)0)).X;
    }

    private int getBarIndex() {
        int idx = -1;
        for (int i = 0; i < this.graphics.size(); ++i) {
            if (this.graphics.get(i).getGraphicN(0).getShape().getShapeType() != ShapeTypes.BAR) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private int getImageIndex() {
        int idx = -1;
        for (int i = 0; i < this.graphics.size(); ++i) {
            if (this.graphics.get(i).getGraphicN(0).getShape().getShapeType() != ShapeTypes.IMAGE) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private void drawImage(Graphics2D g, Graphic igraphic, Rectangle2D area) {
        ImageShape ishape = (ImageShape)igraphic.getShape();
        BufferedImage image = ishape.getImage();
        Extent extent = ishape.getExtent();
        double sx = extent.minX;
        double sy = extent.maxY;
        double[] xy1 = this.projToScreen(sx, sy, area);
        double ex = extent.maxX;
        double ey = extent.minY;
        double[] xy2 = this.projToScreen(ex, ey, area);
        int x = (int)xy1[0];
        int y = (int)xy1[1];
        int width = (int)(xy2[0] - xy1[0]);
        int height = (int)(xy2[1] - xy1[1]);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, ishape.getInterpolation());
        g.drawImage(image, x, y, width, height, null);
    }

    @Override
    Extent getAutoExtent() {
        double[] xValues;
        int imageIdx;
        Extent extent = (Extent)this.graphics.getExtent().clone();
        if (extent.minX == extent.maxX) {
            extent.minX -= Math.abs(extent.minX);
            extent.maxX += Math.abs(extent.minX);
        }
        if (extent.minY == extent.maxY) {
            extent.minY -= Math.abs(extent.minY);
            extent.maxY += Math.abs(extent.maxY);
        }
        if ((imageIdx = this.getImageIndex()) >= 0) {
            return extent;
        }
        int barIdx = this.getBarIndex();
        if (barIdx >= 0) {
            double dx = this.getBarXInterval(barIdx);
            extent.minX -= dx;
            extent.maxX += dx;
        }
        if (this.getXAxis() instanceof TimeAxis) {
            xValues = (double[])MIMath.getIntervalValues((double)extent.minX, (double)extent.maxX, (boolean)false).get(0);
            xValues[0] = extent.minX;
            xValues[xValues.length - 1] = extent.maxX;
        } else {
            xValues = this.getXAxis() instanceof LogAxis ? MIMath.getIntervalValues_Log((double)extent.minX, (double)extent.maxX) : (double[])MIMath.getIntervalValues((double)extent.minX, (double)extent.maxX, (boolean)true).get(0);
        }
        double[] yValues = this.getYAxis() instanceof LogAxis ? MIMath.getIntervalValues_Log((double)extent.minY, (double)extent.maxY) : (double[])MIMath.getIntervalValues((double)extent.minY, (double)extent.maxY, (boolean)true).get(0);
        if (this.getPlotOrientation() == PlotOrientation.VERTICAL) {
            return new Extent(xValues[0], xValues[xValues.length - 1], yValues[0], yValues[yValues.length - 1]);
        }
        return new Extent(yValues[0], yValues[yValues.length - 1], xValues[0], xValues[xValues.length - 1]);
    }

    @Override
    public void setAutoExtent() {
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
        this.setExtent((Extent)extent.clone());
    }

    @Override
    public void updateLegendScheme() {
        if (this.getLegend() == null) {
            this.setLegend(new ChartLegend(this.getLegendScheme()));
        } else {
            this.getLegend().setLegendScheme(this.getLegendScheme());
        }
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LegendScheme getLegendScheme() {
        LegendScheme ls = null;
        int n = this.graphics.getNumGraphics();
        for (int i = n - 1; i >= 0; --i) {
            Graphic g = this.graphics.getGraphicN(i);
            if (g instanceof ImageGraphic) {
                ls = ((ImageGraphic)g).getLegendScheme();
                continue;
            }
            if (!(g instanceof GraphicCollection)) continue;
            ls = ((GraphicCollection)g).getLegendScheme();
        }
        if (ls == null) {
            ShapeTypes stype = ShapeTypes.POLYLINE;
            ls = new LegendScheme(stype);
            for (Graphic g : this.graphics.getGraphics()) {
                ls.getLegendBreaks().add(g.getLegend());
            }
        }
        return ls;
    }
}

