/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.graphic.GraphicFactory;
import org.meteoinfo.chart.plot.GridLine;
import org.meteoinfo.chart.plot.Plot2D;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geo.drawing.Draw;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.ndarray.util.BigDecimalUtil;

public class PolarPlot
extends Plot2D {
    private double radius;
    private double bottom = 0.0;
    private Font xTickFont = new Font("Arial", 0, 12);
    private Font yTickFont = new Font("Aria", 0, 12);
    private Color xTickColor = Color.black;
    private Color yTickColor = Color.black;
    private List<Double> xTickLocations;
    private List<String> xTickLabels;
    private boolean yTickAuto = true;
    private List<Double> yTickLocations;
    private List<String> yTickLabels;
    private float yTickLabelPos = 22.5f;
    private String yTickFormat = "";

    public PolarPlot() {
        this.aspectType = AspectType.EQUAL;
        GridLine gl = this.getGridLine();
        gl.setDrawXLine(true);
        gl.setDrawYLine(true);
        this.xTickLocations = new ArrayList<Double>();
        this.xTickLabels = new ArrayList<String>();
        for (double angle = 0.0; angle < 360.0; angle += 45.0) {
            this.xTickLocations.add(angle);
            String label = DataConvert.removeTailingZeros((String)String.valueOf(angle)) + String.valueOf('\u00ba');
            this.xTickLabels.add(label);
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double value) {
        this.radius = value + this.bottom;
        super.setDrawExtent(new Extent(-this.radius, this.radius, -this.radius, this.radius));
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double value) {
        this.bottom = value;
    }

    public Font getXTickFont() {
        return this.xTickFont;
    }

    public void setXTickFont(Font value) {
        this.xTickFont = value;
    }

    public Font getYTickFont() {
        return this.yTickFont;
    }

    public void setYTickFont(Font value) {
        this.yTickFont = value;
    }

    public Color getXTickColor() {
        return this.xTickColor;
    }

    public void setXTickColor(Color value) {
        this.xTickColor = value;
    }

    public Color getYTickColor() {
        return this.yTickColor;
    }

    public void setYTickColor(Color value) {
        this.yTickColor = value;
    }

    public List<Double> getXTickLocations() {
        return this.xTickLocations;
    }

    public void setXTickLocations(List<Number> value) {
        this.xTickLocations = new ArrayList<Double>();
        for (Number v : value) {
            this.xTickLocations.add(v.doubleValue());
        }
        if (this.xTickLabels.size() != value.size()) {
            this.xTickLabels = new ArrayList<String>();
            for (Number v : value) {
                String label = DataConvert.removeTailingZeros((String)String.valueOf(v.floatValue())) + String.valueOf('\u00ba');
                this.xTickLabels.add(label);
            }
        }
    }

    public List<String> getXTickLabels() {
        return this.xTickLabels;
    }

    public void setXTickLabels(List<String> value) {
        this.xTickLabels = value;
    }

    public List<Double> getYTickLocations() {
        return this.yTickLocations;
    }

    public void setYTickLocations(List<Number> value) {
        this.yTickLocations = new ArrayList<Double>();
        for (Number v : value) {
            this.yTickLocations.add(v.doubleValue());
        }
        this.yTickAuto = false;
    }

    public List<String> getYTickLabels() {
        return this.yTickLabels;
    }

    public void setYTickLabels(List<String> value) {
        this.yTickLabels = value;
        this.yTickAuto = false;
    }

    public float getYTickLabelPos() {
        return this.yTickLabelPos;
    }

    public void setYTickLabelPos(float value) {
        this.yTickLabelPos = value;
    }

    public String getYTickFormat() {
        return this.yTickFormat;
    }

    public void setYTickFormat(String value) {
        this.yTickFormat = value;
    }

    @Override
    public void addGraphic(Graphic g) {
        GraphicFactory.polarToCartesian((GraphicCollection)g, this.bottom);
        super.addGraphic(g);
    }

    @Override
    public void addGraphic(int idx, Graphic g) {
        GraphicFactory.polarToCartesian((GraphicCollection)g, this.bottom);
        super.addGraphic(idx, g);
    }

    @Override
    Extent getAutoExtent() {
        Extent extent = this.getGraphics().getExtent();
        if (extent.minX == extent.maxX) {
            extent.minX -= Math.abs(extent.minX);
            extent.maxX += Math.abs(extent.minX);
        }
        if (extent.minY == extent.maxY) {
            extent.minY -= Math.abs(extent.minY);
            extent.maxY += Math.abs(extent.maxY);
        }
        return extent;
    }

    @Override
    public void setDrawExtent(Extent extent) {
        double max = Math.abs(extent.minX);
        max = Math.max(max, Math.abs(extent.maxX));
        max = Math.max(max, Math.abs(extent.minY));
        max = Math.max(max, Math.abs(extent.maxY));
        double[] values = (double[])MIMath.getIntervalValues((double)0.0, (double)max, (boolean)true).get(0);
        this.radius = values[values.length - 1] + this.bottom;
        super.setDrawExtent(new Extent(-this.radius, this.radius, -this.radius, this.radius));
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        int left = 2;
        int bottom = 2;
        int right = 2;
        int top = 5;
        if (this.getTitle() != null) {
            top += this.getTitle().getTrueDimension((Graphics2D)g).height + 15;
        }
        if (!this.getLegends().isEmpty()) {
            Dimension dim = this.getLegend().getLegendDimension(g, new Dimension((int)positionArea.getWidth(), (int)positionArea.getHeight()));
            switch (this.getLegend().getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        int space = 5;
        if (this.xTickLabels != null && this.xTickLabels.size() > 0) {
            g.setFont(this.xTickFont);
            Dimension dim = Draw.getStringDimension((String)this.xTickLabels.get(0), (Graphics2D)g);
            bottom += dim.height;
            top += dim.height;
            left += dim.width + space;
            right += dim.width + space;
        }
        return new Margin(left, right, top, bottom);
    }

    @Override
    public Rectangle2D getGraphArea(Graphics2D g, Rectangle2D area) {
        int left = 5;
        int bottom = 5;
        int right = 5;
        int top = 5;
        int space = 10;
        if (this.getTitle() != null) {
            top += this.getTitle().getTrueDimension((Graphics2D)g).height + 10;
        }
        if (!this.getLegends().isEmpty()) {
            Dimension dim = this.getLegend().getLegendDimension(g, new Dimension((int)area.getWidth(), (int)area.getHeight()));
            switch (this.getLegend().getPosition()) {
                case UPPER_CENTER_OUTSIDE: {
                    top += dim.height + 10;
                    break;
                }
                case LOWER_CENTER_OUTSIDE: {
                    bottom += dim.height + 10;
                    break;
                }
                case LEFT_OUTSIDE: {
                    left += dim.width + 10;
                    break;
                }
                case RIGHT_OUTSIDE: {
                    right += dim.width + 10;
                }
            }
        }
        Rectangle2D.Double plotArea = new Rectangle2D.Double(left += space, top += space, area.getWidth() - (double)left - (double)(right += space), area.getHeight() - (double)top - (double)(bottom += space));
        return plotArea;
    }

    @Override
    public void draw(Graphics2D g, Rectangle2D area) {
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        Rectangle2D graphArea = this.getPositionArea();
        this.setGraphArea(graphArea);
        this.drawTitle(g, graphArea);
        if (graphArea.getWidth() < 10.0 || graphArea.getHeight() < 10.0) {
            return;
        }
        if (this.background != null) {
            g.setColor(this.getBackground());
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            ellipse.setFrame(graphArea);
            g.fill(ellipse);
        }
        if (this.getGridLine().isTop()) {
            this.drawGraph(g, graphArea);
            this.drawGridLine(g, graphArea);
        } else {
            this.drawGridLine(g, graphArea);
            this.drawGraph(g, graphArea);
        }
        this.drawGridLabel(g, graphArea);
        this.drawBorder(g, graphArea);
        if (this.isDrawNeatLine()) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.black);
            g.draw(graphArea);
        }
        this.drawText(g, graphArea);
        this.drawLegend(g, area, graphArea);
    }

    @Override
    int getTopAxisHeight(Graphics2D g) {
        g.setFont(this.xTickFont);
        int height = Draw.getStringDimension((String)"tick", (Graphics2D)g).height + 5;
        return height;
    }

    @Override
    void drawGraph(Graphics2D g, Rectangle2D area) {
        super.drawGraph(g, area);
    }

    @Override
    void drawGridLine(Graphics2D g, Rectangle2D area) {
        GridLine gridLine = this.getGridLine();
        if (!gridLine.isDrawXLine() && !gridLine.isDrawYLine()) {
            return;
        }
        double miny = area.getY();
        double minx = area.getX();
        if (gridLine.getStyle() == LineStyles.SOLID) {
            g.setStroke(new BasicStroke(gridLine.getSize()));
        } else {
            float[] dashPattern = Draw.getDashPattern((LineStyles)gridLine.getStyle());
            g.setStroke(new BasicStroke(gridLine.getSize(), 0, 0, 10.0f, dashPattern, 0.0f));
        }
        double[] xy = this.projToScreen(0.0, 0.0, area);
        double x0 = xy[0] + minx;
        double y0 = xy[1] + miny;
        if (gridLine.isDrawXLine()) {
            g.setFont(this.xTickFont);
            float shift = 5.0f;
            for (int i = 0; i < this.xTickLocations.size(); ++i) {
                double angle = this.xTickLocations.get(i);
                if (this.bottom != 0.0) {
                    xy = MIMath.polarToCartesian((double)Math.toRadians(angle), (double)this.bottom);
                    xy = this.projToScreen(xy[0], xy[1], area);
                    x0 = xy[0] + minx;
                    y0 = xy[1] + miny;
                }
                xy = MIMath.polarToCartesian((double)Math.toRadians(angle), (double)this.radius);
                xy = this.projToScreen(xy[0], xy[1], area);
                double x = xy[0] + minx;
                double y = xy[1] + miny;
                g.setColor(gridLine.getColor());
                g.draw(new Line2D.Double(x0, y0, x, y));
            }
        }
        if (gridLine.isDrawYLine()) {
            g.setFont(this.yTickFont);
            if (this.yTickAuto) {
                this.yTickLocations = this.getTickValues();
            }
            for (int i = 0; i < this.yTickLocations.size(); ++i) {
                double v = this.yTickLocations.get(i);
                if (!(v > 0.0) || !(v < this.radius)) continue;
                g.setColor(gridLine.getColor());
                this.drawCircle(g, area, v + this.bottom);
            }
        }
    }

    void drawGridLabel_bak(Graphics2D g, Rectangle2D area) {
        double y;
        double x;
        double[] xy;
        GridLine gridLine = this.getGridLine();
        if (!gridLine.isDrawXLine() && !gridLine.isDrawYLine()) {
            return;
        }
        double miny = area.getY();
        double minx = area.getX();
        if (gridLine.isDrawXLine()) {
            g.setFont(this.xTickFont);
            float shift = 5.0f;
            for (int i = 0; i < this.xTickLocations.size(); ++i) {
                double angle = this.xTickLocations.get(i);
                xy = MIMath.polarToCartesian((double)Math.toRadians(angle), (double)this.radius);
                xy = this.projToScreen(xy[0], xy[1], area);
                x = xy[0];
                y = xy[1];
                x += minx;
                y += miny;
                String label = this.xTickLabels.get(i);
                Dimension dim = Draw.getStringDimension((String)label, (Graphics2D)g);
                float w = dim.width;
                float h = dim.height;
                if (angle == 0.0 || angle == 180.0) {
                    y += (double)h * 0.5;
                    if (angle == 0.0) {
                        x += (double)shift;
                    } else {
                        x -= (double)w;
                        x -= (double)shift;
                    }
                } else if (angle == 90.0 || angle == 270.0) {
                    x -= (double)w * 0.5;
                    if (angle == 90.0) {
                        y -= (double)shift;
                    } else {
                        y += (double)h;
                        y += (double)shift;
                    }
                } else if (angle > 0.0 && angle <= 45.0) {
                    x += (double)shift;
                } else if (angle > 45.0 && angle < 90.0) {
                    y -= (double)shift;
                } else if (angle > 90.0 && angle < 180.0) {
                    x -= (double)w;
                    x -= (double)shift;
                } else if (angle > 180.0 && angle <= 225.0) {
                    x -= (double)w;
                    x -= (double)shift;
                    y += (double)h;
                } else if (angle > 225.0 && angle < 270.0) {
                    x -= (double)w;
                    x -= (double)shift;
                    y += (double)h;
                } else if (angle > 270.0) {
                    x += (double)shift;
                    y += (double)h;
                }
                g.setColor(Color.black);
                g.drawString(label, (float)x, (float)y);
            }
        }
        if (gridLine.isDrawYLine()) {
            g.setFont(this.yTickFont);
            if (this.yTickAuto) {
                this.yTickLocations = this.getTickValues();
            }
            for (int i = 0; i < this.yTickLocations.size(); ++i) {
                double v = this.yTickLocations.get(i);
                if (!(v > 0.0)) continue;
                g.setColor(Color.black);
                xy = MIMath.polarToCartesian((double)Math.toRadians(this.yTickLabelPos), (double)v);
                xy = this.projToScreen(xy[0], xy[1], area);
                x = xy[0];
                y = xy[1];
                String label = this.yTickLabels != null ? this.yTickLabels.get(i) : (this.yTickFormat.equals("%") ? DataConvert.removeTailingZeros((String)String.valueOf(BigDecimalUtil.mul((double)v, (double)100.0))) + "%" : DataConvert.removeTailingZeros((String)String.valueOf(v)));
                g.drawString(label, (float)(x += minx), (float)(y += miny));
            }
        }
    }

    void drawGridLabel(Graphics2D g, Rectangle2D area) {
        double y;
        double x;
        double[] xy;
        GridLine gridLine = this.getGridLine();
        if (!gridLine.isDrawXLine() && !gridLine.isDrawYLine()) {
            return;
        }
        double miny = area.getY();
        double minx = area.getX();
        if (gridLine.isDrawXLine()) {
            g.setFont(this.xTickFont);
            g.setColor(this.xTickColor);
            float shift = 5.0f;
            for (int i = 0; i < this.xTickLocations.size(); ++i) {
                double angle = this.xTickLocations.get(i);
                xy = MIMath.polarToCartesian((double)Math.toRadians(angle), (double)this.radius);
                xy = this.projToScreen(xy[0], xy[1], area);
                x = xy[0];
                y = xy[1];
                x += minx;
                y += miny;
                String label = this.xTickLabels.get(i);
                Dimension dim = Draw.getStringDimension((String)label, (Graphics2D)g);
                float w = dim.width;
                float h = dim.height;
                if (angle == 0.0 || angle == 180.0) {
                    if (angle == 0.0) {
                        Draw.drawString((Graphics2D)g, (float)((float)(x += (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (boolean)false);
                        continue;
                    }
                    Draw.drawString((Graphics2D)g, (float)((float)(x -= (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (boolean)false);
                    continue;
                }
                if (angle == 90.0 || angle == 270.0) {
                    if (angle == 90.0) {
                        Draw.drawString((Graphics2D)g, (float)((float)x), (float)((float)(y -= (double)shift)), (String)label, (XAlign)XAlign.CENTER, (YAlign)YAlign.BOTTOM, (boolean)false);
                        continue;
                    }
                    Draw.drawString((Graphics2D)g, (float)((float)x), (float)((float)(y += (double)shift)), (String)label, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (boolean)false);
                    continue;
                }
                if (angle > 0.0 && angle < 90.0) {
                    Draw.drawString((Graphics2D)g, (float)((float)(x += (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.LEFT, (YAlign)YAlign.BOTTOM, (boolean)false);
                    continue;
                }
                if (angle > 90.0 && angle < 180.0) {
                    Draw.drawString((Graphics2D)g, (float)((float)(x -= (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.RIGHT, (YAlign)YAlign.BOTTOM, (boolean)false);
                    continue;
                }
                if (angle > 180.0 && angle < 270.0) {
                    Draw.drawString((Graphics2D)g, (float)((float)(x -= (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (boolean)false);
                    continue;
                }
                if (!(angle > 270.0)) continue;
                Draw.drawString((Graphics2D)g, (float)((float)(x += (double)shift)), (float)((float)y), (String)label, (XAlign)XAlign.LEFT, (YAlign)YAlign.TOP, (boolean)false);
            }
        }
        if (gridLine.isDrawYLine()) {
            g.setFont(this.yTickFont);
            g.setColor(this.yTickColor);
            if (this.yTickAuto) {
                this.yTickLocations = this.getTickValues();
            }
            for (int i = 0; i < this.yTickLocations.size(); ++i) {
                double v = this.yTickLocations.get(i);
                if (!(v > 0.0) || !(v < this.radius)) continue;
                xy = MIMath.polarToCartesian((double)Math.toRadians(this.yTickLabelPos), (double)(v + this.bottom));
                xy = this.projToScreen(xy[0], xy[1], area);
                x = xy[0];
                y = xy[1];
                String label = this.yTickLabels != null ? this.yTickLabels.get(i) : (this.yTickFormat.equals("%") ? DataConvert.removeTailingZeros((String)String.valueOf(BigDecimalUtil.mul((double)v, (double)100.0))) + "%" : DataConvert.removeTailingZeros((String)String.valueOf(v)));
                g.drawString(label, (float)(x += minx), (float)(y += miny));
            }
        }
    }

    List<Double> getTickValues() {
        double[] v = MIMath.getIntervalValues((double)0.0, (double)this.radius, (int)4);
        ArrayList<Double> vl = new ArrayList<Double>();
        for (double vv : v) {
            vl.add(vv);
        }
        return vl;
    }

    void drawBorder(Graphics2D g, Rectangle2D area) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f));
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.setFrame(area);
        g.draw(ellipse);
    }

    void drawCircle(Graphics2D g, Rectangle2D area, double r) {
        double[] xy = this.projToScreen(0.0, 0.0, area);
        double x = xy[0] + area.getX();
        double y = xy[1] + area.getY();
        r = this.projXLength(r, area);
        g.draw(new Ellipse2D.Double(x - r, y - r, 2.0 * r, 2.0 * r));
    }
}

