/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class FileCharsetDetector {
    private boolean found = false;
    private String encoding = null;

    public String guestFileEncoding(File file) throws FileNotFoundException, IOException {
        return this.guestFileEncoding(file, new nsDetector());
    }

    public String guestFileEncoding(File file, int languageHint) throws FileNotFoundException, IOException {
        return this.guestFileEncoding(file, new nsDetector(languageHint));
    }

    public String guestFileEncoding(String path) throws FileNotFoundException, IOException {
        return this.guestFileEncoding(new File(path));
    }

    public String guestFileEncoding(String path, int languageHint) throws FileNotFoundException, IOException {
        return this.guestFileEncoding(new File(path), languageHint);
    }

    private String guestFileEncoding(File file, nsDetector det) throws FileNotFoundException, IOException {
        int len;
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                FileCharsetDetector.this.found = true;
                FileCharsetDetector.this.encoding = charset;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            this.encoding = "ASCII";
            this.found = true;
        }
        if (!this.found) {
            String[] prob = det.getProbableCharsets();
            if (prob.length > 0) {
                this.encoding = prob[0];
            } else {
                return null;
            }
        }
        return this.encoding;
    }
}

