/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.common.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.meteoinfo.common.util.BigDecimalUtil;
import org.meteoinfo.common.util.TypeUtils;

public class JDateUtil {
    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime asLocalDateTime(long ms) {
        return Instant.ofEpochMilli(ms).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime fromOADate(double oaDate) {
        long t = (long)BigDecimalUtil.mul(oaDate, 1000000.0);
        Instant instant = Instant.ofEpochMilli(t);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static long asMilliSeconds(LocalDateTime ldt) {
        return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static double toOADate(LocalDateTime ldt) {
        double oaDate = ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        oaDate = BigDecimalUtil.div(oaDate, 1000000.0);
        return oaDate;
    }

    public static int getDaysOfMonth(int year, int month) {
        YearMonth ym = YearMonth.of(year, month);
        return ym.lengthOfMonth();
    }

    public static int getDaysOfYear(int year) {
        YearMonth ym = YearMonth.of(year, 1);
        return ym.lengthOfYear();
    }

    public static List<Integer> getTimeDeltaValues(List<LocalDateTime> times, LocalDateTime baseDate, String tDelta) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < times.size(); ++i) {
            int value;
            if (tDelta.equalsIgnoreCase("hours")) {
                value = (int)Duration.between(baseDate, times.get(i)).toHours();
                values.add(value);
                continue;
            }
            if (!tDelta.equalsIgnoreCase("days")) continue;
            value = Period.between(baseDate.toLocalDate(), times.get(i).toLocalDate()).getDays();
            values.add(value);
        }
        return values;
    }

    public static int getTimeDeltaValue(LocalDateTime t, LocalDateTime baseDate, String tDelta) {
        int value = 0;
        if (tDelta.equalsIgnoreCase("hours")) {
            value = (int)Duration.between(baseDate, t).toHours();
        } else if (tDelta.equalsIgnoreCase("days")) {
            value = Period.between(baseDate.toLocalDate(), t.toLocalDate()).getDays();
        }
        return value;
    }

    public static int getDays(LocalDateTime t, LocalDateTime baseDate) {
        return Period.between(baseDate.toLocalDate(), t.toLocalDate()).getDays();
    }

    public static int getHours(LocalDateTime t, LocalDateTime baseDate) {
        return (int)Duration.between(baseDate, t).toHours();
    }

    public static boolean equals(LocalDateTime a, LocalDateTime b) {
        return a.equals(b);
    }

    public static int dayOfYear(int year, int month, int day) {
        LocalDate ldt = LocalDate.of(year, month, day);
        int doy = ldt.getDayOfYear();
        return doy;
    }

    public static LocalDate doy2date(int year, int doy) {
        return LocalDate.ofYearDay(year, doy);
    }

    public static ChronoUnit getPeriodType(String p) {
        ChronoUnit pt = ChronoUnit.DAYS;
        switch (p) {
            case "H": {
                pt = ChronoUnit.HOURS;
                break;
            }
            case "M": {
                pt = ChronoUnit.MINUTES;
                break;
            }
            case "S": {
                pt = ChronoUnit.SECONDS;
                break;
            }
            case "m": {
                pt = ChronoUnit.MONTHS;
                break;
            }
            case "Y": {
                pt = ChronoUnit.YEARS;
            }
        }
        return pt;
    }

    public static TemporalAmount getPeriod(String pStr) {
        TemporalAmount pe;
        String p;
        int n = 1;
        int idx = 0;
        for (int i = 0; i < pStr.length() && !Character.isLetter(pStr.charAt(i)); ++i) {
            ++idx;
        }
        if (idx == 0) {
            p = pStr;
        } else {
            p = pStr.substring(idx);
            n = Integer.parseInt(pStr.substring(0, idx));
        }
        switch (p) {
            case "H": {
                pe = Duration.ofHours(n);
                break;
            }
            case "T": 
            case "Min": {
                pe = Duration.ofMinutes(n);
                break;
            }
            case "S": {
                pe = Duration.ofSeconds(n);
                break;
            }
            case "D": {
                pe = Period.ofDays(n);
                break;
            }
            case "W": {
                pe = Period.ofWeeks(n);
                break;
            }
            case "M": {
                pe = Period.ofMonths(n);
                break;
            }
            case "Y": {
                pe = Period.ofYears(n);
                break;
            }
            default: {
                pe = Duration.ofSeconds(n);
            }
        }
        return pe;
    }

    public static ChronoUnit getChronoUnit(TemporalAmount ta) {
        Duration duration;
        Period period;
        ChronoUnit cu = ChronoUnit.HOURS;
        cu = ta instanceof Period ? ((period = (Period)ta).getYears() > 0 ? ChronoUnit.YEARS : (period.getMonths() > 0 ? ChronoUnit.MONTHS : ChronoUnit.DAYS)) : ((duration = (Duration)ta).toHours() > 0L ? ChronoUnit.HOURS : (duration.toMinutes() > 0L ? ChronoUnit.MINUTES : (duration.getSeconds() > 0L ? ChronoUnit.SECONDS : (duration.toMillis() > 0L ? ChronoUnit.MILLIS : ChronoUnit.MICROS))));
        return cu;
    }

    public static String getDateFormat(TemporalAmount p) {
        String df = "yyyy-MM-dd";
        ChronoUnit cp = JDateUtil.getChronoUnit(p);
        switch (cp) {
            case HOURS: {
                df = "yyyy-MM-dd HH";
                break;
            }
            case MINUTES: {
                df = "yyyy-MM-dd HH:mm";
                break;
            }
            case SECONDS: {
                df = "yyyy-MM-dd HH:mm:ss";
            }
        }
        return df;
    }

    public static LocalDateTime getDateTime(String dts) {
        int year;
        int day;
        int month;
        String[] ymd;
        String dateStr = dts;
        String timeStr = null;
        if (dts.contains(":")) {
            String[] v = dts.split("\\s+");
            dateStr = v[0].trim();
            timeStr = v[1].trim();
        }
        if (dateStr.contains("/")) {
            ymd = dateStr.split("/");
            month = Integer.parseInt(ymd[0]);
            day = Integer.parseInt(ymd[1]);
            year = Integer.parseInt(ymd[2]);
        } else if (dateStr.contains("-")) {
            ymd = dateStr.split("-");
            month = Integer.parseInt(ymd[1]);
            day = Integer.parseInt(ymd[2]);
            year = Integer.parseInt(ymd[0]);
        } else {
            year = Integer.parseInt(dateStr.substring(0, 4));
            month = Integer.parseInt(dateStr.substring(4, 6));
            day = Integer.parseInt(dateStr.substring(6));
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (timeStr != null) {
            String[] hms = timeStr.split(":");
            hour = Integer.parseInt(hms[0]);
            minute = Integer.parseInt(hms[1]);
            second = hms.length == 3 ? Integer.parseInt(hms[2]) : 0;
        }
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public static LocalDateTime getDateTime_(String dts) {
        DateTimeFormatter dtf = dts.contains(":") ? TypeUtils.getDateTimeFormatter(dts) : TypeUtils.getDateFormatter(dts);
        LocalDateTime dt = LocalDateTime.parse(dts, dtf);
        return dt;
    }

    public static List<LocalDateTime> getDateTimes(LocalDateTime start, LocalDateTime end, TemporalAmount p) {
        ArrayList<LocalDateTime> dts = new ArrayList<LocalDateTime>();
        while (!start.isAfter(end)) {
            dts.add(start);
            start = start.plus(p);
        }
        return dts;
    }

    public static List<LocalDateTime> getDateTimes(LocalDateTime start, int tNum, TemporalAmount p) {
        ArrayList<LocalDateTime> dts = new ArrayList<LocalDateTime>();
        for (int i = 0; i < tNum; ++i) {
            dts.add(start);
            start = start.plus(p);
        }
        return dts;
    }

    public static List<LocalDateTime> getDateTimes(int tNum, LocalDateTime end, TemporalAmount p) {
        ArrayList<LocalDateTime> dts = new ArrayList<LocalDateTime>();
        for (int i = 0; i < tNum; ++i) {
            dts.add(end);
            end = end.minus(p);
        }
        return dts;
    }

    public static LocalDateTime parseDateTime(String dtStr, DateTimeFormatter formatter) {
        TemporalAccessor parsed = formatter.parse(dtStr);
        long epochDay = 0L;
        long nanoSeconds = 0L;
        int offsetSeconds = 0;
        if (parsed.isSupported(ChronoField.EPOCH_DAY)) {
            epochDay = parsed.getLong(ChronoField.EPOCH_DAY);
        }
        if (parsed.isSupported(ChronoField.NANO_OF_DAY)) {
            nanoSeconds = parsed.getLong(ChronoField.NANO_OF_DAY);
        }
        if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
            offsetSeconds = parsed.get(ChronoField.OFFSET_SECONDS);
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(offsetSeconds);
        LocalDate datePart = LocalDate.ofEpochDay(epochDay);
        LocalTime timePart = LocalTime.ofNanoOfDay(nanoSeconds);
        return OffsetDateTime.of(datePart, timePart, zoneOffset).toLocalDateTime();
    }

    public static LocalDateTime parseDateTime_bak(String dtStr, DateTimeFormatter formatter) {
        TemporalAccessor ta = formatter.parse(dtStr);
        if (ta.isSupported(ChronoField.HOUR_OF_DAY)) {
            return LocalDateTime.from(ta);
        }
        if (ta.isSupported(ChronoField.DAY_OF_MONTH)) {
            return LocalDate.from(ta).atStartOfDay();
        }
        if (ta.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return LocalDate.of(ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR), 1).atStartOfDay();
        }
        return LocalDate.of(ta.get(ChronoField.YEAR), 1, 1).atStartOfDay();
    }
}

