/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.console.editor;

import java.io.Writer;
import javax.swing.JTextPane;

public class JTextPaneWriter
extends Writer {
    private final JTextPane _jta;
    private final int _maxBuffSize;
    private final StringBuffer _stringBuffer = new StringBuffer();
    private final int _maxLength = 200000;

    public JTextPaneWriter(JTextPane ta) {
        this(ta, -1);
    }

    public JTextPaneWriter(JTextPane ta, int maxBuffSize) {
        this._jta = ta;
        this._maxBuffSize = maxBuffSize;
    }

    private void flushBufferToTextArea() {
        boolean onLastPosition = this._jta.getCaretPosition() == this._jta.getText().length();
        this.append(this._stringBuffer.toString());
        if (onLastPosition) {
            this._jta.setCaretPosition(this._jta.getText().length());
        }
        this._stringBuffer.setLength(0);
    }

    public synchronized String toString() {
        this.flushBufferToTextArea();
        return this._jta.getText();
    }

    @Override
    public synchronized void flush() {
        this.flushBufferToTextArea();
    }

    @Override
    public synchronized void write(int b) {
        if (this._stringBuffer.length() >= this._maxBuffSize || b == 10) {
            this.flushBufferToTextArea();
        }
        if (this._jta.getText().length() > 200000) {
            this._jta.setText("");
        }
        this._stringBuffer.append((char)b);
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) {
        String line = new String(cbuf, off, len);
        if (this._jta.getDocument().getLength() > 200000) {
            this._jta.setText("");
        }
        this.append(line);
    }

    @Override
    public void close() {
    }

    private void append(String string) {
        int slen = this._jta.getDocument().getLength();
        this._jta.select(slen, slen);
        this._jta.replaceSelection(string);
    }
}

