/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.ascii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.util.BigDecimalUtil;

public class ASCIIGridDataInfo
extends DataInfo
implements IGridDataInfo {
    private DataType dataType;

    public ASCIIGridDataInfo() {
        this.setDataType(MeteoDataType.ASCII_GRID);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            int i;
            this.setFileName(fileName);
            BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
            String aLine = sr.readLine();
            for (i = 1; i <= 5; ++i) {
                aLine = aLine + " " + sr.readLine();
            }
            String[] dataArray = aLine.split("\\s+");
            int ncols = Integer.parseInt(dataArray[1]);
            int nrows = Integer.parseInt(dataArray[3]);
            String xll = dataArray[4];
            double xllCenter = Double.parseDouble(dataArray[5]);
            String yll = dataArray[6];
            double yllCenter = Double.parseDouble(dataArray[7]);
            double cellSize = Double.parseDouble(dataArray[9]);
            double nodata_value = Double.parseDouble(dataArray[11]);
            if (xll.toLowerCase().equals("xllcorner")) {
                xllCenter += cellSize * 0.5;
            }
            if (yll.toLowerCase().equals("yllcorner")) {
                yllCenter += cellSize * 0.5;
            }
            aLine = sr.readLine();
            if ((aLine = aLine.trim()).length() > 7 && aLine.substring(0, 7).equalsIgnoreCase("version")) {
                aLine = sr.readLine();
            }
            dataArray = aLine.split("\\s+");
            boolean isInt = true;
            for (String dd : dataArray) {
                if (!dd.contains(".")) continue;
                isInt = false;
                break;
            }
            this.setMissingValue(nodata_value);
            double[] X = new double[ncols];
            X[0] = xllCenter;
            for (i = 1; i < ncols; ++i) {
                X[i] = BigDecimalUtil.add((double)X[i - 1], (double)cellSize);
            }
            if (X[ncols - 1] + cellSize - X[0] == 360.0) {
                this.setGlobal(true);
            }
            double[] Y = new double[nrows];
            Y[0] = yllCenter;
            for (i = 1; i < nrows; ++i) {
                Y[i] = BigDecimalUtil.add((double)Y[i - 1], (double)cellSize);
            }
            this.addAttribute(new Attribute("data_format", "ASCII grid data"));
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setShortName("X");
            xDim.setValues(X);
            this.setXDimension(xDim);
            this.addDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setShortName("Y");
            yDim.setValues(Y);
            this.setYDimension(yDim);
            this.addDimension(yDim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Variable aVar = new Variable();
            aVar.setName("var");
            aVar.addDimension(yDim);
            aVar.addDimension(xDim);
            aVar.setFillValue(nodata_value);
            this.dataType = isInt ? DataType.INT : DataType.FLOAT;
            this.dataType = DataType.FLOAT;
            aVar.setDataType(this.dataType);
            aVar.addAttribute(new Attribute("fill_value", this.getMissingValue()));
            variables.add(aVar);
            this.setVariables(variables);
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)this.dataType, (int[])section.getShape());
            int rangeIdx = 0;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            this.readXY(yRange, xRange, dataArray);
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(Range yRange, Range xRange, Array data) {
        try {
            String aLine;
            int i;
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (i = 0; i < 6; ++i) {
                sr.readLine();
            }
            List<Object> dataList = new ArrayList<String>();
            int row = 0;
            int drow = 0;
            while ((aLine = sr.readLine()) != null) {
                String[] dataArray = aLine.trim().split("\\s+");
                dataList.addAll(Arrays.asList(dataArray));
                if (row == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                    aLine = sr.readLine();
                    dataArray = aLine.trim().split("\\s+");
                    dataList = Arrays.asList(dataArray);
                }
                for (i = 0; i < 100 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                    dataArray = aLine.trim().split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                }
                int nrow = yNum - row - 1;
                if (nrow >= yRange.first() && nrow <= yRange.last() && (nrow - yRange.first()) % yRange.stride() == 0) {
                    int idx = (yRange.length() - drow - 1) * xRange.length();
                    for (i = xRange.first(); i <= xRange.last(); i += xRange.stride()) {
                        if (this.dataType == DataType.INT) {
                            data.setObject(idx, (Object)Integer.parseInt((String)dataList.get(i)));
                        } else {
                            data.setObject(idx, (Object)Float.valueOf(Float.parseFloat((String)dataList.get(i))));
                        }
                        ++idx;
                    }
                    ++drow;
                }
                dataList = dataList.size() > xNum ? dataList.subList(xNum, dataList.size() - 1) : new ArrayList();
                ++row;
                if (aLine != null) continue;
            }
            sr.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readXY_bak1(Range yRange, Range xRange, IndexIterator ii) {
        try {
            String aLine;
            int i;
            int xNum = this.getXDimension().getLength();
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (i = 0; i < 6; ++i) {
                sr.readLine();
            }
            List<String> dataList = new ArrayList<String>();
            int row = 0;
            while ((aLine = sr.readLine()) != null) {
                String[] dataArray = aLine.trim().split("\\s+");
                dataList.addAll(Arrays.asList(dataArray));
                if (row == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                    aLine = sr.readLine();
                    dataArray = aLine.trim().split("\\s+");
                    dataList = Arrays.asList(dataArray);
                }
                for (i = 0; i < 100 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                    dataArray = aLine.trim().split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                }
                if (row >= yRange.first() && row <= yRange.last() && (row - yRange.first()) % yRange.stride() == 0) {
                    for (i = xRange.first(); i <= xRange.last(); i += xRange.stride()) {
                        if (this.dataType == DataType.INT) {
                            ii.setObjectNext((Object)Integer.parseInt((String)dataList.get(i)));
                            continue;
                        }
                        ii.setObjectNext((Object)Float.valueOf(Float.parseFloat((String)dataList.get(i))));
                    }
                }
                dataList = dataList.size() > xNum ? dataList.subList(xNum, dataList.size() - 1) : new ArrayList();
                ++row;
                if (aLine != null) continue;
            }
            sr.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readXY_bak(Range yRange, Range xRange, IndexIterator ii) {
        try {
            String aLine;
            int i;
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            float[][] theData = new float[yNum][xNum];
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (i = 0; i < 6; ++i) {
                sr.readLine();
            }
            List<String> dataList = new ArrayList<String>();
            int col = 0;
            while ((aLine = sr.readLine()) != null) {
                String[] dataArray = aLine.trim().split("\\s+");
                dataList.addAll(Arrays.asList(dataArray));
                if (col == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                    aLine = sr.readLine();
                    dataArray = aLine.trim().split("\\s+");
                    dataList = Arrays.asList(dataArray);
                }
                for (i = 0; i < 100 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                    dataArray = aLine.trim().split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                }
                for (i = 0; i < xNum; ++i) {
                    theData[col][i] = Float.parseFloat((String)dataList.get(i));
                }
                dataList = dataList.size() > xNum ? dataList.subList(xNum, dataList.size() - 1) : new ArrayList();
                ++col;
                if (aLine != null) continue;
            }
            sr.close();
            float[] data = new float[yNum * xNum];
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    data[i * xNum + j] = theData[yNum - 1 - i][j];
                }
            }
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        GridArray ga = new GridArray();
        ga.setData(this.read(varName));
        ga.xArray = this.getXDimension().getValues();
        ga.yArray = this.getYDimension().getValues();
        ga.missingValue = this.getMissingValue();
        return ga;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            String aLine;
            int i;
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            double[][] theData = new double[yNum][xNum];
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (i = 0; i < 6; ++i) {
                sr.readLine();
            }
            List<String> dataList = new ArrayList<String>();
            int col = 0;
            while ((aLine = sr.readLine()) != null) {
                String[] dataArray = aLine.trim().split("\\s+");
                dataList.addAll(Arrays.asList(dataArray));
                if (col == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                    aLine = sr.readLine();
                    dataArray = aLine.trim().split("\\s+");
                    dataList = Arrays.asList(dataArray);
                }
                for (i = 0; i < 100 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                    dataArray = aLine.trim().split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                }
                for (i = 0; i < xNum; ++i) {
                    theData[col][i] = Double.parseDouble((String)dataList.get(i));
                }
                dataList = dataList.size() > xNum ? dataList.subList(xNum, dataList.size() - 1) : new ArrayList();
                ++col;
                if (aLine != null) continue;
            }
            sr.close();
            double[][] newGridData = new double[yNum][xNum];
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    newGridData[i][j] = theData[yNum - 1 - i][j];
                }
            }
            return new GridData(newGridData, this.getXDimension().getValues(), this.getYDimension().getValues(), this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

