/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.ITrajDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.TrajectoryInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.table.ColumnData;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataTable;

public class HYSPLITTrajDataInfo
extends DataInfo
implements ITrajDataInfo {
    public Integer meteoFileNum;
    public int trajNum;
    private int endPointNum;
    public String trajDirection;
    public String verticalMotion;
    private List<TrajectoryInfo> trajInfoList;
    public int varNum;
    public List<String> varNames;
    private String[] inVarNames;
    private List<DataTable> dataTables;

    public HYSPLITTrajDataInfo() {
        this.meteoDataType = MeteoDataType.HYSPLIT_TRAJ;
        this.initVariables();
    }

    private void initVariables() {
        this.trajInfoList = new ArrayList<TrajectoryInfo>();
        this.varNames = new ArrayList<String>();
        this.trajNum = 0;
        this.inVarNames = new String[]{"time", "run_hour", "lat", "lon", "height"};
    }

    @Override
    public String getXVarName() {
        return "lon";
    }

    @Override
    public String getYVarName() {
        return "lat";
    }

    @Override
    public String getZVarName() {
        return "height";
    }

    @Override
    public String getTVarName() {
        return "time";
    }

    @Override
    public List<TrajectoryInfo> getTrajInfoList() {
        return this.trajInfoList;
    }

    @Override
    public List<DataTable> getDataTables() {
        return this.dataTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            int i;
            this.setFileName(fileName);
            this.initVariables();
            ArrayList<Double> times = new ArrayList<Double>();
            sr = new BufferedReader(new FileReader(new File(fileName)));
            String aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            this.meteoFileNum = Integer.parseInt(dataArray[0]);
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            this.trajNum = Integer.parseInt(dataArray[0]);
            this.trajDirection = dataArray[1];
            this.verticalMotion = dataArray[2];
            for (i = 0; i < this.trajNum; ++i) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                int y = Integer.parseInt(dataArray[0]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                LocalDateTime tt = LocalDateTime.of(y, Integer.parseInt(dataArray[1]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                if (times.isEmpty()) {
                    times.add(JDateUtil.toOADate((LocalDateTime)tt));
                }
                TrajectoryInfo aTrajInfo = new TrajectoryInfo();
                aTrajInfo.startTime = tt;
                aTrajInfo.startLat = Float.parseFloat(dataArray[4]);
                aTrajInfo.startLon = Float.parseFloat(dataArray[5]);
                aTrajInfo.startHeight = Float.parseFloat(dataArray[6]);
                this.trajInfoList.add(aTrajInfo);
            }
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setValues(times);
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            this.varNum = Integer.parseInt(dataArray[0]);
            if (this.varNum > dataArray.length - 1) {
                this.varNum = dataArray.length - 1;
            }
            for (i = 0; i < this.varNum; ++i) {
                this.varNames.add(dataArray[i + 1]);
            }
            sr.close();
            this.dataTables = this.readTable();
            this.endPointNum = 0;
            for (DataTable table : this.dataTables) {
                if (this.endPointNum >= table.getRowCount()) continue;
                this.endPointNum = table.getRowCount();
            }
            Dimension trajDim = new Dimension(DimensionType.OTHER);
            trajDim.setName("trajectory");
            trajDim.setLength(this.trajNum);
            this.addDimension(trajDim);
            Dimension obsDim = new Dimension(DimensionType.OTHER);
            obsDim.setName("obs");
            obsDim.setLength(this.endPointNum);
            this.addDimension(obsDim);
            for (String vName : this.inVarNames) {
                Variable var = new Variable();
                var.setName(vName);
                switch (vName) {
                    case "time": {
                        var.setDataType(DataType.DATE);
                        break;
                    }
                    case "run_hour": {
                        var.setDataType(DataType.INT);
                        break;
                    }
                    default: {
                        var.setDataType(DataType.FLOAT);
                    }
                }
                var.addDimension(trajDim);
                var.addDimension(obsDim);
                var.addAttribute("long_name", vName);
                this.addVariable(var);
            }
            for (String vName : this.varNames) {
                Variable var = new Variable();
                var.setName(vName);
                var.setDataType(DataType.FLOAT);
                var.addDimension(trajDim);
                var.addDimension(obsDim);
                var.addAttribute("long_name", vName);
                var.setStation(true);
                this.addVariable(var);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        dataInfo = dataInfo + "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory number = " + String.valueOf(this.trajNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory direction = " + this.trajDirection;
        dataInfo = dataInfo + System.getProperty("line.separator") + "Vertical motion =" + this.verticalMotion;
        dataInfo = dataInfo + System.getProperty("line.separator") + "Number of diagnostic output variables = " + String.valueOf(this.varNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Variables:";
        for (int i = 0; i < this.varNum; ++i) {
            dataInfo = dataInfo + " " + this.varNames.get(i);
        }
        dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "Trajectories:";
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        for (TrajectoryInfo aTrajInfo : this.trajInfoList) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "  " + format.format(aTrajInfo.startTime) + "  " + String.valueOf(aTrajInfo.startLat) + "  " + String.valueOf(aTrajInfo.startLon) + "  " + String.valueOf(aTrajInfo.startHeight);
        }
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        int[] origin = new int[]{0, 0};
        int[] size = new int[]{this.trajNum, this.endPointNum};
        int[] stride = new int[]{1, 1};
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            DataColumn col = this.dataTables.get(0).findColumn(varName);
            DataType dtype = DataType.FLOAT;
            switch (col.getDataType()) {
                case DATE: {
                    dtype = DataType.DOUBLE;
                    break;
                }
                case INT: {
                    dtype = DataType.INT;
                }
            }
            Section section = new Section(origin, size, stride);
            Array array = Array.factory((DataType)dtype, (int[])section.getShape());
            Range trajRange = section.getRange(0);
            Range obsRange = section.getRange(1);
            Index index = array.getIndex();
            for (int trajIdx = trajRange.first(); trajIdx <= trajRange.last(); trajIdx += trajRange.stride()) {
                DataTable dTable = this.dataTables.get(trajIdx);
                ColumnData colData = dTable.getColumnData(varName);
                for (int obsIdx = obsRange.first(); obsIdx <= obsRange.last(); obsIdx += obsRange.stride()) {
                    if (colData.size() > obsIdx) {
                        if (col.getDataType() == DataType.DATE) {
                            array.setObject(index, (Object)JDateUtil.toOADate((LocalDateTime)((LocalDateTime)colData.getValue(obsIdx))));
                        } else {
                            array.setObject(index, colData.getValue(obsIdx));
                        }
                    } else {
                        array.setObject(index, (Object)Double.NaN);
                    }
                    index.incr();
                }
            }
            return array;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<DataTable> readTable() throws Exception {
        ArrayList<DataTable> tables = new ArrayList<DataTable>();
        for (int i = 0; i < this.trajNum; ++i) {
            DataTable table = new DataTable();
            table.addColumn("time", DataType.DATE);
            table.addColumn("run_hour", DataType.FLOAT);
            table.addColumn("lat", DataType.FLOAT);
            table.addColumn("lon", DataType.FLOAT);
            table.addColumn("height", DataType.FLOAT);
            for (String vName : this.varNames) {
                table.addColumn(vName, DataType.FLOAT);
            }
            tables.add(table);
        }
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(this.getFileName()));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray((Object)dataArray, (int)dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int trajIdx = Integer.parseInt(dataArray[0]) - 1;
                DataTable table = (DataTable)tables.get(trajIdx);
                table.addRow();
                int rowIdx = table.getRowCount() - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                LocalDateTime tt = LocalDateTime.of(y, Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                table.setValue(rowIdx, "time", (Object)tt);
                table.setValue(rowIdx, "run_hour", (Object)Float.valueOf(Float.parseFloat(dataArray[8])));
                table.setValue(rowIdx, "lat", (Object)Float.valueOf(Float.parseFloat(dataArray[9])));
                table.setValue(rowIdx, "lon", (Object)Float.valueOf(Float.parseFloat(dataArray[10])));
                table.setValue(rowIdx, "height", (Object)Float.valueOf(Float.parseFloat(dataArray[11])));
                for (i = 12; i < dataArray.length; ++i) {
                    table.setValue(rowIdx, i - 7, (Object)Float.valueOf(Float.parseFloat(dataArray[i])));
                }
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tables;
    }

    public XYListDataset getXYDataset(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        LocalDateTime tt = LocalDateTime.now();
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray((Object)dataArray, (int)dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                tt = LocalDateTime.of(y, Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                PointD aPoint = new PointD();
                aPoint.X = JDateUtil.toOADate((LocalDateTime)tt);
                aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                ((List)PointList.get(TrajIdx)).add(aPoint);
            }
            for (i = 0; i < this.trajNum; ++i) {
                int n = ((List)PointList.get(i)).size();
                double[] xvs = new double[n];
                double[] yvs = new double[n];
                for (int j = 0; j < n; ++j) {
                    xvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).X;
                    yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                }
                dataset.addSeries("Traj_" + String.valueOf(this.trajNum), xvs, yvs);
            }
            sr.close();
        }
        catch (IOException | NumberFormatException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataset;
    }

    public XYListDataset getXYDataset_HourX(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        LocalDateTime tt = LocalDateTime.now();
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray((Object)dataArray, (int)dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                tt = LocalDateTime.of(y, Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                PointD aPoint = new PointD();
                aPoint.X = JDateUtil.toOADate((LocalDateTime)tt);
                aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                ((List)PointList.get(TrajIdx)).add(aPoint);
            }
            for (i = 0; i < this.trajNum; ++i) {
                int n = ((List)PointList.get(i)).size();
                double[] xvs = new double[n];
                double[] yvs = new double[n];
                LocalDateTime sdate = LocalDateTime.now();
                for (int j = 0; j < n; ++j) {
                    LocalDateTime cdate = JDateUtil.fromOADate((double)((PointD)((List)PointList.get((int)i)).get((int)j)).X);
                    if (j == 0) {
                        sdate = cdate;
                        xvs[j] = 0.0;
                    } else {
                        xvs[j] = Duration.between(sdate, cdate).toHours();
                    }
                    yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                }
                dataset.addSeries("Traj_" + String.valueOf(this.trajNum), xvs, yvs);
            }
            sr.close();
        }
        catch (IOException | NumberFormatException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataset;
    }
}

