/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class MICAPS4DataInfo
extends DataInfo
implements IGridDataInfo {
    private String _description;
    private double[] _xArray;
    private double[] _yArray;
    private int _headLineNum;
    private boolean _yReverse = false;
    private int _preHours;
    private int _level;

    public MICAPS4DataInfo() {
        this.setDataType(MeteoDataType.MICAPS_4);
        this.setMissingValue(9999.0);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            int i;
            String aLine;
            BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "gbk"));
            ArrayList<String> dataList = new ArrayList<String>();
            this.setFileName(fileName);
            this._description = aLine = sr.readLine().trim();
            aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i].isEmpty()) continue;
                dataList.add(dataArray[i]);
            }
            this._headLineNum = 2;
            for (int n = 0; n <= 10 && dataList.size() < 19; ++n) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                for (i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i].isEmpty()) continue;
                    dataList.add(dataArray[i]);
                }
                ++this._headLineNum;
            }
            sr.close();
            int year = Integer.parseInt((String)dataList.get(0));
            if (year < 100) {
                year = year < 50 ? 2000 + year : 1900 + year;
            }
            this._preHours = Integer.parseInt((String)dataList.get(4));
            LocalDateTime time = LocalDateTime.of(year, Integer.parseInt((String)dataList.get(1)), Integer.parseInt((String)dataList.get(2)), Integer.parseInt((String)dataList.get(3)), 0, 0);
            time = time.plusHours(this._preHours);
            this._level = Integer.parseInt((String)dataList.get(5));
            float XDelt = Float.parseFloat((String)dataList.get(6));
            float YDelt = Float.parseFloat((String)dataList.get(7));
            float XMin = Float.parseFloat((String)dataList.get(8));
            float XMax = Float.parseFloat((String)dataList.get(9));
            float YMin = Float.parseFloat((String)dataList.get(10));
            float YMax = Float.parseFloat((String)dataList.get(11));
            int XNum = Integer.parseInt((String)dataList.get(12));
            int YNum = Integer.parseInt((String)dataList.get(13));
            float contourDelt = Float.parseFloat((String)dataList.get(14));
            float contourSValue = Float.parseFloat((String)dataList.get(15));
            float contourEValue = Float.parseFloat((String)dataList.get(16));
            float smoothCo = Float.parseFloat((String)dataList.get(17));
            float boldValue = Float.parseFloat((String)dataList.get(18));
            boolean isLonLat = !((String)dataList.get(16)).equals("-1") && !((String)dataList.get(16)).equals("-2") && !((String)dataList.get(16)).equals("-3");
            this._xArray = new double[XNum];
            for (i = 0; i < XNum; ++i) {
                this._xArray[i] = XMin + (float)i * XDelt;
            }
            this._yArray = new double[YNum];
            this._yReverse = false;
            if (YDelt < 0.0f) {
                this._yReverse = true;
                YDelt = -YDelt;
            }
            if (YMin > YMax) {
                float temp = YMin;
                YMin = YMax;
                YMax = temp;
            }
            for (i = 0; i < YNum; ++i) {
                this._yArray[i] = YMin + (float)i * YDelt;
            }
            Dimension tdim = new Dimension(DimensionType.T);
            double[] values = new double[]{JDateUtil.toOADate((LocalDateTime)time)};
            tdim.setValues(values);
            this.setTimeDimension(tdim);
            this.addDimension(tdim);
            Dimension zdim = new Dimension(DimensionType.Z);
            zdim.setValues(new double[]{this._level});
            this.addDimension(zdim);
            Dimension xdim = new Dimension(DimensionType.X);
            xdim.setValues(this._xArray);
            this.setXDimension(xdim);
            Dimension ydim = new Dimension(DimensionType.Y);
            ydim.setValues(this._yArray);
            this.setYDimension(ydim);
            this.addDimension(ydim);
            this.addDimension(xdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Variable var = new Variable();
            var.setName("var");
            var.setDataType(DataType.FLOAT);
            var.setDimension(tdim);
            var.setDimension(zdim);
            var.setDimension(ydim);
            var.setDimension(xdim);
            var.setFillValue(this.getMissingValue());
            variables.add(var);
            this.setVariables(variables);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 2;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            this.readXY(yRange, xRange, ii);
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(Range yRange, Range xRange, IndexIterator ii) {
        try {
            int j;
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "gbk"));
            for (i = 0; i < this._headLineNum; ++i) {
                sr.readLine();
            }
            List<String> dataList = new ArrayList<String>();
            int col = 0;
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            float[][] theData = new float[yNum][xNum];
            while ((aLine = sr.readLine()) != null) {
                if (!(aLine = aLine.trim()).isEmpty()) {
                    String[] dataArray = aLine.split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                    if (col == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                        aLine = sr.readLine().trim();
                        dataArray = aLine.split("\\s+");
                        dataList.clear();
                        dataList.addAll(Arrays.asList(dataArray));
                    }
                    for (i = 0; i < 1000 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                        aLine = aLine.trim();
                        dataArray = aLine.split("\\s+");
                        dataList.addAll(Arrays.asList(dataArray));
                    }
                    for (i = 0; i < xNum; ++i) {
                        theData[col][i] = Float.parseFloat((String)dataList.get(i));
                    }
                    dataList = dataList.size() > xNum ? dataList.subList(xNum, dataList.size()) : new ArrayList();
                    ++col;
                }
                if (aLine != null) continue;
            }
            sr.close();
            float[] data = new float[yNum * xNum];
            if (this._yReverse) {
                for (i = 0; i < yNum; ++i) {
                    for (j = 0; j < xNum; ++j) {
                        data[i * xNum + j] = theData[yNum - 1 - i][j];
                    }
                }
            } else {
                for (i = 0; i < yNum; ++i) {
                    for (j = 0; j < xNum; ++j) {
                        data[i * xNum + j] = theData[i][j];
                    }
                }
            }
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "gbk"));
            for (i = 0; i < this._headLineNum; ++i) {
                sr.readLine();
            }
            ArrayList<String> dataList = new ArrayList<String>();
            int col = 0;
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            double[][] theData = new double[yNum][xNum];
            while ((aLine = sr.readLine()) != null) {
                if (!(aLine = aLine.trim()).isEmpty()) {
                    String[] dataArray = aLine.split("\\s+");
                    dataList.addAll(Arrays.asList(dataArray));
                    if (col == 0 && !MIMath.isNumeric((String)((String)dataList.get(0)))) {
                        aLine = sr.readLine().trim();
                        dataArray = aLine.split("\\s+");
                        dataList.clear();
                        dataList.addAll(Arrays.asList(dataArray));
                    }
                    for (i = 0; i < 1000 && dataList.size() < xNum && (aLine = sr.readLine()) != null; ++i) {
                        if ((aLine = aLine.trim()).isEmpty()) continue;
                        dataArray = aLine.split("\\s+");
                        dataList.addAll(Arrays.asList(dataArray));
                    }
                    for (i = 0; i < xNum; ++i) {
                        theData[col][i] = Double.parseDouble((String)dataList.get(i));
                    }
                    dataList = dataList.size() > xNum ? new ArrayList(dataList.subList(xNum, dataList.size())) : new ArrayList();
                    ++col;
                }
                if (aLine != null) continue;
            }
            sr.close();
            double[][] newGridData = new double[yNum][xNum];
            if (!this._yReverse) {
                newGridData = theData;
            } else {
                for (i = 0; i < yNum; ++i) {
                    for (int j = 0; j < xNum; ++j) {
                        newGridData[i][j] = theData[yNum - 1 - i][j];
                    }
                }
            }
            return new GridData(newGridData, this.getXDimension().getValues(), this.getYDimension().getValues(), this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

