/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.mm5;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.mm5.DataHead;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;

public class MM5IMDataInfo
extends DataInfo
implements IGridDataInfo {
    private final ByteOrder _byteOrder = ByteOrder.BIG_ENDIAN;
    private DataOutputStream _bw = null;
    private final List<DataHead> _dataHeads = new ArrayList<DataHead>();

    public MM5IMDataInfo() {
        this.setDataType(MeteoDataType.MM5IM);
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            ArrayList<Variable> variables = new ArrayList<Variable>();
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            while (br.getFilePointer() < br.length() - 100L) {
                int i;
                long pos = br.getFilePointer();
                DataHead dh = this.readDataHead(br);
                if (!times.contains(dh.getDate())) {
                    times.add(dh.getDate());
                }
                dh.position = pos;
                dh.length = (int)(br.getFilePointer() - pos);
                this._dataHeads.add(dh);
                int n = dh.idim * dh.jdim;
                br.skipBytes(n * 4 + 8);
                boolean isNewVar = true;
                for (Variable var : variables) {
                    if (!var.getName().equals(dh.field)) continue;
                    isNewVar = false;
                    var.addLevel(dh.level);
                    break;
                }
                if (!isNewVar) continue;
                Variable var = new Variable();
                var.setName(dh.field);
                var.addLevel(dh.level);
                var.setUnits(dh.units);
                var.setDescription(dh.desc);
                double[] X = new double[dh.idim];
                for (i = 0; i < dh.idim; ++i) {
                    X[i] = dh.startlon + dh.deltalon * (float)i;
                }
                double[] Y = new double[dh.jdim];
                for (i = 0; i < dh.jdim; ++i) {
                    Y[i] = dh.startlat + dh.deltalat * (float)(dh.jdim - 1 - i);
                }
                Dimension xdim = new Dimension(DimensionType.X);
                xdim.setValues(X);
                Dimension ydim = new Dimension(DimensionType.Y);
                ydim.setValues(Y);
                var.setXDimension(xdim);
                var.setYDimension(ydim);
                variables.add(var);
                if (this._dataHeads.size() != 1) continue;
                this.setXDimension(xdim);
                this.setYDimension(ydim);
            }
            ArrayList<Double> values = new ArrayList<Double>();
            for (LocalDateTime t : times) {
                values.add(JDateUtil.toOADate((LocalDateTime)t));
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            for (Variable var : variables) {
                var.updateZDimension();
                var.setTDimension(tDim);
            }
            this.setVariables(variables);
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private DataHead readDataHead(RandomAccessFile br) throws IOException {
        DataHead dh = new DataHead();
        br.skipBytes(4);
        byte[] bytes = new byte[4];
        br.read(bytes);
        dh.iversion = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this._byteOrder);
        br.skipBytes(4);
        br.skipBytes(4);
        bytes = new byte[24];
        br.read(bytes);
        dh.hdate = new String(bytes).trim();
        bytes = new byte[4];
        br.read(bytes);
        dh.xfcst = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
        bytes = new byte[9];
        br.read(bytes);
        dh.field = new String(bytes).trim();
        dh.field = dh.field.split("\\s+")[0];
        bytes = new byte[25];
        br.read(bytes);
        dh.units = new String(bytes).trim();
        bytes = new byte[46];
        br.read(bytes);
        dh.desc = new String(bytes).trim();
        bytes = new byte[4];
        br.read(bytes);
        dh.level = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
        br.read(bytes);
        dh.idim = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this._byteOrder);
        br.read(bytes);
        dh.jdim = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this._byteOrder);
        br.read(bytes);
        dh.llflag = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this._byteOrder);
        br.skipBytes(4);
        br.skipBytes(4);
        if (dh.llflag == 0) {
            br.read(bytes);
            dh.startlat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
            br.read(bytes);
            dh.startlon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
            br.read(bytes);
            dh.deltalat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
            br.read(bytes);
            dh.deltalon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
        }
        br.skipBytes(4);
        return dh;
    }

    private DataHead findDataHead(String varName, double level) {
        for (DataHead dh : this._dataHeads) {
            if (!dh.field.equals(varName) || (double)dh.level != level) continue;
            return dh;
        }
        return this._dataHeads.get(0);
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Xsize = " + String.valueOf(this.getXDimension().getLength()) + "  Ysize = " + String.valueOf(this.getYDimension().getLength());
        dataInfo = dataInfo + System.getProperty("line.separator") + "Number of Variables = " + String.valueOf(this.getVariableNum());
        for (String v : this.getVariableNames()) {
            dataInfo = dataInfo + System.getProperty("line.separator") + v;
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            int i;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            Variable var = this.getVariable(varName);
            DataHead dh = this.findDataHead(var.getName(), var.getLevels().get(levelIdx));
            br.seek(dh.position + (long)dh.length);
            int n = dh.idim * dh.jdim;
            br.skipBytes(4);
            byte[] dataBytes = new byte[n * 4];
            br.read(dataBytes);
            br.close();
            double[][] theData = new double[dh.jdim][dh.idim];
            int start = 0;
            byte[] bytes = new byte[4];
            for (i = 0; i < dh.jdim; ++i) {
                for (int j = 0; j < dh.idim; ++j) {
                    System.arraycopy(dataBytes, start, bytes, 0, 4);
                    theData[dh.jdim - 1 - i][j] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                    start += 4;
                }
            }
            double[] X = new double[dh.idim];
            for (i = 0; i < dh.idim; ++i) {
                X[i] = dh.startlon + dh.deltalon * (float)i;
            }
            double[] Y = new double[dh.jdim];
            for (i = 0; i < dh.jdim; ++i) {
                Y[i] = dh.startlat + dh.deltalat * (float)(dh.jdim - 1 - i);
            }
            return new GridData(theData, X, Y, this.getMissingValue());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void createDataFile(String fileName) {
        try {
            this._bw = new DataOutputStream(new FileOutputStream(new File(fileName)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeDataFile() {
        try {
            this._bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeDataHead(DataHead dh) throws IOException {
        int skip = 4;
        this._bw.writeInt(skip);
        this._bw.writeInt(dh.iversion);
        this._bw.writeInt(skip);
        skip = 124;
        this._bw.writeInt(skip);
        this._bw.writeBytes(GlobalUtil.padRight((String)dh.hdate, (int)24, (char)' '));
        this._bw.writeFloat(dh.xfcst);
        this._bw.writeBytes(GlobalUtil.padRight((String)dh.field, (int)9, (char)' '));
        this._bw.writeBytes(GlobalUtil.padRight((String)dh.units, (int)25, (char)' '));
        this._bw.writeBytes(GlobalUtil.padRight((String)dh.desc, (int)46, (char)' '));
        this._bw.writeFloat(dh.level);
        this._bw.writeInt(dh.idim);
        this._bw.writeInt(dh.jdim);
        this._bw.writeInt(dh.llflag);
        this._bw.writeInt(skip);
        skip = 16;
        this._bw.writeInt(skip);
        this._bw.writeFloat(dh.startlat);
        this._bw.writeFloat(dh.startlon);
        this._bw.writeFloat(dh.deltalat);
        this._bw.writeFloat(dh.deltalon);
        this._bw.writeInt(skip);
    }

    public void writeGridData(GridData gridData) throws IOException {
        int xn = gridData.getXNum();
        int yn = gridData.getYNum();
        byte[] dataBytes = new byte[xn * yn * 4];
        int start = 0;
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn; ++j) {
                byte[] bytes = DataConvert.float2Bytes((float)((Float)gridData.getValue(yn - 1 - i, j)).floatValue(), (ByteOrder)this._byteOrder);
                for (int k = 0; k < 4; ++k) {
                    dataBytes[start + k] = bytes[k];
                }
                start += 4;
            }
        }
        int skip = xn * yn * 4;
        this._bw.writeInt(skip);
        this._bw.write(dataBytes);
        this._bw.writeInt(skip);
    }
}

