/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.ResampleMethods;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;

public class GridArray {
    private Array data;
    private Index2D index2D;
    public double[] xArray;
    public double[] yArray;
    public double missingValue;
    public ProjectionInfo projInfo = null;
    public String fieldName = "Data";
    private boolean _xStag = false;
    private boolean _yStag = false;

    public GridArray() {
        this.missingValue = -9999.0;
    }

    public GridArray(GridArray aGridData) {
        this.projInfo = aGridData.projInfo;
        this.xArray = (double[])aGridData.xArray.clone();
        this.yArray = (double[])aGridData.yArray.clone();
        this.missingValue = aGridData.missingValue;
        this.setData(aGridData.data.copy());
    }

    public GridArray(double xStart, double xDelt, int xNum, double yStart, double yDelt, int yNum) {
        int i;
        this.xArray = new double[xNum];
        this.yArray = new double[yNum];
        for (i = 0; i < xNum; ++i) {
            this.xArray[i] = BigDecimalUtil.add((double)xStart, (double)BigDecimalUtil.mul((double)xDelt, (double)i));
        }
        for (i = 0; i < yNum; ++i) {
            this.yArray[i] = BigDecimalUtil.add((double)yStart, (double)BigDecimalUtil.mul((double)yDelt, (double)i));
        }
        this.missingValue = -9999.0;
        int[] shape = new int[]{yNum, xNum};
        this.setData(Array.factory((DataType)DataType.DOUBLE, (int[])shape));
    }

    public GridArray(Array array, List<Number> xdata, List<Number> ydata, double missingValue, ProjectionInfo projInfo) {
        int i;
        int yn = ydata.size();
        int xn = xdata.size();
        this.setData(array);
        this.xArray = new double[xn];
        this.yArray = new double[yn];
        for (i = 0; i < xn; ++i) {
            this.xArray[i] = xdata.get(i).doubleValue();
        }
        for (i = 0; i < yn; ++i) {
            this.yArray[i] = ydata.get(i).doubleValue();
        }
        this.missingValue = missingValue;
        this.projInfo = projInfo;
    }

    public GridArray(Array array, Array xdata, Array ydata, Number missingValue, ProjectionInfo projInfo) {
        int i;
        int yn = (int)ydata.getSize();
        int xn = (int)xdata.getSize();
        this.setData(array);
        this.xArray = new double[xn];
        this.yArray = new double[yn];
        IndexIterator iter = xdata.getIndexIterator();
        for (i = 0; i < xn; ++i) {
            this.xArray[i] = iter.getDoubleNext();
        }
        iter = ydata.getIndexIterator();
        for (i = 0; i < yn; ++i) {
            this.yArray[i] = iter.getDoubleNext();
        }
        this.missingValue = missingValue.doubleValue();
        this.projInfo = projInfo;
    }

    public GridArray(Array array, Array xdata, Array ydata, Number missingValue) {
        int i;
        int yn = (int)ydata.getSize();
        int xn = (int)xdata.getSize();
        this.setData(array);
        this.xArray = new double[xn];
        this.yArray = new double[yn];
        IndexIterator iter = xdata.getIndexIterator();
        for (i = 0; i < xn; ++i) {
            this.xArray[i] = iter.getDoubleNext();
        }
        iter = ydata.getIndexIterator();
        for (i = 0; i < yn; ++i) {
            this.yArray[i] = iter.getDoubleNext();
        }
        this.missingValue = missingValue.doubleValue();
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public Array getData() {
        return this.data;
    }

    public void setData(Array value) {
        this.data = value;
        this.index2D = (Index2D)this.data.getIndex();
    }

    public int getXNum() {
        return this.xArray.length;
    }

    public int getYNum() {
        return this.yArray.length;
    }

    public double getXDelt() {
        return BigDecimalUtil.sub((double)this.xArray[1], (double)this.xArray[0]);
    }

    public double getYDelt() {
        return BigDecimalUtil.sub((double)this.yArray[1], (double)this.yArray[0]);
    }

    public Extent getExtent() {
        Extent extent = new Extent();
        extent.minX = this.xArray[0];
        extent.maxX = this.xArray[this.xArray.length - 1];
        extent.minY = this.yArray[0];
        extent.maxY = this.yArray[this.yArray.length - 1];
        return extent;
    }

    public boolean isGlobal() {
        boolean isGlobal = false;
        if (MIMath.doubleEquals((double)(this.xArray[this.getXNum() - 1] + this.getXDelt() - this.xArray[0]), (double)360.0)) {
            isGlobal = true;
        }
        return isGlobal;
    }

    public boolean isXStagger() {
        return this._xStag;
    }

    public void setXStagger(boolean value) {
        this._xStag = value;
    }

    public boolean isYStagger() {
        return this._yStag;
    }

    public void setYStagger(boolean value) {
        this._yStag = value;
    }

    public Number getValue(int i, int j) {
        switch (this.data.getDataType()) {
            case UBYTE: {
                return this.data.getInt(this.index2D.set(i, j));
            }
            case USHORT: {
                return this.data.getInt(this.index2D.set(i, j));
            }
            case UINT: {
                return this.data.getLong(this.index2D.set(i, j));
            }
        }
        return (Number)this.data.getObject(this.index2D.set(i, j));
    }

    public double getDoubleValue(int i, int j) {
        return this.data.getDouble(this.index2D.set(i, j));
    }

    public List<Dimension> getDimensions() {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension ydim = new Dimension(DimensionType.Y);
        ydim.setValues(this.yArray);
        dims.add(ydim);
        Dimension xdim = new Dimension(DimensionType.X);
        xdim.setValues(this.xArray);
        dims.add(xdim);
        return dims;
    }

    public double getXMin() {
        return this.xArray[0];
    }

    public double getXMax() {
        return this.xArray[this.xArray.length - 1];
    }

    public double getYMin() {
        return this.yArray[0];
    }

    public double getYMax() {
        return this.yArray[this.yArray.length - 1];
    }

    public double getBorderXMin() {
        return this.getXMin() - this.getXDelt() / 2.0;
    }

    public double getBorderXMax() {
        return this.getXMax() + this.getXDelt() / 2.0;
    }

    public double getBorderYMin() {
        return this.getYMin() - this.getYDelt() / 2.0;
    }

    public double getBorderYMax() {
        return this.getYMax() + this.getYDelt() / 2.0;
    }

    public int[] getIJIndex(double x, double y) {
        int xidx = -1;
        int yidx = -1;
        if (x >= this.getBorderXMin() && x <= this.getBorderXMax() && y >= this.getBorderYMin() && y <= this.getBorderYMax()) {
            xidx = (int)((x - this.getBorderXMin()) / this.getXDelt());
            yidx = (int)((y - this.getBorderYMin()) / this.getYDelt());
        }
        if (xidx >= this.getXNum() || yidx >= this.getYNum()) {
            xidx = -1;
            yidx = -1;
        }
        return new int[]{xidx, yidx};
    }

    public boolean testUniqueValues() {
        ArrayList<Number> values = new ArrayList<Number>();
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (MIMath.doubleEquals((double)this.getValue(i, j).doubleValue(), (double)this.missingValue)) continue;
                if (vdNum == 0) {
                    values.add(this.getValue(i, j));
                    ++vdNum;
                } else if (!values.contains(this.getValue(i, j))) {
                    values.add(this.getValue(i, j));
                    ++vdNum;
                }
                if (vdNum <= 20) continue;
                return false;
            }
        }
        return true;
    }

    public List<Number> getUniqueValues() {
        ArrayList<Number> values = new ArrayList();
        int vdNum = 0;
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                if (Double.isNaN(this.getValue(i, j).doubleValue()) || MIMath.doubleEquals((double)this.getValue(i, j).doubleValue(), (double)this.missingValue)) continue;
                if (vdNum == 0) {
                    values.add(this.getValue(i, j));
                } else if (!values.contains(this.getValue(i, j))) {
                    values.add(this.getValue(i, j));
                }
                ++vdNum;
            }
        }
        values = values.stream().sorted().collect(Collectors.toList());
        return values;
    }

    public GridDataSetting getGridDataSetting() {
        GridDataSetting gDataSet = new GridDataSetting();
        gDataSet.dataExtent = (Extent)this.getExtent().clone();
        gDataSet.xNum = this.getXNum();
        gDataSet.yNum = this.getYNum();
        return gDataSet;
    }

    public boolean getMaxMinValue(double[] maxmin) {
        double max = 0.0;
        double min = 0.0;
        int vdNum = 0;
        boolean hasUndef = false;
        IndexIterator iter = this.data.getIndexIterator();
        while (iter.hasNext()) {
            double v = iter.getDoubleNext();
            if (Double.isNaN(v) || MIMath.doubleEquals((double)v, (double)this.missingValue)) {
                hasUndef = true;
                continue;
            }
            if (vdNum == 0) {
                max = min = v;
            } else {
                if (min > v) {
                    min = v;
                }
                if (max < v) {
                    max = v;
                }
            }
            ++vdNum;
        }
        maxmin[0] = max;
        maxmin[1] = min;
        return hasUndef;
    }

    public double min() {
        return ArrayMath.getMinimum((Array)this.data, (double)this.missingValue);
    }

    public double max() {
        return ArrayMath.getMaximum((Array)this.data, (double)this.missingValue);
    }

    public boolean hasNaN() {
        return ArrayMath.containsNaN((Array)this.data);
    }

    public GridArray project(ProjectionInfo toProj) throws InvalidRangeException {
        if (this.projInfo == null) {
            return null;
        }
        return this.project(this.projInfo, toProj, ResampleMethods.NearestNeighbor);
    }

    public GridArray project(ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods resampleMethod) throws InvalidRangeException {
        int i;
        int xnum = this.getXNum();
        int ynum = this.getYNum();
        Extent aExtent = this.isGlobal() || this.xArray[xnum - 1] - this.xArray[0] == 360.0 ? ProjectionUtil.getProjectionGlobalExtent((ProjectionInfo)toProj) : ProjectionUtil.getProjectionExtent((ProjectionInfo)fromProj, (ProjectionInfo)toProj, (double[])this.xArray, (double[])this.yArray);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            x.add(this.xArray[i]);
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            y.add(this.yArray[i]);
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array[] rxy = ArrayUtil.meshgrid((Array)rx, (Array)ry);
        Array rrx = rxy[0];
        Array rry = rxy[1];
        Array r = Reproject.reproject((Array)this.data, x, y, (Array)rrx, (Array)rry, (ProjectionInfo)fromProj, (ProjectionInfo)toProj, (double)this.missingValue, (ResampleMethods)resampleMethod);
        GridArray rdata = new GridArray(r, rx, ry, this.missingValue);
        rdata.projInfo = toProj;
        return rdata;
    }

    public void saveAsSurferASCIIFile(String aFile) {
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
            sw.write("DSAA");
            sw.newLine();
            sw.write(String.valueOf(this.getXNum()) + " " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write(String.valueOf(this.xArray[0]) + " " + String.valueOf(this.xArray[this.xArray.length - 1]));
            sw.newLine();
            sw.write(String.valueOf(this.yArray[0]) + " " + String.valueOf(this.yArray[this.yArray.length - 1]));
            sw.newLine();
            double[] maxmin = new double[2];
            this.getMaxMinValue(maxmin);
            sw.write(String.valueOf(maxmin[1]) + " " + String.valueOf(maxmin[0]));
            String aLine = "";
            for (int i = 0; i < this.getYNum(); ++i) {
                for (int j = 0; j < this.getXNum(); ++j) {
                    Number value = this.getValue(i, j);
                    aLine = j == 0 ? value.toString() : aLine + " " + value.toString();
                }
                sw.newLine();
                sw.write(aLine);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsESRIASCIIFile(String aFile) {
        if (this.getXDelt() != this.getYDelt()) {
            JOptionPane.showMessageDialog(null, "X cell size is not equal y cell size!", "Error", 0);
            return;
        }
        try {
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
            sw.write("NCOLS " + String.valueOf(this.getXNum()));
            sw.newLine();
            sw.write("NROWS " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write("XLLCENTER " + String.valueOf(this.xArray[0]));
            sw.newLine();
            sw.write("YLLCENTER " + String.valueOf(this.yArray[0]));
            sw.newLine();
            sw.write("CELLSIZE " + String.valueOf(this.getXDelt()));
            sw.newLine();
            sw.write("NODATA_VALUE " + String.valueOf(this.missingValue));
            String aLine = "";
            int xn = this.getXNum();
            int yn = this.getYNum();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    String value = this.getValue(yn - i - 1, j).toString();
                    aLine = j == 0 ? value : aLine + " " + value;
                }
                sw.newLine();
                sw.write(aLine);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsBILFile(String fileName) throws IOException {
        try {
            DataOutputStream outs = new DataOutputStream(new FileOutputStream(fileName));
            int xn = this.getXNum();
            int yn = this.getYNum();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    outs.writeFloat((float)this.getDoubleValue(yn - i - 1, j));
                }
            }
            outs.close();
            String hfn = fileName.replace(".bil", ".hdr");
            BufferedWriter sw = new BufferedWriter(new FileWriter(new File(hfn)));
            sw.write("nrows " + String.valueOf(this.getYNum()));
            sw.newLine();
            sw.write("ncols " + String.valueOf(this.getXNum()));
            sw.newLine();
            sw.write("nbands 1");
            sw.newLine();
            sw.write("nbits 32");
            sw.newLine();
            sw.write("pixeltype float");
            sw.newLine();
            sw.write("byteorder M");
            sw.newLine();
            sw.write("layout bil");
            sw.newLine();
            sw.write("ulxmap " + String.valueOf(this.xArray[0]));
            sw.newLine();
            sw.write("ulymap " + String.valueOf(this.yArray[this.yArray.length - 1]));
            sw.newLine();
            sw.write("xdim " + String.valueOf(this.getXDelt()));
            sw.newLine();
            sw.write("ydim " + String.valueOf(this.getYDelt()));
            sw.newLine();
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GridData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAsMICAPS4File(String aFile, String description, LocalDateTime aTime, int hours, int level, float smooth, float boldValue, String floatFormat) throws IOException {
        double undef = 9999.0;
        double[] maxmin = new double[2];
        this.getMaxMinValue(maxmin);
        double min = maxmin[1];
        double max = maxmin[0];
        double[] CValues = MIMath.getIntervalValues((double)min, (double)max);
        double cDelt = 0.0;
        if (CValues.length > 1) {
            cDelt = CValues[1] - CValues[0];
        }
        if (floatFormat == null) {
            int dNum = MIMath.getDecimalNum((double)min);
            floatFormat = "%." + String.valueOf(dNum) + "f";
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yy MM dd HH");
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
        sw.write("diamond 4 " + description);
        sw.newLine();
        String aLine = format.format(aTime) + " " + String.valueOf(hours) + " " + String.valueOf(level);
        sw.write(aLine);
        sw.newLine();
        aLine = String.valueOf(this.getXDelt()) + " " + String.valueOf(this.getYDelt()) + " " + String.valueOf(this.xArray[0]) + " " + String.valueOf(this.xArray[this.getXNum() - 1]) + " " + String.valueOf(this.yArray[0]) + " " + String.valueOf(this.yArray[this.getYNum() - 1]);
        sw.write(aLine);
        sw.newLine();
        aLine = String.valueOf(this.getXNum()) + " " + String.valueOf(this.getYNum()) + " " + String.valueOf(cDelt) + " " + String.valueOf(CValues[0]) + " " + String.valueOf(CValues[CValues.length - 1]) + " " + String.valueOf(smooth) + " " + String.valueOf(boldValue);
        sw.write(aLine);
        sw.newLine();
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                double value = this.getDoubleValue(i, j);
                if (Double.isNaN(value)) {
                    value = undef;
                } else if (MIMath.doubleEquals((double)value, (double)this.missingValue)) {
                    value = undef;
                }
                aLine = j == 0 ? String.format(floatFormat, value) : aLine + " " + String.format(floatFormat, value);
            }
            sw.write(aLine);
            sw.newLine();
        }
        sw.close();
    }

    public void saveAsMICAPS4File(String aFile, String description, LocalDateTime aTime, int hours, int level, float smooth, float boldValue, String floatFormat, ProjectionInfo projInfo) throws IOException {
        double undef = 9999.0;
        double[] maxmin = new double[2];
        this.getMaxMinValue(maxmin);
        double min = maxmin[1];
        double max = maxmin[0];
        double[] CValues = MIMath.getIntervalValues((double)min, (double)max);
        double cDelt = CValues[1] - CValues[0];
        if (floatFormat == null) {
            int dNum = MIMath.getDecimalNum((double)min);
            floatFormat = "%1$." + String.valueOf(dNum) + "f";
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yy MM dd HH");
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(aFile)));
        sw.write("diamond 4 " + description);
        String aLine = format.format(aTime) + " " + String.valueOf(hours) + " " + String.valueOf(level);
        sw.write(aLine);
        sw.newLine();
        double eCValue = CValues[CValues.length - 1];
        double xdelt = this.getXDelt();
        double ydelt = this.getYDelt();
        double sLon = this.xArray[0];
        double eLon = this.xArray[this.getXNum() - 1];
        double sLat = this.yArray[0];
        double eLat = this.yArray[this.getYNum() - 1];
        if (!projInfo.isLonLat()) {
            switch (projInfo.getProjectionName()) {
                case Lambert_Conformal_Conic: {
                    eCValue = -1.0;
                    break;
                }
                case Mercator: {
                    eCValue = -2.0;
                    break;
                }
                case North_Polar_Stereographic_Azimuthal: {
                    eCValue = -3.0;
                }
            }
            ProjectionInfo toProj = KnownCoordinateSystems.geographic.world.WGS1984;
            double[][] points = new double[][]{{sLon, sLat}, {eLon, eLat}};
            Reproject.reprojectPoints((double[][])points, (ProjectionInfo)projInfo, (ProjectionInfo)toProj, (int)0, (int)2);
            xdelt = points[1][0];
            ydelt = points[0][1];
            sLon = points[0][0];
            sLat = points[0][1];
            eLon = points[1][0];
            eLat = points[1][1];
        }
        aLine = String.valueOf(xdelt) + " " + String.valueOf(ydelt) + " " + String.valueOf(sLon) + " " + String.valueOf(eLon) + " " + String.valueOf(sLat) + " " + String.valueOf(eLat);
        sw.write(aLine);
        sw.newLine();
        aLine = String.valueOf(this.getXNum()) + " " + String.valueOf(this.getYNum()) + " " + String.valueOf(cDelt) + " " + String.valueOf(CValues[0]) + " " + String.valueOf(eCValue) + " " + String.valueOf(smooth) + " " + String.valueOf(boldValue);
        sw.write(aLine);
        sw.newLine();
        for (int i = 0; i < this.getYNum(); ++i) {
            for (int j = 0; j < this.getXNum(); ++j) {
                double value = this.getDoubleValue(i, j);
                if (Double.isNaN(value)) {
                    value = undef;
                } else if (MIMath.doubleEquals((double)value, (double)this.missingValue)) {
                    value = undef;
                }
                aLine = j == 0 ? String.format(floatFormat, value) : aLine + " " + String.format(floatFormat, value);
            }
            sw.write(aLine);
            sw.newLine();
        }
        sw.close();
    }

    public Object clone() {
        GridArray newGriddata = new GridArray(this);
        return newGriddata;
    }
}

