/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.geotiff;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.mapdata.geotiff.FieldType;
import org.meteoinfo.data.mapdata.geotiff.GeoKey;
import org.meteoinfo.data.mapdata.geotiff.Tag;

public class IFDEntry
implements Comparable {
    protected Tag tag;
    protected FieldType type;
    protected long count;
    protected int[] value;
    protected long[] valueL;
    protected double[] valueD;
    protected String valueS;
    protected List<GeoKey> geokeys = null;

    IFDEntry(Tag tag, FieldType type) {
        this.tag = tag;
        this.type = type;
        this.count = 1L;
    }

    IFDEntry(Tag tag, FieldType type, long count) {
        this.tag = tag;
        this.type = type;
        this.count = count;
    }

    public IFDEntry setValue(int v) {
        this.value = new int[1];
        this.value[0] = v;
        return this;
    }

    public IFDEntry setValue(int n, int d) {
        this.value = new int[2];
        this.value[0] = n;
        this.value[1] = d;
        return this;
    }

    public IFDEntry setValue(int n, int d, int f) {
        this.value = new int[3];
        this.value[0] = n;
        this.value[1] = d;
        this.value[2] = f;
        return this;
    }

    public IFDEntry setValue(int[] v) {
        this.count = v.length;
        this.value = (int[])v.clone();
        return this;
    }

    public IFDEntry setValue(double v) {
        this.count = 1L;
        this.valueD = new double[1];
        this.valueD[0] = v;
        return this;
    }

    public IFDEntry setValue(double[] v) {
        this.count = v.length;
        this.valueD = (double[])v.clone();
        return this;
    }

    public IFDEntry setValue(String v) {
        this.count = v.length();
        this.valueS = v;
        return this;
    }

    public void addGeoKey(GeoKey geokey) {
        if (this.geokeys == null) {
            this.geokeys = new ArrayList<GeoKey>();
        }
        this.geokeys.add(geokey);
    }

    public GeoKey findGeoKey(GeoKey.Tag tag) {
        for (GeoKey geoKey : this.geokeys) {
            if (geoKey.tag != tag) continue;
            return geoKey;
        }
        return null;
    }

    public int compareTo(Object o) {
        return this.tag.compareTo(((IFDEntry)o).tag);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(" tag = " + this.tag);
        sbuf.append(" type = " + this.type);
        sbuf.append(" count = " + this.count);
        sbuf.append(" values = ");
        if (this.type == FieldType.ASCII) {
            sbuf.append(this.valueS);
        } else if (this.type == FieldType.RATIONAL) {
            for (int i = 0; i < 2; i += 2) {
                if (i > 1) {
                    sbuf.append(", ");
                }
                sbuf.append(this.value[i] + "/" + this.value[i + 1]);
            }
        } else if (this.type == FieldType.DOUBLE || this.type == FieldType.FLOAT) {
            int i = 0;
            while ((long)i < this.count) {
                sbuf.append(this.valueD[i] + " ");
                ++i;
            }
        } else if (this.type == FieldType.LONG8 || this.type == FieldType.SLONG8) {
            int i = 0;
            while ((long)i < this.count) {
                sbuf.append(this.valueL[i] + " ");
                ++i;
            }
        } else {
            long n = Math.min(this.count, 30L);
            int i = 0;
            while ((long)i < n) {
                sbuf.append(this.value[i] + " ");
                ++i;
            }
        }
        if (this.geokeys != null) {
            sbuf.append("\n");
            for (int i = 0; i < this.geokeys.size(); ++i) {
                GeoKey elem = this.geokeys.get(i);
                sbuf.append("        " + elem + "\n");
            }
        }
        return sbuf.toString();
    }
}

