/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.grads;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.io.EndianDataOutputStream;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.arl.ARLDataInfo;
import org.meteoinfo.data.meteodata.grads.Options;
import org.meteoinfo.data.meteodata.grads.PDEFS;
import org.meteoinfo.data.meteodata.grads.PDEF_LCC;
import org.meteoinfo.data.meteodata.grads.STData;
import org.meteoinfo.data.meteodata.grads.STDataHead;
import org.meteoinfo.data.meteodata.grads.STLevData;
import org.meteoinfo.data.meteodata.grads.TDEFS;
import org.meteoinfo.data.meteodata.grads.VARDEFS;
import org.meteoinfo.data.meteodata.grads.XDEFS;
import org.meteoinfo.data.meteodata.grads.YDEFS;
import org.meteoinfo.data.meteodata.grads.ZDEFS;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.Reproject;

public class GrADSDataInfo
extends DataInfo
implements IGridDataInfo,
IStationDataInfo {
    public String DESCRIPTOR = "null";
    public String DSET;
    public boolean isLatLon = true;
    public boolean EarthWind = true;
    public String DTYPE = "Gridded";
    public Options OPTIONS;
    public String TITLE = "null";
    public PDEFS PDEF;
    public XDEFS XDEF = new XDEFS();
    public YDEFS YDEF = new YDEFS();
    public ZDEFS ZDEF = new ZDEFS();
    public TDEFS TDEF = new TDEFS();
    private List<String> ensNames = new ArrayList<String>();
    public VARDEFS VARDEF = new VARDEFS();
    public int FILEHEADER = 0;
    public int THEADER = 0;
    public int XYHEADER = 0;
    public boolean isGlobal = false;
    public int RecordLen;
    public long RecLenPerTime;
    public double[] X;
    public double[] Y;
    public int XNum;
    public int YNum;
    private DataOutputStream _bw = null;
    private ByteOrder _byteOrder = ByteOrder.LITTLE_ENDIAN;

    public GrADSDataInfo() {
        this.OPTIONS = new Options();
        this.PDEF = new PDEFS();
        this.setDataType(MeteoDataType.GRADS_GRID);
    }

    public List<String> getVarNames() {
        ArrayList<String> varList = new ArrayList<String>();
        for (Variable aVar : this.VARDEF.getVars()) {
            varList.add(aVar.getName());
        }
        return varList;
    }

    public List<Variable> getUpperVariables() {
        ArrayList<Variable> uVarList = new ArrayList<Variable>();
        for (Variable aVar : this.VARDEF.getVars()) {
            if (aVar.getLevelNum() <= 1) continue;
            uVarList.add(aVar);
        }
        return uVarList;
    }

    public List<String> getUpperVariableNames() {
        ArrayList<String> uVarList = new ArrayList<String>();
        for (Variable aVar : this.VARDEF.getVars()) {
            if (aVar.getLevelNum() <= 1) continue;
            uVarList.add(aVar.getName());
        }
        return uVarList;
    }

    @Override
    public List<LocalDateTime> getTimes() {
        return this.TDEF.times;
    }

    public boolean isBigEndian() {
        return this._byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public void setBigEndian(boolean value) {
        this._byteOrder = value ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public static boolean canOpen(String fileName) {
        try {
            BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
            return true;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public void readDataInfo(String aFile) {
        String eStr = "";
        try {
            this.readDataInfo(aFile, eStr);
            if (this.OPTIONS.big_endian || this.OPTIONS.byteswapped) {
                this._byteOrder = ByteOrder.BIG_ENDIAN;
            }
            this.setTimes(this.TDEF.times);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean readDataInfo(String aFile, String errorStr) throws FileNotFoundException, IOException {
        this.setFileName(aFile);
        sr = new BufferedReader(new FileReader(new File(aFile)));
        aLine = "";
        isEnd = false;
        this.DESCRIPTOR = aFile;
        isReadLine = true;
        isNotPath = false;
        eDim = null;
        this.addAttribute(new Attribute("data_format", "GrADS binary"));
        do {
            if (isReadLine && (aLine = sr.readLine().trim()).isEmpty()) continue;
            isReadLine = true;
            dataArray = aLine.split("(\\s*,\\s*|\\s+)");
            var13_14 = hStr = dataArray[0].toUpperCase();
            var14_15 = -1;
            switch (var13_14.hashCode()) {
                case 2107774: {
                    if (!var13_14.equals("DSET")) break;
                    var14_15 = 0;
                    break;
                }
                case 65389950: {
                    if (!var13_14.equals("DTYPE")) break;
                    var14_15 = 1;
                    break;
                }
                case -531492226: {
                    if (!var13_14.equals("OPTIONS")) break;
                    var14_15 = 2;
                    break;
                }
                case 80890540: {
                    if (!var13_14.equals("UNDEF")) break;
                    var14_15 = 3;
                    break;
                }
                case 79833656: {
                    if (!var13_14.equals("TITLE")) break;
                    var14_15 = 4;
                    break;
                }
                case -1421363447: {
                    if (!var13_14.equals("FILEHEADER")) break;
                    var14_15 = 5;
                    break;
                }
                case -632076319: {
                    if (!var13_14.equals("THEADER")) break;
                    var14_15 = 6;
                    break;
                }
                case -1741038386: {
                    if (!var13_14.equals("XYHEADER")) break;
                    var14_15 = 7;
                    break;
                }
                case 2450837: {
                    if (!var13_14.equals("PDEF")) break;
                    var14_15 = 8;
                    break;
                }
                case 2689165: {
                    if (!var13_14.equals("XDEF")) break;
                    var14_15 = 9;
                    break;
                }
                case 2718956: {
                    if (!var13_14.equals("YDEF")) break;
                    var14_15 = 10;
                    break;
                }
                case 2748747: {
                    if (!var13_14.equals("ZDEF")) break;
                    var14_15 = 11;
                    break;
                }
                case 2570001: {
                    if (!var13_14.equals("TDEF")) break;
                    var14_15 = 12;
                    break;
                }
                case 2123136: {
                    if (!var13_14.equals("EDEF")) break;
                    var14_15 = 13;
                    break;
                }
                case 2627116: {
                    if (!var13_14.equals("VARS")) break;
                    var14_15 = 14;
                    break;
                }
                case -888255129: {
                    if (!var13_14.equals("ENDVARS")) break;
                    var14_15 = 15;
                }
            }
            block18 : switch (var14_15) {
                case 0: {
                    this.DSET = dataArray[1];
                    isNotPath = false;
                    if (!this.DSET.contains("/") && !this.DSET.contains("\\")) {
                        isNotPath = true;
                    }
                    theFile = new File(aFile);
                    aDir = theFile.getParent();
                    if (isNotPath) {
                        this.DSET = this.DSET.substring(0, 1).equals("^") != false ? aDir + File.separator + this.DSET.substring(1) : aDir + File.separator + this.DSET;
                        if (new File(this.DSET).isFile()) {
                            isNotPath = false;
                        } else {
                            this.DSET = dataArray[1];
                            this.DSET = theFile.getParent() + "/" + this.DSET.substring(1, this.DSET.length());
                        }
                    }
                    if (new File(this.DSET).isFile()) {
                        isNotPath = false;
                        break;
                    }
                    if (this.DSET.substring(0, 2).equals("./") || this.DSET.substring(0, 2).equals(".\\")) {
                        this.DSET = aDir + File.separator + this.DSET.substring(2);
                    }
                    isNotPath = new File(this.DSET).isFile() == false;
                    break;
                }
                case 1: {
                    this.DTYPE = dataArray[1];
                    if (!this.DTYPE.toUpperCase().equals("GRIDDED") && !this.DTYPE.toUpperCase().equals("STATION")) {
                        errorStr = "The data type is not supported at present!" + System.getProperty("line.separator") + this.DTYPE;
                    }
                    if (this.DTYPE.toUpperCase().equals("STATION")) {
                        this.setDataType(MeteoDataType.GRADS_STATION);
                    }
                    attr = new Attribute("data_type", this.DTYPE);
                    this.addAttribute(attr);
                    break;
                }
                case 2: {
                    block91: for (i = 1; i < dataArray.length; ++i) {
                        var19_20 = oStr = dataArray[i].toLowerCase();
                        var20_21 = -1;
                        switch (var19_20.hashCode()) {
                            case 1942911930: {
                                if (!var19_20.equals("big_endian")) break;
                                var20_21 = 0;
                                break;
                            }
                            case 891598996: {
                                if (!var19_20.equals("byteswapped")) break;
                                var20_21 = 1;
                                break;
                            }
                            case 124304750: {
                                if (!var19_20.equals("365_day_calendar")) break;
                                var20_21 = 2;
                                break;
                            }
                            case 2048371813: {
                                if (!var19_20.equals("cray_32bit_ieee")) break;
                                var20_21 = 3;
                                break;
                            }
                            case -859310844: {
                                if (!var19_20.equals("little_endian")) break;
                                var20_21 = 4;
                                break;
                            }
                            case -792524281: {
                                if (!var19_20.equals("pascals")) break;
                                var20_21 = 5;
                                break;
                            }
                            case -164011777: {
                                if (!var19_20.equals("sequential")) break;
                                var20_21 = 6;
                                break;
                            }
                            case -1321546630: {
                                if (!var19_20.equals("template")) break;
                                var20_21 = 7;
                                break;
                            }
                            case 3717514: {
                                if (!var19_20.equals("yrev")) break;
                                var20_21 = 8;
                                break;
                            }
                            case 3747305: {
                                if (!var19_20.equals("zrev")) break;
                                var20_21 = 9;
                            }
                        }
                        switch (var20_21) {
                            case 0: {
                                this.OPTIONS.big_endian = true;
                                continue block91;
                            }
                            case 1: {
                                this.OPTIONS.byteswapped = true;
                                continue block91;
                            }
                            case 2: {
                                this.OPTIONS.calendar_365_day = true;
                                continue block91;
                            }
                            case 3: {
                                this.OPTIONS.cray_32bit_ieee = true;
                                continue block91;
                            }
                            case 4: {
                                this.OPTIONS.little_endian = true;
                                continue block91;
                            }
                            case 5: {
                                this.OPTIONS.pascals = true;
                                continue block91;
                            }
                            case 6: {
                                this.OPTIONS.sequential = true;
                                continue block91;
                            }
                            case 7: {
                                this.OPTIONS.template = true;
                                continue block91;
                            }
                            case 8: {
                                this.OPTIONS.yrev = true;
                                continue block91;
                            }
                            case 9: {
                                this.OPTIONS.zrev = true;
                                continue block91;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    this.setMissingValue(Double.parseDouble(dataArray[1]));
                    attr = new Attribute("fill_value", this.getMissingValue());
                    this.addAttribute(attr);
                    break;
                }
                case 4: {
                    this.TITLE = aLine.substring(5, aLine.length()).trim();
                    attr = new Attribute("title", this.TITLE);
                    this.addAttribute(attr);
                    break;
                }
                case 5: {
                    this.FILEHEADER = Integer.parseInt(dataArray[1]);
                    break;
                }
                case 6: {
                    this.THEADER = Integer.parseInt(dataArray[1]);
                    break;
                }
                case 7: {
                    this.XYHEADER = Integer.parseInt(dataArray[1]);
                    break;
                }
                case 8: {
                    var21_23 = pStr = (this.PDEF.PDEF_Type = dataArray[3].toUpperCase());
                    var22_24 = -1;
                    switch (var21_23.hashCode()) {
                        case 75180: {
                            if (!var21_23.equals("LCC")) break;
                            var22_24 = 0;
                            break;
                        }
                        case 2330662: {
                            if (!var21_23.equals("LCCR")) break;
                            var22_24 = 1;
                            break;
                        }
                        case 77521: {
                            if (!var21_23.equals("NPS")) break;
                            var22_24 = 2;
                            break;
                        }
                        case 82326: {
                            if (!var21_23.equals("SPS")) break;
                            var22_24 = 3;
                        }
                    }
                    switch (var22_24) {
                        case 0: 
                        case 1: {
                            aPLCC = new PDEF_LCC();
                            aPLCC.isize = Integer.parseInt(dataArray[1]);
                            aPLCC.jsize = Integer.parseInt(dataArray[2]);
                            aPLCC.latref = Float.parseFloat(dataArray[4]);
                            aPLCC.lonref = Float.parseFloat(dataArray[5]);
                            aPLCC.iref = Float.parseFloat(dataArray[6]);
                            aPLCC.jref = Float.parseFloat(dataArray[7]);
                            aPLCC.Struelat = Float.parseFloat(dataArray[8]);
                            aPLCC.Ntruelat = Float.parseFloat(dataArray[9]);
                            aPLCC.slon = Float.parseFloat(dataArray[10]);
                            aPLCC.dx = Float.parseFloat(dataArray[11]);
                            aPLCC.dy = Float.parseFloat(dataArray[12]);
                            this.PDEF.PDEF_Content = aPLCC;
                            this.isLatLon = false;
                            ProjStr = "+proj=lcc +lat_1=" + String.valueOf(aPLCC.Struelat) + " +lat_2=" + String.valueOf(aPLCC.Ntruelat) + " +lat_0=" + String.valueOf(aPLCC.latref) + " +lon_0=" + String.valueOf(aPLCC.slon);
                            theProj = ProjectionInfo.factory((String)ProjStr);
                            this.setProjectionInfo(theProj);
                            if (this.PDEF.PDEF_Type.equals("LCCR")) {
                                this.EarthWind = false;
                            }
                            this.XNum = aPLCC.isize;
                            this.YNum = aPLCC.jsize;
                            this.X = new double[aPLCC.isize];
                            this.Y = new double[aPLCC.jsize];
                            this.getProjectedXY(theProj, aPLCC.dx, aPLCC.dy, aPLCC.iref, aPLCC.jref, aPLCC.lonref, aPLCC.latref, this.X, this.Y);
                            xdim = new Dimension(DimensionType.X);
                            xdim.setShortName("X");
                            xdim.setValues(this.X);
                            this.setXDimension(xdim);
                            this.addDimension(xdim);
                            ydim = new Dimension(DimensionType.Y);
                            ydim.setShortName("Y");
                            ydim.setValues(this.Y);
                            this.setYDimension(ydim);
                            this.addDimension(ydim);
                            break block18;
                        }
                        case 2: 
                        case 3: {
                            iSize = Integer.parseInt(dataArray[1]);
                            jSize = Integer.parseInt(dataArray[2]);
                            iPole = Float.parseFloat(dataArray[3]);
                            jPole = Float.parseFloat(dataArray[4]);
                            lonRef = Float.parseFloat(dataArray[5]);
                            dy = dx = Float.parseFloat(dataArray[6]) * 1000.0f;
                            lat0 = "90";
                            if (this.PDEF.PDEF_Type.equals("SPS")) {
                                lat0 = "-90";
                            }
                            this.isLatLon = false;
                            ProjStr = "+proj=stere +lon_0=" + String.valueOf(lonRef) + " +lat_0=" + lat0;
                            this.setProjectionInfo(ProjectionInfo.factory((String)ProjStr));
                            this.XNum = iSize;
                            this.YNum = jSize;
                            this.X = new double[iSize];
                            this.Y = new double[jSize];
                            this.getProjectedXY_NPS(dx, dy, iPole, jPole, this.X, this.Y);
                            xdim = new Dimension(DimensionType.X);
                            xdim.setShortName("X");
                            xdim.setValues(this.X);
                            this.setXDimension(xdim);
                            this.addDimension(xdim);
                            ydim = new Dimension(DimensionType.Y);
                            ydim.setShortName("Y");
                            ydim.setValues(this.Y);
                            this.setYDimension((Dimension)ydim);
                            this.addDimension((Dimension)ydim);
                            break block18;
                        }
                    }
                    errorStr = "The PDEF type is not supported at present!" + System.getProperty("line.separator") + "Please send your data to the author to improve MeteoInfo!";
                    break;
                }
                case 9: {
                    if (!this.getProjectionInfo().isLonLat()) break;
                    this.XDEF.XNum = Integer.parseInt(dataArray[1]);
                    this.XDEF.X = new double[this.XDEF.XNum];
                    this.XDEF.Type = dataArray[2];
                    values = new ArrayList<E>();
                    if (this.XDEF.Type.toUpperCase().equals("LINEAR")) {
                        this.XDEF.XMin = Float.parseFloat(dataArray[3]);
                        this.XDEF.XDelt = Float.parseFloat(dataArray[4]);
                    } else {
                        if (dataArray.length < this.XDEF.XNum + 3) {
                            while ((aLine = aLine + " " + sr.readLine().trim()).isEmpty() || (dataArray = aLine.split("\\s+")).length < this.XDEF.XNum + 3) {
                            }
                        }
                        if (dataArray.length > this.XDEF.XNum + 3) {
                            errorStr = "XDEF is wrong! Please check the ctl file!";
                        }
                        this.XDEF.XMin = Float.parseFloat(dataArray[3]);
                        xmax = Float.parseFloat(dataArray[dataArray.length - 1]);
                        this.XDEF.XDelt = (xmax - this.XDEF.XMin) / (float)(this.XDEF.XNum - 1);
                    }
                    delta = BigDecimalUtil.toDouble((float)this.XDEF.XDelt);
                    min = BigDecimalUtil.toDouble((float)this.XDEF.XMin);
                    for (i = 0; i < this.XDEF.XNum; ++i) {
                        this.XDEF.X[i] = BigDecimalUtil.add((double)min, (double)BigDecimalUtil.mul((double)i, (double)delta));
                        values.add(this.XDEF.X[i]);
                    }
                    if (this.XDEF.XMin == 0.0f && this.XDEF.X[this.XDEF.XNum - 1] + (double)this.XDEF.XDelt == 360.0) {
                        this.isGlobal = true;
                    }
                    xDim = new Dimension(DimensionType.X);
                    xDim.setShortName("X");
                    xDim.setValues(values);
                    this.setXDimension(xDim);
                    this.addDimension(xDim);
                    break;
                }
                case 10: {
                    if (!this.getProjectionInfo().isLonLat()) break;
                    this.YDEF.YNum = Integer.parseInt(dataArray[1]);
                    this.YDEF.Y = new double[this.YDEF.YNum];
                    this.YDEF.Type = dataArray[2];
                    values = new ArrayList<E>();
                    if (this.YDEF.Type.toUpperCase().equals("LINEAR")) {
                        this.YDEF.YMin = Float.parseFloat(dataArray[3]);
                        this.YDEF.YDelt = Float.parseFloat(dataArray[4]);
                    } else {
                        if (dataArray.length < this.YDEF.YNum + 3) {
                            while ((aLine = aLine + " " + sr.readLine().trim()).isEmpty() || (dataArray = aLine.split("\\s+")).length < this.YDEF.YNum + 3) {
                            }
                        }
                        if (dataArray.length > this.YDEF.YNum + 3) {
                            errorStr = "YDEF is wrong! Please check the ctl file!";
                        }
                        this.YDEF.YMin = Float.parseFloat(dataArray[3]);
                        ymax = Float.parseFloat(dataArray[dataArray.length - 1]);
                        this.YDEF.YDelt = (ymax - this.YDEF.YMin) / (float)(this.YDEF.YNum - 1);
                    }
                    delta = BigDecimalUtil.toDouble((float)this.YDEF.YDelt);
                    min = BigDecimalUtil.toDouble((float)this.YDEF.YMin);
                    for (i = 0; i < this.YDEF.YNum; ++i) {
                        this.YDEF.Y[i] = BigDecimalUtil.add((double)min, (double)BigDecimalUtil.mul((double)i, (double)delta));
                        values.add(this.YDEF.Y[i]);
                    }
                    if (this.OPTIONS.yrev) {
                        Collections.reverse(values);
                    }
                    yDim = new Dimension(DimensionType.Y);
                    yDim.setShortName("Y");
                    yDim.setValues(values);
                    this.setYDimension(yDim);
                    this.addDimension(yDim);
                    break;
                }
                case 11: {
                    this.ZDEF.ZNum = Integer.parseInt(dataArray[1]);
                    this.ZDEF.Type = dataArray[2];
                    this.ZDEF.ZLevels = new float[this.ZDEF.ZNum];
                    values = new ArrayList<Double>();
                    if (!this.ZDEF.Type.toUpperCase().equals("LINEAR")) ** GOTO lbl374
                    this.ZDEF.SLevel = Float.parseFloat(dataArray[3]);
                    this.ZDEF.ZDelt = Float.parseFloat(dataArray[4]);
                    for (i = 0; i < this.ZDEF.ZNum; ++i) {
                        this.ZDEF.ZLevels[i] = this.ZDEF.SLevel + (float)i * this.ZDEF.ZDelt;
                        values.add(Double.valueOf(this.ZDEF.ZLevels[i]));
                    }
                    ** GOTO lbl401
lbl374:
                    // 1 sources

                    if (dataArray.length >= this.ZDEF.ZNum + 3) ** GOTO lbl393
                    while (true) {
                        if ((line = sr.readLine().trim()).isEmpty()) {
                            continue;
                        }
                        dataArray = line.split("\\s+|,");
                        if (!this.isKeyWord(dataArray[0])) ** GOTO lbl391
                        dataArray = aLine.split("\\s+|,");
                        this.ZDEF.ZNum = dataArray.length - 3;
                        this.ZDEF.ZLevels = new float[this.ZDEF.ZNum];
                        for (i = 0; i < this.ZDEF.ZNum; ++i) {
                            this.ZDEF.ZLevels[i] = Float.parseFloat(dataArray[3 + i]);
                            values.add(Double.parseDouble(dataArray[3 + i]));
                        }
                        aLine = line;
                        isReadLine = false;
                        ** GOTO lbl401
lbl391:
                        // 1 sources

                        aLine = aLine + " " + line;
                    }
lbl393:
                    // 1 sources

                    this.ZDEF.ZNum = dataArray.length - 3;
                    this.ZDEF.ZLevels = new float[this.ZDEF.ZNum];
                    for (i = 0; i < this.ZDEF.ZNum; ++i) {
                        v = dataArray[3 + i].trim();
                        this.ZDEF.ZLevels[i] = Float.parseFloat(dataArray[3 + i]);
                        values.add(Double.parseDouble(dataArray[3 + i]));
                    }
lbl401:
                    // 3 sources

                    zDim = new Dimension(DimensionType.Z);
                    zDim.setShortName("Z");
                    zDim.setValues(values);
                    this.setZDimension(zDim);
                    this.addDimension(zDim);
                    break;
                }
                case 12: {
                    tnum = Integer.parseInt(dataArray[1]);
                    this.TDEF.Type = dataArray[2];
                    if (this.TDEF.Type.toUpperCase().equals("LINEAR")) {
                        dStr = dataArray[3];
                        dStr = dStr.toUpperCase();
                        i = dStr.indexOf("Z");
                        switch (i) {
                            case -1: {
                                if (Character.isDigit(dStr.charAt(0))) {
                                    dStr = "00:00Z" + dStr;
                                    break;
                                }
                                dStr = "00:00Z01" + dStr;
                                break;
                            }
                            case 1: {
                                dStr = "0" + dStr.substring(0, 1) + ":00" + dStr.substring(1);
                                break;
                            }
                            case 2: {
                                dStr = dStr.substring(0, 2) + ":00" + dStr.substring(2);
                                break;
                            }
                        }
                        if (!Character.isDigit(dStr.charAt(dStr.length() - 3))) {
                            aY = Integer.parseInt(dStr.substring(dStr.length() - 2));
                            aY = aY > 50 ? 1900 + aY : 2000 + aY;
                            dStr = dStr.substring(0, dStr.length() - 2) + String.valueOf(aY);
                        }
                        if (dStr.length() == 14) {
                            strb = new StringBuilder(dStr);
                            strb.insert(6, "0");
                            dStr = strb.toString();
                        }
                        mn = dStr.substring(8, 11);
                        Nmn = mn.substring(0, 1).toUpperCase() + mn.substring(1, 3).toLowerCase();
                        dStr = dStr.replace(mn, Nmn);
                        dStr = dStr.replace("Z", " ");
                        formatter = DateTimeFormatter.ofPattern("HH:mm ddMMMyyyy", Locale.ENGLISH);
                        this.TDEF.STime = LocalDateTime.parse(dStr, formatter);
                        this.TDEF.TDelt = dataArray[4];
                        tChar = dataArray[4].toCharArray();
                        aPos = 0;
                        for (i = 0; i < tChar.length; ++i) {
                            if (Character.isDigit(tChar[i])) continue;
                            aPos = i;
                            break;
                        }
                        if (aPos == 0) {
                            errorStr = "TDEF is wrong! Please check the ctl file!";
                        }
                        this.TDEF.DeltaValue = iNum = Integer.parseInt(this.TDEF.TDelt.substring(0, aPos));
                        this.TDEF.unit = tStr = this.TDEF.TDelt.substring(aPos).toLowerCase();
                        sTime = this.TDEF.STime;
                        ydim = tStr;
                        var33_67 = -1;
                        switch (ydim.hashCode()) {
                            case 3489: {
                                if (!ydim.equals("mn")) break;
                                var33_67 = 0;
                                break;
                            }
                            case 3338: {
                                if (!ydim.equals("hr")) break;
                                var33_67 = 1;
                                break;
                            }
                            case 3221: {
                                if (!ydim.equals("dy")) break;
                                var33_67 = 2;
                                break;
                            }
                            case 3490: {
                                if (!ydim.equals("mo")) break;
                                var33_67 = 3;
                                break;
                            }
                            case 108300: {
                                if (!ydim.equals("mon")) break;
                                var33_67 = 4;
                                break;
                            }
                            case 3865: {
                                if (!ydim.equals("yr")) break;
                                var33_67 = 5;
                            }
                        }
                        switch (var33_67) {
                            case 0: {
                                this.TDEF.duration = Duration.ofMinutes(iNum);
                                for (i = 0; i < tnum; ++i) {
                                    this.TDEF.times.add(sTime);
                                    sTime = sTime.plusMinutes(iNum);
                                }
                                break;
                            }
                            case 1: {
                                this.TDEF.duration = Duration.ofHours(iNum);
                                for (i = 0; i < tnum; ++i) {
                                    this.TDEF.times.add(sTime);
                                    sTime = sTime.plusHours(iNum);
                                }
                                break;
                            }
                            case 2: {
                                this.TDEF.duration = Duration.ofDays(iNum);
                                for (i = 0; i < tnum; ++i) {
                                    this.TDEF.times.add(sTime);
                                    sTime = sTime.plusDays(iNum);
                                }
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.TDEF.duration = Duration.ofDays(30 * iNum);
                                for (i = 0; i < tnum; ++i) {
                                    this.TDEF.times.add(sTime);
                                    sTime = sTime.plusMonths(iNum);
                                }
                                break;
                            }
                            case 5: {
                                this.TDEF.duration = Duration.ofDays(365 * iNum);
                                for (i = 0; i < tnum; ++i) {
                                    this.TDEF.times.add(sTime);
                                    sTime = sTime.plusYears(iNum);
                                }
                                break;
                            }
                        }
                        values = new ArrayList<E>();
                        for (LocalDateTime t : this.TDEF.times) {
                            values.add(JDateUtil.toOADate((LocalDateTime)t));
                        }
                        tDim = new Dimension(DimensionType.T);
                        tDim.setShortName("T");
                        tDim.setValues(values);
                        this.setTimeDimension(tDim);
                        this.addDimension(tDim);
                        break;
                    }
                    if (dataArray.length < tnum + 3) {
                        while ((aLine = aLine + " " + sr.readLine().trim()).isEmpty() || (dataArray = aLine.split("\\s+")).length < tnum + 3) {
                        }
                    }
                    if (dataArray.length > tnum + 3) {
                        errorStr = "TDEF is wrong! Please check the ctl file!";
                    }
                    formatter = DateTimeFormatter.ofPattern("HH:mm ddMMMyyyy", Locale.ENGLISH);
                    values = new ArrayList<E>();
                    for (i = 0; i < tnum; ++i) {
                        dStr = dataArray[3 + i];
                        dStr = dStr.replace("Z", " ");
                        t = LocalDateTime.parse(dStr, formatter);
                        this.TDEF.times.add(t);
                        values.add(JDateUtil.toOADate((LocalDateTime)t));
                    }
                    tDim = new Dimension(DimensionType.T);
                    tDim.setShortName("T");
                    tDim.setValues(values);
                    this.setTimeDimension(tDim);
                    this.addDimension(tDim);
                    break;
                }
                case 13: {
                    eNum = Integer.parseInt(dataArray[1]);
                    if (dataArray.length < eNum + 3) {
                        while ((aLine = aLine + " " + sr.readLine().trim()).isEmpty() || (dataArray = aLine.split("\\s+")).length < eNum + 3) {
                        }
                    }
                    if (dataArray.length > eNum + 3) {
                        errorStr = "EDEF is wrong! Please check the ctl file!";
                    }
                    for (i = 0; i < eNum; ++i) {
                        this.ensNames.add(dataArray[3 + i]);
                    }
                    eDim = new Dimension(DimensionType.E);
                    eDim.setLength(eNum);
                    this.addDimension(eDim);
                    evar = new Variable();
                    evar.setName("ensemble");
                    evar.setDataType(DataType.STRING);
                    evar.addAttribute("standard_name", "ensemble");
                    evar.addDimension(eDim);
                    this.addVariable(evar);
                    break;
                }
                case 14: {
                    vNum = Integer.parseInt(dataArray[1]);
                    for (i = 0; i < vNum; ++i) {
                        aLine = sr.readLine().trim();
                        if (aLine.isEmpty()) {
                            --i;
                            continue;
                        }
                        dataArray = aLine.split("\\s+");
                        aVar = new Variable();
                        aVar.setName(dataArray[0]);
                        aVar.setDataType(DataType.FLOAT);
                        lNum = Integer.parseInt(dataArray[1]);
                        aVar.setUnits(dataArray[2]);
                        if (dataArray.length > 3) {
                            idx = aLine.indexOf(dataArray[3]);
                            desc = aLine.substring(idx);
                            aVar.setDescription(desc);
                            attr = new Attribute("description", desc);
                            aVar.addAttribute(attr);
                        }
                        if (eDim != null) {
                            aVar.addDimension(eDim);
                        }
                        aVar.setDimension(this.getTimeDimension());
                        if (lNum > 1) {
                            isNew = true;
                            for (Dimension dim : this.getDimensions()) {
                                if (dim.getDimType() != DimensionType.Z || lNum != dim.getLength()) continue;
                                aVar.setDimension(dim);
                                isNew = false;
                                break;
                            }
                            if (isNew) {
                                levs = new ArrayList<Double>();
                                for (j = 0; j < lNum; ++j) {
                                    if (this.ZDEF.ZNum <= j) continue;
                                    aVar.addLevel(this.ZDEF.ZLevels[j]);
                                    levs.add(Double.valueOf(this.ZDEF.ZLevels[j]));
                                }
                                dim = new Dimension(DimensionType.Z);
                                dim.setShortName("Z_" + String.valueOf(lNum));
                                dim.setValues(levs);
                                aVar.setDimension(dim);
                                this.addDimension(dim);
                            }
                        }
                        aVar.setDimension(this.getYDimension());
                        aVar.setDimension(this.getXDimension());
                        if (this.getDataType() == MeteoDataType.GRADS_STATION) {
                            aVar.setStation(true);
                        }
                        aVar.setFillValue(this.getMissingValue());
                        this.VARDEF.addVar(aVar);
                        this.addVariable(aVar);
                    }
                    break;
                }
                case 15: {
                    isEnd = true;
                    break;
                }
            }
            if (isEnd) break;
        } while (aLine != null);
        sr.close();
        if (isNotPath && !this.OPTIONS.template) {
            errorStr = "The data file is not exist!" + System.getProperty("line.separator") + this.DSET;
            System.out.println(errorStr);
        }
        if (this.isLatLon) {
            this.X = this.XDEF.X;
            this.Y = this.YDEF.Y;
            this.XNum = this.XDEF.XNum;
            this.YNum = this.YDEF.YNum;
        }
        this.RecordLen = this.XNum * this.YNum * 4;
        if (this.OPTIONS.sequential) {
            this.RecordLen += 8;
        }
        this.RecLenPerTime = 0L;
        for (i = 0; i < this.VARDEF.getVNum(); ++i) {
            lNum = this.VARDEF.getVars().get(i).getLevelNum();
            if (lNum == 0) {
                lNum = 1;
            }
            this.RecLenPerTime += (long)(lNum * this.RecordLen);
        }
        return true;
    }

    private boolean isKeyWord(String str) {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add("DSET");
        keyWords.add("CHSUB");
        keyWords.add("DTYPE");
        keyWords.add("INDEX");
        keyWords.add("STNMAP");
        keyWords.add("TITLE");
        keyWords.add("UNDEF");
        keyWords.add("UNPACK");
        keyWords.add("FILEHEADER");
        keyWords.add("XYHEADER");
        keyWords.add("TRAILERBYTES");
        keyWords.add("XVAR");
        keyWords.add("YVAR");
        keyWords.add("ZVAR");
        keyWords.add("STID");
        keyWords.add("TVAR");
        keyWords.add("TOFFVAR");
        keyWords.add("CACHESIZE");
        keyWords.add("OPTIONS");
        keyWords.add("PDEF");
        keyWords.add("XDEF");
        keyWords.add("YDEF");
        keyWords.add("ZDEF");
        keyWords.add("TDEF");
        keyWords.add("EDEF");
        keyWords.add("VECTORPAIRS");
        keyWords.add("VARS");
        keyWords.add("ENDVARS");
        keyWords.add("ATTRIBUTE METADATA");
        keyWords.add("COMMENTS");
        return keyWords.contains(str.toUpperCase());
    }

    private void getProjectedXY(ProjectionInfo projInfo, float size, float sync_XP, float sync_YP, float sync_Lon, float sync_Lat, double[] X, double[] Y) {
        int i;
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[][]{{sync_Lon, sync_Lat}};
        Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)projInfo, (int)0, (int)1);
        double sync_X = points[0][0];
        double sync_Y = points[0][1];
        int i_XP = (int)sync_XP;
        double i_X = sync_XP == (float)i_XP ? sync_X : sync_X - (double)((sync_XP - (float)i_XP) * size);
        int i_YP = (int)sync_YP;
        double i_Y = sync_YP == (float)i_YP ? sync_Y : sync_Y - (double)((sync_YP - (float)i_YP) * size);
        int nx = X.length;
        int ny = Y.length;
        double xlb = i_X - (double)((float)(i_XP - 1) * size);
        double ylb = i_Y - (double)((float)(i_YP - 1) * size);
        for (i = 0; i < nx; ++i) {
            X[i] = xlb + (double)((float)i * size);
        }
        for (i = 0; i < ny; ++i) {
            Y[i] = ylb + (double)((float)i * size);
        }
    }

    private void getProjectedXY(ProjectionInfo projInfo, float XSize, float YSize, float sync_XP, float sync_YP, float sync_Lon, float sync_Lat, double[] X, double[] Y) {
        int i;
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[][]{{sync_Lon, sync_Lat}};
        Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)projInfo, (int)0, (int)1);
        double sync_X = points[0][0];
        double sync_Y = points[0][1];
        int i_XP = (int)sync_XP;
        double i_X = sync_XP == (float)i_XP ? sync_X : sync_X - (double)((sync_XP - (float)i_XP) * XSize);
        int i_YP = (int)sync_YP;
        double i_Y = sync_YP == (float)i_YP ? sync_Y : sync_Y - (double)((sync_YP - (float)i_YP) * YSize);
        int nx = X.length;
        int ny = Y.length;
        double xlb = i_X - (double)((float)(i_XP - 1) * XSize);
        double ylb = i_Y - (double)((float)(i_YP - 1) * YSize);
        for (i = 0; i < nx; ++i) {
            X[i] = xlb + (double)((float)i * XSize);
        }
        for (i = 0; i < ny; ++i) {
            Y[i] = ylb + (double)((float)i * YSize);
        }
    }

    private void getProjectedXY_NPS(float XSize, float YSize, float sync_XP, float sync_YP, double[] X, double[] Y) {
        int i;
        double sync_X = 0.0;
        double sync_Y = 0.0;
        int i_XP = (int)sync_XP;
        double i_X = sync_XP == (float)i_XP ? sync_X : sync_X - (double)((sync_XP - (float)i_XP) * XSize);
        int i_YP = (int)sync_YP;
        double i_Y = sync_YP == (float)i_YP ? sync_Y : sync_Y - (double)((sync_YP - (float)i_YP) * YSize);
        int nx = X.length;
        int ny = Y.length;
        double xlb = i_X - (double)((float)(i_XP - 1) * XSize);
        double ylb = i_Y - (double)((float)(i_YP - 1) * YSize);
        for (i = 0; i < nx; ++i) {
            X[i] = xlb + (double)((float)i * XSize);
        }
        for (i = 0; i < ny; ++i) {
            Y[i] = ylb + (double)((float)i * YSize);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    private Object[] getFilePath_Template(int timeIdx) {
        DateTimeFormatter format;
        File file = new File(this.DSET);
        if (file.isFile()) {
            return new Object[]{file.getAbsolutePath(), 0};
        }
        String path = file.getParent();
        String fn = file.getName();
        if (fn.contains("%f")) {
            int hours = (int)this.TDEF.duration.toHours();
            if (fn.contains("%f2")) {
                fn = fn.replace("%f2", String.format("%02d", timeIdx * hours));
            } else if (fn.contains("%f3")) {
                fn = fn.replace("%f3", String.format("%03d", timeIdx * hours));
            } else if (fn.contains("%fhn")) {
                Duration duration = this.TDEF.duration.multipliedBy(timeIdx);
                long seconds = duration.getSeconds();
                fn = fn.replace("%fhn", String.format("%02d%02d", seconds / 3600L, seconds % 3600L / 60L));
            }
            String filePath = path + File.separator + fn;
            return new Object[]{filePath, 0};
        }
        LocalDateTime time = this.getTimes().get(timeIdx);
        String tStr = "year";
        if (fn.contains("%y4")) {
            format = DateTimeFormatter.ofPattern("yyyy");
            fn = fn.replace("%y4", format.format(time));
        }
        if (fn.contains("%y2")) {
            format = DateTimeFormatter.ofPattern("yy");
            fn = fn.replace("%y2", format.format(time));
        }
        if (fn.contains("%m1")) {
            format = DateTimeFormatter.ofPattern("M");
            fn = fn.replace("%m1", format.format(time));
            tStr = "month";
        }
        if (fn.contains("%m2")) {
            format = DateTimeFormatter.ofPattern("MM");
            fn = fn.replace("%m2", format.format(time));
            tStr = "month";
        }
        if (fn.contains("%mc")) {
            format = DateTimeFormatter.ofPattern("MMM", Locale.ENGLISH);
            fn = fn.replace("%mc", format.format(time));
            tStr = "month";
        }
        if (fn.contains("%d1")) {
            format = DateTimeFormatter.ofPattern("d");
            fn = fn.replace("%d1", format.format(time));
            tStr = "day";
        }
        if (fn.contains("%d2")) {
            format = DateTimeFormatter.ofPattern("dd");
            fn = fn.replace("%d2", format.format(time));
            tStr = "day";
        }
        if (fn.contains("%h1")) {
            format = DateTimeFormatter.ofPattern("H");
            fn = fn.replace("%h1", format.format(time));
            tStr = "hour";
        }
        if (fn.contains("%h2")) {
            format = DateTimeFormatter.ofPattern("HH");
            fn = fn.replace("%h2", format.format(time));
            tStr = "hour";
        }
        if (fn.contains("%n2")) {
            format = DateTimeFormatter.ofPattern("mm");
            fn = fn.replace("%n2", format.format(time));
            tStr = "minute";
        }
        String filePath = path + File.separator + fn;
        int tIdx = 0;
        if (tStr.equalsIgnoreCase("year")) {
            switch (this.TDEF.unit) {
                case "mn": {
                    tIdx = ((time.getDayOfYear() - 1) * 24 * 60 + time.getMinute()) / this.TDEF.DeltaValue;
                    break;
                }
                case "hr": {
                    tIdx = ((time.getDayOfYear() - 1) * 24 + time.getHour()) / this.TDEF.DeltaValue;
                    break;
                }
                case "dy": {
                    tIdx = time.getDayOfYear() - 1;
                    break;
                }
                case "mo": 
                case "mon": {
                    tIdx = time.getMonthValue() - 1;
                    break;
                }
            }
        } else if (tStr.equalsIgnoreCase("month")) {
            switch (this.TDEF.unit) {
                case "mn": {
                    tIdx = ((time.getDayOfMonth() - 1) * 24 * 60 + time.getMinute()) / this.TDEF.DeltaValue;
                    break;
                }
                case "hr": {
                    tIdx = ((time.getDayOfMonth() - 1) * 24 + time.getHour()) / this.TDEF.DeltaValue;
                    break;
                }
                case "dy": {
                    tIdx = time.getDayOfMonth() - 1;
                    break;
                }
            }
        } else if (tStr.equalsIgnoreCase("day")) {
            if (this.TDEF.unit.equals("mn")) {
                tIdx = ((time.getHour() - 1) * 60 + time.getMinute()) / this.TDEF.DeltaValue;
            } else if (this.TDEF.unit.equals("hr")) {
                tIdx = time.getHour() - 1;
            }
        }
        return new Object[]{filePath, tIdx};
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            Section section = new Section(origin, size, stride);
            if (varName.equals("ensemble")) {
                Array dataArray = Array.factory((DataType)DataType.STRING, (int[])section.getShape());
                IndexIterator ii = dataArray.getIndexIterator();
                Range eRange = section.getRange(0);
                this.readEnsemble(eRange, ii);
                return dataArray;
            }
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 0;
            Dimension eDim = var.getDimension(DimensionType.E);
            Range eRange = eDim != null ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range levRange = var.getLevelNum() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            for (int eIdx = eRange.first(); eIdx <= eRange.last(); eIdx += eRange.stride()) {
                for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
                    for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                        this.readXY(varName, eIdx, timeIdx, levelIdx, yRange, xRange, ii);
                    }
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readEnsemble(Range eRange, IndexIterator ii) {
        for (int i = eRange.first(); i <= eRange.last(); i += eRange.stride()) {
            ii.setObjectNext((Object)this.ensNames.get(i));
        }
    }

    private void readXY(String varName, int timeIdx, int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            int i;
            int varIdx = this.getVariableNames().indexOf(varName);
            int xNum = this.XNum;
            int yNum = this.YNum;
            float[] data = new float[yNum * xNum];
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            br.seek(this.FILEHEADER);
            br.seek(br.getFilePointer() + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
            if (this.OPTIONS.sequential) {
                br.seek(br.getFilePointer() + 4L);
            }
            byte[] byteData = new byte[xNum * yNum * 4];
            br.read(byteData);
            int start = 0;
            for (i = 0; i < yNum * xNum; ++i) {
                byte[] aBytes = new byte[4];
                System.arraycopy(byteData, start, aBytes, 0, 4);
                start += 4;
                data[i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            }
            br.close();
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readXY(String varName, int eIdx, int timeIdx, int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            int i;
            int varIdx = this.getVariableNames().indexOf(varName);
            int xNum = this.XNum;
            int yNum = this.YNum;
            float[] data = new float[yNum * xNum];
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            br.seek(this.FILEHEADER);
            br.seek(br.getFilePointer() + (long)(eIdx * this.getTimeNum()) * this.RecLenPerTime);
            br.seek(br.getFilePointer() + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
            if (this.OPTIONS.sequential) {
                br.seek(br.getFilePointer() + 4L);
            }
            byte[] byteData = new byte[xNum * yNum * 4];
            br.read(byteData);
            int start = 0;
            for (i = 0; i < yNum * xNum; ++i) {
                byte[] aBytes = new byte[4];
                System.arraycopy(byteData, start, aBytes, 0, 4);
                start += 4;
                data[i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            }
            br.close();
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            int varIdx = this.getVariableIndex(varName);
            double[][] data = this.readGrADSData_Grid_LonLat(timeIdx, varIdx, levelIdx);
            GridData gridData = new GridData(data, this.X, this.Y, this.missingValue);
            if (this.OPTIONS.yrev) {
                gridData.yReverse();
            }
            return gridData;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private double[][] readGrADSData_Grid_LonLat(int timeIdx, int varIdx, int levelIdx) throws FileNotFoundException, IOException {
        int i;
        int xNum = this.XNum;
        int yNum = this.YNum;
        double[][] gridData = new double[yNum][xNum];
        String filePath = this.DSET;
        int tIdx = timeIdx;
        if (this.OPTIONS.template) {
            Object[] result = this.getFilePath_Template(timeIdx);
            filePath = (String)result[0];
            tIdx = (Integer)result[1];
            if (tIdx < 0) {
                tIdx = 0;
            }
            if (tIdx >= this.getTimeNum()) {
                tIdx = this.getTimeNum() - 1;
            }
        }
        RandomAccessFile br = new RandomAccessFile(filePath, "r");
        br.seek(this.FILEHEADER);
        br.seek(br.getFilePointer() + (long)tIdx * this.RecLenPerTime);
        for (i = 0; i < varIdx; ++i) {
            int lNum = this.VARDEF.getVars().get(i).getLevelNum();
            if (lNum == 0) {
                lNum = 1;
            }
            br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
        }
        br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
        if (this.OPTIONS.sequential) {
            br.seek(br.getFilePointer() + 4L);
        }
        byte[] byteData = new byte[xNum * yNum * 4];
        br.read(byteData);
        int start = 0;
        for (i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                byte[] aBytes = new byte[4];
                System.arraycopy(byteData, start, aBytes, 0, 4);
                start += 4;
                gridData[i][j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            }
        }
        br.close();
        return gridData;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        try {
            int j;
            int lNum;
            int i;
            int t;
            int varIdx = this.getVariableIndex(varName);
            int xNum = this.YNum;
            int yNum = this.TDEF.getTimeNum();
            double[][] gridData = new double[yNum][xNum];
            if (this.OPTIONS.template) {
                byte[] aBytes = new byte[4];
                for (t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    Object[] result = this.getFilePath_Template(t);
                    String filePath = (String)result[0];
                    int tIdx = (Integer)result[1];
                    RandomAccessFile br = new RandomAccessFile(filePath, "r");
                    br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    for (i = 0; i < this.YNum; ++i) {
                        for (j = 0; j < this.XNum; ++j) {
                            br.read(aBytes);
                            if (j != lonIdx) continue;
                            gridData[t][i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        }
                    }
                    br.close();
                }
            } else {
                RandomAccessFile br = new RandomAccessFile(this.DSET, "r");
                for (t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    br.seek((long)this.FILEHEADER + (long)t * this.RecLenPerTime);
                    long aTPosition = br.getFilePointer();
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    byte[] aBytes = new byte[4];
                    for (i = 0; i < this.YNum; ++i) {
                        for (j = 0; j < this.XNum; ++j) {
                            br.read(aBytes);
                            if (j != lonIdx) continue;
                            gridData[t][i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        }
                    }
                    br.seek(aTPosition);
                }
                br.close();
            }
            double[] yArray = new double[this.getTimeNum()];
            for (i = 0; i < this.getTimeNum(); ++i) {
                yArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().get(i));
            }
            return new GridData(gridData, this.Y, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        try {
            int j;
            int lNum;
            int i;
            int t;
            int varIdx = this.getVariableIndex(varName);
            int xNum = this.XNum;
            int yNum = this.TDEF.getTimeNum();
            double[][] gridData = new double[yNum][xNum];
            if (this.OPTIONS.template) {
                byte[] aBytes = new byte[4];
                for (t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    Object[] result = this.getFilePath_Template(t);
                    String filePath = (String)result[0];
                    int tIdx = (Integer)result[1];
                    RandomAccessFile br = new RandomAccessFile(filePath, "r");
                    br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    br.seek(br.getFilePointer() + (long)(latIdx * xNum * 4));
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    for (j = 0; j < xNum; ++j) {
                        br.read(aBytes);
                        gridData[t][j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    }
                    br.close();
                }
            } else {
                RandomAccessFile br = new RandomAccessFile(this.DSET, "r");
                for (t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    br.seek((long)this.FILEHEADER + (long)t * this.RecLenPerTime);
                    long aTPosition = br.getFilePointer();
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    br.seek(br.getFilePointer() + (long)(latIdx * xNum * 4));
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    byte[] aBytes = new byte[4];
                    for (j = 0; j < xNum; ++j) {
                        br.read(aBytes);
                        gridData[t][j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    }
                    br.seek(aTPosition);
                }
                br.close();
            }
            double[] yArray = new double[this.getTimeNum()];
            for (i = 0; i < this.getTimeNum(); ++i) {
                yArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().get(i));
            }
            return new GridData(gridData, this.X, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        try {
            int i;
            int varIdx = this.getVariableIndex(varName);
            int xNum = this.YNum;
            int yNum = this.VARDEF.getVars().get(varIdx).getLevelNum();
            double[][] gridData = new double[yNum][xNum];
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            if (br.getFilePointer() >= br.length()) {
                System.out.println("Erro");
            }
            for (i = 0; i < yNum; ++i) {
                if (this.OPTIONS.sequential) {
                    br.seek(br.getFilePointer() + 4L);
                }
                byte[] aBytes = new byte[4];
                for (int j = 0; j < this.YNum; ++j) {
                    br.skipBytes(lonIdx * 4);
                    br.read(aBytes);
                    gridData[i][j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    br.skipBytes((this.XNum - lonIdx - 1) * 4);
                }
            }
            br.close();
            double[] levels = new double[this.VARDEF.getVars().get(varIdx).getLevelNum()];
            for (i = 0; i < levels.length; ++i) {
                levels[i] = this.ZDEF.ZLevels[i];
            }
            return new GridData(gridData, this.Y, levels, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        try {
            int i;
            int varIdx = this.getVariableIndex(varName);
            int xNum = this.XNum;
            int yNum = this.VARDEF.getVars().get(varIdx).getLevelNum();
            double[][] gridData = new double[yNum][xNum];
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            if (br.getFilePointer() >= br.length()) {
                System.out.println("Erro");
            }
            for (i = 0; i < yNum; ++i) {
                if (this.OPTIONS.sequential) {
                    br.seek(br.getFilePointer() + 4L);
                }
                br.seek(br.getFilePointer() + (long)(latIdx * xNum * 4));
                byte[] aBytes = new byte[4];
                for (int j = 0; j < xNum; ++j) {
                    br.read(aBytes);
                    gridData[i][j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                }
                br.seek(br.getFilePointer() + (long)((this.YNum - latIdx - 1) * xNum * 4));
            }
            br.close();
            double[] levels = new double[this.VARDEF.getVars().get(varIdx).getLevelNum()];
            for (i = 0; i < levels.length; ++i) {
                levels[i] = this.ZDEF.ZLevels[i];
            }
            return new GridData(gridData, this.X, levels, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        try {
            int lNum;
            int i;
            int t;
            int varIdx = this.getVariableIndex(varName);
            int xNum = this.TDEF.getTimeNum();
            int yNum = this.VARDEF.getVars().get(varIdx).getLevelNum();
            double[][] gridData = new double[yNum][xNum];
            if (this.OPTIONS.template) {
                byte[] aBytes = new byte[4];
                for (t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    Object[] result = this.getFilePath_Template(t);
                    String filePath = (String)result[0];
                    int tIdx = (Integer)result[1];
                    RandomAccessFile br = new RandomAccessFile(filePath, "r");
                    br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    for (i = 0; i < yNum; ++i) {
                        if (this.OPTIONS.sequential) {
                            br.seek(br.getFilePointer() + 4L);
                        }
                        br.seek(br.getFilePointer() + (long)(latIdx * xNum * 4) + (long)(lonIdx * 4));
                        br.read(aBytes);
                        gridData[i][t] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        br.seek(br.getFilePointer() + (long)((this.XNum - lonIdx - 1) * 4) + (long)((this.YNum - latIdx - 1) * xNum * 4));
                    }
                    br.close();
                }
            } else {
                RandomAccessFile br = new RandomAccessFile(this.DSET, "r");
                for (t = 0; t < xNum; ++t) {
                    br.seek((long)this.FILEHEADER + (long)t * this.RecLenPerTime);
                    long aTPosition = br.getFilePointer();
                    for (i = 0; i < varIdx; ++i) {
                        lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    byte[] aBytes = new byte[4];
                    for (i = 0; i < yNum; ++i) {
                        if (this.OPTIONS.sequential) {
                            br.seek(br.getFilePointer() + 4L);
                        }
                        br.seek(br.getFilePointer() + (long)(latIdx * xNum * 4) + (long)(lonIdx * 4));
                        br.read(aBytes);
                        gridData[i][t] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        br.seek(br.getFilePointer() + (long)((this.XNum - lonIdx - 1) * 4) + (long)((this.YNum - latIdx - 1) * xNum * 4));
                    }
                    br.seek(aTPosition);
                }
                br.close();
            }
            double[] xArray = new double[this.getTimeNum()];
            for (i = 0; i < this.getTimeNum(); ++i) {
                xArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().get(i));
            }
            double[] levels = new double[this.VARDEF.getVars().get(varIdx).getLevelNum()];
            for (i = 0; i < levels.length; ++i) {
                levels[i] = this.ZDEF.ZLevels[i];
            }
            return new GridData(gridData, xArray, levels, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        try {
            int varIdx = this.getVariableIndex(varName);
            byte[] aBytes = new byte[4];
            double[] xArray = new double[this.TDEF.getTimeNum()];
            double[] yArray = new double[]{0.0};
            double[][] data = new double[1][this.TDEF.getTimeNum()];
            if (this.OPTIONS.template) {
                for (int t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    Object[] result = this.getFilePath_Template(t);
                    String filePath = (String)result[0];
                    int tIdx = (Integer)result[1];
                    RandomAccessFile br = new RandomAccessFile(filePath, "r");
                    br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
                    for (int i = 0; i < varIdx; ++i) {
                        int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    br.seek(br.getFilePointer() + (long)(latIdx * this.XNum * 4));
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    br.seek(br.getFilePointer() + (long)(lonIdx * 4));
                    br.read(aBytes);
                    float aValue = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    xArray[t] = JDateUtil.toOADate((LocalDateTime)this.TDEF.times.get(t));
                    data[0][t] = aValue;
                    br.close();
                }
            } else {
                RandomAccessFile br = new RandomAccessFile(this.DSET, "r");
                for (int t = 0; t < this.TDEF.getTimeNum(); ++t) {
                    br.seek((long)this.FILEHEADER + (long)t * this.RecLenPerTime);
                    for (int i = 0; i < varIdx; ++i) {
                        int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                        if (lNum == 0) {
                            lNum = 1;
                        }
                        br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
                    }
                    br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
                    if (this.OPTIONS.sequential) {
                        br.seek(br.getFilePointer() + 4L);
                    }
                    br.seek(br.getFilePointer() + (long)(latIdx * this.XNum * 4));
                    if (br.getFilePointer() >= br.length()) {
                        System.out.println("Erro");
                    }
                    br.seek(br.getFilePointer() + (long)(lonIdx * 4));
                    br.read(aBytes);
                    float aValue = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    xArray[t] = JDateUtil.toOADate((LocalDateTime)this.TDEF.times.get(t));
                    data[0][t] = aValue;
                }
                br.close();
            }
            return new GridData(data, xArray, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        try {
            int i;
            int varIdx = this.getVariableIndex(varName);
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            byte[] aBytes = new byte[4];
            double[] xArray = new double[this.ZDEF.ZNum];
            double[] yArray = new double[]{0.0};
            double[][] data = new double[1][this.ZDEF.ZNum];
            br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            long aPosition = br.getFilePointer();
            for (i = 0; i < this.ZDEF.ZNum; ++i) {
                br.seek(aPosition + (long)(i * this.RecordLen));
                if (this.OPTIONS.sequential) {
                    br.seek(br.getFilePointer() + 4L);
                }
                br.seek(br.getFilePointer() + (long)(latIdx * this.XNum * 4) + (long)(lonIdx * 4));
                br.read(aBytes);
                float aValue = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                xArray[i] = this.ZDEF.ZLevels[i];
                data[0][i] = aValue;
            }
            br.close();
            return new GridData(data, xArray, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        try {
            int i;
            int varIdx = this.getVariableIndex(varName);
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            byte[] aBytes = new byte[4];
            double[] yArray = new double[]{0.0};
            double[][] data = new double[1][this.X.length];
            br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
            if (this.OPTIONS.sequential) {
                br.seek(br.getFilePointer() + 4L);
            }
            br.seek(br.getFilePointer() + (long)(latIdx * this.XNum * 4));
            for (i = 0; i < this.XNum; ++i) {
                br.read(aBytes);
                float aValue = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                data[0][i] = aValue;
            }
            br.close();
            return new GridData(data, this.X, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        try {
            int i;
            int varIdx = this.getVariableIndex(varName);
            String filePath = this.DSET;
            int tIdx = timeIdx;
            if (this.OPTIONS.template) {
                Object[] result = this.getFilePath_Template(timeIdx);
                filePath = (String)result[0];
                tIdx = (Integer)result[1];
            }
            RandomAccessFile br = new RandomAccessFile(filePath, "r");
            byte[] aBytes = new byte[4];
            double[] yArray = new double[]{0.0};
            double[][] data = new double[1][this.Y.length];
            br.seek((long)this.FILEHEADER + (long)tIdx * this.RecLenPerTime);
            for (i = 0; i < varIdx; ++i) {
                int lNum = this.VARDEF.getVars().get(i).getLevelNum();
                if (lNum == 0) {
                    lNum = 1;
                }
                br.seek(br.getFilePointer() + (long)(lNum * this.RecordLen));
            }
            br.seek(br.getFilePointer() + (long)(levelIdx * this.RecordLen));
            if (this.OPTIONS.sequential) {
                br.seek(br.getFilePointer() + 4L);
            }
            long aPosition = br.getFilePointer();
            for (i = 0; i < this.YNum; ++i) {
                br.seek(aPosition + (long)(i * this.XNum * 4) + (long)(lonIdx * 4));
                br.read(aBytes);
                float aValue = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                data[0][i] = aValue;
            }
            br.close();
            return new GridData(data, this.Y, yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public GridData getGridData_Station(int vIdx, String stID) {
        try {
            int i;
            RandomAccessFile br = new RandomAccessFile(this.DSET, "r");
            STDataHead aSTDH = new STDataHead();
            STLevData aSTLevData = new STLevData();
            STData aSTData = new STData();
            Variable aVar = this.getUpperVariables().get(vIdx);
            int varNum = this.VARDEF.getVNum();
            int uVarNum = this.getUpperVariables().size();
            if (uVarNum > 0) {
                varNum -= uVarNum;
            }
            double[] xArray = new double[this.getTimeNum()];
            for (i = 0; i < this.getTimeNum(); ++i) {
                xArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().get(i));
            }
            double[] yArray = new double[aVar.getLevelNum()];
            for (i = 0; i < aVar.getLevelNum(); ++i) {
                yArray[i] = i + 1;
            }
            double[][] data = new double[aVar.getLevelNum()][this.getTimeNum()];
            int stNum = 0;
            int tNum = 0;
            block5: while (true) {
                byte[] aBytes = this.getByteArray(br, 8);
                aSTDH.STID = new String(aBytes, "UTF-8");
                aBytes = this.getByteArray(br, 4);
                aSTDH.Lat = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                aBytes = this.getByteArray(br, 4);
                aSTDH.Lon = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                aBytes = this.getByteArray(br, 4);
                aSTDH.T = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                aBytes = this.getByteArray(br, 4);
                aSTDH.NLev = DataConvert.bytes2Int((byte[])aBytes);
                aBytes = this.getByteArray(br, 4);
                aSTDH.Flag = DataConvert.bytes2Int((byte[])aBytes);
                if (aSTDH.NLev > 0) {
                    ++stNum;
                    aSTData.STHead = aSTDH;
                    aSTData.dataList = new ArrayList<STLevData>();
                    if (aSTDH.Flag == 1) {
                        if (aSTDH.STID.equals(stID)) {
                            aSTLevData.data = new float[varNum];
                            for (i = 0; i < varNum; ++i) {
                                aBytes = this.getByteArray(br, 4);
                                aSTLevData.data[i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                            }
                            aSTLevData.lev = 0.0f;
                            aSTData.dataList.add(aSTLevData);
                        } else {
                            br.skipBytes(varNum * 4);
                        }
                    }
                    if (aSTDH.NLev - aSTDH.Flag <= 0) continue;
                    if (aSTDH.STID.equals(stID)) {
                        i = 0;
                        while (true) {
                            if (i >= aSTDH.NLev - aSTDH.Flag) continue block5;
                            br.skipBytes(4 + vIdx * 4);
                            aBytes = this.getByteArray(br, 4);
                            data[i][tNum] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                            br.skipBytes((uVarNum - vIdx - 1) * 4);
                            ++i;
                        }
                    }
                    br.skipBytes((aSTDH.NLev - aSTDH.Flag) * (uVarNum + 1) * 4);
                    continue;
                }
                stNum = 0;
                if (tNum == this.getTimes().size() - 1) break;
                ++tNum;
                if (br.getFilePointer() + 28L >= br.length()) break;
            }
            br.close();
            return new GridData(data, xArray, yArray, this.missingValue);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private byte[] getByteArray(RandomAccessFile br, int n) {
        try {
            byte[] bytes = new byte[n];
            br.read(bytes);
            return bytes;
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<STData> readGrADSData_Station(int timeIdx) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        ArrayList<STData> stDataList = new ArrayList<STData>();
        String filePath = this.DSET;
        int tIdx = timeIdx;
        if (this.OPTIONS.template) {
            Object[] result = this.getFilePath_Template(timeIdx);
            filePath = (String)result[0];
            tIdx = (Integer)result[1];
        }
        RandomAccessFile br = new RandomAccessFile(filePath, "r");
        int varNum = this.VARDEF.getVNum();
        int uVarNum = this.getUpperVariables().size();
        if (uVarNum > 0) {
            varNum -= uVarNum;
        }
        int tNum = 0;
        if (this.OPTIONS.template) {
            timeIdx = 0;
        }
        while (true) {
            STDataHead aSTDH = new STDataHead();
            byte[] aBytes = this.getByteArray(br, 8);
            aSTDH.STID = new String(aBytes);
            aBytes = this.getByteArray(br, 4);
            aSTDH.Lat = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            aBytes = this.getByteArray(br, 4);
            aSTDH.Lon = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            aBytes = this.getByteArray(br, 4);
            aSTDH.T = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
            aBytes = this.getByteArray(br, 4);
            aSTDH.NLev = DataConvert.bytes2Int((byte[])aBytes, (ByteOrder)this._byteOrder);
            aBytes = this.getByteArray(br, 4);
            aSTDH.Flag = DataConvert.bytes2Int((byte[])aBytes, (ByteOrder)this._byteOrder);
            if (aSTDH.NLev > 0) {
                int i;
                STLevData aSTLevData;
                STData aSTData = new STData();
                aSTData.STHead = aSTDH;
                aSTData.dataList = new ArrayList<STLevData>();
                if (aSTDH.Flag == 1) {
                    aSTLevData = new STLevData();
                    aSTLevData.data = new float[varNum];
                    for (i = 0; i < varNum; ++i) {
                        aBytes = this.getByteArray(br, 4);
                        aSTLevData.data[i] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                    }
                    aSTLevData.lev = 0.0f;
                    aSTData.dataList.add(aSTLevData);
                }
                if (aSTDH.NLev - aSTDH.Flag > 0) {
                    for (i = 0; i < aSTDH.NLev - aSTDH.Flag; ++i) {
                        aBytes = this.getByteArray(br, 4);
                        aSTLevData = new STLevData();
                        aSTLevData.lev = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        aSTLevData.data = new float[uVarNum];
                        for (int j = 0; j < uVarNum; ++j) {
                            aBytes = this.getByteArray(br, 4);
                            aSTLevData.data[j] = DataConvert.bytes2Float((byte[])aBytes, (ByteOrder)this._byteOrder);
                        }
                        aSTData.dataList.add(aSTLevData);
                    }
                }
                if (tNum != tIdx) continue;
                stDataList.add(aSTData);
                continue;
            }
            if (tNum == tIdx) break;
            ++tNum;
            if (br.getFilePointer() + 28L >= br.length()) break;
        }
        br.close();
        return stDataList;
    }

    public StationData getGroundStationData(List<STData> stDataList, int varIdx) {
        StationData stationData = new StationData();
        ArrayList<float[]> disDataList = new ArrayList<float[]>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        ArrayList<String> stations = new ArrayList<String>();
        for (STData sTData : stDataList) {
            if (sTData.STHead.Flag != 1) continue;
            String stid = sTData.STHead.STID;
            float lon = sTData.STHead.Lon;
            float lat = sTData.STHead.Lat;
            STLevData aSTLevData = sTData.dataList.get(0);
            float aValue = aSTLevData.data[varIdx];
            stations.add(stid);
            disDataList.add(new float[]{lon, lat, aValue});
        }
        double[][] discretedData = new double[disDataList.size()][3];
        int i = 0;
        for (float[] disData : disDataList) {
            discretedData[i][0] = disData[0];
            discretedData[i][1] = disData[1];
            discretedData[i][2] = disData[2];
            if (i == 0) {
                maxX = minX = disData[0];
                maxY = minY = disData[1];
            } else {
                if (minX > disData[0]) {
                    minX = disData[0];
                } else if (maxX < disData[0]) {
                    maxX = disData[0];
                }
                if (minY > disData[1]) {
                    minY = disData[1];
                } else if (maxY < disData[1]) {
                    maxY = disData[1];
                }
            }
            ++i;
        }
        Extent extent = new Extent();
        extent.minX = minX;
        extent.maxX = maxX;
        extent.minY = minY;
        extent.maxY = maxY;
        stationData.data = discretedData;
        stationData.dataExtent = extent;
        stationData.stations = stations;
        stationData.missingValue = this.getMissingValue();
        return stationData;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        if (levelIdx == 0) {
            try {
                List<STData> stationData = this.readGrADSData_Station(timeIdx);
                int varIdx = this.getVariableIndex(varName);
                return this.getGroundStationData(stationData, varIdx);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IOException ex) {
                Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return null;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addTime(LocalDateTime time) {
        this.TDEF.times.add(time);
    }

    public void writeGrADSCTLFile() {
        try {
            String tStr;
            int i;
            String aLine;
            File file = new File(this.getFileName());
            BufferedWriter sw = new BufferedWriter(new FileWriter(file));
            String fn = this.DSET;
            sw.write("DSET ^" + new File(fn).getName());
            sw.newLine();
            if (!this.DTYPE.equals("GRIDDED")) {
                sw.write("DTYPE " + this.DTYPE);
                sw.newLine();
            }
            sw.write("TITLE " + this.TITLE);
            sw.newLine();
            String line = "OPTIONS";
            if (this.OPTIONS.sequential) {
                line = line + " sequential";
            }
            if (this.OPTIONS.big_endian) {
                line = line + " big_endian";
            }
            if (line.length() > "OPTIONS".length()) {
                sw.write(line);
                sw.newLine();
            }
            sw.write("UNDEF " + String.valueOf(this.getMissingValue()));
            sw.newLine();
            if (this.DTYPE.equals("GRIDDED")) {
                aLine = "XDEF " + String.valueOf(this.XDEF.XNum) + " " + this.XDEF.Type;
                if (this.XDEF.Type.toUpperCase().equals("LINEAR")) {
                    aLine = aLine + " " + String.valueOf(this.XDEF.XMin) + " " + String.valueOf(this.XDEF.XDelt);
                } else {
                    for (i = 0; i < this.XDEF.XNum; ++i) {
                        aLine = aLine + " " + String.valueOf(this.XDEF.X[i]);
                    }
                }
                sw.write(aLine);
                sw.newLine();
                aLine = "YDEF " + String.valueOf(this.YDEF.YNum) + " " + this.YDEF.Type;
                if (this.YDEF.Type.toUpperCase().equals("LINEAR")) {
                    aLine = aLine + " " + String.valueOf(this.YDEF.YMin) + " " + String.valueOf(this.YDEF.YDelt);
                } else {
                    for (i = 0; i < this.YDEF.YNum; ++i) {
                        aLine = aLine + " " + String.valueOf(this.YDEF.Y[i]);
                    }
                }
                sw.write(aLine);
                sw.newLine();
                aLine = "ZDEF " + String.valueOf(this.ZDEF.ZNum) + " " + this.ZDEF.Type;
                if (this.ZDEF.Type.toUpperCase().equals("LINEAR")) {
                    aLine = aLine + " " + String.valueOf(this.ZDEF.SLevel) + " " + String.valueOf(this.ZDEF.ZDelt);
                } else {
                    for (i = 0; i < this.ZDEF.ZNum; ++i) {
                        aLine = aLine + " " + String.valueOf(this.ZDEF.ZLevels[i]);
                    }
                }
                sw.write(aLine);
                sw.newLine();
            }
            aLine = "TDEF " + String.valueOf(this.TDEF.getTimeNum()) + " " + this.TDEF.Type;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm-ddMMMyyyy", Locale.ENGLISH);
            if (this.TDEF.Type.toUpperCase().equals("LINEAR")) {
                tStr = formatter.format(this.TDEF.STime);
                tStr = tStr.replace("-", "Z");
                aLine = aLine + " " + tStr + " " + this.TDEF.TDelt;
                sw.write(aLine);
                sw.newLine();
            } else {
                sw.write(aLine);
                sw.newLine();
                for (i = 0; i < this.TDEF.getTimeNum(); ++i) {
                    tStr = formatter.format(this.TDEF.times.get(i));
                    tStr = tStr.replace("-", "Z");
                    sw.write("  " + tStr);
                    sw.newLine();
                }
            }
            sw.write("VARS " + String.valueOf(this.VARDEF.getVNum()));
            sw.newLine();
            for (i = 0; i < this.VARDEF.getVNum(); ++i) {
                sw.write("  " + this.VARDEF.getVars().get(i).getName() + " " + this.VARDEF.getVars().get(i).getLevelNum() + " 99 " + this.VARDEF.getVars().get(i).getDescription() + " (" + this.VARDEF.getVars().get(i).getUnits() + ")");
                sw.newLine();
            }
            sw.write("ENDVARS");
            sw.newLine();
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createDataFile(String aFile) throws IOException {
        this._bw = new DataOutputStream(new FileOutputStream(new File(aFile)));
    }

    public void closeDataFile() throws IOException {
        this._bw.close();
    }

    public void writeGridData(GridData gridData) {
        try {
            this.writeGrADSData_Grid(this._bw, gridData.getData());
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeGridData(double[][] gridData) {
        try {
            this.writeGrADSData_Grid(this._bw, gridData);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeGrADSData_Grid(DataOutputStream bw, double[][] gridData) throws IOException {
        int ynum = gridData.length;
        int xnum = gridData[0].length;
        EndianDataOutputStream ebw = new EndianDataOutputStream((OutputStream)bw);
        if (this.OPTIONS.sequential) {
            if (this._byteOrder == ByteOrder.BIG_ENDIAN) {
                ebw.writeIntBE(xnum * ynum * 4);
            } else {
                ebw.writeIntLE(xnum * ynum * 4);
            }
        }
        byte[] bytes = new byte[ynum * xnum * 4];
        int p = 0;
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                byte[] bs = DataConvert.float2Bytes((float)((float)gridData[i][j]), (ByteOrder)this._byteOrder);
                for (int k = 0; k < 4; ++k) {
                    bytes[p + k] = bs[k];
                }
                p += 4;
            }
        }
        ebw.write(bytes, 0, bytes.length);
        if (this.OPTIONS.sequential) {
            if (this._byteOrder == ByteOrder.BIG_ENDIAN) {
                ebw.writeIntBE(xnum * ynum * 4);
            } else {
                ebw.writeIntLE(xnum * ynum * 4);
            }
        }
    }

    public void writeGridData_Null() {
        this.writeGrADSData_Grid_Null(this._bw);
    }

    public void writeGrADSData_Grid_Null(DataOutputStream bw) {
        double[][] gridData = new double[this.YDEF.YNum][this.XDEF.XNum];
        for (int i = 0; i < this.YDEF.YNum; ++i) {
            for (int j = 0; j < this.XDEF.XNum; ++j) {
                gridData[i][j] = this.getMissingValue();
            }
        }
        try {
            this.writeGrADSData_Grid(bw, gridData);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeStationData(StationInfoData stInfoData) {
        try {
            this.writeStationData(this._bw, stInfoData);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void writeStationData(DataOutputStream bw, StationInfoData stInfoData) throws IOException {
        String aStid = "11111";
        float lon = 0.0f;
        float lat = 0.0f;
        float t = 0.0f;
        int nLev = 1;
        int flag = 1;
        int varNum = stInfoData.getVariables().size();
        EndianDataOutputStream ebw = new EndianDataOutputStream((OutputStream)bw);
        for (int i = 0; i < stInfoData.getDataList().size(); ++i) {
            List<String> dataList = stInfoData.getDataList().get(i);
            aStid = dataList.get(0);
            lon = Float.parseFloat(dataList.get(1));
            lat = Float.parseFloat(dataList.get(2));
            aStid = String.format("%1$-8s", aStid);
            bw.write(aStid.getBytes());
            ebw.writeFloatLE(lat);
            ebw.writeFloatLE(lon);
            ebw.writeFloatLE(t);
            ebw.writeIntLE(nLev);
            ebw.writeIntLE(flag);
            for (int j = 0; j < varNum; ++j) {
                float value = Float.parseFloat(dataList.get(j + 3));
                ebw.writeFloatLE(value);
            }
        }
        nLev = 0;
        aStid = String.format("%1$-8s", aStid);
        bw.write(aStid.getBytes());
        ebw.writeFloatLE(lat);
        ebw.writeFloatLE(lon);
        ebw.writeFloatLE(t);
        ebw.writeIntLE(nLev);
        ebw.writeIntLE(flag);
    }

    public void writeStationData(StationData stData) {
        try {
            this.writeStationData(this._bw, stData);
        }
        catch (IOException ex) {
            Logger.getLogger(GrADSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void writeStationData(DataOutputStream bw, StationData stData) throws IOException {
        String aStid = "11111";
        float lon = 0.0f;
        float lat = 0.0f;
        float t = 0.0f;
        int nLev = 1;
        int flag = 1;
        EndianDataOutputStream ebw = new EndianDataOutputStream((OutputStream)bw);
        for (int i = 0; i < stData.getStNum(); ++i) {
            aStid = stData.getStid(i);
            lon = (float)stData.getX(i);
            lat = (float)stData.getY(i);
            aStid = String.format("%1$-8s", aStid);
            bw.write(aStid.getBytes());
            ebw.writeFloatLE(lat);
            ebw.writeFloatLE(lon);
            ebw.writeFloatLE(t);
            ebw.writeIntLE(nLev);
            ebw.writeIntLE(flag);
            float value = (float)stData.getValue(i);
            ebw.writeFloatLE(value);
        }
        nLev = 0;
        aStid = String.format("%1$-8s", aStid);
        bw.write(aStid.getBytes());
        ebw.writeFloatLE(lat);
        ebw.writeFloatLE(lon);
        ebw.writeFloatLE(t);
        ebw.writeIntLE(nLev);
        ebw.writeIntLE(flag);
    }
}

