/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;

public class HYSPLITPartDataInfo
extends DataInfo
implements IStationDataInfo {
    private List<List<Integer>> _parameters = new ArrayList<List<Integer>>();

    public HYSPLITPartDataInfo() {
        this.setDataType(MeteoDataType.HYSPLIT_PARTICLE);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            this._parameters = new ArrayList<List<Integer>>();
            ArrayList<Variable> variables = new ArrayList<Variable>();
            this.addAttribute(new Attribute("data_format", "HYSPLIT Particles"));
            int i = 0;
            String[] varNames = new String[]{"lat", "lon", "height"};
            while (br.getFilePointer() < br.length() - 28L) {
                int pos = (int)br.getFilePointer();
                br.skipBytes(4);
                int particleNum = br.readInt();
                int pollutantNum = br.readInt();
                int year = br.readInt();
                int month = br.readInt();
                int day = br.readInt();
                int hour = br.readInt();
                year = year < 50 ? 2000 + year : 1900 + year;
                times.add(LocalDateTime.of(year, month, day, hour, 0, 0));
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(particleNum);
                data.add(pollutantNum);
                data.add(pos);
                this._parameters.add(data);
                Dimension dim = new Dimension();
                dim.setName(String.format("pnum_t%d", i));
                dim.setValues(new float[particleNum]);
                this.addDimension(dim);
                for (String varName : varNames) {
                    Variable var = new Variable();
                    var.setStation(true);
                    var.setName(String.format("%s_t%d", varName, i));
                    var.setDimension(dim);
                    var.setDataType(DataType.FLOAT);
                    var.addAttribute(new Attribute("time_index", i));
                    if (varName == "lon") {
                        var.addAttribute("long_name", "longitude");
                    } else if (varName == "lat") {
                        var.addAttribute("long_name", "latitude");
                    } else {
                        var.addAttribute("long_name", "height");
                    }
                    variables.add(var);
                }
                int len = (8 + pollutantNum * 4 + 60) * particleNum + 4;
                br.skipBytes(len);
                ++i;
            }
            br.close();
            ArrayList<Double> values = new ArrayList<Double>();
            for (LocalDateTime t : times) {
                values.add(JDateUtil.toOADate((LocalDateTime)t));
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            this.addDimension(tDim);
            this.setVariables(variables);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            int timeIdx = (Integer)var.findAttribute("time_index").getNumericValue();
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            Array r = Array.factory((DataType)var.getDataType(), (int[])new int[]{particleNum});
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            br.seek(pos);
            br.skipBytes(28);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                if (varName.startsWith("lon")) {
                    r.setFloat(i, lon);
                } else if (varName.startsWith("lat")) {
                    r.setFloat(i, lat);
                } else {
                    r.setFloat(i, alt);
                }
                br.skipBytes(40);
            }
            return r;
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataFrame readDataFrame(int timeIdx) {
        try {
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            ArrayList<Array> data = new ArrayList<Array>();
            ColumnIndex columns = new ColumnIndex();
            for (Variable var : this.variables) {
                if ((Integer)var.findAttribute("time_index").getNumericValue() != timeIdx) continue;
                columns.add((Object)new Column(var.getName(), var.getDataType()));
                data.add(Array.factory((DataType)var.getDataType(), (int[])new int[]{particleNum}));
            }
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            br.seek(pos);
            br.skipBytes(28);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                ((Array)data.get(0)).setFloat(i, lat);
                ((Array)data.get(1)).setFloat(i, lon);
                ((Array)data.get(2)).setFloat(i, alt);
                br.skipBytes(40);
            }
            Index index = Index.factory((int)particleNum);
            DataFrame df = new DataFrame(data, index, columns);
            return df;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        try {
            StationData stationData = new StationData();
            ArrayList<String> stations = new ArrayList<String>();
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            double[][] discreteData = new double[particleNum][3];
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            float minX = 0.0f;
            float maxX = 0.0f;
            float minY = 0.0f;
            float maxY = 0.0f;
            br.seek(pos);
            br.skipBytes(28);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                discreteData[i][0] = lon;
                discreteData[i][1] = lat;
                discreteData[i][2] = alt;
                stations.add("P" + String.valueOf(i + 1));
                br.skipBytes(40);
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                    continue;
                }
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                    continue;
                }
                if (!(maxY < lat)) continue;
                maxY = lat;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            br.close();
            stationData.data = discreteData;
            stationData.dataExtent = dataExtent;
            stationData.stations = stations;
            return stationData;
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

