/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.BOMInputStream;
import org.meteoinfo.data.meteodata.MeteoDataType;

public class MICAPSDataInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeteoDataType getDataType(String fileName) {
        BufferedReader sr = null;
        MeteoDataType mdType = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(fileName)), "gbk"));
            String aLine = sr.readLine().trim();
            if (aLine.substring(0, 4).equals("mdfs")) {
                mdType = MeteoDataType.MICAPS_MDFS;
            } else {
                String[] dataArray = aLine.split("\\s+");
                String dataType = dataArray[0] + " " + dataArray[1];
                if ((dataType = dataType.trim().toLowerCase()).contains("iamond 1")) {
                    mdType = MeteoDataType.MICAPS_1;
                }
                if (dataType.equals("diamond 2")) {
                    mdType = MeteoDataType.MICAPS_2;
                }
                if (dataType.equals("diamond 3")) {
                    mdType = MeteoDataType.MICAPS_3;
                }
                if (dataType.equals("diamond 4")) {
                    mdType = MeteoDataType.MICAPS_4;
                }
                if (dataType.equals("diamond 7")) {
                    mdType = MeteoDataType.MICAPS_7;
                }
                if (dataType.equals("diamond 11")) {
                    mdType = MeteoDataType.MICAPS_11;
                }
                if (dataType.equals("diamond 13")) {
                    mdType = MeteoDataType.MICAPS_13;
                }
                if (dataType.contains("iamond 120")) {
                    mdType = MeteoDataType.MICAPS_120;
                }
                if (dataType.contains("diamond 131")) {
                    mdType = MeteoDataType.MICAPS_131;
                }
                if (mdType == null) {
                    System.out.println(String.format("Unknown MICAPS data file type: %s", dataType));
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return mdType;
    }
}

