/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.metar;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;

public class METARDataInfo
extends DataInfo
implements IStationDataInfo {
    private String stFileName;
    private LocalDateTime date;
    private int stationNum;
    private final List<String> varList;
    private List<List<String>> DataList;

    public METARDataInfo() {
        String[] items = new String[]{"WindDirection", "WindSpeed", "Visibility", "Weather", "CloudCover", "Temperature", "DewPoint", "Altimeter"};
        this.varList = Arrays.asList(items);
        this.DataList = new ArrayList<List<String>>();
        this.setDataType(MeteoDataType.METAR);
    }

    public String getStationFileName() {
        return this.stFileName;
    }

    public void setStationFileName(String value) {
        this.stFileName = value;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            String[] dataArray;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader(new FileInputStream(this.stFileName)));
            ArrayList<String> stNameList = new ArrayList<String>();
            ArrayList<String[]> stPosList = new ArrayList<String[]>();
            sr.readLine();
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                dataArray = aLine.split(",");
                stNameList.add(dataArray[1]);
                stPosList.add(new String[]{dataArray[2], dataArray[3]});
            }
            sr.close();
            sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            ArrayList<List<String>> disDataList = new ArrayList<List<String>>();
            ArrayList<String> stList = new ArrayList<String>();
            aLine = sr.readLine();
            if (aLine.isEmpty()) {
                aLine = sr.readLine();
            }
            aLine = aLine.trim();
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
            LocalDateTime ddate = LocalDateTime.parse(aLine, format);
            ddate = ddate.plusMinutes(29L);
            this.date = ddate = ddate.minusMinutes(ddate.getMinute());
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty() || (aLine = aLine.trim()).length() == 16) continue;
                dataArray = aLine.split("\\s+");
                ArrayList<String> dataList = new ArrayList<String>();
                for (int i = 0; i < dataArray.length; ++i) {
                    dataList.add(dataArray[i]);
                }
                String stName = (String)dataList.get(0);
                int stIdx = stNameList.indexOf(stName);
                int stIdx1 = stList.indexOf(stName);
                if (stIdx < 0 || stIdx1 >= 0) continue;
                stList.add(stName);
                dataList.add(0, ((String[])stPosList.get(stIdx))[0]);
                dataList.add(0, ((String[])stPosList.get(stIdx))[1]);
                disDataList.add(dataList);
            }
            sr.close();
            this.stationNum = disDataList.size();
            this.DataList = disDataList;
            Dimension tdim = new Dimension(DimensionType.T);
            double[] values = new double[]{JDateUtil.toOADate((LocalDateTime)this.date)};
            tdim.setValues(values);
            this.setTimeDimension(tdim);
            ArrayList<Variable> vars = new ArrayList<Variable>();
            for (String vName : this.varList) {
                Variable var = new Variable();
                var.setName(vName);
                var.setDimension(tdim);
                var.setStation(true);
                vars.add(var);
            }
            this.setVariables(vars);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(METARDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(METARDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(METARDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().get(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + "Station Number: " + String.valueOf(this.stationNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Number of Variables = " + String.valueOf(this.getVariableNum());
        for (int i = 0; i < this.getVariableNum(); ++i) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this.getVariableNames().get(i);
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int i;
        int varIdx = this.getVariableIndex(varName);
        StationData stationData = new StationData();
        ArrayList<String> stations = new ArrayList<String>();
        double t = 0.0;
        ArrayList<double[]> discreteData = new ArrayList<double[]>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        block16: for (i = 0; i < this.DataList.size(); ++i) {
            String dataStr;
            List<String> dataList = this.DataList.get(i);
            String aStid = dataList.get(2);
            float lon = Float.parseFloat(dataList.get(0));
            float lat = Float.parseFloat(dataList.get(1));
            double[] disData = new double[]{lon, lat, -9999.0};
            stations.add(aStid);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
            } else {
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                } else if (maxY < lat) {
                    maxY = lat;
                }
            }
            int nVIdx = varIdx + 4;
            if (dataList.get(4).toUpperCase().equals("AUTO")) {
                ++nVIdx;
            }
            if (varIdx >= 1) {
                --nVIdx;
            }
            if (varIdx >= 2) {
                if (dataList.get(nVIdx - (varIdx - 2)).contains("V")) {
                    ++nVIdx;
                }
                if (!MIMath.isNumeric((String)(dataStr = dataList.get(nVIdx - (varIdx - 2)))) && dataStr.length() < 3 || dataStr.length() >= 3 && !dataStr.substring(dataStr.length() - 2).equals("SM") && !dataStr.substring(dataStr.length() - 3).equals("NDV")) {
                    if (varIdx == 2) continue;
                    --nVIdx;
                }
            }
            if (varIdx >= 3) {
                if (dataList.size() <= nVIdx) continue;
                while (dataList.get(nVIdx - (varIdx - 3)).substring(0, 1).equals("R") && dataList.get(nVIdx - (varIdx - 3)).contains("/")) {
                    ++nVIdx;
                }
                dataStr = dataList.get(nVIdx - (varIdx - 3));
                if (!(dataStr.substring(0, 1).equals("+") || dataStr.substring(0, 1).equals("-") || dataStr.substring(0, 2).equals("VC") || dataStr.length() == 2 || dataStr.length() == 4)) {
                    if (varIdx == 3) continue;
                    --nVIdx;
                }
            }
            if (varIdx >= 4 && dataList.get(nVIdx - (varIdx - 4)).length() == 2) {
                ++nVIdx;
            }
            if (varIdx >= 5) {
                while ((dataStr = dataList.get(nVIdx - (varIdx - 5))).length() == 6 && MIMath.isNumeric((String)dataStr.substring(dataStr.length() - 3)) || dataStr.length() == 9 && dataStr.substring(dataStr.length() - 3).equals("///") || dataStr.substring(0, 1).equals("/")) {
                    ++nVIdx;
                }
            }
            if (varIdx >= 6) {
                --nVIdx;
            }
            if (nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            block0 : switch (varIdx) {
                case 0: {
                    if (dataStr.length() < 7 || !MIMath.isNumeric((String)dataStr.substring(0, 3))) continue block16;
                    t = Double.parseDouble(dataStr.substring(0, 3));
                    break;
                }
                case 1: {
                    if (dataStr.length() < 7 || !MIMath.isNumeric((String)dataStr.substring(3, 5))) continue block16;
                    t = Double.parseDouble(dataStr.substring(3, 5));
                    if (!dataStr.substring(5, 7).toUpperCase().equals("KT")) break;
                    t *= 0.51444;
                    break;
                }
                case 2: {
                    if (MIMath.isNumeric((String)dataStr)) {
                        t = Double.parseDouble(dataStr);
                        break;
                    }
                    if (dataStr.length() < 3) continue block16;
                    if (dataStr.substring(dataStr.length() - 2).toUpperCase().equals("SM")) {
                        if ((dataStr = dataStr.substring(0, dataStr.length() - 2)).contains("/")) {
                            if (dataStr.substring(0, 1).toUpperCase().equals("M")) {
                                dataStr = dataStr.substring(1);
                            }
                            t = Integer.parseInt(dataStr.substring(0, dataStr.indexOf("/"))) / Integer.parseInt(dataStr.substring(dataStr.indexOf("/") + 1));
                        } else {
                            t = Double.parseDouble(dataStr);
                        }
                        t *= 1603.9;
                        break;
                    }
                    if (!dataStr.substring(dataStr.length() - 3, 3).toUpperCase().equals("NDV")) continue block16;
                    dataStr = dataStr.substring(0, dataStr.length() - 3);
                    t = Double.parseDouble(dataStr);
                    break;
                }
                case 3: {
                    switch (dataStr.length()) {
                        case 2: {
                            int wIdx = this.getWeatherIndex(dataStr, "", "");
                            if (wIdx < 0) break;
                            t = wIdx;
                            break block0;
                        }
                        case 3: {
                            int wIdx;
                            if (!dataStr.substring(0, 1).equals("+") && !dataStr.substring(0, 1).equals("-") || (wIdx = this.getWeatherIndex(dataStr.substring(1, 3), dataStr.substring(0, 1), "")) < 0) break;
                            t = wIdx;
                            break block0;
                        }
                        case 4: {
                            int wIdx = this.getWeatherIndex(dataStr.substring(2, 4), "", dataStr.substring(0, 2));
                            if (wIdx < 0) break;
                            t = wIdx;
                            break block0;
                        }
                        case 5: {
                            int wIdx;
                            if (!dataStr.substring(0, 1).equals("+") && !dataStr.substring(0, 1).equals("-") || (wIdx = this.getWeatherIndex(dataStr.substring(3, 5), dataStr.substring(0, 1), dataStr.substring(1, 3))) < 0) break;
                            t = wIdx;
                            break block0;
                        }
                    }
                    continue block16;
                }
                case 4: {
                    int cCover;
                    if (dataStr.length() < 2) continue block16;
                    if (dataStr.substring(0, 2).equals("VV")) {
                        t = 9.0;
                        break;
                    }
                    if (dataStr.equals("CAVOK")) {
                        t = 0.0;
                        break;
                    }
                    if (dataStr.length() < 3 || (cCover = this.getCloudCover(dataStr = dataStr.substring(0, 3))) < 0) continue block16;
                    t = cCover;
                    break;
                }
                case 5: {
                    if (!dataStr.contains("/") || (dataStr = dataStr.substring(0, dataStr.indexOf("/"))).length() == 0) continue block16;
                    if (dataStr.substring(0, 1).equals("M")) {
                        dataStr = dataStr.replace("M", "-");
                    }
                    if (!MIMath.isNumeric((String)dataStr)) continue block16;
                    t = Double.parseDouble(dataStr);
                    break;
                }
                case 6: {
                    if (!dataStr.contains("/") || (dataStr = dataStr.substring(dataStr.indexOf("/") + 1)).length() == 0) continue block16;
                    if (dataStr.substring(0, 1).equals("M")) {
                        dataStr = dataStr.replace("M", "-");
                    }
                    if (!MIMath.isNumeric((String)dataStr)) continue block16;
                    t = Double.parseDouble(dataStr);
                    break;
                }
                case 7: {
                    String altType = dataStr.substring(0, 1);
                    if (dataStr.length() <= 1 || !altType.equals("A") && !altType.equals("Q") || !MIMath.isNumeric((String)(dataStr = dataStr.substring(1)))) continue block16;
                    t = Double.parseDouble(dataStr);
                    if (altType.equals("A")) {
                        t = t * 33.863 / 100.0;
                    }
                    if (t < 10.0) continue block16;
                }
            }
            disData[2] = t;
            discreteData.add(disData);
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        stationData.data = new double[discreteData.size()][3];
        i = 0;
        while (true) {
            if (i >= discreteData.size()) {
                stationData.dataExtent = dataExtent;
                stationData.stations = stations;
                return stationData;
            }
            stationData.data[i][0] = ((double[])discreteData.get(i))[0];
            stationData.data[i][1] = ((double[])discreteData.get(i))[1];
            stationData.data[i][2] = ((double[])discreteData.get(i))[2];
            ++i;
        }
    }

    private int getWeatherIndex(String wStr, String intensity, String descriptor) {
        int wIdx = -1;
        block20 : switch (wStr.toUpperCase()) {
            case "DZ": {
                switch (intensity) {
                    case "+": {
                        switch (descriptor) {
                            case "FZ": {
                                wIdx = 57;
                                break block20;
                            }
                        }
                        wIdx = 55;
                        break block20;
                    }
                    case "-": {
                        switch (descriptor) {
                            case "FZ": {
                                wIdx = 56;
                                break block20;
                            }
                        }
                        wIdx = 51;
                        break block20;
                    }
                }
                switch (descriptor) {
                    case "FZ": {
                        wIdx = 57;
                        break block20;
                    }
                }
                wIdx = 53;
                break;
            }
            case "RA": {
                switch (intensity) {
                    case "+": {
                        switch (descriptor) {
                            case "FZ": {
                                wIdx = 67;
                                break block20;
                            }
                            case "TS": {
                                wIdx = 92;
                                break block20;
                            }
                            case "SH": {
                                wIdx = 81;
                                break block20;
                            }
                        }
                        wIdx = 65;
                        break block20;
                    }
                    case "-": {
                        switch (descriptor) {
                            case "FZ": {
                                wIdx = 66;
                                break block20;
                            }
                            case "TS": {
                                wIdx = 91;
                                break block20;
                            }
                            case "SH": {
                                wIdx = 80;
                                break block20;
                            }
                        }
                        wIdx = 61;
                        break block20;
                    }
                }
                switch (descriptor) {
                    case "FZ": {
                        wIdx = 67;
                        break block20;
                    }
                    case "TS": {
                        wIdx = 92;
                        break block20;
                    }
                    case "SH": {
                        wIdx = 81;
                        break block20;
                    }
                }
                wIdx = 63;
                break;
            }
            case "SN": {
                switch (intensity) {
                    case "+": {
                        switch (descriptor) {
                            case "TS": {
                                wIdx = 94;
                                break block20;
                            }
                            case "SH": {
                                wIdx = 86;
                                break block20;
                            }
                        }
                        wIdx = 75;
                        break block20;
                    }
                    case "-": {
                        switch (descriptor) {
                            case "TS": {
                                wIdx = 93;
                                break block20;
                            }
                            case "SH": {
                                wIdx = 85;
                                break block20;
                            }
                        }
                        wIdx = 71;
                        break block20;
                    }
                }
                switch (descriptor) {
                    case "TS": {
                        wIdx = 94;
                        break block20;
                    }
                    case "SH": {
                        wIdx = 86;
                        break block20;
                    }
                }
                wIdx = 73;
                break;
            }
            case "SG": {
                wIdx = 77;
                break;
            }
            case "IC": {
                wIdx = 76;
                break;
            }
            case "PE": {
                switch (descriptor) {
                    case "SH": {
                        if (intensity.equals("-")) {
                            wIdx = 87;
                            break block20;
                        }
                        wIdx = 88;
                        break block20;
                    }
                }
                wIdx = 79;
                break;
            }
            case "GR": {
                switch (descriptor) {
                    case "TS": {
                        if (intensity.equals("+")) {
                            wIdx = 99;
                            break block20;
                        }
                        wIdx = 96;
                        break block20;
                    }
                }
                if (intensity.equals("-")) {
                    wIdx = 89;
                    break;
                }
                wIdx = 90;
                break;
            }
            case "GS": {
                wIdx = 89;
                break;
            }
            case "BR": {
                wIdx = 10;
                break;
            }
            case "FG": {
                wIdx = 45;
                break;
            }
            case "FU": {
                wIdx = 4;
                break;
            }
            case "DU": {
                wIdx = 6;
                break;
            }
            case "SA": {
                wIdx = 7;
                break;
            }
            case "HZ": {
                wIdx = 5;
                break;
            }
            case "PO": {
                wIdx = 8;
                break;
            }
            case "SQ": {
                wIdx = 39;
                break;
            }
            case "FC": {
                wIdx = 19;
                break;
            }
            case "SS": {
                switch (intensity) {
                    case "+": {
                        wIdx = 34;
                        break block20;
                    }
                    case "-": {
                        wIdx = 31;
                        break block20;
                    }
                }
                wIdx = 31;
            }
        }
        return wIdx;
    }

    private int getCloudCover(String cStr) {
        int cCover = -1;
        switch (cStr) {
            case "CLR": 
            case "SKC": {
                cCover = 0;
                break;
            }
            case "FEW": {
                cCover = 1;
                break;
            }
            case "SCT": {
                cCover = 3;
                break;
            }
            case "BKN": {
                cCover = 6;
                break;
            }
            case "OVC": {
                cCover = 8;
            }
        }
        return cCover;
    }

    private double getDataValue(List<String> dataList, int vIdx, int sIdx, String windSpeedIndicator) {
        double value = this.getMissingValue();
        switch (vIdx) {
            case 0: {
                String str = dataList.get(sIdx);
                if (str.length() != 5 || (str = str.substring(3)).contains("/")) break;
                value = Integer.parseInt(str);
                if (value <= 50.0) {
                    value /= 10.0;
                    break;
                }
                if (value >= 56.0 && value <= 80.0) {
                    value -= 50.0;
                    break;
                }
                if (value >= 81.0 && value <= 89.0) {
                    value = 30.0 + (value - 80.0) * 5.0;
                    break;
                }
                if (!(value >= 90.0) || !(value <= 99.0)) break;
                switch ((int)value) {
                    case 90: {
                        value = 0.04;
                        break;
                    }
                    case 91: {
                        value = 0.05;
                        break;
                    }
                    case 92: {
                        value = 0.2;
                        break;
                    }
                    case 93: {
                        value = 0.5;
                        break;
                    }
                    case 94: {
                        value = 1.0;
                        break;
                    }
                    case 95: {
                        value = 2.0;
                        break;
                    }
                    case 96: {
                        value = 4.0;
                        break;
                    }
                    case 97: {
                        value = 10.0;
                        break;
                    }
                    case 98: {
                        value = 20.0;
                        break;
                    }
                    case 99: {
                        value = 50.0;
                    }
                }
                break;
            }
            case 1: {
                String str = dataList.get(sIdx + 1);
                if (str.length() != 5 || (str = str.substring(0, 1)).equals("/")) break;
                value = Integer.parseInt(str);
                break;
            }
            case 2: {
                String str = dataList.get(sIdx + 1);
                if (str.length() != 5 || (str = str.substring(1, 3)).equals("//") || !((value = (double)(Integer.parseInt(str) * 10)) > 360.0)) break;
                value = 0.0;
                break;
            }
            case 3: {
                String str;
                if (windSpeedIndicator.equals("/") || (str = dataList.get(sIdx + 1)).length() != 5 || (str = str.substring(3)).contains("/")) break;
                if (str.equals("99")) {
                    str = dataList.get(sIdx + 2).substring(2);
                    if (str.contains("/")) break;
                    value = Integer.parseInt(str);
                } else {
                    value = Integer.parseInt(str);
                }
                if (!windSpeedIndicator.equals("3") && !windSpeedIndicator.equals("4")) break;
                value *= 0.51444;
                break;
            }
            case 4: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("1")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/")) break;
                String sign = str.substring(1, 2);
                value = Double.parseDouble(str.substring(2)) / 10.0;
                if (!sign.equals("1")) break;
                value = -value;
                break;
            }
            case 5: {
                String sign;
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("2")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || (sign = str.substring(1, 2)).equals("9")) break;
                value = Double.parseDouble(str.substring(2)) / 10.0;
                if (!sign.equals("1")) break;
                value = -value;
                break;
            }
            case 6: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("3")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || !MIMath.isNumeric((String)str.substring(1))) break;
                value = Double.parseDouble(str.substring(1)) / 10.0;
                if (!((value /= 10.0) < 500.0)) break;
                value += 1000.0;
                break;
            }
            case 7: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("6")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || !((value = Double.parseDouble(str.substring(1, 4))) >= 990.0)) break;
                value -= 990.0;
                break;
            }
            case 8: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("7")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.substring(1, 3).contains("/")) break;
                value = Integer.parseInt(str.substring(1, 3));
            }
        }
        return value;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        return null;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        StationModelData smData = new StationModelData();
        ArrayList<StationModel> smList = new ArrayList<StationModel>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        for (int i = 0; i < this.DataList.size(); ++i) {
            double t;
            List<String> dataList = this.DataList.get(i);
            String aStid = dataList.get(2);
            float lon = Float.parseFloat(dataList.get(0));
            float lat = Float.parseFloat(dataList.get(1));
            if (lon < 0.0f) {
                lon += 360.0f;
            }
            StationModel sm = new StationModel();
            sm.setLongitude(lon);
            sm.setLatitude(lat);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
            } else {
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                } else if (maxY < lat) {
                    maxY = lat;
                }
            }
            int nVIdx = 4;
            if (dataList.get(4).toUpperCase().equals("AUTO")) {
                ++nVIdx;
            }
            if (nVIdx >= dataList.size()) continue;
            String dataStr = dataList.get(nVIdx);
            if (dataStr.length() >= 7 && MIMath.isNumeric((String)dataStr.substring(0, 3))) {
                t = Double.parseDouble(dataStr.substring(0, 3));
                sm.setWindDirection(t);
            }
            if (dataStr.length() >= 7 && MIMath.isNumeric((String)dataStr.substring(3, 5))) {
                t = Double.parseDouble(dataStr.substring(3, 5));
                if (dataStr.substring(5, 7).toUpperCase().equals("KT")) {
                    t *= 0.51444;
                }
                sm.setWindSpeed(t);
            }
            if (++nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            if (dataStr.contains("V")) {
                ++nVIdx;
            }
            if (nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            if (MIMath.isNumeric((String)dataStr)) {
                t = Double.parseDouble(dataStr);
                sm.setVisibility(t);
            } else if (dataStr.length() >= 3) {
                if (dataStr.substring(dataStr.length() - 2).toUpperCase().equals("SM")) {
                    if ((dataStr = dataStr.substring(0, dataStr.length() - 2)).contains("/")) {
                        if (dataStr.substring(0, 1).toUpperCase().equals("M")) {
                            dataStr = dataStr.substring(1);
                        }
                        t = Integer.parseInt(dataStr.substring(0, dataStr.indexOf("/"))) / Integer.parseInt(dataStr.substring(dataStr.indexOf("/") + 1));
                    } else {
                        t = Double.parseDouble(dataStr);
                    }
                    sm.setVisibility(t *= 1603.9);
                } else if (dataStr.substring(dataStr.length() - 3).toUpperCase().equals("NDV")) {
                    dataStr = dataStr.substring(0, dataStr.length() - 3);
                    t = Double.parseDouble(dataStr);
                    sm.setVisibility(t);
                } else {
                    --nVIdx;
                }
            } else {
                --nVIdx;
            }
            if (++nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            while (dataStr.substring(0, 1).equals("R") && dataStr.contains("/")) {
                if (++nVIdx >= dataList.size()) continue;
                dataStr = dataList.get(nVIdx);
            }
            dataStr = dataList.get(nVIdx);
            switch (dataStr.length()) {
                case 2: {
                    int wIdx = this.getWeatherIndex(dataStr, "", "");
                    if (wIdx >= 0) {
                        t = wIdx;
                        sm.setWeather(t);
                        break;
                    }
                    --nVIdx;
                    break;
                }
                case 3: {
                    int wIdx;
                    if (dataStr.substring(0, 1).equals("+") || dataStr.substring(0, 1).equals("-")) {
                        wIdx = this.getWeatherIndex(dataStr.substring(1, 3), dataStr.substring(0, 1), "");
                        if (wIdx >= 0) {
                            t = wIdx;
                            sm.setWeather(t);
                            break;
                        }
                        --nVIdx;
                        break;
                    }
                    --nVIdx;
                    break;
                }
                case 4: {
                    int wIdx = this.getWeatherIndex(dataStr.substring(2, 4), "", dataStr.substring(0, 2));
                    if (wIdx >= 0) {
                        t = wIdx;
                        sm.setWeather(t);
                        break;
                    }
                    --nVIdx;
                    break;
                }
                case 5: {
                    int wIdx;
                    if (dataStr.substring(0, 1).equals("+") || dataStr.substring(0, 1).equals("-")) {
                        wIdx = this.getWeatherIndex(dataStr.substring(3, 5), dataStr.substring(0, 1), dataStr.substring(1, 3));
                        if (wIdx >= 0) {
                            t = wIdx;
                            sm.setWeather(t);
                            break;
                        }
                        --nVIdx;
                        break;
                    }
                    --nVIdx;
                    break;
                }
                default: {
                    --nVIdx;
                }
            }
            if (++nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            if (dataStr.length() == 2) {
                ++nVIdx;
            }
            if (nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            if (dataStr.length() >= 2) {
                int cCover;
                if (dataStr.substring(0, 2).equals("VV")) {
                    t = 9.0;
                    sm.setCloudCover(t);
                } else if (dataStr.equals("CAVOK")) {
                    t = 0.0;
                    sm.setCloudCover(t);
                } else if (dataStr.length() >= 3 && (cCover = this.getCloudCover(dataStr = dataStr.substring(0, 3))) >= 0) {
                    t = cCover;
                    sm.setCloudCover(t);
                }
            }
            if (++nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            while (dataStr.length() == 6 && MIMath.isNumeric((String)dataStr.substring(dataStr.length() - 3)) || dataStr.length() == 9 && dataStr.substring(dataStr.length() - 3).equals("///") || dataStr.substring(0, 1).equals("/")) {
                if (++nVIdx >= dataList.size()) continue;
                dataStr = dataList.get(nVIdx);
            }
            dataStr = dataList.get(nVIdx);
            if (dataStr.contains("/") && (dataStr = dataStr.substring(0, dataStr.indexOf("/"))).length() > 0) {
                if (dataStr.substring(0, 1).equals("M")) {
                    dataStr = dataStr.replace("M", "-");
                }
                if (MIMath.isNumeric((String)dataStr)) {
                    t = Double.parseDouble(dataStr);
                    sm.setTemperature(t);
                }
            }
            if ((dataStr = dataList.get(nVIdx)).contains("/") && (dataStr = dataStr.substring(dataStr.indexOf("/") + 1)).length() > 0) {
                if (dataStr.substring(0, 1).equals("M")) {
                    dataStr = dataStr.replace("M", "-");
                }
                if (MIMath.isNumeric((String)dataStr)) {
                    t = Double.parseDouble(dataStr);
                    sm.setDewPoint(t);
                }
            }
            if (++nVIdx >= dataList.size()) continue;
            dataStr = dataList.get(nVIdx);
            String altType = dataStr.substring(0, 1);
            if (dataStr.length() > 1 && (altType.equals("A") || altType.equals("Q")) && MIMath.isNumeric((String)(dataStr = dataStr.substring(1)))) {
                t = Double.parseDouble(dataStr);
                if (altType.equals("A")) {
                    t = t * 33.863 / 100.0;
                }
                if (t > 10.0) {
                    sm.setPressure(t);
                }
            }
            smList.add(sm);
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        smData.setData(smList);
        smData.setDataExtent(dataExtent);
        smData.setMissingValue(this.getMissingValue());
        return smData;
    }
}

