/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.radar.CutConfig;
import org.meteoinfo.data.meteodata.radar.GenericHeader;
import org.meteoinfo.data.meteodata.radar.MomentHeader;
import org.meteoinfo.data.meteodata.radar.RadialHeader;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.data.meteodata.radar.SiteConfig;
import org.meteoinfo.data.meteodata.radar.TaskConfig;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class CMARadarBaseDataInfo
extends DataInfo
implements IGridDataInfo {
    private GenericHeader genericHeader;
    private SiteConfig siteConfig;
    private TaskConfig taskConfig;
    private List<CutConfig> cutConfigs;
    private Map<Integer, String> productMap = Stream.of({1, "dBT"}, {2, "dBZ"}, {3, "V"}, {4, "W"}, {5, "SQI"}, {6, "CPA"}, {7, "ZDR"}, {8, "LDR"}, {9, "CC"}, {10, "PhiDP"}, {11, "KDP"}, {12, "CP"}, {13, "Flag"}, {14, "HCL"}, {15, "CF"}, {16, "SNRH"}, {17, "SNRV"}, {18, "Flag"}, {19, "Flag"}, {20, "Flag"}, {21, "Flag"}, {22, "Flag"}, {23, "Flag"}, {24, "Flag"}, {25, "Flag"}, {26, "Flag"}, {27, "Flag"}, {28, "Flag"}, {29, "Flag"}, {30, "Flag"}, {31, "Flag"}, {32, "Zc"}, {33, "Vc"}, {34, "Wc"}, {35, "ZDRc"}, {0, "Flag"}).collect(Collectors.toMap(data -> (Integer)data[0], data -> (String)data[1]));
    private Map<String, RadialRecord> recordMap = new HashMap<String, RadialRecord>();

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            byte[] bytes = new byte[4];
            raf.read(bytes);
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean canOpen(String fileName) {
        try {
            byte[] bytes = new byte[4];
            if (fileName.endsWith("bz2")) {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)new FileInputStream(fileName));
                inputStream.read(bytes);
            } else {
                RandomAccessFile raf = new RandomAccessFile(fileName, "r");
                raf.seek(0L);
                raf.read(bytes);
            }
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void readDataInfo(String fileName) {
        this.fileName = fileName;
        if (fileName.endsWith(".bz2")) {
            try {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)new FileInputStream(fileName));
                this.readDataInfo((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            this.readDataInfo(raf);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    void readDataInfo(RandomAccessFile raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.taskConfig = new TaskConfig(raf);
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                this.cutConfigs.add(new CutConfig(raf));
            }
            ArrayList<RadialHeader> radialHeaders = new ArrayList<RadialHeader>();
            while (raf.length() - raf.getFilePointer() > (long)RadialHeader.length) {
                RadialHeader radialHeader = new RadialHeader(raf);
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = momentHeader.scale;
                        record.offset = momentHeader.offset;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)0).logResolution));
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.elevation));
                    record.azimuth.get(record.azimuth.size() - 1).add(Float.valueOf(radialHeader.azimuth));
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(bytes);
                }
                radialHeaders.add(radialHeader);
            }
            raf.close();
            Dimension xyzDim = new Dimension(DimensionType.OTHER);
            xyzDim.setShortName("xyz");
            xyzDim.setDimValue(Array.factory((DataType)DataType.INT, (int[])new int[]{3}, (Object)new int[]{1, 2, 3}));
            this.addDimension(xyzDim);
            for (String product : this.recordMap.keySet()) {
                this.recordMap.get(product).makeVariables(this, xyzDim);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void readDataInfo(InputStream raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.taskConfig = new TaskConfig(raf);
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                this.cutConfigs.add(new CutConfig(raf));
            }
            ArrayList<RadialHeader> radialHeaders = new ArrayList<RadialHeader>();
            byte[] rhBytes = new byte[RadialHeader.length];
            while (raf.read(rhBytes) != -1) {
                RadialHeader radialHeader = new RadialHeader(rhBytes);
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = momentHeader.scale;
                        record.offset = momentHeader.offset;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)0).logResolution));
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.elevation));
                    record.azimuth.get(record.azimuth.size() - 1).add(Float.valueOf(radialHeader.azimuth));
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(bytes);
                }
                radialHeaders.add(radialHeader);
            }
            raf.close();
            Dimension xyzDim = new Dimension(DimensionType.OTHER);
            xyzDim.setShortName("xyz");
            xyzDim.setDimValue(Array.factory((DataType)DataType.INT, (int[])new int[]{3}, (Object)new int[]{1, 2, 3}));
            this.addDimension(xyzDim);
            for (String product : this.recordMap.keySet()) {
                this.recordMap.get(product).makeVariables(this, xyzDim);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Array dataArray;
            int idx = varName.lastIndexOf("_s");
            int scanIdx = Integer.parseInt(varName.substring(idx + 2)) - 1;
            String product = varName.substring(0, idx);
            boolean isXYZ = product.startsWith("xyz_");
            if (isXYZ) {
                product = product.substring(4);
            }
            RadialRecord record = this.recordMap.get(product);
            if (isXYZ) {
                dataArray = record.getXYZ(scanIdx).section(origin, size, stride).copy();
            } else {
                List<Array> arrays = record.getDataArray(scanIdx);
                Section section = new Section(origin, size, stride);
                dataArray = Array.factory((DataType)record.getDataType(), (int[])section.getShape());
                Range yRange = section.getRange(0);
                Range xRange = section.getRange(1);
                IndexIterator iter = dataArray.getIndexIterator();
                for (int i = yRange.first(); i <= yRange.last(); i += yRange.stride()) {
                    Array array = arrays.get(i);
                    for (int j = xRange.first(); j <= xRange.last(); j += xRange.stride()) {
                        iter.setObjectNext(array.getObject(j));
                    }
                }
                Variable variable = this.getVariable(varName);
                Attribute aoAttr = variable.findAttribute("add_offset");
                Attribute sfAttr = variable.findAttribute("scale_factor");
                if (aoAttr != null || sfAttr != null) {
                    Number add_offset = Float.valueOf(0.0f);
                    Number scale_factor = Float.valueOf(1.0f);
                    if (aoAttr != null) {
                        switch (aoAttr.getDataType()) {
                            case DOUBLE: {
                                add_offset = aoAttr.getValues().getDouble(0);
                                break;
                            }
                            case FLOAT: 
                            case INT: {
                                add_offset = Float.valueOf(aoAttr.getValues().getFloat(0));
                            }
                        }
                    }
                    if (sfAttr != null) {
                        switch (sfAttr.getDataType()) {
                            case DOUBLE: {
                                scale_factor = sfAttr.getValues().getDouble(0);
                                break;
                            }
                            case FLOAT: 
                            case INT: {
                                scale_factor = Float.valueOf(sfAttr.getValues().getFloat(0));
                            }
                        }
                    }
                    dataArray = ArrayMath.div((Array)ArrayMath.sub((Array)dataArray, (Number)add_offset), (Number)scale_factor);
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException e) {
            return null;
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }
}

