/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.radar.CMARadarBaseDataInfo;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class RadialRecord {
    public String product;
    private int binLength;
    private DataType dataType;
    public int scale;
    public int offset;
    public List<List<Float>> elevation = new ArrayList<List<Float>>();
    public List<List<Float>> azimuth = new ArrayList<List<Float>>();
    public List<Array> distance = new ArrayList<Array>();
    private List<List<Array>> data = new ArrayList<List<Array>>();

    public RadialRecord(String product) {
        this.product = product;
    }

    public void setBinLength(int value) {
        this.binLength = value;
        this.dataType = this.binLength == 1 ? DataType.UBYTE : DataType.USHORT;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getScanNumber() {
        return this.elevation.size();
    }

    public int getRadialNumber(int scanIdx) {
        return this.elevation.get(scanIdx).size();
    }

    public int getGateNumber(int scanIdx) {
        return (int)this.distance.get(scanIdx).getSize();
    }

    public void newScanData() {
        this.data.add(new ArrayList());
    }

    public void addDataBytes(byte[] bytes) {
        Array array;
        if (this.data.isEmpty()) {
            this.data.add(new ArrayList());
        }
        if (this.dataType == DataType.UBYTE) {
            array = Array.factory((DataType)this.dataType, (int[])new int[]{bytes.length}, (Object)bytes);
        } else {
            int n = bytes.length / 2;
            array = Array.factory((DataType)this.dataType, (int[])new int[]{n});
            for (int i = 0; i < n; ++i) {
                short v = DataConvert.bytes2Short((byte[])new byte[]{bytes[i * 2], bytes[i * 2 + 1]}, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                array.setShort(i, v);
            }
        }
        this.data.get(this.data.size() - 1).add(array);
    }

    public List<Array> getDataArray(int scanIdx) {
        return this.data.get(scanIdx);
    }

    public double[] antennaToCartesian(float r, float a, float e) {
        double R = 8494666.666666666;
        double z = Math.pow((double)(r * r) + R * R + 2.0 * (double)r * R * Math.sin(e), 0.5) - R;
        double s = R * Math.asin((double)r * Math.cos(e) / (R + z));
        double x = s * Math.sin(a);
        double y = s * Math.cos(a);
        return new double[]{x, y, z};
    }

    public double[] antennaToCartesian(float r, float a, float e, float h) {
        double R = 8494666.666666666;
        double z = Math.pow(Math.pow((double)r * Math.cos(e), 2.0) + Math.pow(R + (double)h + (double)r * Math.sin(e), 2.0), 0.5) - R;
        double s = R * Math.asin((double)r * Math.cos(e) / (R + z));
        double x = s * Math.sin(a);
        double y = s * Math.cos(a);
        return new double[]{x, y, z};
    }

    public Array getXYZ(int scanIdx) {
        List<Float> azi = this.azimuth.get(scanIdx);
        Array dis = this.distance.get(scanIdx);
        List<Float> ele = this.elevation.get(scanIdx);
        int nz = 3;
        int ny = azi.size();
        int nx = (int)dis.getSize();
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nz, ny, nx});
        Index index = r.getIndex();
        for (int i = 0; i < ny; ++i) {
            float a = (float)Math.toRadians(azi.get(i).floatValue());
            float e = (float)Math.toRadians(ele.get(i).floatValue());
            for (int j = 0; j < nx; ++j) {
                double[] xyz = this.antennaToCartesian(dis.getFloat(j), a, e);
                index.set(0, i, j);
                r.setFloat(index, (float)xyz[0]);
                index.set(1, i, j);
                r.setFloat(index, (float)xyz[1]);
                index.set(2, i, j);
                r.setFloat(index, (float)xyz[2]);
            }
        }
        return r;
    }

    public void makeVariables(CMARadarBaseDataInfo dataInfo, Dimension xyzDim) {
        for (int i = 0; i < this.getScanNumber(); ++i) {
            String suffix = "_s" + String.valueOf(i + 1);
            Dimension radialDim = new Dimension(DimensionType.Y);
            radialDim.setShortName("azimuth_" + this.product + suffix);
            radialDim.setUnit("degree");
            radialDim.setDimValue(ArrayUtil.array_list(this.azimuth.get(i), (DataType)DataType.FLOAT));
            dataInfo.addDimension(radialDim);
            Dimension disDim = new Dimension(DimensionType.X);
            disDim.setShortName("distance_" + this.product + suffix);
            disDim.setUnit("meter");
            disDim.setDimValue(this.distance.get(i));
            dataInfo.addDimension(disDim);
            Dimension eleDim = new Dimension(DimensionType.OTHER);
            eleDim.setShortName("elevation_" + this.product + suffix);
            eleDim.setUnit("degree");
            eleDim.setDimValue(ArrayUtil.array_list(this.elevation.get(i), (DataType)DataType.FLOAT));
            dataInfo.addDimension(eleDim);
            Variable variable = new Variable();
            variable.setName(this.product + suffix);
            variable.setDataType(this.dataType);
            variable.addDimension(radialDim);
            variable.addDimension(disDim);
            variable.addAttribute(new Attribute("scale_factor", this.scale));
            variable.addAttribute(new Attribute("add_offset", this.offset));
            dataInfo.addVariable(variable);
            variable = new Variable();
            variable.setName("xyz_" + this.product + suffix);
            variable.setDataType(DataType.FLOAT);
            variable.addDimension(xyzDim);
            variable.addDimension(radialDim);
            variable.addDimension(disDim);
            variable.addAttribute(new Attribute("long_name", "x, y, z coordinates"));
            variable.addAttribute(new Attribute("units", "meters"));
            dataInfo.addVariable(variable);
        }
    }
}

