/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class Variable {
    public int Number;
    private String name;
    private String shortName;
    private DataType dataType;
    protected int[] shape = new int[0];
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected double addOffset = 0.0;
    protected double scaleFactor = 1.0;
    protected double fillValue = Double.NaN;
    private int levelType;
    private List<Double> levels;
    private String units;
    private String description;
    private String hdfPath;
    private boolean isStation = false;
    private boolean isSwath = false;
    private int varId;
    private boolean dimVar = false;
    private List<Integer> levelIdxs = new ArrayList<Integer>();
    private List<Integer> varInLevelIdxs = new ArrayList<Integer>();
    private Array cachedData;

    public Variable() {
        this.name = "null";
        this.shortName = null;
        this.dataType = DataType.FLOAT;
        this.levels = new ArrayList<Double>();
        this.units = "null";
        this.description = "null";
    }

    public Variable(int aNum, String aName, String aDesc, String aUnit) {
        this.Number = aNum;
        this.name = aName;
        this.units = aUnit;
        this.description = aDesc;
        this.levels = new ArrayList<Double>();
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName == null ? this.name : this.shortName;
    }

    public void setShortName(String value) {
        this.shortName = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType value) {
        this.dataType = value;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<Dimension> getDimensions(Section section) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < section.getRank(); ++i) {
            Range range = section.getRange(i);
            if (range.length() <= 1) continue;
            Dimension dim = this.dimensions.get(i).extract(range);
            dims.add(dim);
        }
        return dims;
    }

    public Dimension getDimension(int index) {
        return this.dimensions.get(index);
    }

    public void setDimensions(List<Dimension> dims) {
        this.dimensions = dims;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    public double getAddOffset() {
        return this.addOffset;
    }

    public void setAddOffset(double value) {
        this.addOffset = value;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double value) {
        this.scaleFactor = value;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double value) {
        this.fillValue = value;
    }

    public int getLevelType() {
        return this.levelType;
    }

    public void setLevelType(int value) {
        this.levelType = value;
    }

    public List<Double> getLevels() {
        Dimension zDim = this.getZDimension();
        if (zDim == null) {
            return this.levels;
        }
        return zDim.getDimValueList();
    }

    public void setLevels(List<Double> value) {
        this.levels = value;
        this.updateZDimension();
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String value) {
        this.units = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public int getDimNumber() {
        return this.getDimensions().size();
    }

    public int getLevelNum() {
        Dimension zDim = this.getZDimension();
        if (zDim == null) {
            return 0;
        }
        return zDim.getLength();
    }

    public String getHDFPath() {
        return this.hdfPath;
    }

    public void setHDFPath(String value) {
        this.hdfPath = value;
    }

    public Dimension getXDimension() {
        return this.getDimension(DimensionType.X);
    }

    public void setXDimension(Dimension value) {
        this.setDimension(value, DimensionType.X);
    }

    public Dimension getYDimension() {
        return this.getDimension(DimensionType.Y);
    }

    public void setYDimension(Dimension value) {
        this.setDimension(value, DimensionType.Y);
    }

    public Dimension getZDimension() {
        return this.getDimension(DimensionType.Z);
    }

    public void setZDimension(Dimension value) {
        this.setDimension(value, DimensionType.Z);
    }

    public Dimension getTDimension() {
        return this.getDimension(DimensionType.T);
    }

    public void setTDimension(Dimension value) {
        this.setDimension(value, DimensionType.T);
    }

    public int[] getDimIds() {
        int[] dimids = new int[this.getDimensions().size()];
        for (int i = 0; i < this.getDimensions().size(); ++i) {
            dimids[i] = this.getDimension(i).getDimId();
        }
        return dimids;
    }

    public boolean isStation() {
        return this.isStation;
    }

    public void setStation(boolean value) {
        this.isStation = value;
    }

    public boolean isSwath() {
        return this.isSwath;
    }

    public void setSwath(boolean value) {
        this.isSwath = value;
    }

    public boolean isPlottable() {
        if (this.isStation) {
            return true;
        }
        if (this.getXDimension() == null) {
            return false;
        }
        return this.getYDimension() != null;
    }

    public int getAttNumber() {
        return this.getAttributes().size();
    }

    public int getVarId() {
        return this.varId;
    }

    public void setVarId(int value) {
        this.varId = value;
    }

    public boolean isDimVar() {
        return this.dimVar;
    }

    public void setDimVar(boolean value) {
        this.dimVar = value;
    }

    public List<Integer> getLevelIdxs() {
        return this.levelIdxs;
    }

    public void setLevelIdxs(List<Integer> value) {
        this.levelIdxs = value;
    }

    public List<Integer> getVarInLevelIdxs() {
        return this.varInLevelIdxs;
    }

    public void setVarInLevelIdxs(List<Integer> value) {
        this.varInLevelIdxs = value;
    }

    public Array getCachedData() {
        return this.cachedData;
    }

    public void setCachedData(Array value) {
        this.cachedData = value;
    }

    public boolean hasCachedData() {
        return this.cachedData != null;
    }

    public Attribute findAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public Object clone() {
        Variable aPar = new Variable();
        aPar.Number = this.Number;
        aPar.setName(this.getName());
        aPar.setShortName(this.getShortName());
        aPar.setUnits(this.units);
        aPar.setDescription(this.description);
        aPar.setLevelType(this.levelType);
        aPar.getDimensions().addAll(this.getDimensions());
        aPar.setDimVar(this.dimVar);
        aPar.getLevels().addAll(this.levels);
        aPar.setVarId(this.varId);
        return aPar;
    }

    public boolean equals(Variable aVar) {
        if (!this.getName().equals(aVar.getName())) {
            return false;
        }
        if (this.Number != aVar.Number) {
            return false;
        }
        if (!this.description.equals(aVar.getDescription())) {
            return false;
        }
        return this.units.equals(aVar.getUnits());
    }

    public boolean tEquals(Variable aVar) {
        if (!this.getName().equals(aVar.getName())) {
            return false;
        }
        if (this.Number != aVar.Number) {
            return false;
        }
        if (!this.description.equals(aVar.getDescription())) {
            return false;
        }
        if (!this.units.equals(aVar.getUnits())) {
            return false;
        }
        return this.levelType == aVar.getLevelType();
    }

    public void addLevel(double levelValue) {
        if (!this.levels.contains(levelValue)) {
            this.levels.add(levelValue);
        }
    }

    public int getTrueLevelNumber() {
        if (this.getLevelNum() == 0) {
            return 1;
        }
        return this.getLevelNum();
    }

    public Dimension getDimension(DimensionType dimType) {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = this.getDimension(i);
            if (aDim.getDimType() != dimType) continue;
            return aDim;
        }
        return null;
    }

    public void resetShape() {
        this.shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = this.dimensions.get(i);
            this.shape[i] = dim.getLength();
        }
    }

    public void setDimension(String tstr, List<Number> values, boolean reverse) {
        DimensionType dType = DimensionType.OTHER;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        dim.setReverse(reverse);
        this.setDimension(dim);
    }

    public void setDimension(String tstr, List<Number> values, boolean reverse, int index) {
        DimensionType dType = DimensionType.OTHER;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        dim.setReverse(reverse);
        this.setDimension(index, dim);
    }

    public void setDimension(Dimension aDim) {
        if (aDim == null) {
            return;
        }
        if (aDim.getDimType() == DimensionType.OTHER) {
            this.addDimension(aDim);
        } else {
            boolean hasDim = false;
            for (int i = 0; i < this.getDimNumber(); ++i) {
                Dimension bDim = this.getDimension(i);
                if (bDim.getDimType() != aDim.getDimType()) continue;
                this.setDimension(i, aDim);
                hasDim = true;
                break;
            }
            if (!hasDim) {
                this.addDimension(aDim);
                this.resetShape();
            }
        }
    }

    public void setDimension(int idx, Dimension aDim) {
        if (aDim == null) {
            return;
        }
        if (this.getDimNumber() > idx) {
            this.dimensions.set(idx, aDim);
        } else {
            this.dimensions.add(aDim);
        }
        this.resetShape();
    }

    public void setDimension(Dimension aDim, DimensionType dimType) {
        if (aDim.getDimType() == dimType) {
            this.setDimension(aDim);
        }
    }

    public int getDimIndex(Dimension aDim) {
        int idx = -1;
        for (int i = 0; i < this.getDimNumber(); ++i) {
            if (!aDim.equals(this.getDimension(i))) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public int getDimLength(int idx) {
        return this.getDimension(idx).getLength();
    }

    public boolean hasXtrackDimension() {
        boolean has = false;
        for (int i = 0; i < this.getDimNumber(); ++i) {
            if (this.getDimension(i).getDimType() != DimensionType.X_TRACK) continue;
            has = true;
            break;
        }
        return has;
    }

    public boolean hasDimension(int dimId) {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = this.getDimension(i);
            if (aDim.getDimId() != dimId) continue;
            return true;
        }
        return false;
    }

    public boolean hasNullDimension() {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = this.getDimension(i);
            if (aDim == null) {
                return true;
            }
            if (aDim.getName() == null) {
                return true;
            }
            if (!aDim.getName().equals("null")) continue;
            return true;
        }
        return false;
    }

    public boolean dimensionEquales(Variable var) {
        if (this.getDimNumber() != var.getDimNumber()) {
            return false;
        }
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension adim = this.getDimension(i);
            Dimension bdim = var.getDimension(i);
            if (adim.getShortName().equals(bdim.getShortName())) continue;
            return false;
        }
        return true;
    }

    public boolean dimensionSizeEquals(Variable var) {
        if (this.getDimNumber() != var.getDimNumber()) {
            return false;
        }
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension adim = this.getDimension(i);
            Dimension bdim = var.getDimension(i);
            if (adim.getLength() == bdim.getLength()) continue;
            return false;
        }
        return true;
    }

    public boolean dimensionContains(Variable var) {
        if (this.getDimNumber() < var.getDimNumber()) {
            return false;
        }
        int sidx = 0;
        if (this.getDimNumber() > var.getDimNumber()) {
            sidx = this.getDimNumber() - var.getDimNumber();
        }
        for (int i = sidx; i < var.getDimNumber(); ++i) {
            Dimension adim = this.getDimension(i);
            Dimension bdim = var.getDimension(i - sidx);
            if (adim.getLength() == bdim.getLength()) continue;
            return false;
        }
        return true;
    }

    public Dimension getLevelDimension(Variable var) {
        if (this.getDimNumber() > var.getDimNumber()) {
            for (int i = var.getDimNumber(); i < this.getDimNumber(); ++i) {
                Dimension dim = this.getDimension(i);
                if (dim.getDimType() != DimensionType.OTHER) continue;
                return dim;
            }
        }
        return null;
    }

    public List<LocalDateTime> getTimes() {
        Dimension tDim = this.getTDimension();
        if (tDim == null) {
            return null;
        }
        List<Double> values = tDim.getDimValueList();
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
        for (Double v : values) {
            times.add(JDateUtil.fromOADate((double)v));
        }
        return times;
    }

    public int getAttributeIndex(String attName) {
        int idx = -1;
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            if (!this.getAttributes().get(i).getShortName().equalsIgnoreCase(attName)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public String getAttributeString(String attName) {
        String attStr = "";
        for (Attribute aAtt : this.getAttributes()) {
            if (!aAtt.getShortName().equalsIgnoreCase(attName)) continue;
            attStr = aAtt.toString();
        }
        return attStr;
    }

    public void addDimension(Dimension dim) {
        this.getDimensions().add(dim);
        this.resetShape();
    }

    public void addDimension(int idx, Dimension dim) {
        this.getDimensions().add(idx, dim);
        this.resetShape();
    }

    public void addDimension(DimensionType dType, List<Number> values) {
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        this.addDimension(dim);
    }

    public void addDimension(String tstr, List<Number> values) {
        DimensionType dType = DimensionType.OTHER;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        this.addDimension(dim);
    }

    public int getStaggerDimIndex() {
        int i = 0;
        for (Dimension dim : this.dimensions) {
            if (dim.isStagger()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public void addAttribute(String attName, List attValue) {
        Attribute aAtt = new Attribute(attName, attValue);
        this.addAttribute(aAtt);
    }

    public void addAttribute(String attName, String attValue) {
        Attribute aAtt = new Attribute(attName, attValue);
        this.addAttribute(aAtt);
    }

    public void addAttribute(String attName, double attValue) {
        Attribute aAtt = new Attribute(attName, attValue);
        this.addAttribute(aAtt);
    }

    public void updateZDimension() {
        if (this.levels.size() > 0) {
            Dimension zdim = new Dimension("null", 0, DimensionType.Z);
            zdim.setValues(this.levels);
            this.setZDimension(zdim);
        }
    }

    public List<Dimension> sectionDimensions(int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        Section section = new Section(origin, size, stride);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < section.getRank(); ++i) {
            Range range = section.getRange(i);
            if (range.length() <= 1) continue;
            Dimension dim = this.dimensions.get(i).extract(range);
            dims.add(dim);
        }
        return dims;
    }

    public String toString() {
        return this.name;
    }
}

