/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.BOMInputStream;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.micaps.MDFSDataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS11DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS120DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS131DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS13DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS1DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS2DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS3DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS4DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS7DataInfo;

public class MICAPSDataInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeteoDataType getDataType(String fileName) {
        BufferedReader sr = null;
        MeteoDataType mdType = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(fileName)), "gbk"));
            String aLine = sr.readLine().trim();
            if (aLine.substring(0, 4).equals("mdfs")) {
                mdType = MeteoDataType.MICAPS_MDFS;
            } else {
                String[] dataArray = aLine.split("\\s+");
                String dataType = dataArray[0] + " " + dataArray[1];
                if ((dataType = dataType.trim().toLowerCase()).equals("diamond 11")) {
                    mdType = MeteoDataType.MICAPS_11;
                }
                if (dataType.equals("diamond 13")) {
                    mdType = MeteoDataType.MICAPS_13;
                }
                if (dataType.contains("iamond 120")) {
                    mdType = MeteoDataType.MICAPS_120;
                }
                if (dataType.contains("diamond 131")) {
                    mdType = MeteoDataType.MICAPS_131;
                }
                if (dataType.contains("diamond 1")) {
                    mdType = MeteoDataType.MICAPS_1;
                }
                if (dataType.equals("diamond 2")) {
                    mdType = MeteoDataType.MICAPS_2;
                }
                if (dataType.equals("diamond 3")) {
                    mdType = MeteoDataType.MICAPS_3;
                }
                if (dataType.equals("diamond 4")) {
                    mdType = MeteoDataType.MICAPS_4;
                }
                if (dataType.equals("diamond 7")) {
                    mdType = MeteoDataType.MICAPS_7;
                }
                if (mdType == null) {
                    System.out.println(String.format("Unknown MICAPS data file type: %s", dataType));
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return mdType;
    }

    public static DataInfo getDataInfo(RandomAccessFile raf) {
        DataInfo dataInfo = null;
        try {
            raf.seek(0L);
            byte[] bytes = new byte[1000];
            raf.read(bytes);
            String line = new String(bytes).trim();
            if (line.substring(0, 4).equals("mdfs")) {
                dataInfo = new MDFSDataInfo();
            } else {
                StringTokenizer stoker = new StringTokenizer(line);
                if (stoker.countTokens() >= 2) {
                    String dataType = stoker.nextToken() + " " + stoker.nextToken();
                    if (dataType.equals("diamond 11")) {
                        dataInfo = new MICAPS11DataInfo();
                    } else if (dataType.equals("diamond 13")) {
                        dataInfo = new MICAPS13DataInfo();
                    } else if (dataType.contains("iamond 120")) {
                        dataInfo = new MICAPS120DataInfo();
                    } else if (dataType.contains("diamond 131")) {
                        dataInfo = new MICAPS131DataInfo();
                    } else if (dataType.contains("diamond 1")) {
                        dataInfo = new MICAPS1DataInfo();
                    } else if (dataType.equals("diamond 2")) {
                        dataInfo = new MICAPS2DataInfo();
                    } else if (dataType.equals("diamond 3")) {
                        dataInfo = new MICAPS3DataInfo();
                    } else if (dataType.equals("diamond 4")) {
                        dataInfo = new MICAPS4DataInfo();
                    } else if (dataType.equals("diamond 7")) {
                        dataInfo = new MICAPS7DataInfo();
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataInfo;
    }
}

