/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.radar.CutConfig;
import org.meteoinfo.data.meteodata.radar.GenericHeader;
import org.meteoinfo.data.meteodata.radar.MomentHeader;
import org.meteoinfo.data.meteodata.radar.RadialHeader;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.data.meteodata.radar.SiteConfig;
import org.meteoinfo.data.meteodata.radar.TaskConfig;
import org.meteoinfo.data.meteodata.radar.Transform;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class CMARadarBaseDataInfo
extends DataInfo
implements IGridDataInfo {
    private GenericHeader genericHeader;
    private SiteConfig siteConfig;
    private TaskConfig taskConfig;
    private List<CutConfig> cutConfigs;
    private List<RadialHeader> radialHeaders;
    private final Map<Integer, String> productMap = Stream.of({1, "dBT"}, {2, "dBZ"}, {3, "V"}, {4, "W"}, {5, "SQI"}, {6, "CPA"}, {7, "ZDR"}, {8, "LDR"}, {9, "CC"}, {10, "PhiDP"}, {11, "KDP"}, {12, "CP"}, {13, "Flag"}, {14, "HCL"}, {15, "CF"}, {16, "SNRH"}, {17, "SNRV"}, {18, "Flag"}, {19, "Flag"}, {20, "Flag"}, {21, "Flag"}, {22, "Flag"}, {23, "Flag"}, {24, "Flag"}, {25, "Flag"}, {26, "Flag"}, {27, "Flag"}, {28, "Flag"}, {29, "Flag"}, {30, "Flag"}, {31, "Flag"}, {32, "Zc"}, {33, "Vc"}, {34, "Wc"}, {35, "ZDRc"}, {0, "Flag"}).collect(Collectors.toMap(data -> (Integer)data[0], data -> (String)data[1]));
    private final Map<String, RadialRecord> recordMap = new HashMap<String, RadialRecord>();
    private final List<String> velocityGroup = new ArrayList<String>(Arrays.asList("V", "W"));
    private Dimension radialDim;
    private Dimension scanDim;
    private Dimension gateRDim;
    private Dimension gateVDim;

    public CMARadarBaseDataInfo() {
        this.meteoDataType = MeteoDataType.RADAR;
    }

    public GenericHeader getGenericHeader() {
        return this.genericHeader;
    }

    public SiteConfig getSiteConfig() {
        return this.siteConfig;
    }

    public TaskConfig getTaskConfig() {
        return this.taskConfig;
    }

    public List<CutConfig> getCutConfigs() {
        return this.cutConfigs;
    }

    public List<RadialHeader> getRadialHeaders() {
        return this.radialHeaders;
    }

    public Map<String, RadialRecord> getRecordMap() {
        return this.recordMap;
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        return null;
    }

    public boolean isVelocityGroup(RadialRecord record) {
        return this.velocityGroup.contains(record.product);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            byte[] bytes = new byte[4];
            raf.read(bytes);
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean canOpen(String fileName) {
        try {
            byte[] bytes = new byte[4];
            if (fileName.endsWith("bz2")) {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
                inputStream.read(bytes);
                inputStream.close();
            } else {
                RandomAccessFile raf = new RandomAccessFile(fileName, "r");
                raf.seek(0L);
                raf.read(bytes);
                raf.close();
            }
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void readDataInfo(String fileName) {
        this.fileName = fileName;
        if (fileName.endsWith(".bz2")) {
            try {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
                this.readDataInfo((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
            this.readDataInfo(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void readDataInfo(RandomAccessFile raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.taskConfig = new TaskConfig(raf);
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                this.cutConfigs.add(new CutConfig(raf));
            }
            this.radialHeaders = new ArrayList<RadialHeader>();
            while (raf.length() - raf.getFilePointer() > (long)RadialHeader.length) {
                RadialHeader radialHeader = new RadialHeader(raf);
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = momentHeader.scale;
                        record.offset = momentHeader.offset;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)0).logResolution));
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.elevation));
                    record.azimuth.get(record.azimuth.size() - 1).add(Float.valueOf(radialHeader.azimuth));
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(bytes);
                }
                this.radialHeaders.add(radialHeader);
            }
            raf.close();
            Dimension xyzDim = new Dimension(DimensionType.OTHER);
            xyzDim.setShortName("xyz");
            xyzDim.setDimValue(Array.factory((DataType)DataType.INT, (int[])new int[]{3}, (Object)new int[]{1, 2, 3}));
            this.addDimension(xyzDim);
            for (String product : this.recordMap.keySet()) {
                this.recordMap.get(product).makeVariables(this, xyzDim);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void readDataInfo(InputStream raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.addAttribute(new Attribute("RadarType", this.siteConfig.getRadarType()));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.taskConfig = new TaskConfig(raf);
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                this.cutConfigs.add(new CutConfig(raf));
            }
            this.radialHeaders = new ArrayList<RadialHeader>();
            byte[] rhBytes = new byte[RadialHeader.length];
            while (raf.read(rhBytes) != -1) {
                RadialHeader radialHeader = new RadialHeader(rhBytes);
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = momentHeader.scale;
                        record.offset = momentHeader.offset;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.fixedElevation.add(Float.valueOf(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).elevation));
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.azimuthMinIndex.add(0);
                        if (this.isVelocityGroup(record)) {
                            record.disResolution.add(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).dopplerResolution);
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).dopplerResolution));
                        } else {
                            record.disResolution.add(this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).logResolution);
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)this.cutConfigs.get((int)(radialHeader.elevationNumber - 1)).logResolution));
                        }
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.elevation));
                    record.addAzimuth(radialHeader.azimuth);
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(bytes);
                }
                this.radialHeaders.add(radialHeader);
            }
            raf.close();
            RadialRecord refRadialRecord = this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(refRadialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(refRadialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateRDim = new Dimension();
            this.gateRDim.setName("gateR");
            this.gateRDim.setLength(refRadialRecord.getGateNumber(0));
            this.addDimension(this.gateRDim);
            this.makeRefVariables(refRadialRecord);
            RadialRecord velRadialRecord = this.recordMap.get("V");
            this.gateVDim = new Dimension();
            this.gateVDim.setName("gateV");
            this.gateVDim.setLength(velRadialRecord.getGateNumber(0));
            this.addDimension(this.gateVDim);
            this.makeVelVariables(velRadialRecord);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeRefVariables(RadialRecord refRadialRecord) {
        Dimension[] dimensions = new Dimension[]{this.scanDim, this.radialDim, this.gateRDim};
        for (RadialRecord radialRecord : this.recordMap.values()) {
            if (radialRecord.isVelocityGroup()) continue;
            radialRecord.makeVariable(this, dimensions);
        }
        Variable elevation = new Variable();
        elevation.setName("elevationR");
        elevation.setDataType(DataType.FLOAT);
        elevation.addDimension(this.scanDim);
        elevation.addDimension(this.radialDim);
        elevation.addAttribute(new Attribute("units", "degree"));
        elevation.addAttribute(new Attribute("long_name", "elevation angle in degrees"));
        this.addVariable(elevation);
        Variable azimuth = new Variable();
        azimuth.setName("azimuthR");
        azimuth.setDataType(DataType.FLOAT);
        azimuth.addDimension(this.scanDim);
        azimuth.addDimension(this.radialDim);
        azimuth.addAttribute(new Attribute("units", "degree"));
        azimuth.addAttribute(new Attribute("long_name", "azimuth angle in degrees"));
        this.addVariable(azimuth);
        Variable distance = new Variable();
        distance.setName("distanceR");
        distance.setDataType(DataType.FLOAT);
        distance.addDimension(this.gateRDim);
        distance.addAttribute(new Attribute("units", "m"));
        distance.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        this.addVariable(distance);
        Variable nRadials = new Variable();
        nRadials.setName("numRadialsR");
        nRadials.setDataType(DataType.INT);
        nRadials.addDimension(this.scanDim);
        nRadials.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        this.addVariable(nRadials);
        Variable nGates = new Variable();
        nGates.setName("numGatesR");
        nGates.setDataType(DataType.INT);
        nGates.addDimension(this.scanDim);
        nGates.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        this.addVariable(nGates);
        int nScan = this.scanDim.getLength();
        int nRadial = this.radialDim.getLength();
        int nGate = this.gateRDim.getLength();
        Array elevData = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nScan, nRadial});
        Array aziData = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nScan, nRadial});
        Array nRData = Array.factory((DataType)DataType.INT, (int[])new int[]{nScan});
        Array nGData = Array.factory((DataType)DataType.INT, (int[])new int[]{nScan});
        Index elevIndex = elevData.getIndex();
        Index aziIndex = aziData.getIndex();
        for (int i = 0; i < nScan; ++i) {
            List<Float> elevList = refRadialRecord.elevation.get(i);
            List<Float> aziList = refRadialRecord.azimuth.get(i);
            nRData.setInt(i, aziList.size());
            nGData.setInt(i, (int)refRadialRecord.distance.get(i).getSize());
            for (int j = 0; j < nRadial; ++j) {
                if (j < elevList.size()) {
                    elevData.setFloat(elevIndex.set(i, j), elevList.get(j).floatValue());
                    aziData.setFloat(aziIndex.set(i, j), aziList.get(j).floatValue());
                    continue;
                }
                elevData.setFloat(elevIndex.set(i, j), Float.NaN);
                aziData.setFloat(aziIndex.set(i, j), Float.NaN);
            }
        }
        Array disData = refRadialRecord.distance.get(0);
        elevation.setCachedData(elevData);
        azimuth.setCachedData(aziData);
        distance.setCachedData(disData);
        nRadials.setCachedData(nRData);
        nGates.setCachedData(nGData);
    }

    private void makeVelVariables(RadialRecord velRadialRecord) {
        Dimension[] dimensions = new Dimension[]{this.scanDim, this.radialDim, this.gateVDim};
        for (RadialRecord radialRecord : this.recordMap.values()) {
            if (!radialRecord.isVelocityGroup()) continue;
            radialRecord.makeVariable(this, dimensions);
        }
        Variable elevation = new Variable();
        elevation.setName("elevationV");
        elevation.setDataType(DataType.FLOAT);
        elevation.addDimension(this.scanDim);
        elevation.addDimension(this.radialDim);
        elevation.addAttribute(new Attribute("units", "degree"));
        elevation.addAttribute(new Attribute("long_name", "elevation angle in degrees"));
        this.addVariable(elevation);
        Variable azimuth = new Variable();
        azimuth.setName("azimuthV");
        azimuth.setDataType(DataType.FLOAT);
        azimuth.addDimension(this.scanDim);
        azimuth.addDimension(this.radialDim);
        azimuth.addAttribute(new Attribute("units", "degree"));
        azimuth.addAttribute(new Attribute("long_name", "azimuth angle in degrees"));
        this.addVariable(azimuth);
        Variable distance = new Variable();
        distance.setName("distanceV");
        distance.setDataType(DataType.FLOAT);
        distance.addDimension(this.gateVDim);
        distance.addAttribute(new Attribute("units", "m"));
        distance.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        this.addVariable(distance);
        Variable nRadials = new Variable();
        nRadials.setName("numRadialsR");
        nRadials.setDataType(DataType.INT);
        nRadials.addDimension(this.scanDim);
        nRadials.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        this.addVariable(nRadials);
        Variable nGates = new Variable();
        nGates.setName("numGatesR");
        nGates.setDataType(DataType.INT);
        nGates.addDimension(this.scanDim);
        nGates.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        this.addVariable(nGates);
        int nScan = this.scanDim.getLength();
        int nRadial = this.radialDim.getLength();
        int nGate = this.gateVDim.getLength();
        Array elevData = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nScan, nRadial});
        Array aziData = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nScan, nRadial});
        Array nRData = Array.factory((DataType)DataType.INT, (int[])new int[]{nScan});
        Array nGData = Array.factory((DataType)DataType.INT, (int[])new int[]{nScan});
        Index elevIndex = elevData.getIndex();
        Index aziIndex = aziData.getIndex();
        for (int i = 0; i < nScan; ++i) {
            List<Float> elevList = velRadialRecord.elevation.get(i);
            List<Float> aziList = velRadialRecord.azimuth.get(i);
            nRData.setInt(i, aziList.size());
            nGData.setInt(i, (int)velRadialRecord.distance.get(i).getSize());
            for (int j = 0; j < nRadial; ++j) {
                if (j < elevList.size()) {
                    elevData.setFloat(elevIndex.set(i, j), elevList.get(j).floatValue());
                    aziData.setFloat(aziIndex.set(i, j), aziList.get(j).floatValue());
                    continue;
                }
                elevData.setFloat(elevIndex.set(i, j), Float.NaN);
                aziData.setFloat(aziIndex.set(i, j), Float.NaN);
            }
        }
        Array disData = velRadialRecord.distance.get(0);
        elevation.setCachedData(elevData);
        azimuth.setCachedData(aziData);
        distance.setCachedData(disData);
        nRadials.setCachedData(nRData);
        nGates.setCachedData(nGData);
    }

    public List<String> getProducts() {
        ArrayList<String> products = new ArrayList<String>();
        for (String product : this.recordMap.keySet()) {
            products.add(product);
        }
        return products;
    }

    public List<Float> getElevations() {
        ArrayList<Float> elevations = new ArrayList<Float>();
        for (CutConfig cutConfig : this.cutConfigs) {
            if (elevations.contains(Float.valueOf(cutConfig.elevation))) continue;
            elevations.add(Float.valueOf(cutConfig.elevation));
        }
        return elevations;
    }

    public List<Float> getElevations(String product) {
        RadialRecord radialRecord = this.recordMap.get(product);
        return radialRecord.fixedElevation;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable variable = this.getVariable(varName);
            if (variable.hasCachedData()) {
                return variable.getCachedData().section(origin, size, stride).copy();
            }
            Section section = new Section(origin, size, stride);
            RadialRecord record = this.recordMap.get(varName);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            Range zRange = section.getRange(0);
            Range yRange = section.getRange(1);
            Range xRange = section.getRange(2);
            IndexIterator iter = dataArray.getIndexIterator();
            for (int s = zRange.first(); s <= zRange.last(); s += zRange.stride()) {
                List<Array> arrays = record.getDataArray(s);
                for (int i = yRange.first(); i <= yRange.last(); i += yRange.stride()) {
                    if (i < arrays.size()) {
                        Array array = arrays.get(i);
                        for (int j = xRange.first(); j <= xRange.last(); j += xRange.stride()) {
                            if ((long)j < array.getSize()) {
                                iter.setFloatNext(array.getFloat(j));
                                continue;
                            }
                            iter.setFloatNext(Float.NaN);
                        }
                        continue;
                    }
                    for (int j = xRange.first(); j <= xRange.last(); j += xRange.stride()) {
                        iter.setFloatNext(Float.NaN);
                    }
                }
            }
            Attribute aoAttr = variable.findAttribute("add_offset");
            Attribute sfAttr = variable.findAttribute("scale_factor");
            if (aoAttr != null || sfAttr != null) {
                Number add_offset = Float.valueOf(0.0f);
                Number scale_factor = Float.valueOf(1.0f);
                if (aoAttr != null) {
                    switch (aoAttr.getDataType()) {
                        case DOUBLE: {
                            add_offset = aoAttr.getValues().getDouble(0);
                            break;
                        }
                        case FLOAT: 
                        case INT: {
                            add_offset = Float.valueOf(aoAttr.getValues().getFloat(0));
                        }
                    }
                }
                if (sfAttr != null) {
                    switch (sfAttr.getDataType()) {
                        case DOUBLE: {
                            scale_factor = sfAttr.getValues().getDouble(0);
                            break;
                        }
                        case FLOAT: 
                        case INT: {
                            scale_factor = Float.valueOf(sfAttr.getValues().getFloat(0));
                        }
                    }
                }
                dataArray = ArrayMath.div((Array)ArrayMath.sub((Array)dataArray, (Number)add_offset), (Number)scale_factor);
            }
            return dataArray;
        }
        catch (InvalidRangeException e) {
            return null;
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }

    public Array readGridData(String varName, int scanIdx, Array xa, Array ya, Float h) {
        RadialRecord record = this.recordMap.get(varName);
        if (h == null) {
            h = Float.valueOf(this.siteConfig.antennaHeight);
        }
        Array[] rr = Transform.cartesianToAntennaElevation(xa, ya, record.fixedElevation.get(scanIdx).floatValue(), h.floatValue());
        Array azimuth = rr[0];
        Array ranges = rr[1];
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])xa.getShape());
        IndexIterator iterA = azimuth.getIndexIterator();
        IndexIterator iterR = ranges.getIndexIterator();
        IndexIterator iterData = data.getIndexIterator();
        while (iterData.hasNext()) {
            float v = record.interpolateValue(scanIdx, iterA.getFloatNext(), iterR.getFloatNext());
            iterData.setFloatNext(v);
        }
        return data;
    }

    public Array getCRData(String varName, Array xa, Array ya, Float h) {
        RadialRecord record = this.recordMap.get(varName);
        int nScan = record.getScanNumber();
        if (h == null) {
            h = Float.valueOf(this.siteConfig.antennaHeight);
        }
        int[] shape = xa.getShape();
        int ny = shape[0];
        int nx = shape[1];
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Index2D index2D = (Index2D)data.getIndex();
        for (int s = 0; s < nScan; ++s) {
            float v;
            Array[] rr = Transform.cartesianToAntennaElevation(xa, ya, record.fixedElevation.get(s).floatValue(), h.floatValue());
            Array azimuth = rr[0];
            Array ranges = rr[1];
            IndexIterator iterA = azimuth.getIndexIterator();
            IndexIterator iterR = ranges.getIndexIterator();
            if (s == 0) {
                for (int i = 0; i < ny; ++i) {
                    for (int j = 0; j < nx; ++j) {
                        v = record.interpolateValue(s, iterA.getFloatNext(), iterR.getFloatNext());
                        data.setFloat(index2D.set(i, j), v);
                    }
                }
                continue;
            }
            for (int i = 0; i < ny; ++i) {
                for (int j = 0; j < nx; ++j) {
                    v = record.interpolateValue(s, iterA.getFloatNext(), iterR.getFloatNext());
                    index2D.set(i, j);
                    float v1 = data.getFloat((Index)index2D);
                    if (!Float.isNaN(v1) && !(v > v1)) continue;
                    data.setFloat((Index)index2D, v);
                }
            }
        }
        return data;
    }

    public Array getCAPPIData(String varName, Array xa, Array ya, float z, Float h) {
        RadialRecord record = this.recordMap.get(varName);
        if (h == null) {
            h = Float.valueOf(this.siteConfig.antennaHeight);
        }
        Array[] rr = Transform.cartesianToAntenna(xa, ya, z, h.floatValue());
        Array azimuth = rr[0];
        Array ranges = rr[1];
        Array elevation = rr[2];
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])xa.getShape());
        IndexIterator iterA = azimuth.getIndexIterator();
        IndexIterator iterR = ranges.getIndexIterator();
        IndexIterator iterE = elevation.getIndexIterator();
        IndexIterator iterData = data.getIndexIterator();
        float halfBeamWidth = this.siteConfig.beamWidthVert / 2.0f;
        while (iterData.hasNext()) {
            float v = record.interpolateValue(iterE.getFloatNext(), iterA.getFloatNext(), iterR.getFloatNext(), halfBeamWidth);
            iterData.setFloatNext(v);
        }
        return data;
    }

    public Array getGrid3DData(String varName, Array xa, Array ya, Array za, Float h) {
        RadialRecord record = this.recordMap.get(varName);
        if (h == null) {
            h = Float.valueOf(this.siteConfig.antennaHeight);
        }
        int nz = (int)za.getSize();
        int[] shape2D = xa.getShape();
        int[] shape3D = new int[]{nz, shape2D[0], shape2D[1]};
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])shape3D);
        IndexIterator iterData = data.getIndexIterator();
        IndexIterator iterZ = za.getIndexIterator();
        float halfBeamWidth = this.siteConfig.beamWidthVert / 2.0f;
        while (iterZ.hasNext()) {
            float z = iterZ.getFloatNext();
            Array[] rr = Transform.cartesianToAntenna(xa, ya, z, h.floatValue());
            Array azimuth = rr[0];
            Array ranges = rr[1];
            Array elevation = rr[2];
            IndexIterator iterA = azimuth.getIndexIterator();
            IndexIterator iterR = ranges.getIndexIterator();
            IndexIterator iterE = elevation.getIndexIterator();
            while (iterA.hasNext()) {
                float v = record.interpolateValue(iterE.getFloatNext(), iterA.getFloatNext(), iterR.getFloatNext(), halfBeamWidth);
                iterData.setFloatNext(v);
            }
        }
        return data;
    }

    public Array[] getVCSData(String varName, float startX, float startY, float endX, float endY) {
        RadialRecord record = this.recordMap.get(varName);
        int nScan = record.getScanNumber();
        float halfBeamWidth = this.siteConfig.beamWidthVert / 2.0f;
        float binRes = this.cutConfigs.get((int)0).logResolution;
        float height = this.siteConfig.antennaHeight;
        float startEndDistance = (float)Math.sqrt(Math.pow(endX - startX, 2.0) + Math.pow(endY - startY, 2.0));
        int nPoints = (int)(startEndDistance * 1000.0f / binRes + 1.0f);
        Array xa = ArrayUtil.lineSpace((Number)Float.valueOf(startX), (Number)Float.valueOf(endX), (int)nPoints);
        Array ya = ArrayUtil.lineSpace((Number)Float.valueOf(startY), (Number)Float.valueOf(endY), (int)nPoints);
        Array aa = Transform.xyToAzimuth(xa, ya);
        int[] shape = new int[]{nScan, 2, nPoints};
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Array meshXY = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Array meshZ = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Index dataIndex = data.getIndex();
        Index meshXYIndex = meshXY.getIndex();
        Index meshZIndex = meshZ.getIndex();
        for (int i = 0; i < nScan; ++i) {
            float ele = record.fixedElevation.get(i).floatValue();
            for (int j = 0; j < nPoints; ++j) {
                float x = xa.getFloat(j);
                float y = ya.getFloat(j);
                float dis = (float)Math.sqrt(x * x + y * y);
                float azi = aa.getFloat(j);
                float v = record.getValue(i, azi, dis * 1000.0f);
                float z1 = Transform.toCartesianZ(dis * 1000.0f, (float)Math.toRadians(ele - halfBeamWidth), height) / 1000.0f;
                float z2 = Transform.toCartesianZ(dis * 1000.0f, (float)Math.toRadians(ele + halfBeamWidth), height) / 1000.0f;
                for (int k = 0; k < 2; ++k) {
                    data.setFloat(dataIndex.set(i, k, j), v);
                    meshXY.setFloat(meshXYIndex.set(i, k, j), dis);
                }
                meshZ.setFloat(meshZIndex.set(i, 0, j), z1);
                meshZ.setFloat(meshZIndex.set(i, 1, j), z2);
            }
        }
        return new Array[]{data, meshXY, meshZ};
    }
}

