/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.radar.CMARadarBaseDataInfo;
import org.meteoinfo.data.meteodata.radar.Transform;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class RadialRecord {
    public String product;
    private int binLength;
    private DataType dataType;
    private int fillValue;
    public int scale;
    public int offset;
    public List<Float> fixedElevation = new ArrayList<Float>();
    public List<List<Float>> elevation = new ArrayList<List<Float>>();
    public List<List<Float>> azimuth = new ArrayList<List<Float>>();
    public List<Integer> azimuthMinIndex = new ArrayList<Integer>();
    public List<Array> distance = new ArrayList<Array>();
    public List<Integer> disResolution = new ArrayList<Integer>();
    private final List<List<Array>> data = new ArrayList<List<Array>>();

    public RadialRecord(String product) {
        this.product = product;
    }

    public void setBinLength(int value) {
        this.binLength = value;
        this.dataType = this.binLength == 1 ? DataType.UBYTE : DataType.USHORT;
        this.fillValue = this.dataType == DataType.UBYTE ? 0 : Short.MIN_VALUE;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void addAzimuth(float a) {
        int n = this.getScanNumber();
        List<Float> azi = this.azimuth.get(n - 1);
        azi.add(Float.valueOf(a));
        if (this.azimuthMinIndex.get(n - 1) == 0 && azi.size() > 1 && a < azi.get(azi.size() - 2).floatValue()) {
            this.azimuthMinIndex.set(n - 1, azi.size() - 1);
        }
    }

    public boolean isVelocityGroup() {
        return this.product.equals("V") || this.product.equals("W");
    }

    public int getScanNumber() {
        return this.elevation.size();
    }

    public int getRadialNumber(int scanIdx) {
        return this.elevation.get(scanIdx).size();
    }

    public int getGateNumber(int scanIdx) {
        return (int)this.distance.get(scanIdx).getSize();
    }

    public void newScanData() {
        this.data.add(new ArrayList());
    }

    public void addDataBytes(byte[] bytes) {
        Array array;
        if (this.data.isEmpty()) {
            this.data.add(new ArrayList());
        }
        if (this.dataType == DataType.UBYTE) {
            array = Array.factory((DataType)this.dataType, (int[])new int[]{bytes.length}, (Object)bytes);
        } else {
            int n = bytes.length / 2;
            array = Array.factory((DataType)this.dataType, (int[])new int[]{n});
            for (int i = 0; i < n; ++i) {
                short v = DataConvert.bytes2Short((byte[])new byte[]{bytes[i * 2], bytes[i * 2 + 1]}, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                array.setShort(i, v);
            }
        }
        this.data.get(this.data.size() - 1).add(array);
    }

    public void addDataBytes(byte[] bytes, int offset, int scale) {
        Array array;
        if (this.data.isEmpty()) {
            this.data.add(new ArrayList());
        }
        if (this.binLength == 1) {
            array = Array.factory((DataType)this.dataType, (int[])new int[]{bytes.length});
            for (int i = 0; i < bytes.length; ++i) {
                float v = DataType.unsignedByteToShort((byte)bytes[i]);
                v = (v - (float)offset) / (float)scale;
                array.setFloat(i, v);
            }
        } else {
            int n = bytes.length / 2;
            array = Array.factory((DataType)this.dataType, (int[])new int[]{n});
            for (int i = 0; i < n; ++i) {
                short s = DataConvert.bytes2Short((byte[])new byte[]{bytes[i * 2], bytes[i * 2 + 1]}, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                float v = DataType.unsignedShortToInt((short)s);
                v = (v - (float)offset) / (float)scale;
                array.setFloat(i, v);
            }
        }
        this.data.get(this.data.size() - 1).add(array);
    }

    public List<Array> getDataArray(int scanIdx) {
        return this.data.get(scanIdx);
    }

    public int getMaxRadials() {
        int maxRadials = 0;
        for (List<Float> a : this.azimuth) {
            if (maxRadials >= a.size()) continue;
            maxRadials = a.size();
        }
        return maxRadials;
    }

    public int getMinRadials() {
        int minRadials = Integer.MAX_VALUE;
        for (List<Float> a : this.azimuth) {
            if (minRadials <= a.size()) continue;
            minRadials = a.size();
        }
        return minRadials;
    }

    public Array getXYZ(int scanIdx) {
        List<Float> azi = this.azimuth.get(scanIdx);
        Array dis = this.distance.get(scanIdx);
        List<Float> ele = this.elevation.get(scanIdx);
        int nz = 3;
        int ny = azi.size();
        int nx = (int)dis.getSize();
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{nz, ny, nx});
        Index index = r.getIndex();
        for (int i = 0; i < ny; ++i) {
            float a = (float)Math.toRadians(azi.get(i).floatValue());
            float e = (float)Math.toRadians(ele.get(i).floatValue());
            for (int j = 0; j < nx; ++j) {
                double[] xyz = Transform.antennaToCartesian(dis.getFloat(j), a, e);
                index.set(0, i, j);
                r.setFloat(index, (float)xyz[0]);
                index.set(1, i, j);
                r.setFloat(index, (float)xyz[1]);
                index.set(2, i, j);
                r.setFloat(index, (float)xyz[2]);
            }
        }
        return r;
    }

    public void makeVariable(CMARadarBaseDataInfo dataInfo, Dimension[] dimensions) {
        Variable variable = new Variable();
        variable.setName(this.product);
        variable.setDataType(this.dataType);
        for (Dimension dimension : dimensions) {
            variable.addDimension(dimension);
        }
        variable.addAttribute(new Attribute("scale_factor", this.scale));
        variable.addAttribute(new Attribute("add_offset", this.offset));
        dataInfo.addVariable(variable);
    }

    public void makeVariables(CMARadarBaseDataInfo dataInfo, Dimension xyzDim) {
        for (int i = 0; i < this.getScanNumber(); ++i) {
            String suffix = "_s" + String.valueOf(i + 1);
            Dimension radialDim = new Dimension(DimensionType.Y);
            radialDim.setShortName("azimuth_" + this.product + suffix);
            radialDim.setUnit("degree");
            radialDim.setDimValue(ArrayUtil.array_list(this.azimuth.get(i), (DataType)DataType.FLOAT));
            dataInfo.addDimension(radialDim);
            Dimension disDim = new Dimension(DimensionType.X);
            disDim.setShortName("distance_" + this.product + suffix);
            disDim.setUnit("meter");
            disDim.setDimValue(this.distance.get(i));
            dataInfo.addDimension(disDim);
            Dimension eleDim = new Dimension(DimensionType.OTHER);
            eleDim.setShortName("elevation_" + this.product + suffix);
            eleDim.setUnit("degree");
            eleDim.setDimValue(ArrayUtil.array_list(this.elevation.get(i), (DataType)DataType.FLOAT));
            dataInfo.addDimension(eleDim);
            Variable variable = new Variable();
            variable.setName(this.product + suffix);
            variable.setDataType(this.dataType);
            variable.addDimension(radialDim);
            variable.addDimension(disDim);
            variable.addAttribute(new Attribute("scale_factor", this.scale));
            variable.addAttribute(new Attribute("add_offset", this.offset));
            dataInfo.addVariable(variable);
            variable = new Variable();
            variable.setName("xyz_" + this.product + suffix);
            variable.setDataType(DataType.FLOAT);
            variable.addDimension(xyzDim);
            variable.addDimension(radialDim);
            variable.addDimension(disDim);
            variable.addAttribute(new Attribute("long_name", "x, y, z coordinates"));
            variable.addAttribute(new Attribute("units", "meters"));
            dataInfo.addVariable(variable);
        }
    }

    public List<Float> getSortedAzimuth(int scanIndex) {
        int sIdx = this.azimuthMinIndex.get(scanIndex);
        if (sIdx == 0) {
            return this.azimuth.get(scanIndex);
        }
        List<Float> azs = this.azimuth.get(scanIndex);
        ArrayList<Float> sortedAzimuth = new ArrayList<Float>();
        sortedAzimuth.addAll(azs.subList(sIdx, azs.size()));
        sortedAzimuth.addAll(azs.subList(0, sIdx));
        return sortedAzimuth;
    }

    public int getAzimuthIndex(int ei, float a) {
        List<Float> azs = this.azimuth.get(ei);
        int n = azs.size();
        int sIdx = this.azimuthMinIndex.get(ei);
        int eIdx = sIdx - 1;
        if (eIdx < 0) {
            eIdx = n - 1;
        }
        int i1 = -1;
        int i2 = -1;
        if (a < azs.get(sIdx).floatValue() || a > azs.get(eIdx).floatValue()) {
            i1 = eIdx;
            i2 = sIdx;
        } else {
            int i;
            for (i = sIdx + 1; i < n; ++i) {
                if (a == azs.get(i).floatValue()) {
                    return i;
                }
                if (!(a < azs.get(i).floatValue())) continue;
                i1 = i - 1;
                i2 = i;
                break;
            }
            if (i1 < 0) {
                for (i = 0; i <= eIdx; ++i) {
                    if (a == azs.get(i).floatValue()) {
                        return i;
                    }
                    if (!(a < azs.get(i).floatValue())) continue;
                    i1 = i - 1;
                    i2 = i;
                    if (i1 >= 0) break;
                    i1 = n - 1;
                    break;
                }
            }
        }
        if (azs.get(i2).floatValue() - a < a - azs.get(i1).floatValue()) {
            return i2;
        }
        return i1;
    }

    public int[] getAzimuthIndices(int ei, float a) {
        List<Float> azs = this.azimuth.get(ei);
        int n = azs.size();
        int sIdx = this.azimuthMinIndex.get(ei);
        int eIdx = sIdx - 1;
        if (eIdx < 0) {
            eIdx = n - 1;
        }
        int i1 = -1;
        int i2 = -1;
        if (a < azs.get(sIdx).floatValue() || a > azs.get(eIdx).floatValue()) {
            i1 = eIdx;
            i2 = sIdx;
        } else {
            int i;
            for (i = sIdx + 1; i < n; ++i) {
                if (a == azs.get(i).floatValue()) {
                    return new int[]{i, i};
                }
                if (!(a < azs.get(i).floatValue())) continue;
                i1 = i - 1;
                i2 = i;
                break;
            }
            if (i1 < 0) {
                for (i = 0; i <= eIdx; ++i) {
                    if (a == azs.get(i).floatValue()) {
                        return new int[]{i, i};
                    }
                    if (!(a < azs.get(i).floatValue())) continue;
                    i1 = i - 1;
                    i2 = i;
                    if (i1 >= 0) break;
                    i1 = n - 1;
                    break;
                }
            }
        }
        return new int[]{i1, i2};
    }

    public int[] getScanIndices(float e) {
        if (e < this.fixedElevation.get(0).floatValue() || e > this.fixedElevation.get(this.fixedElevation.size() - 1).floatValue()) {
            return new int[]{-1, -1};
        }
        if (e == this.fixedElevation.get(0).floatValue()) {
            return new int[]{0, 0};
        }
        if (e == this.fixedElevation.get(this.fixedElevation.size() - 1).floatValue()) {
            return new int[]{this.fixedElevation.size() - 1, this.fixedElevation.size() - 1};
        }
        for (int i = 1; i < this.fixedElevation.size(); ++i) {
            if (!(e <= this.fixedElevation.get(i).floatValue())) continue;
            return new int[]{i - 1, i};
        }
        return new int[]{-1, -1};
    }

    public int[] getScanIndices(float e, float halfBeamWidth) {
        if (e < this.fixedElevation.get(0).floatValue() - halfBeamWidth || e > this.fixedElevation.get(this.fixedElevation.size() - 1).floatValue() + halfBeamWidth) {
            return new int[]{-1, -1};
        }
        if (e <= this.fixedElevation.get(0).floatValue()) {
            return new int[]{0, 0};
        }
        if (e >= this.fixedElevation.get(this.fixedElevation.size() - 1).floatValue()) {
            return new int[]{this.fixedElevation.size() - 1, this.fixedElevation.size() - 1};
        }
        for (int i = 1; i < this.fixedElevation.size(); ++i) {
            if (!(e <= this.fixedElevation.get(i).floatValue())) continue;
            return new int[]{i - 1, i};
        }
        return new int[]{-1, -1};
    }

    public float getValue(int ei, float a, float r) {
        float v;
        Array rData;
        List<Array> sData = this.data.get(ei);
        int aziIdx = this.getAzimuthIndex(ei, a);
        int disRes = this.disResolution.get(ei);
        int disIdx = (int)(r / (float)disRes);
        if ((long)disIdx < (rData = sData.get(aziIdx)).getSize()) {
            v = rData.getFloat(disIdx);
            if (v == (float)this.fillValue) {
                v = Float.NaN;
            }
        } else {
            v = Float.NaN;
        }
        if (!Float.isNaN(v)) {
            v = (v - (float)this.offset) / (float)this.scale;
        }
        return v;
    }

    public float interpolateValue(int ei, int ai, float r) {
        float v;
        List<Array> sData = this.data.get(ei);
        int disRes = this.disResolution.get(ei);
        Array rData = sData.get(ai);
        float disIdx = r / (float)disRes;
        int di1 = (int)Math.floor(disIdx);
        int di2 = (int)Math.ceil(disIdx);
        if ((long)di1 < rData.getSize()) {
            v = rData.getFloat(di1);
            if (v == (float)this.fillValue) {
                v = Float.NaN;
            }
        } else {
            v = Float.NaN;
        }
        if (di1 != di2) {
            float v2;
            if ((long)di2 < rData.getSize()) {
                v2 = rData.getFloat(di2);
                if (v2 == (float)this.fillValue) {
                    v2 = Float.NaN;
                }
            } else {
                v2 = Float.NaN;
            }
            if (Float.isNaN(v)) {
                v = v2;
            } else if (!Float.isNaN(v2)) {
                Array dis = this.distance.get(ei);
                v += (v2 - v) * (r - dis.getFloat(di1)) / (dis.getFloat(di2) - dis.getFloat(di1));
            }
        }
        return v;
    }

    public float interpolateValue(int ei, float a, float r) {
        List<Array> sData = this.data.get(ei);
        int[] aziIndices = this.getAzimuthIndices(ei, a);
        int ai1 = aziIndices[0];
        int ai2 = aziIndices[1];
        float v = this.interpolateValue(ei, ai1, r);
        if (ai2 != ai1) {
            float v2 = this.interpolateValue(ei, ai2, r);
            if (Float.isNaN(v)) {
                v = v2;
            } else if (!Float.isNaN(v2)) {
                List<Float> azi = this.azimuth.get(ei);
                v += (v2 - v) * (a - azi.get(ai1).floatValue()) / (azi.get(ai2).floatValue() - azi.get(ai1).floatValue());
            }
        }
        if (!Float.isNaN(v)) {
            v = (v - (float)this.offset) / (float)this.scale;
        }
        return v;
    }

    public float interpolateValue(float e, float a, float r) {
        int[] scanIdx = this.getScanIndices(e);
        if (scanIdx[0] < 0) {
            return Float.NaN;
        }
        int ei1 = scanIdx[0];
        int ei2 = scanIdx[1];
        float v = this.interpolateValue(ei1, a, r);
        if (ei2 != ei1) {
            float v2 = this.interpolateValue(ei2, a, r);
            if (Float.isNaN(v)) {
                v = v2;
            } else if (!Float.isNaN(v2)) {
                v += (v2 - v) * (e - this.fixedElevation.get(ei1).floatValue()) / (this.fixedElevation.get(ei2).floatValue() - this.fixedElevation.get(ei1).floatValue());
            }
        }
        return v;
    }

    public float interpolateValue(float e, float a, float r, float halfBeamWidth) {
        int[] scanIdx = this.getScanIndices(e, halfBeamWidth);
        if (scanIdx[0] < 0) {
            return Float.NaN;
        }
        int ei1 = scanIdx[0];
        int ei2 = scanIdx[1];
        float v = this.interpolateValue(ei1, a, r);
        if (ei2 != ei1) {
            float v2 = this.interpolateValue(ei2, a, r);
            if (Float.isNaN(v)) {
                v = v2;
            } else if (!Float.isNaN(v2)) {
                v += (v2 - v) * (e - this.fixedElevation.get(ei1).floatValue()) / (this.fixedElevation.get(ei2).floatValue() - this.fixedElevation.get(ei1).floatValue());
            }
        }
        return v;
    }
}

