/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class Transform {
    static double R = 8494666.666666666;

    public static double[] antennaToCartesian(float r, float a, float e) {
        double z = Math.pow((double)(r * r) + R * R + 2.0 * (double)r * R * Math.sin(e), 0.5) - R;
        double s = R * Math.asin((double)r * Math.cos(e) / (R + z));
        double x = s * Math.sin(a);
        double y = s * Math.cos(a);
        return new double[]{x, y, z};
    }

    public static float toCartesianZ(float r, float e, float h) {
        float z = (float)(Math.pow(Math.pow((double)r * Math.cos(e), 2.0) + Math.pow(R + (double)h + (double)r * Math.sin(e), 2.0), 0.5) - R);
        return z;
    }

    public static double[] antennaToCartesian(float r, float a, float e, float h) {
        double z = Math.pow(Math.pow((double)r * Math.cos(e), 2.0) + Math.pow(R + (double)h + (double)r * Math.sin(e), 2.0), 0.5) - R;
        double s = R * Math.asin((double)r * Math.cos(e) / (R + z));
        double x = s * Math.sin(a);
        double y = s * Math.cos(a);
        return new double[]{x, y, z};
    }

    public static Array[] antennaToCartesian(Array ra, Array aa, Array ea) {
        ra = ra.copyIfView();
        aa = aa.copyIfView();
        ea = ea.copyIfView();
        Array xa = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array ya = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array za = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        int i = 0;
        while ((long)i < ra.getSize()) {
            float r = ra.getFloat(i);
            float a = aa.getFloat(i);
            float e = ea.getFloat(i);
            double[] xyz = Transform.antennaToCartesian(r, a, e);
            xa.setDouble(i, xyz[0]);
            ya.setDouble(i, xyz[1]);
            za.setDouble(i, xyz[2]);
            ++i;
        }
        return new Array[]{xa, ya, za};
    }

    public static Array[] antennaToCartesian(Array ra, Array aa, float e) {
        ra = ra.copyIfView();
        aa = aa.copyIfView();
        Array xa = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array ya = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array za = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        int i = 0;
        while ((long)i < ra.getSize()) {
            float r = ra.getFloat(i);
            float a = aa.getFloat(i);
            double[] xyz = Transform.antennaToCartesian(r, a, e);
            xa.setDouble(i, xyz[0]);
            ya.setDouble(i, xyz[1]);
            za.setDouble(i, xyz[2]);
            ++i;
        }
        return new Array[]{xa, ya, za};
    }

    public static Array[] antennaToCartesian(Array ra, Array aa, Array ea, float h) {
        ra = ra.copyIfView();
        aa = aa.copyIfView();
        ea = ea.copyIfView();
        Array xa = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array ya = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array za = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        int i = 0;
        while ((long)i < ra.getSize()) {
            float r = ra.getFloat(i);
            float a = aa.getFloat(i);
            float e = ea.getFloat(i);
            double[] xyz = Transform.antennaToCartesian(r, a, e, h);
            xa.setDouble(i, xyz[0]);
            ya.setDouble(i, xyz[1]);
            za.setDouble(i, xyz[2]);
            ++i;
        }
        return new Array[]{xa, ya, za};
    }

    public static Array[] antennaToCartesian(Array ra, Array aa, float e, float h) {
        ra = ra.copyIfView();
        aa = aa.copyIfView();
        Array xa = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array ya = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        Array za = Array.factory((DataType)DataType.DOUBLE, (int[])ra.getShape());
        int i = 0;
        while ((long)i < ra.getSize()) {
            float r = ra.getFloat(i);
            float a = aa.getFloat(i);
            double[] xyz = Transform.antennaToCartesian(r, a, e, h);
            xa.setDouble(i, xyz[0]);
            ya.setDouble(i, xyz[1]);
            za.setDouble(i, xyz[2]);
            ++i;
        }
        return new Array[]{xa, ya, za};
    }

    public static double xyToAzimuth(float x, float y) {
        double az = 1.5707963267948966 - Math.atan2(y, x);
        if (az < 0.0) {
            az = Math.PI * 2 + az;
        }
        return Math.toDegrees(az);
    }

    public static Array xyToAzimuth(Array xa, Array ya) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        Array aa = Array.factory((DataType)DataType.FLOAT, (int[])xa.getShape());
        int i = 0;
        while ((long)i < aa.getSize()) {
            aa.setFloat(i, (float)Transform.xyToAzimuth(xa.getFloat(i), ya.getFloat(i)));
            ++i;
        }
        return aa;
    }

    public static double[] cartesianToAntenna(float x, float y, float z, float h) {
        double ranges = Math.sqrt(Math.pow(R + (double)h, 2.0) + Math.pow(R + (double)z, 2.0) - 2.0 * (R + (double)h) * (R + (double)z) * Math.cos(Math.sqrt(x * x + y * y) / R));
        double elevation = (Math.acos(((R + (double)h) * (R + (double)h) + ranges * ranges - (R + (double)z) * (R + (double)z)) / (2.0 * (R + (double)h) * ranges)) - 1.5707963267948966) * 180.0 / Math.PI;
        double azimuth = Transform.xyToAzimuth(x, y);
        return new double[]{azimuth, ranges, elevation};
    }

    public static Array[] cartesianToAntenna(Array xa, Array ya, Array za, float h) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        Array ranges = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array azimuth = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array elevation = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        int i = 0;
        while ((long)i < xa.getSize()) {
            float x = xa.getFloat(i);
            float y = ya.getFloat(i);
            float z = za.getFloat(i);
            double[] rr = Transform.cartesianToAntenna(x, y, z, h);
            azimuth.setDouble(i, rr[0]);
            ranges.setDouble(i, rr[1]);
            elevation.setDouble(i, rr[2]);
            ++i;
        }
        return new Array[]{azimuth, ranges, elevation};
    }

    public static Array[] cartesianToAntenna(Array xa, Array ya, float z, float h) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        Array ranges = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array azimuth = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array elevation = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        int i = 0;
        while ((long)i < xa.getSize()) {
            float x = xa.getFloat(i);
            float y = ya.getFloat(i);
            double[] rr = Transform.cartesianToAntenna(x, y, z, h);
            azimuth.setDouble(i, rr[0]);
            ranges.setDouble(i, rr[1]);
            elevation.setDouble(i, rr[2]);
            ++i;
        }
        return new Array[]{azimuth, ranges, elevation};
    }

    public static double[] cartesianToAntennaElevation(float x, float y, float e, float h) {
        double s = Math.sqrt(x * x + y * y);
        double range = Math.tan(s / R) * (R + (double)h) * Math.cosh(e);
        double z = (R + (double)h) / Math.cos((double)e + s / R) * Math.cos(e) - R;
        double azimuth = Transform.xyToAzimuth(x, y);
        return new double[]{azimuth, range, z};
    }

    public static Array[] cartesianToAntennaElevation(Array xa, Array ya, float e, float h) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        Array ranges = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array azimuth = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        Array za = Array.factory((DataType)DataType.DOUBLE, (int[])xa.getShape());
        int i = 0;
        while ((long)i < xa.getSize()) {
            float x = xa.getFloat(i);
            float y = ya.getFloat(i);
            double[] rr = Transform.cartesianToAntennaElevation(x, y, e, h);
            azimuth.setDouble(i, rr[0]);
            ranges.setDouble(i, rr[1]);
            za.setDouble(i, rr[2]);
            ++i;
        }
        return new Array[]{azimuth, ranges, za};
    }
}

