/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.synop;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.DimArray;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;

public class SYNOPDataInfo
extends DataInfo
implements IStationDataInfo {
    private String stFileName;
    private LocalDateTime date;
    private int stationNum;
    private final List<String> varList;
    private List<List<String>> DataList;

    public SYNOPDataInfo() {
        String[] items = new String[]{"Visibility", "CloudCover", "WindDirection", "WindSpeed", "Temperature", "DewPoint", "Pressure", "Precipitation", "Weather"};
        this.varList = Arrays.asList(items);
        this.DataList = new ArrayList<List<String>>();
        this.setDataType(MeteoDataType.SYNOP);
    }

    public String getStationFileName() {
        return this.stFileName;
    }

    public void setStationFileName(String value) {
        this.stFileName = value;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            String[] dataArray;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader(new FileInputStream(this.stFileName)));
            ArrayList<String> stIDList = new ArrayList<String>();
            ArrayList<String[]> stPosList = new ArrayList<String[]>();
            sr.readLine();
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                dataArray = aLine.split(",");
                stIDList.add(dataArray[1]);
                stPosList.add(new String[]{dataArray[5], dataArray[4]});
            }
            sr.close();
            sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            ArrayList<List<String>> disDataList = new ArrayList<List<String>>();
            String reportType = "AAXX";
            LocalDateTime toDay = LocalDateTime.now();
            LocalDateTime tt = LocalDateTime.now();
            String windSpeedIndicator = "/";
            boolean isSetTime = true;
            while ((aLine = sr.readLine()) != null) {
                block55: {
                    String str;
                    if ((aLine = aLine.trim()).isEmpty()) continue;
                    if (aLine.length() == 3 && MIMath.isNumeric((String)aLine)) {
                        sr.readLine();
                        continue;
                    }
                    if (aLine.length() < 4) continue;
                    switch (aLine.substring(0, 4)) {
                        case "AAXX": {
                            reportType = "AAXX";
                            str = aLine.substring(aLine.length() - 5, aLine.length());
                            if (isSetTime) {
                                this.date = tt = LocalDateTime.of(toDay.getYear(), toDay.getMonth(), Integer.parseInt(str.substring(0, 2)), Integer.parseInt(str.substring(2, 4)), 0, 0);
                                isSetTime = false;
                            }
                            windSpeedIndicator = str.substring(str.length() - 1, str.length());
                            break block55;
                        }
                        case "BBXX": {
                            reportType = "BBXX";
                            break block55;
                        }
                        case "OOXX": {
                            reportType = "OOXX";
                            break block55;
                        }
                    }
                    while (!aLine.substring(aLine.length() - 1, aLine.length()).equals("=") && (str = sr.readLine()) != null) {
                        aLine = aLine + " " + sr.readLine();
                    }
                    dataArray = aLine.split("\\s+");
                    ArrayList<String> dataList = new ArrayList<String>();
                    for (int i = 0; i < dataArray.length; ++i) {
                        dataList.add(dataArray[i]);
                    }
                    String stID = (String)dataList.get(0);
                    switch (reportType) {
                        case "AAXX": {
                            int stIdx;
                            if (dataList.size() <= 2 || (stIdx = stIDList.indexOf(stID)) < 0) break;
                            dataList.add(0, windSpeedIndicator);
                            dataList.add(0, reportType);
                            dataList.add(0, ((String[])stPosList.get(stIdx))[1]);
                            dataList.add(0, ((String[])stPosList.get(stIdx))[0]);
                            disDataList.add(dataList);
                            break;
                        }
                        case "BBXX": 
                        case "OOXX": {
                            if (dataList.size() <= 5 || ((String)dataList.get(2)).contains("/") || ((String)dataList.get(3)).contains("/") || !((String)dataList.get(2)).substring(0, 2).equals("99")) break;
                            str = (String)dataList.get(1);
                            windSpeedIndicator = str.substring(str.length() - 1, str.length());
                            float lat = Float.parseFloat(((String)dataList.get(2)).substring(2)) / 10.0f;
                            float lon = Float.parseFloat(((String)dataList.get(3)).substring(1)) / 10.0f;
                            if (lat > 90.0f || lon > 180.0f) break;
                            switch (((String)dataList.get(3)).substring(0, 1)) {
                                case "1": {
                                    break;
                                }
                                case "3": {
                                    lat = -lat;
                                    break;
                                }
                                case "5": {
                                    lat = -lat;
                                    lon = -lon;
                                    break;
                                }
                                case "7": {
                                    lon = -lon;
                                }
                            }
                            dataList.add(0, windSpeedIndicator);
                            dataList.add(0, reportType);
                            dataList.add(0, String.valueOf(lat));
                            dataList.add(0, String.valueOf(lon));
                            disDataList.add(dataList);
                        }
                    }
                }
            }
            sr.close();
            this.stationNum = disDataList.size();
            this.DataList = disDataList;
            Dimension tdim = new Dimension(DimensionType.T);
            double[] values = new double[]{JDateUtil.toOADate((LocalDateTime)this.date)};
            tdim.setValues(values);
            this.setTimeDimension(tdim);
            ArrayList<Variable> vars = new ArrayList<Variable>();
            for (String vName : this.varList) {
                Variable var = new Variable();
                var.setName(vName);
                var.setDimension(tdim);
                var.setStation(true);
                vars.add(var);
            }
            this.setVariables(vars);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SYNOPDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SYNOPDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SYNOPDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().get(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + "Station Number: " + String.valueOf(this.stationNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Number of Variables = " + String.valueOf(this.getVariableNum());
        for (int i = 0; i < this.getVariableNum(); ++i) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this.getVariableNames().get(i);
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public DimArray readDimArray(String varName) {
        return null;
    }

    @Override
    public DimArray readDimArray(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int i;
        StationData stationData = new StationData();
        ArrayList<String> stations = new ArrayList<String>();
        int varIdx = this.getVariableIndex(varName);
        ArrayList<double[]> discreteData = new ArrayList<double[]>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        String windSpeedIndicator = "/";
        String reportType = "AAXX";
        for (i = 0; i < this.DataList.size(); ++i) {
            List<String> dataList = this.DataList.get(i);
            reportType = dataList.get(2);
            windSpeedIndicator = dataList.get(3);
            String aStid = dataList.get(4);
            float lon = Float.parseFloat(dataList.get(0));
            float lat = Float.parseFloat(dataList.get(1));
            int sIdx = 5;
            switch (reportType) {
                case "BBXX": 
                case "OOXX": {
                    sIdx = 8;
                }
            }
            double[] disData = new double[]{lon, lat, this.getDataValue(dataList, varIdx, sIdx, windSpeedIndicator)};
            stations.add(aStid);
            discreteData.add(disData);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        stationData.data = new double[discreteData.size()][3];
        for (i = 0; i < discreteData.size(); ++i) {
            stationData.data[i][0] = ((double[])discreteData.get(i))[0];
            stationData.data[i][1] = ((double[])discreteData.get(i))[1];
            stationData.data[i][2] = ((double[])discreteData.get(i))[2];
        }
        stationData.dataExtent = dataExtent;
        stationData.stations = stations;
        return stationData;
    }

    private double getDataValue(List<String> dataList, int vIdx, int sIdx, String windSpeedIndicator) {
        double value = this.getMissingValue();
        switch (vIdx) {
            case 0: {
                String str = dataList.get(sIdx);
                if (str.length() != 5 || (str = str.substring(3)).contains("/")) break;
                value = Integer.parseInt(str);
                if (value <= 50.0) {
                    value /= 10.0;
                    break;
                }
                if (value >= 56.0 && value <= 80.0) {
                    value -= 50.0;
                    break;
                }
                if (value >= 81.0 && value <= 89.0) {
                    value = 30.0 + (value - 80.0) * 5.0;
                    break;
                }
                if (!(value >= 90.0) || !(value <= 99.0)) break;
                switch ((int)value) {
                    case 90: {
                        value = 0.04;
                        break;
                    }
                    case 91: {
                        value = 0.05;
                        break;
                    }
                    case 92: {
                        value = 0.2;
                        break;
                    }
                    case 93: {
                        value = 0.5;
                        break;
                    }
                    case 94: {
                        value = 1.0;
                        break;
                    }
                    case 95: {
                        value = 2.0;
                        break;
                    }
                    case 96: {
                        value = 4.0;
                        break;
                    }
                    case 97: {
                        value = 10.0;
                        break;
                    }
                    case 98: {
                        value = 20.0;
                        break;
                    }
                    case 99: {
                        value = 50.0;
                    }
                }
                break;
            }
            case 1: {
                String str = dataList.get(sIdx + 1);
                if (str.length() != 5 || (str = str.substring(0, 1)).equals("/")) break;
                value = Integer.parseInt(str);
                break;
            }
            case 2: {
                String str = dataList.get(sIdx + 1);
                if (str.length() != 5 || (str = str.substring(1, 3)).equals("//") || !((value = (double)(Integer.parseInt(str) * 10)) > 360.0)) break;
                value = 0.0;
                break;
            }
            case 3: {
                String str;
                if (windSpeedIndicator.equals("/") || (str = dataList.get(sIdx + 1)).length() != 5 || (str = str.substring(3)).contains("/")) break;
                if (str.equals("99")) {
                    str = dataList.get(sIdx + 2).substring(2);
                    if (str.contains("/")) break;
                    value = Integer.parseInt(str);
                } else {
                    value = Integer.parseInt(str);
                }
                if (!windSpeedIndicator.equals("3") && !windSpeedIndicator.equals("4")) break;
                value *= 0.51444;
                break;
            }
            case 4: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("1")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/")) break;
                String sign = str.substring(1, 2);
                value = Double.parseDouble(str.substring(2)) / 10.0;
                if (!sign.equals("1")) break;
                value = -value;
                break;
            }
            case 5: {
                String sign;
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("2")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || (sign = str.substring(1, 2)).equals("9")) break;
                value = Double.parseDouble(str.substring(2)) / 10.0;
                if (!sign.equals("1")) break;
                value = -value;
                break;
            }
            case 6: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("3")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || !MIMath.isNumeric((String)str.substring(1))) break;
                value = Double.parseDouble(str.substring(1)) / 10.0;
                if (!((value /= 10.0) < 500.0)) break;
                value += 1000.0;
                break;
            }
            case 7: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("6")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.contains("/") || !((value = Double.parseDouble(str.substring(1, 4))) >= 990.0)) break;
                value -= 990.0;
                break;
            }
            case 8: {
                String str = "";
                for (int i = sIdx + 2; i < dataList.size(); ++i) {
                    if (dataList.get(i).length() != 5 || !dataList.get(i).substring(0, 1).equals("7")) continue;
                    str = dataList.get(i);
                    break;
                }
                if (str.isEmpty() || str.substring(1, 3).contains("/")) break;
                value = Integer.parseInt(str.substring(1, 3));
            }
        }
        return value;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        return null;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        StationModelData smData = new StationModelData();
        ArrayList<StationModel> smList = new ArrayList<StationModel>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        String windSpeedIndicator = "/";
        String reportType = "AAXX";
        for (int i = 0; i < this.DataList.size(); ++i) {
            List<String> dataList = this.DataList.get(i);
            reportType = dataList.get(2);
            windSpeedIndicator = dataList.get(3);
            String aStid = dataList.get(4);
            float lon = Float.parseFloat(dataList.get(0));
            float lat = Float.parseFloat(dataList.get(1));
            int sIdx = 5;
            switch (reportType) {
                case "BBXX": 
                case "OOXX": {
                    sIdx = 8;
                }
            }
            StationModel sm = new StationModel();
            sm.setLongitude(lon);
            sm.setLatitude(lat);
            sm.setWindDirection(this.getDataValue(dataList, 2, sIdx, windSpeedIndicator));
            sm.setWindSpeed(this.getDataValue(dataList, 3, sIdx, windSpeedIndicator));
            sm.setVisibility(this.getDataValue(dataList, 0, sIdx, windSpeedIndicator));
            sm.setWeather(this.getDataValue(dataList, 8, sIdx, windSpeedIndicator));
            sm.setCloudCover(this.getDataValue(dataList, 1, sIdx, windSpeedIndicator));
            sm.setTemperature(this.getDataValue(dataList, 4, sIdx, windSpeedIndicator));
            sm.setDewPoint(this.getDataValue(dataList, 5, sIdx, windSpeedIndicator));
            smList.add(sm);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        smData.setData(smList);
        smData.setDataExtent(dataExtent);
        smData.setMissingValue(this.getMissingValue());
        return smData;
    }
}

