package org.meteoinfo.data.meteodata.radar;

import org.meteoinfo.common.DataConvert;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.logging.Level;

public class CutConfig {
    public static int length = 256;
    public int processMode;
    public int waveForm;
    public float PRF1;
    public float PRF2;
    public int deAliasingMode;
    public float azimuth;
    public float elevation;
    public float startAngle;
    public float endAngle;
    public float angularResolution;
    public float scanSpeed;
    public int logResolution;
    public int dopplerResolution;
    public int maximumRange1;
    public int maximumRange2;
    public int startRange;
    public int sample1;
    public int sample2;
    public int phaseMode;
    public float atmosphericLoss;
    public float nyquistSpeed;
    public long momentsMask;
    public long momentsSizeMask;
    public int miscFilterMask;
    public float SQIThreshold;
    public float SIGThreshold;
    public float CSRThreshold;
    public float LOGThreshold;
    public float CPAThreshold;
    public float PMIThreshold;
    public float DPLOGThreshold;
    public byte[] thresholdsReserved;
    public int dBTMask;
    public int dBZMask;
    public int velocityMask;
    public int spectrumWidthMask;
    public int DPMask;
    public byte[] maskReserved;
    public byte[] reserved;
    public int direction;
    public short groundClutterClassifierType;
    public short groundClutterFilterType;
    public short groundClutterNotchWidth;
    public short groundClutterFilterWindow;
    public byte[] reserved2;

    /**
     * Constructor
     * @param raf RandomAccessFile object
     */
    public CutConfig(RandomAccessFile raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        processMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        waveForm = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PRF1 = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PRF2 = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        deAliasingMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        azimuth = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        elevation = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        startAngle = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        endAngle = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        angularResolution = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        scanSpeed = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        logResolution = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        dopplerResolution = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        maximumRange1 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        maximumRange2 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        startRange = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        sample1 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        sample2 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        phaseMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        atmosphericLoss = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        nyquistSpeed = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[8];
        raf.read(bytes);
        momentsMask = DataConvert.bytes2Long(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        momentsSizeMask = DataConvert.bytes2Long(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        raf.read(bytes);
        miscFilterMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        SQIThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        SIGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        CSRThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        LOGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        CPAThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PMIThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        DPLOGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        thresholdsReserved = new byte[4];
        raf.read(thresholdsReserved);
        raf.read(bytes);
        dBTMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        dBZMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        velocityMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        spectrumWidthMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        DPMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        maskReserved = new byte[12];
        raf.read(maskReserved);
        reserved = new byte[4];
        raf.read(reserved);
        raf.read(bytes);
        direction = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        groundClutterClassifierType = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterFilterType = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterNotchWidth = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterFilterWindow = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        reserved2 = new byte[72];
        raf.read(reserved2);
    }

    /**
     * Constructor
     * @param raf InputStream object
     */
    public CutConfig(InputStream raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        processMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        waveForm = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PRF1 = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PRF2 = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        deAliasingMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        azimuth = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        elevation = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        startAngle = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        endAngle = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        angularResolution = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        scanSpeed = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        logResolution = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        dopplerResolution = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        maximumRange1 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        maximumRange2 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        startRange = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        sample1 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        sample2 = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        phaseMode = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        atmosphericLoss = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        nyquistSpeed = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[8];
        raf.read(bytes);
        momentsMask = DataConvert.bytes2Long(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        momentsSizeMask = DataConvert.bytes2Long(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        raf.read(bytes);
        miscFilterMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        SQIThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        SIGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        CSRThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        LOGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        CPAThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        PMIThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        DPLOGThreshold = DataConvert.bytes2Float(bytes, ByteOrder.LITTLE_ENDIAN);
        thresholdsReserved = new byte[4];
        raf.read(thresholdsReserved);
        raf.read(bytes);
        dBTMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        dBZMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        velocityMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        spectrumWidthMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        DPMask = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        maskReserved = new byte[12];
        raf.read(maskReserved);
        reserved = new byte[4];
        raf.read(reserved);
        raf.read(bytes);
        direction = DataConvert.bytes2Int(bytes, ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        groundClutterClassifierType = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterFilterType = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterNotchWidth = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        groundClutterFilterWindow = DataConvert.bytes2Short(bytes, ByteOrder.LITTLE_ENDIAN);
        reserved2 = new byte[72];
        raf.read(reserved2);
    }
}
