/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.impl.Aggregate;
import org.meteoinfo.ndarray.DataType;

public class Aggregation {
    private static Object name(DataFrame df, Object row, Object stat) {
        return df.getIndex().size() > 1 ? Arrays.asList(row, stat) : stat;
    }

    public static DataFrame describe(DataFrame df) {
        DataFrame desc = new DataFrame();
        for (Column col : df.getColumns()) {
            Column ncol = new Column(col.getName(), DataType.DOUBLE);
            for (Object row : df.getIndex()) {
                Object value = df.getValue(row, col);
                if (!(value instanceof StatisticalSummary)) continue;
                if (!desc.getColumns().contains(ncol)) {
                    desc.addColumn(ncol);
                    if (desc.isEmpty()) {
                        for (Object r : df.getIndex()) {
                            for (String stat : Arrays.asList("count", "mean", "std", "var", "max", "min")) {
                                Object name = Aggregation.name(df, r, stat);
                                desc.append(name, new ArrayList());
                            }
                        }
                    }
                }
                StatisticalSummary summary = (StatisticalSummary)StatisticalSummary.class.cast(value);
                desc.setValue(Aggregation.name(df, row, "count"), ncol, (Object)summary.getN());
                desc.setValue(Aggregation.name(df, row, "mean"), ncol, (Object)summary.getMean());
                desc.setValue(Aggregation.name(df, row, "std"), ncol, (Object)summary.getStandardDeviation());
                desc.setValue(Aggregation.name(df, row, "var"), ncol, (Object)summary.getVariance());
                desc.setValue(Aggregation.name(df, row, "max"), ncol, (Object)summary.getMax());
                desc.setValue(Aggregation.name(df, row, "min"), ncol, (Object)summary.getMin());
            }
        }
        return desc;
    }

    public static class Describe<V>
    implements Aggregate<V, StatisticalSummary> {
        private final SummaryStatistics stat = new SummaryStatistics();

        @Override
        public StatisticalSummary apply(List<V> values) {
            this.stat.clear();
            for (Object value : values) {
                double v;
                if (value == null) continue;
                if (value instanceof Boolean) {
                    value = (Boolean)Boolean.class.cast(value) != false ? 1 : 0;
                }
                if (Double.isNaN(v = ((Number)Number.class.cast(value)).doubleValue())) continue;
                this.stat.addValue(v);
            }
            return this.stat.getSummary();
        }
    }

    public static class Percentile<V>
    extends AbstractStatistic<V> {
        public Percentile(double quantile) {
            super((UnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Percentile(quantile));
        }
    }

    public static class Median<V>
    extends AbstractStatistic<V> {
        public Median() {
            super((UnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Median());
        }
    }

    private static abstract class AbstractStatistic<V>
    implements Aggregate<V, Number> {
        protected final UnivariateStatistic stat;

        protected AbstractStatistic(UnivariateStatistic stat) {
            this.stat = stat;
        }

        @Override
        public Number apply(List<V> values) {
            int count = 0;
            double[] vals = new double[values.size()];
            for (int i = 0; i < vals.length; ++i) {
                V val = values.get(i);
                if (val == null) continue;
                vals[count++] = ((Number)Number.class.cast(val)).doubleValue();
            }
            return this.stat.evaluate(vals, 0, count);
        }
    }

    public static class Max<V>
    extends AbstractStorelessStatistic<V> {
        public Max() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Max());
        }
    }

    public static class Min<V>
    extends AbstractStorelessStatistic<V> {
        public Min() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Min());
        }
    }

    public static class Kurtosis<V>
    extends AbstractStorelessStatistic<V> {
        public Kurtosis() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Kurtosis());
        }
    }

    public static class Skew<V>
    extends AbstractStorelessStatistic<V> {
        public Skew() {
            super((StorelessUnivariateStatistic)new Skewness());
        }
    }

    public static class Variance<V>
    extends AbstractStorelessStatistic<V> {
        public Variance() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Variance());
        }
    }

    public static class StdDev<V>
    extends AbstractStorelessStatistic<V> {
        public StdDev() {
            super((StorelessUnivariateStatistic)new StandardDeviation());
        }
    }

    public static class Mean<V>
    extends AbstractStorelessStatistic<V> {
        public Mean() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Mean());
        }
    }

    public static class Product<V>
    extends AbstractStorelessStatistic<V> {
        public Product() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.summary.Product());
        }
    }

    public static class Sum<V>
    extends AbstractStorelessStatistic<V> {
        public Sum() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.summary.Sum());
        }
    }

    private static abstract class AbstractStorelessStatistic<V>
    implements Aggregate<V, Number> {
        protected final StorelessUnivariateStatistic stat;

        protected AbstractStorelessStatistic(StorelessUnivariateStatistic stat) {
            this.stat = stat;
        }

        @Override
        public Number apply(List<V> values) {
            this.stat.clear();
            for (Object value : values) {
                double v;
                if (value == null) continue;
                if (value instanceof Boolean) {
                    value = (Boolean)Boolean.class.cast(value) != false ? 1 : 0;
                }
                if (Double.isNaN(v = ((Number)Number.class.cast(value)).doubleValue())) continue;
                this.stat.increment(((Number)Number.class.cast(value)).doubleValue());
            }
            if (this.stat.getN() == 0L) {
                return Double.NaN;
            }
            return this.stat.getResult();
        }
    }

    public static class Collapse<V>
    implements Aggregate<V, String> {
        private final String delimiter;

        public Collapse() {
            this(",");
        }

        public Collapse(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public String apply(List<V> values) {
            HashSet<V> seen = new HashSet<V>();
            StringBuilder sb = new StringBuilder();
            for (V value : values) {
                if (seen.contains(value)) continue;
                if (sb.length() > 0) {
                    sb.append(this.delimiter);
                }
                sb.append(String.valueOf(value));
                seen.add(value);
            }
            return sb.toString();
        }
    }

    public static class Unique<V>
    implements Aggregate<V, V> {
        @Override
        public V apply(List<V> values) {
            HashSet<V> unique = new HashSet<V>(values);
            if (unique.size() > 1) {
                throw new IllegalArgumentException("values not unique: " + unique);
            }
            return values.get(0);
        }
    }

    public static class Count<V>
    implements Aggregate<V, Number> {
        @Override
        public Number apply(List<V> values) {
            int n = 0;
            for (V value : values) {
                double v;
                if (value == null || value instanceof Number && Double.isNaN(v = ((Number)Number.class.cast(value)).doubleValue())) continue;
                ++n;
            }
            return n;
        }
    }
}

