/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.common.util.TypeUtils;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrameGroupBy;
import org.meteoinfo.dataframe.DateTimeIndex;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.dataframe.IntIndex;
import org.meteoinfo.dataframe.Series;
import org.meteoinfo.dataframe.impl.Aggregation;
import org.meteoinfo.dataframe.impl.Function;
import org.meteoinfo.dataframe.impl.Grouping;
import org.meteoinfo.dataframe.impl.KeyFunction;
import org.meteoinfo.dataframe.impl.SortDirection;
import org.meteoinfo.dataframe.impl.Sorting;
import org.meteoinfo.dataframe.impl.Views;
import org.meteoinfo.dataframe.impl.WindowFunction;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.DataTypeUtil;
import org.mozilla.universalchardet.UniversalDetector;

public class DataFrame
implements Iterable {
    private Index index;
    private ColumnIndex columns;
    private Object data;
    private boolean array2D = false;

    public DataFrame() {
        this.columns = new ColumnIndex();
    }

    public DataFrame(ColumnIndex columns) {
        this.columns = columns;
    }

    public DataFrame(Index index) {
        this();
        this.index = index;
    }

    public DataFrame(List index) {
        this(Index.factory(index));
    }

    public DataFrame(Array data, Index index, ColumnIndex columns) {
        this(index, columns, (Object)data);
    }

    public DataFrame(Array data, Index index, List<String> columns) {
        this(index, columns, (Object)data);
    }

    public DataFrame(Index index, ColumnIndex columns, Object data) {
        if (data instanceof Array) {
            if (((Array)data).getRank() == 1) {
                if (columns.size() == 1) {
                    this.data = new ArrayList();
                    ((List)this.data).add(data);
                } else if (((Array)data).getSize() == (long)columns.size()) {
                    this.data = ((Array)data).reshape(new int[]{1, columns.size()});
                    this.array2D = true;
                }
            } else {
                this.data = data;
                this.array2D = true;
            }
        } else {
            this.data = data;
        }
        this.columns = columns;
        this.index = index;
    }

    public DataFrame(Index index, List<String> columns, Object data) {
        this.columns = new ColumnIndex();
        if (data instanceof Array) {
            ArrayList<DataType> dtypes = new ArrayList<DataType>();
            if (((Array)data).getRank() == 1) {
                this.data = new ArrayList();
                ((List)this.data).add(data);
                String colName = columns == null ? "C_1" : columns.get(0);
                this.columns.add(Column.factory(colName, (Array)data));
            } else {
                int i;
                this.data = data;
                this.array2D = true;
                int n = ((Array)data).getShape()[1];
                if (columns == null) {
                    columns = new ArrayList<String>();
                    for (i = 0; i < n; ++i) {
                        columns.add("C_" + String.valueOf(i));
                    }
                }
                for (i = 0; i < n; ++i) {
                    dtypes.add(((Array)data).getDataType());
                    this.columns.add(new Column(columns.get(i), (DataType)dtypes.get(i)));
                }
            }
        } else {
            int i;
            this.data = data;
            int n = ((List)data).size();
            if (columns == null) {
                columns = new ArrayList<String>();
                for (i = 0; i < n; ++i) {
                    columns.add("C_" + String.valueOf(i));
                }
            }
            for (i = 0; i < n; ++i) {
                this.columns.add(new Column(columns.get(i), ((Array)((List)data).get(i)).getDataType()));
            }
        }
        this.index = index;
    }

    public DataFrame(Array data, List index, List<String> columns) {
        this(data, Index.factory(index), columns);
    }

    public DataFrame(List<Array> data, Index index, ColumnIndex columns) {
        this(index, columns, data);
    }

    public DataFrame(List<Array> data, Index index, List<String> columns) {
        this(index, columns, data);
    }

    public DataFrame(List<Array> data, List index, List columns) {
        this(data, Index.factory(index), (List<String>)columns);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Array value) {
        if (value.getRank() == 1) {
            this.data = new ArrayList();
            ((List)this.data).add(value);
        } else {
            this.data = value;
            this.array2D = true;
        }
    }

    public void setData(List<Array> value) {
        this.data = value;
        this.array2D = false;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index value) {
        this.index = value;
    }

    public void setIndex(List value) {
        this.index = Index.factory(value);
    }

    public ColumnIndex getColumns() {
        return this.columns;
    }

    public List<String> getColumnNames() {
        return this.columns.getNames();
    }

    public List<DataType> getColumnDataTypes() {
        return this.columns.getDataTypes();
    }

    public void setColumns(ColumnIndex value) {
        this.columns = value;
    }

    public void setColumns(List<String> colNames) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i >= colNames.size()) continue;
            ((Column)this.columns.get(i)).setName(colNames.get(i));
        }
    }

    public boolean isArray2D() {
        return this.array2D;
    }

    public Iterator iterator() {
        return this.iterrows();
    }

    public ListIterator<List<Object>> iterrows() {
        return new Views.ListView(this, true).listIterator();
    }

    public void updateColumnFormats() {
        if (this.array2D) {
            Column col = (Column)this.columns.get(0);
            col.updateFormat((Array)this.data);
            for (int i = 1; i < this.columns.size(); ++i) {
                ((Column)this.columns.get(i)).setFormat(col.getFormat());
                ((Column)this.columns.get(i)).setFormatLen(col.getFormatLen());
            }
        } else {
            for (int i = 0; i < this.columns.size(); ++i) {
                ((Column)this.columns.get(i)).updateFormat((Array)((List)this.data).get(i));
            }
        }
    }

    public int size() {
        return this.columns.size();
    }

    public int length() {
        return this.index.size();
    }

    public boolean isEmpty() {
        return this.data == null ? true : this.length() == 0;
    }

    public List col(Integer column) {
        return new Views.DataFrameListView(this, column, true);
    }

    public List row(Integer row) {
        return new Views.SeriesListView(this, row, false);
    }

    public Series rowSeries(int row) {
        Views.SeriesListView rowData = new Views.SeriesListView(this, row, false);
        Array a = this.columns.isSameDataType() ? Array.factory((DataType)((Column)this.columns.get((int)0)).dataType, (int[])new int[]{rowData.size()}) : Array.factory((DataType)DataType.OBJECT, (int[])new int[]{rowData.size()});
        for (int i = 0; i < rowData.size(); ++i) {
            a.setObject(i, rowData.get(i));
        }
        Index idx = this.columns.asIndex();
        Series s = new Series(a, idx, "Index");
        return s;
    }

    public int[] getShape() {
        int[] shape = new int[]{this.index.size(), this.columns.size()};
        return shape;
    }

    public Object getValue(Object row, Column col) {
        return this.getValue(this.index.indexOf(row), this.columns.indexOf(col));
    }

    public Object getValue(int row, int col) {
        if (this.array2D) {
            return ((Array)this.data).getObject(row * this.size() + col);
        }
        return ((Array)((List)this.data).get(col)).getObject(row);
    }

    public Object getValue(int row, String colName) {
        int col = this.columns.indexOfName(colName);
        if (col >= 0) {
            return this.getValue(row, col);
        }
        System.out.println("Column not exists: " + colName + "!");
        return null;
    }

    public void setValue(Object row, Column col, Object v) {
        int ri = this.index.indexOf(row);
        this.setValue(ri, col, v);
    }

    public void setValue(int row, int col, Object v) {
        if (this.array2D) {
            ((Array)this.data).setObject(row * this.size() + col, v);
        } else {
            ((Array)((List)this.data).get(col)).setObject(row, v);
        }
    }

    public void setValue(int row, String colName, Object v) {
        int col = this.columns.indexOfName(colName);
        if (col >= 0) {
            this.setValue(row, col, v);
        } else {
            System.out.println("Column not exists: " + colName + "!");
        }
    }

    public void setValue(int row, Column column, Object v) {
        int col = this.columns.indexOf(column);
        if (col >= 0) {
            this.setValue(row, col, v);
        } else {
            System.out.println("Column not exists: " + column.getName() + "!");
        }
    }

    public Array getColumnData(int col) throws InvalidRangeException {
        Array r;
        if (this.array2D) {
            Range rowRange = new Range(0, this.length() - 1, 1);
            Range colRange = new Range(col, col, 1);
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(rowRange);
            ranges.add(colRange);
            r = ArrayMath.section((Array)((Array)this.data), ranges);
            r = r.copy();
        } else {
            r = (Array)((List)this.data).get(col);
        }
        return r;
    }

    public Array getColumnData(String colName) throws InvalidRangeException {
        int col = this.columns.getNames().indexOf(colName);
        if (col >= 0) {
            return this.getColumnData(col);
        }
        System.out.println("Column not exists: " + colName + "!");
        return null;
    }

    public void addColumn(Column column) {
        if (this.data == null) {
            this.columns.add(column);
        } else {
            Array array = Array.factory((DataType)column.getDataType(), (int[])new int[]{this.length()});
            try {
                this.addColumn(column, array);
            }
            catch (InvalidRangeException ex) {
                Logger.getLogger(DataFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addColumn(Column column, Array a) throws InvalidRangeException {
        DataType dt = a.getDataType();
        if (this.array2D) {
            DataType dt1 = ((Column)this.columns.get(0)).getDataType();
            if (dt1 != dt && dt1.isNumeric() && dt.isNumeric()) {
                if (dt1 == DataType.DOUBLE) {
                    a = ArrayUtil.toDouble((Array)a);
                    dt = a.getDataType();
                } else if (dt1 == DataType.FLOAT) {
                    a = ArrayUtil.toFloat((Array)a);
                    dt = a.getDataType();
                }
            }
            if (dt1 == dt) {
                Array ra = Array.factory((DataType)dt, (int[])new int[]{this.length(), this.size() + 1});
                Range rowRange = new Range(0, this.length() - 1, 1);
                Range colRange = new Range(0, this.size() - 1, 1);
                List<Range> ranges = Arrays.asList(rowRange, colRange);
                ArrayMath.setSection((Array)ra, ranges, (Array)((Array)this.data));
                colRange = new Range(this.size(), this.size(), 1);
                ranges = Arrays.asList(rowRange, colRange);
                ArrayMath.setSection((Array)ra, ranges, (Array)a);
                this.data = ra;
            } else {
                this.dataToList();
                ((List)this.data).add(a);
            }
        } else {
            if (this.data == null) {
                this.data = new ArrayList();
            }
            ((List)this.data).add(a);
        }
        this.columns.add(column);
    }

    public void addColumn(Column column, Series s) throws InvalidRangeException {
        Array a = s.getData();
        this.addColumn(column, a);
    }

    public void addColumn(int loc, Column column, Array a) throws InvalidRangeException {
        DataType dt = a.getDataType();
        if (this.array2D) {
            DataType dt1 = ((Column)this.columns.get(0)).getDataType();
            if (dt1 != dt && dt1.isNumeric() && dt.isNumeric()) {
                if (dt1 == DataType.DOUBLE) {
                    a = ArrayUtil.toDouble((Array)a);
                    dt = a.getDataType();
                } else if (dt1 == DataType.FLOAT) {
                    a = ArrayUtil.toFloat((Array)a);
                    dt = a.getDataType();
                }
            }
            if (dt1 == dt) {
                Array ra = Array.factory((DataType)dt, (int[])new int[]{this.length(), this.size() + 1});
                Range rowRange = new Range(0, this.length() - 1, 1);
                ArrayList<Integer> colList = new ArrayList<Integer>();
                for (int i = 0; i < this.size() + 1; ++i) {
                    if (i == loc) continue;
                    colList.add(i);
                }
                List<Object> mranges = Arrays.asList(rowRange, colList);
                ra = ArrayMath.setSection_Mix((Array)ra, mranges, (Array)((Array)this.data));
                Range colRange = new Range(loc, loc, 1);
                List<Range> ranges = Arrays.asList(rowRange, colRange);
                ra = ArrayMath.setSection((Array)ra, ranges, (Array)a);
                this.data = ra;
            } else {
                this.dataToList();
                ((List)this.data).add(loc, a);
            }
        } else {
            if (this.data == null) {
                this.data = new ArrayList();
            }
            ((List)this.data).add(loc, a);
        }
        this.columns.add(loc, column);
    }

    public void addColumn(String colName, Array a) throws InvalidRangeException {
        Column column = Column.factory(colName, a);
        this.addColumn(column, a);
    }

    public void addColumn(int loc, String colName, Array a) throws InvalidRangeException {
        Column column = Column.factory(colName, a);
        this.addColumn(loc, column, a);
    }

    public void addColumn(int loc, String colName, Object o) throws InvalidRangeException {
        DataType dt = ArrayMath.getDataType((Object)o);
        Array ra = Array.factory((DataType)dt, (int[])new int[]{this.length()});
        int i = 0;
        while ((long)i < ra.getSize()) {
            ra.setObject(i, o);
            ++i;
        }
        Column column = Column.factory(colName, ra);
        this.addColumn(loc, column, ra);
    }

    public void setColumnName(int idx, String colName) {
        ((Column)this.columns.get(idx)).setName(colName);
    }

    public void setColumn(String colName, Array a) throws InvalidRangeException {
        int col = this.columns.getNames().indexOf(colName);
        if (col >= 0) {
            if (this.array2D) {
                Range rowRange = new Range(0, this.length() - 1, 1);
                Range colRange = new Range(col, col, 1);
                ArrayList<Range> ranges = new ArrayList<Range>();
                ranges.add(rowRange);
                ranges.add(colRange);
                ArrayMath.setSection((Array)((Array)this.data), ranges, (Array)a);
            } else {
                ((Column)this.columns.get(col)).setDataType(a.getDataType());
                ((List)this.data).set(col, a);
            }
        } else {
            this.addColumn(colName, a);
        }
    }

    public void setColumn(String colName, Object a) throws InvalidRangeException {
        int col = this.columns.getNames().indexOf(colName);
        DataType dt = col >= 0 ? ((Column)this.columns.get((int)col)).dataType : ArrayMath.getDataType((Object)a);
        Array ra = Array.factory((DataType)dt, (int[])new int[]{this.length()});
        int i = 0;
        while ((long)i < ra.getSize()) {
            ra.setObject(i, a);
            ++i;
        }
        this.setColumn(colName, ra);
    }

    public DataFrame append(DataFrame df) {
        Index ridx = this.index.append(df.index);
        if (this.array2D && df.array2D) {
            Array ra = Array.factory((DataType)((Array)this.data).getDataType(), (int[])new int[]{this.length() + df.length(), this.size()});
            int n = this.length() * this.size();
            int i = 0;
            while ((long)i < ra.getSize()) {
                if (i < n) {
                    ra.setObject(i, ((Array)this.data).getObject(i));
                } else {
                    ra.setObject(i, ((Array)df.data).getObject(i - n));
                }
                ++i;
            }
            DataFrame rdf = new DataFrame(ra, ridx, this.columns);
            return rdf;
        }
        ArrayList<Array> ra = new ArrayList<Array>();
        int n = this.length();
        for (int i = 0; i < this.size(); ++i) {
            Array a = Array.factory((DataType)((Column)this.columns.get(i)).getDataType(), (int[])new int[]{this.length() + df.length()});
            int j = 0;
            while ((long)j < a.getSize()) {
                if (j < n) {
                    a.setObject(j, this.getValue(j, i));
                } else {
                    a.setObject(j, df.getValue(j - n, i));
                }
                ++j;
            }
            ra.add(a);
        }
        DataFrame rdf = new DataFrame(ra, ridx, this.columns);
        return rdf;
    }

    public void dataToList() {
        if (this.array2D) {
            ArrayList<Array> r = new ArrayList<Array>();
            for (int i = 0; i < this.size(); ++i) {
                Array ra = Array.factory((DataType)((Array)this.data).getDataType(), (int[])new int[]{this.length()});
                for (int j = 0; j < this.length(); ++j) {
                    ra.setObject(j, ((Array)this.data).getObject(j * this.size() + i));
                }
                r.add(ra);
            }
            this.data = r;
            this.array2D = false;
        }
    }

    public void dataReshape(int nrow, int ncol) throws InvalidRangeException {
        if (this.array2D) {
            Array r = Array.factory((DataType)((Array)this.data).getDataType(), (int[])new int[]{nrow, ncol});
            Range rowRange = new Range(0, Math.min(nrow - 1, this.length() - 1), 1);
            Range colRange = new Range(0, Math.min(ncol - 1, this.size() - 1), 1);
            List<Range> ranges = Arrays.asList(rowRange, colRange);
            ArrayMath.setSection((Array)r, ranges, (Array)((Array)this.data));
            this.data = r;
        } else {
            ArrayList<Array> r = new ArrayList<Array>();
            for (Array a : (List)this.data) {
                Array ra = Array.factory((DataType)a.getDataType(), (int[])new int[]{nrow});
                int i = 0;
                while ((long)i < a.getSize()) {
                    ra.setObject(i, a.getObject(i));
                    ++i;
                }
                r.add(ra);
            }
            this.data = r;
        }
    }

    public void append(Object name, List row) {
        block13: {
            block12: {
                if (this.index == null) {
                    ArrayList<Object> idx = new ArrayList<Object>();
                    idx.add(name);
                    this.index = Index.factory(idx);
                } else {
                    this.index.add(name);
                }
                if (this.data != null) break block12;
                this.data = new ArrayList();
                if (row.isEmpty()) {
                    for (Column col : this.columns) {
                        ((ArrayList)this.data).add(Array.factory((DataType)col.dataType, (int[])new int[]{1}));
                    }
                } else {
                    int i = 0;
                    for (Column col : this.columns) {
                        Array a = Array.factory((DataType)col.dataType, (int[])new int[]{1});
                        a.setObject(0, row.get(i));
                        ((ArrayList)this.data).add(a);
                        ++i;
                    }
                }
                break block13;
            }
            try {
                this.dataReshape(this.length() + 1, this.size());
            }
            catch (InvalidRangeException ex) {
                Logger.getLogger(DataFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (row.isEmpty()) break block13;
            if (this.array2D) {
                for (int i = 0; i < this.size(); ++i) {
                    ((Array)this.data).setObject(this.length() * this.size() + i, row.get(i));
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    ((Array)((List)this.data).get(i)).setObject(this.length(), i < row.size() ? row.get(i) : null);
                }
            }
        }
    }

    public void append(Object name, Array row) {
        block13: {
            block12: {
                if (this.index == null) {
                    ArrayList<Object> idx = new ArrayList<Object>();
                    idx.add(name);
                    this.index = Index.factory(idx);
                } else {
                    this.index.add(name);
                }
                if (this.data != null) break block12;
                this.data = new ArrayList();
                if (row == null) {
                    for (Column col : this.columns) {
                        ((ArrayList)this.data).add(Array.factory((DataType)col.dataType, (int[])new int[]{1}));
                    }
                } else {
                    int i = 0;
                    for (Column col : this.columns) {
                        Array a = Array.factory((DataType)col.dataType, (int[])new int[]{1});
                        a.setObject(0, row.getObject(i));
                        ((ArrayList)this.data).add(a);
                        ++i;
                    }
                }
                break block13;
            }
            try {
                this.dataReshape(this.length() + 1, this.size());
            }
            catch (InvalidRangeException ex) {
                Logger.getLogger(DataFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (row == null) break block13;
            if (this.array2D) {
                for (int i = 0; i < this.size(); ++i) {
                    ((Array)this.data).setObject(this.length() * this.size() + i, row.getObject(i));
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    ((Array)((List)this.data).get(i)).setObject(this.length(), (long)i < row.getSize() ? row.getObject(i) : null);
                }
            }
        }
    }

    public void append(List row) {
        Object name = row.get(0);
        row.remove(0);
        this.append(name, row);
    }

    public void setRow(Object key, List row) {
        List<Integer> ii = this.index.indexAll(key);
        if (ii.isEmpty()) {
            this.append(key, row);
        } else {
            for (int i : ii) {
                if (this.array2D) {
                    Array a = (Array)this.data;
                    int[] shape = a.getShape();
                    Index2D idx = (Index2D)a.getIndex();
                    for (int j = 0; j < shape[1]; ++j) {
                        idx.set(j, j);
                        a.setObject((org.meteoinfo.ndarray.Index)idx, row.get(j));
                    }
                    continue;
                }
                for (int j = 0; j < this.size(); ++j) {
                    ((Array)((List)this.data).get(j)).setObject(i, row.get(i));
                }
            }
        }
    }

    public void setRow(Object key, Array row) {
        List<Integer> ii = this.index.indexAll(key);
        if (ii.isEmpty()) {
            this.append(key, row);
        } else {
            for (int i : ii) {
                if (this.array2D) {
                    Array a = (Array)this.data;
                    int[] shape = a.getShape();
                    Index2D idx = (Index2D)a.getIndex();
                    for (int j = 0; j < shape[1]; ++j) {
                        idx.set(j, j);
                        a.setObject((org.meteoinfo.ndarray.Index)idx, row.getObject(j));
                    }
                    continue;
                }
                for (int j = 0; j < this.size(); ++j) {
                    ((Array)((List)this.data).get(j)).setObject(i, row.getObject(i));
                }
            }
        }
    }

    public DataFrame drop(List<String> colNames) {
        return this.drop(this.columns.indexOfName(colNames).stream().mapToInt(Integer::valueOf).toArray());
    }

    public DataFrame drop(Column ... cols) {
        return this.drop(this.columns.indices(cols));
    }

    public DataFrame drop(int ... cols) {
        ArrayList<String> colnames = new ArrayList<String>(this.columns.getNames());
        ArrayList<String> todrop = new ArrayList<String>(cols.length);
        for (int col : cols) {
            todrop.add((String)colnames.get(col));
        }
        colnames.removeAll(todrop);
        if (this.array2D) {
            ArrayList<Object> ranges = new ArrayList<Object>();
            ranges.add(new Range(this.length()));
            ranges.add(this.columns.indexOfName(colnames));
            Array r = ArrayMath.take((Array)((Array)this.data), ranges);
            return new DataFrame(r, this.index.getValues(), colnames);
        }
        ArrayList<Array> keep = new ArrayList<Array>(colnames.size());
        for (String col : colnames) {
            keep.add((Array)((List)this.data).get(this.columns.indexOfName(col)));
        }
        return new DataFrame(keep, this.index.getValues(), colnames);
    }

    public DataFrame dropRows(List dropIndex) {
        int[] idx = this.index.indices(dropIndex);
        List dropRowList = Arrays.stream(idx).boxed().collect(Collectors.toList());
        ArrayList<Integer> rowRange = new ArrayList<Integer>();
        for (int i = 0; i < this.index.size(); ++i) {
            if (dropRowList.contains(i)) continue;
            rowRange.add(i);
        }
        return (DataFrame)this.select(rowRange);
    }

    public DataFrame drop(List dropIndex, List dropCols) {
        if (dropIndex == null) {
            return this.drop(dropCols);
        }
        if (dropCols == null) {
            return this.dropRows(dropIndex);
        }
        List dropRowList = Arrays.stream(this.index.indices(dropIndex)).boxed().collect(Collectors.toList());
        List dropColList = Arrays.stream(this.columns.indices(dropCols)).boxed().collect(Collectors.toList());
        ArrayList<Integer> rowRange = new ArrayList<Integer>();
        for (int i = 0; i < this.index.size(); ++i) {
            if (dropRowList.contains(i)) continue;
            rowRange.add(i);
        }
        ArrayList<Integer> colRange = new ArrayList<Integer>();
        for (int i = 0; i < this.columns.size(); ++i) {
            if (dropColList.contains(i)) continue;
            colRange.add(i);
        }
        return this.extract(rowRange, colRange);
    }

    public DataFrame dropNAAny(boolean row) throws InvalidRangeException {
        int size = this.size();
        int length = this.length();
        if (row) {
            ArrayList<Integer> rowRange = new ArrayList<Integer>();
            for (int i = 0; i < length; ++i) {
                boolean noNA = true;
                for (int j = 0; j < size; ++j) {
                    if (!MIMath.isNullOrNaN((Object)this.getValue(i, j))) continue;
                    noNA = false;
                    break;
                }
                if (!noNA) continue;
                rowRange.add(i);
            }
            return (DataFrame)this.select(rowRange);
        }
        ArrayList<Integer> colRange = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            Array a = this.getColumnData(i);
            if (!ArrayMath.containsNaN((Array)a)) continue;
            colRange.add(i);
        }
        return this.drop(colRange.stream().mapToInt(Integer::valueOf).toArray());
    }

    public DataFrame dropNAAll(boolean row) throws InvalidRangeException {
        int size = this.size();
        int length = this.length();
        if (row) {
            ArrayList<Integer> rowRange = new ArrayList<Integer>();
            for (int i = 0; i < length; ++i) {
                boolean allNA = true;
                for (int j = 0; j < size; ++j) {
                    if (MIMath.isNullOrNaN((Object)this.getValue(i, j))) continue;
                    allNA = false;
                    break;
                }
                if (allNA) continue;
                rowRange.add(i);
            }
            return (DataFrame)this.select(rowRange);
        }
        ArrayList<Integer> colRange = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            Array a = this.getColumnData(i);
            if (!ArrayMath.allNaN((Array)a)) continue;
            colRange.add(i);
        }
        return this.drop(colRange.stream().mapToInt(Integer::valueOf).toArray());
    }

    public DataFrame retain(Object ... cols) {
        return this.retain(new Object[]{this.columns.indices(cols)});
    }

    public DataFrame retain(Integer ... cols) {
        HashSet<Integer> keep = new HashSet<Integer>(Arrays.asList(cols));
        int[] todrop = new int[this.size() - keep.size()];
        int i = 0;
        for (int c = 0; c < this.size(); ++c) {
            if (keep.contains(c)) continue;
            todrop[i++] = c;
        }
        return this.drop(todrop);
    }

    public DataFrame numeric() {
        return null;
    }

    public Object select(int row, Range colRange) throws InvalidRangeException {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)((Column)this.columns.get(i)).clone());
        }
        if (this.array2D) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(new Range(row, row, 1));
            ranges.add(new Range(colRange.first(), colRange.last(), colRange.stride()));
            r = ArrayMath.section((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = 1;
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                rr.setObject(0, mr.getObject(row));
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(row, row + 1, 1);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df.rowSeries(0);
    }

    public void setValues(int row, Range colRange, Number value) throws InvalidRangeException {
        ColumnIndex cols = new ColumnIndex();
        for (int i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)((Column)this.columns.get(i)).clone());
        }
        if (this.array2D) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(new Range(row, row, 1));
            ranges.add(new Range(colRange.first(), colRange.last(), colRange.stride()));
            ArrayMath.setSection((Array)((Array)this.data), ranges, (Number)value);
        } else {
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                ((Array)((List)this.data).get(j)).setObject(row, (Object)value);
            }
        }
    }

    public void setValues(int row, Range colRange, Array value) throws InvalidRangeException {
        int i;
        ColumnIndex cols = new ColumnIndex();
        for (i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)((Column)this.columns.get(i)).clone());
        }
        if (this.array2D) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(new Range(row, row, 1));
            ranges.add(new Range(colRange.first(), colRange.last(), colRange.stride()));
            ArrayMath.setSection((Array)((Array)this.data), ranges, (Array)value);
        } else {
            i = 0;
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                ((Array)((List)this.data).get(j)).setObject(row, value.getObject(i));
                ++i;
            }
        }
    }

    public Object select(Range rowRange, Range colRange) throws InvalidRangeException {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)((Column)this.columns.get(i)).clone());
        }
        if (this.array2D) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(new Range(rowRange.first(), rowRange.last(), rowRange.stride()));
            ranges.add(new Range(colRange.first(), colRange.last(), colRange.stride()));
            r = ArrayMath.section((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = rowRange.length();
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i = rowRange.first(); i <= rowRange.last(); i += rowRange.stride()) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange.first(), rowRange.last() + 1, rowRange.stride());
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(Range rowRange, List<Integer> colRange) throws InvalidRangeException {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i : colRange) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            ArrayList<Object> ranges = new ArrayList<Object>();
            ranges.add(new Range(rowRange.first(), rowRange.last(), rowRange.stride()));
            ranges.add(colRange);
            r = ArrayMath.take((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = rowRange.length();
            for (int j : colRange) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i = rowRange.first(); i <= rowRange.last(); i += rowRange.stride()) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange.first(), rowRange.last() + 1, rowRange.stride());
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(List<Integer> rowRange) {
        Object r;
        ColumnIndex cols = new ColumnIndex();
        for (int i = 0; i < this.size(); ++i) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            ArrayList<List<Integer>> ranges = new ArrayList<List<Integer>>();
            ranges.add(rowRange);
            ranges.add((List<Integer>)new Range(cols.size()));
            r = ArrayMath.take((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j = 0; j < cols.size(); ++j) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series((Array)r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame((Array)r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(List<Integer> rowRange, Range colRange) {
        Object r;
        ColumnIndex cols = new ColumnIndex();
        for (int i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            ArrayList<List<Integer>> ranges = new ArrayList<List<Integer>>();
            ranges.add(rowRange);
            ranges.add((List<Integer>)new Range(colRange));
            r = ArrayMath.take((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series((Array)r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame((Array)r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(Array rowRangeArray, Range colRange) throws InvalidRangeException {
        Array r;
        int i;
        rowRangeArray = rowRangeArray.copyIfView();
        ColumnIndex cols = new ColumnIndex();
        for (int i2 = colRange.first(); i2 <= colRange.last(); i2 += colRange.stride()) {
            cols.add((Column)this.columns.get(i2));
        }
        ArrayList<Integer> rowRange = new ArrayList<Integer>();
        if (rowRangeArray.getDataType() == DataType.BOOLEAN) {
            i = 0;
            while ((long)i < rowRangeArray.getSize()) {
                if (rowRangeArray.getBoolean(i)) {
                    rowRange.add(i);
                }
                ++i;
            }
        } else {
            i = 0;
            while ((long)i < rowRangeArray.getSize()) {
                rowRange.add(rowRangeArray.getInt(i));
                ++i;
            }
        }
        if (this.array2D) {
            ArrayList<ArrayList<Integer>> ranges = new ArrayList<ArrayList<Integer>>();
            ranges.add(rowRange);
            ranges.add((ArrayList<Integer>)new Range(colRange.first(), colRange.last(), colRange.stride()));
            r = ArrayMath.take((Array)((Array)this.data), ranges);
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                Iterator iterator = rowRange.iterator();
                while (iterator.hasNext()) {
                    int i3 = (Integer)iterator.next();
                    rr.setObject(idx, mr.getObject(i3));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(List rowKeys, List<Integer> rowRange, Range colRange) throws InvalidRangeException {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i = colRange.first(); i <= colRange.last(); i += colRange.stride()) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            int n = ((Array)this.data).getShape()[1];
            int rn = rowRange.size();
            int cn = colRange.length();
            DataType dtype = ((Array)this.data).getDataType();
            r = Array.factory((DataType)dtype, (int[])new int[]{rn, cn});
            String format = ((Column)this.columns.get(0)).getFormat();
            int jj = 0;
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                int ii = 0;
                for (int i : rowRange) {
                    int idx = ii * cn + jj;
                    if (i < 0) {
                        r.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        r.setObject(idx, ((Array)this.data).getObject(i * n + j));
                    }
                    ++ii;
                }
                ++jj;
            }
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j = colRange.first(); j <= colRange.last(); j += colRange.stride()) {
                DataType dtype = ((Column)this.columns.get(j)).getDataType();
                String format = ((Column)this.columns.get(j)).getFormat();
                Array rr = Array.factory((DataType)dtype, (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    if (i < 0) {
                        rr.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        rr.setObject(idx, mr.getObject(i));
                    }
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = Index.factory(rowKeys);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(List rowKeys, List<Integer> rowRange, List<Integer> colRange) throws InvalidRangeException {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i : colRange) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            int n = ((Array)this.data).getShape()[1];
            int rn = rowRange.size();
            int cn = colRange.size();
            DataType dtype = ((Array)this.data).getDataType();
            r = Array.factory((DataType)dtype, (int[])new int[]{rn, cn});
            String format = ((Column)this.columns.get(0)).getFormat();
            int jj = 0;
            for (int j : colRange) {
                int ii = 0;
                for (int i : rowRange) {
                    int idx = ii * cn + jj;
                    if (i < 0) {
                        r.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        r.setObject(idx, ((Array)this.data).getObject(i * n + j));
                    }
                    ++ii;
                }
                ++jj;
            }
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j : colRange) {
                DataType dtype = ((Column)this.columns.get(j)).getDataType();
                String format = ((Column)this.columns.get(j)).getFormat();
                Array rr = Array.factory((DataType)dtype, (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    if (i < 0) {
                        rr.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        rr.setObject(idx, mr.getObject(i));
                    }
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = Index.factory(rowKeys);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public Object select(int row, List<Integer> colRange) {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i : colRange) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            int n = ((Array)this.data).getShape()[1];
            int rn = 1;
            int cn = colRange.size();
            DataType dtype = ((Array)this.data).getDataType();
            r = Array.factory((DataType)dtype, (int[])new int[]{rn, cn});
            for (int j : colRange) {
                r.setObject(0, ((Array)this.data).getObject(row * n + j));
            }
        } else {
            r = new ArrayList();
            int rn = 1;
            for (int j : colRange) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                rr.setObject(0, mr.getObject(row));
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(row, row + 1, 1);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df.rowSeries(0);
    }

    public Object select(List<Integer> rowRange, List<Integer> colRange) {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i : colRange) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            int n = ((Array)this.data).getShape()[1];
            int rn = rowRange.size();
            int cn = colRange.size();
            DataType dtype = ((Array)this.data).getDataType();
            r = Array.factory((DataType)dtype, (int[])new int[]{rn, cn});
            String format = ((Column)this.columns.get(0)).getFormat();
            int jj = 0;
            for (int j : colRange) {
                int ii = 0;
                for (int i : rowRange) {
                    int idx = ii * cn + jj;
                    if (i < 0) {
                        r.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        r.setObject(idx, ((Array)this.data).getObject(i * n + j));
                    }
                    ++ii;
                }
                ++jj;
            }
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j : colRange) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange);
        if (cols.size() == 1 && this.columns.size() > 1) {
            Series s = new Series(r, rIndex, ((Column)cols.get(0)).getName());
            return s;
        }
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)r), rIndex, cols);
        return df;
    }

    public DataFrame extract(List<Integer> rowRange, List<Integer> colRange) {
        Array r;
        ColumnIndex cols = new ColumnIndex();
        for (int i : colRange) {
            cols.add((Column)this.columns.get(i));
        }
        if (this.array2D) {
            int n = ((Array)this.data).getShape()[1];
            int rn = rowRange.size();
            int cn = colRange.size();
            DataType dtype = ((Array)this.data).getDataType();
            r = Array.factory((DataType)dtype, (int[])new int[]{rn, cn});
            String format = ((Column)this.columns.get(0)).getFormat();
            int jj = 0;
            for (int j : colRange) {
                int ii = 0;
                for (int i : rowRange) {
                    int idx = ii * cn + jj;
                    if (i < 0) {
                        r.setObject(idx, DataTypeUtil.convertTo(null, (DataType)dtype, (String)format));
                    } else {
                        r.setObject(idx, ((Array)this.data).getObject(i * n + j));
                    }
                    ++ii;
                }
                ++jj;
            }
        } else {
            r = new ArrayList();
            int rn = rowRange.size();
            for (int j : colRange) {
                Array rr = Array.factory((DataType)((Column)this.columns.get(j)).getDataType(), (int[])new int[]{rn});
                Array mr = (Array)((List)this.data).get(j);
                int idx = 0;
                for (int i : rowRange) {
                    rr.setObject(idx, mr.getObject(i));
                    ++idx;
                }
                ((ArrayList)r).add(rr);
            }
            if (cols.size() == 1) {
                r = r.get(0);
            }
        }
        if (r == null) {
            return null;
        }
        Index rIndex = this.index.subIndex(rowRange);
        DataFrame df = r instanceof Array ? new DataFrame(r, rIndex, cols) : new DataFrame((List<Array>)r, rIndex, cols);
        return df;
    }

    public DataFrame transpose() {
        DataFrame df = null;
        if (this.array2D) {
            Array ta = ArrayMath.transpose((Array)((Array)this.data), (int)0, (int)1);
            ArrayList<String> tIndex = new ArrayList<String>();
            for (Column col : this.columns) {
                tIndex.add(col.getName());
            }
            ArrayList<String> tColumns = new ArrayList<String>();
            for (int i = 0; i < this.index.size(); ++i) {
                tColumns.add(this.index.toString(i));
            }
            df = new DataFrame(ta, tIndex, tColumns);
        }
        return df;
    }

    private String toString(int start, int end) {
        this.updateColumnFormats();
        StringBuilder sb = new StringBuilder();
        String format = this.index.getNameFormat();
        sb.append(String.format(format, " "));
        for (Column col : this.columns.getValues()) {
            sb.append(" ");
            sb.append(String.format(col.getNameFormat(), col.getName()));
        }
        sb.append("\n");
        for (int r = start; r < end; ++r) {
            sb.append(this.index.toString(r));
            for (int i = 0; i < this.size(); ++i) {
                sb.append(" ");
                sb.append(((Column)this.columns.get(i)).toString(this.getValue(r, i)));
            }
            sb.append("\n");
        }
        if (end < this.index.size()) {
            sb.append("...");
        }
        return sb.toString();
    }

    public String head(int n) {
        int rn = this.index.size();
        if (n > rn) {
            n = rn;
        }
        return this.toString(0, n);
    }

    public String tail(int n) {
        int rn = this.index.size();
        if (n > rn) {
            n = rn;
        }
        return this.toString(rn - n, rn);
    }

    public DataFrame replace(Object toReplace, Object value) {
        if (this.array2D) {
            Array a = ((Array)this.data).copy();
            ArrayMath.replaceValue((Array)a, (Object)toReplace, (Object)value);
            return new DataFrame(a, (Index)this.index.clone(), (ColumnIndex)this.columns.clone());
        }
        List arrays = (List)this.data;
        ArrayList<Array> r = new ArrayList<Array>();
        for (Array arr : arrays) {
            Array a = arr.copy();
            ArrayMath.replaceValue((Array)a, (Object)toReplace, (Object)value);
            r.add(a);
        }
        return new DataFrame(r, (Index)this.index.clone(), (ColumnIndex)this.columns.clone());
    }

    public String toString() {
        return this.head(100);
    }

    public static DataFrame readTable(String fileName, String delimiter, int skipRows, String formatSpec, String encoding, int indexCol, String indexFormat, List<String> names, Integer header, int skipFooter) throws FileNotFoundException, IOException, Exception {
        DataFrame df;
        Array data;
        Index index;
        int i;
        Column col;
        String[] colFormats;
        if (encoding == null) {
            encoding = UniversalDetector.detectCharset((File)new File(fileName));
        }
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (skipRows > 0) {
            for (int i2 = 0; i2 < skipRows; ++i2) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        switch (encoding) {
            case "UTF8": 
            case "UTF-8": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                if (!title.startsWith("\ufeff")) break;
                title = title.substring(1);
            }
        }
        String[] titleArray1 = GlobalUtil.split((String)title, (String)delimiter);
        ArrayList<String> titleArray = new ArrayList<String>(Arrays.asList(titleArray1));
        if (indexCol >= 0) {
            titleArray.remove(indexCol);
        }
        if (titleArray.isEmpty()) {
            System.out.println("File Format Error!");
            sr.close();
            return null;
        }
        int colNum = titleArray.size();
        if (header == null) {
            for (int i3 = 0; i3 < colNum; ++i3) {
                titleArray.set(i3, "Col_" + String.valueOf(i3));
            }
        }
        ColumnIndex cols = new ColumnIndex();
        ArrayList values = new ArrayList();
        if (formatSpec == null) {
            colFormats = new String[colNum];
            for (int i4 = 0; i4 < colNum; ++i4) {
                colFormats[i4] = "C";
            }
        } else {
            colFormats = formatSpec.split("%");
        }
        int idx = 0;
        boolean isBreak = false;
        for (String colFormat : colFormats) {
            if (colFormat.isEmpty()) continue;
            int num = 1;
            if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                int index2 = colFormat.indexOf("{");
                if (index2 < 0) {
                    index2 = colFormat.length() - 1;
                }
                num = Integer.parseInt(colFormat.substring(0, index2));
                colFormat = colFormat.substring(index2);
            }
            for (int i5 = 0; i5 < num; ++i5) {
                String colName = ((String)titleArray.get(idx)).trim();
                if (colFormat.equals("C") || colFormat.equals("s")) {
                    col = new Column(colName, DataType.STRING);
                } else if (colFormat.equals("i")) {
                    col = new Column(colName, DataType.INT);
                } else if (colFormat.equals("f")) {
                    col = new Column(colName, DataType.FLOAT);
                } else if (colFormat.equals("d")) {
                    col = new Column(colName, DataType.DOUBLE);
                } else if (colFormat.equals("B")) {
                    col = new Column(colName, DataType.BOOLEAN);
                } else if (colFormat.substring(0, 1).equals("{")) {
                    int eidx = colFormat.indexOf("}");
                    String formatStr = colFormat.substring(1, eidx);
                    col = new Column(colName, DataType.DATE);
                    col.setFormat(formatStr);
                } else {
                    col = new Column(colName, DataType.STRING);
                }
                cols.add(col);
                values.add(new ArrayList());
                if (++idx != colNum) continue;
                isBreak = true;
                break;
            }
            if (isBreak) break;
        }
        if (idx < colNum) {
            for (int i6 = idx; i6 < colNum; ++i6) {
                cols.add(new Column((String)titleArray.get(i6), DataType.STRING));
                values.add(new ArrayList());
            }
        }
        List<String> indexValues = new ArrayList();
        String line = header == null ? title : sr.readLine();
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                line = sr.readLine();
                continue;
            }
            String[] dataArray = GlobalUtil.split((String)line, (String)delimiter);
            int cn = 0;
            for (i = 0; i < dataArray.length && cn < colNum; ++i) {
                if (i == indexCol) {
                    indexValues.add(dataArray[i]);
                    continue;
                }
                ((List)values.get(cn)).add(dataArray[i]);
                ++cn;
            }
            if (cn < colNum) {
                for (i = cn; i < colNum; ++i) {
                    ((List)values.get(i)).add("");
                }
            }
            line = sr.readLine();
        }
        sr.close();
        int rn = ((List)values.get(0)).size();
        if (skipFooter > 0) {
            if (indexCol >= 0) {
                indexValues = indexValues.subList(0, rn - skipFooter);
            }
            for (i = 0; i < colNum; ++i) {
                values.set(i, ((List)values.get(i)).subList(0, rn - skipFooter));
            }
        }
        rn = ((List)values.get(0)).size();
        if (indexCol >= 0) {
            DataType idxDT;
            DateTimeFormatter dtFormatter = DateTimeFormatter.ISO_DATE_TIME;
            if (indexFormat != null) {
                if (indexFormat.substring(0, 1).equals("%")) {
                    indexFormat = indexFormat.substring(1);
                }
                if ((idxDT = DataTypeUtil.getDataType((String)indexFormat)) == DataType.DATE) {
                    indexFormat = DataTypeUtil.getDateFormat((String)indexFormat);
                    dtFormatter = DateTimeFormatter.ofPattern(indexFormat);
                }
            } else {
                idxDT = DataTypeUtil.detectDataType(indexValues, (int)10, null);
                if (idxDT == DataType.DATE) {
                    dtFormatter = TypeUtils.getDateTimeFormatter((String)((String)indexValues.get(0)));
                }
            }
            ArrayList<Object> indexData = new ArrayList<Object>();
            if (idxDT == DataType.DATE) {
                for (String s : indexValues) {
                    indexData.add(JDateUtil.parseDateTime((String)s, (DateTimeFormatter)dtFormatter));
                }
                index = new DateTimeIndex(indexData);
                if (indexFormat != null) {
                    index.setFormat(indexFormat);
                } else {
                    index.updateFormat();
                }
            } else {
                for (String s : indexValues) {
                    indexData.add(DataTypeUtil.convertStringTo((String)s, (DataType)idxDT, null));
                }
                index = Index.factory(indexData);
                index.updateFormat();
            }
        } else {
            index = new IntIndex(rn);
            index.updateFormat();
        }
        if (cols.isSameDataType()) {
            data = Array.factory((DataType)((Column)cols.get((int)0)).dataType, (int[])new int[]{rn, colNum});
            col = (Column)cols.get(0);
            for (int i7 = 0; i7 < colNum; ++i7) {
                List vv = (List)values.get(i7);
                for (int j = 0; j < vv.size(); ++j) {
                    String v = (String)vv.get(j);
                    data.setObject(j * colNum + i7, col.convertStringTo(v));
                }
            }
            df = new DataFrame(data, index, cols);
        } else {
            data = new ArrayList();
            for (int i8 = 0; i8 < colNum; ++i8) {
                List vv = (List)values.get(i8);
                col = (Column)cols.get(i8);
                DataType dt = col.getDataType();
                Array a = Array.factory((DataType)dt, (int[])new int[]{rn});
                for (int j = 0; j < vv.size(); ++j) {
                    String v = (String)vv.get(j);
                    a.setObject(j, col.convertStringTo(v));
                }
                data.add(a);
            }
            df = new DataFrame((List<Array>)data, index, cols);
        }
        if (names != null) {
            df.setColumns(names);
        }
        return df;
    }

    public static DataFrame readTable(String fileName, String delimiter, int skipRows, String formatSpec, String encoding, int indexCol, String indexFormat, List<String> names, Integer header, int skipFooter, List<Object> usecolsin) throws FileNotFoundException, IOException, Exception {
        DataFrame df;
        Array data;
        Index index;
        int i;
        Column col;
        String[] colFormats;
        if (encoding == null) {
            encoding = UniversalDetector.detectCharset((File)new File(fileName));
        }
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (skipRows > 0) {
            for (int i2 = 0; i2 < skipRows; ++i2) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        switch (encoding) {
            case "UTF8": 
            case "UTF-8": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                if (!title.startsWith("\ufeff")) break;
                title = title.substring(1);
            }
        }
        String[] titleArray1 = GlobalUtil.split((String)title, (String)delimiter);
        ArrayList<Integer> usecols = new ArrayList<Integer>();
        if (usecolsin.get(0) instanceof Integer) {
            for (Object o : usecolsin) {
                usecols.add((Integer)o);
            }
        } else {
            ArrayList<String> titleArray2 = new ArrayList<String>(Arrays.asList(titleArray1));
            for (Object o : usecolsin) {
                int idx = titleArray2.indexOf((String)o);
                if (idx < 0) continue;
                usecols.add(idx);
            }
        }
        ArrayList<String> titleArray = new ArrayList<String>();
        for (int i3 = 0; i3 < titleArray1.length; ++i3) {
            if (i3 == indexCol || !usecols.contains(i3)) continue;
            titleArray.add(titleArray1[i3]);
        }
        if (titleArray.isEmpty()) {
            System.out.println("File Format Error!");
            sr.close();
            return null;
        }
        int colNum = titleArray.size();
        if (header == null) {
            for (int i4 = 0; i4 < colNum; ++i4) {
                titleArray.set(i4, "Col_" + String.valueOf(i4));
            }
        }
        ColumnIndex cols = new ColumnIndex();
        ArrayList values = new ArrayList();
        if (formatSpec == null) {
            colFormats = new String[colNum];
            for (int i5 = 0; i5 < colNum; ++i5) {
                colFormats[i5] = "C";
            }
        } else {
            colFormats = formatSpec.split("%");
        }
        int idx = 0;
        boolean isBreak = false;
        for (String colFormat : colFormats) {
            if (colFormat.isEmpty()) continue;
            int num = 1;
            if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                int index2 = colFormat.indexOf("{");
                if (index2 < 0) {
                    index2 = colFormat.length() - 1;
                }
                num = Integer.parseInt(colFormat.substring(0, index2));
                colFormat = colFormat.substring(index2);
            }
            for (int i6 = 0; i6 < num; ++i6) {
                String colName = ((String)titleArray.get(idx)).trim();
                if (colFormat.equals("C") || colFormat.equals("s")) {
                    col = new Column(colName, DataType.STRING);
                } else if (colFormat.equals("i")) {
                    col = new Column(colName, DataType.INT);
                } else if (colFormat.equals("f")) {
                    col = new Column(colName, DataType.FLOAT);
                } else if (colFormat.equals("d")) {
                    col = new Column(colName, DataType.DOUBLE);
                } else if (colFormat.equals("B")) {
                    col = new Column(colName, DataType.BOOLEAN);
                } else if (colFormat.substring(0, 1).equals("{")) {
                    int eidx = colFormat.indexOf("}");
                    String formatStr = colFormat.substring(1, eidx);
                    col = new Column(colName, DataType.DATE);
                    col.setFormat(formatStr);
                } else {
                    col = new Column(colName, DataType.STRING);
                }
                cols.add(col);
                values.add(new ArrayList());
                if (++idx != colNum) continue;
                isBreak = true;
                break;
            }
            if (isBreak) break;
        }
        if (idx < colNum) {
            for (int i7 = idx; i7 < colNum; ++i7) {
                cols.add(new Column((String)titleArray.get(i7), DataType.STRING));
                values.add(new ArrayList());
            }
        }
        List<String> indexValues = new ArrayList();
        String line = header == null ? title : sr.readLine();
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                line = sr.readLine();
                continue;
            }
            String[] dataArray = GlobalUtil.split((String)line, (String)delimiter);
            int cn = 0;
            for (i = 0; i < dataArray.length && cn < colNum; ++i) {
                if (i == indexCol) {
                    indexValues.add(dataArray[i]);
                    continue;
                }
                if (!usecols.contains(i)) continue;
                ((List)values.get(cn)).add(dataArray[i]);
                ++cn;
            }
            if (cn < colNum) {
                for (i = cn; i < colNum; ++i) {
                    ((List)values.get(i)).add("");
                }
            }
            line = sr.readLine();
        }
        sr.close();
        int rn = ((List)values.get(0)).size();
        if (skipFooter > 0) {
            if (indexCol >= 0) {
                indexValues = indexValues.subList(0, rn - skipFooter);
            }
            for (i = 0; i < colNum; ++i) {
                values.set(i, ((List)values.get(i)).subList(0, rn - skipFooter));
            }
        }
        rn = ((List)values.get(0)).size();
        if (indexCol >= 0) {
            DataType idxDT;
            DateTimeFormatter dtFormatter = DateTimeFormatter.ISO_DATE_TIME;
            if (indexFormat != null) {
                if (indexFormat.substring(0, 1).equals("%")) {
                    indexFormat = indexFormat.substring(1);
                }
                if ((idxDT = DataTypeUtil.getDataType((String)indexFormat)) == DataType.DATE) {
                    indexFormat = DataTypeUtil.getDateFormat((String)indexFormat);
                    dtFormatter = DateTimeFormatter.ofPattern(indexFormat);
                }
            } else {
                idxDT = DataTypeUtil.detectDataType(indexValues, (int)10, null);
                if (idxDT == DataType.DATE) {
                    dtFormatter = TypeUtils.getDateTimeFormatter((String)((String)indexValues.get(0)));
                }
            }
            ArrayList<Object> indexData = new ArrayList<Object>();
            if (idxDT == DataType.DATE) {
                for (String s : indexValues) {
                    indexData.add(JDateUtil.parseDateTime((String)s, (DateTimeFormatter)dtFormatter));
                }
                index = new DateTimeIndex(indexData);
                if (indexFormat != null) {
                    index.format = indexFormat;
                } else {
                    index.updateFormat();
                }
            } else {
                for (String s : indexValues) {
                    indexData.add(DataTypeUtil.convertStringTo((String)s, (DataType)idxDT, null));
                }
                index = Index.factory(indexData);
                index.updateFormat();
            }
        } else {
            index = new IntIndex(rn);
            index.updateFormat();
        }
        if (cols.isSameDataType()) {
            data = Array.factory((DataType)((Column)cols.get((int)0)).dataType, (int[])new int[]{rn, colNum});
            col = (Column)cols.get(0);
            for (int i8 = 0; i8 < colNum; ++i8) {
                List vv = (List)values.get(i8);
                for (int j = 0; j < vv.size(); ++j) {
                    String v = (String)vv.get(j);
                    data.setObject(j * colNum + i8, col.convertStringTo(v));
                }
            }
            df = new DataFrame(data, index, cols);
        } else {
            data = new ArrayList();
            for (int i9 = 0; i9 < colNum; ++i9) {
                List vv = (List)values.get(i9);
                col = (Column)cols.get(i9);
                DataType dt = col.getDataType();
                Array a = Array.factory((DataType)dt, (int[])new int[]{rn});
                for (int j = 0; j < vv.size(); ++j) {
                    String v = (String)vv.get(j);
                    a.setObject(j, col.convertStringTo(v));
                }
                data.add(a);
            }
            df = new DataFrame((List<Array>)data, index, cols);
        }
        if (names != null) {
            df.setColumns(names);
        }
        return df;
    }

    public void saveCSV(String fileName, String delimiter, String formatSpec, String dateFormat, String floatFormat, boolean index) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(fileName));
        String str = "";
        String idxFormat = this.index.format;
        if (index) {
            str = this.index.getName();
            if (dateFormat != null && this.index instanceof DateTimeIndex) {
                idxFormat = dateFormat;
            }
        }
        for (int i = 0; i < this.size(); ++i) {
            str = str.isEmpty() ? ((Column)this.columns.get(i)).getName() : str + delimiter + ((Column)this.columns.get(i)).getName();
        }
        sw.write(str);
        ArrayList<String> formats = new ArrayList<String>();
        if (formatSpec == null) {
            for (Column col : this.columns) {
                if (col.getDataType() == DataType.FLOAT || col.getDataType() == DataType.DOUBLE) {
                    formats.add(floatFormat == null ? col.getFormat() : floatFormat);
                    continue;
                }
                formats.add(col.getFormat());
            }
        } else {
            String[] formatStrs = formatSpec.split("%");
            int i = 1;
            for (Column col : this.columns) {
                if (i < formatStrs.length) {
                    if (formatStrs[i].equals("i")) {
                        formatStrs[i] = "d";
                    }
                    formats.add("%" + formatStrs[i]);
                } else {
                    formats.add(col.getFormat());
                }
                ++i;
            }
        }
        for (int j = 0; j < this.length(); ++j) {
            String line = "";
            if (index) {
                line = this.index.toString(j, idxFormat).trim();
            }
            for (int i = 0; i < this.size(); ++i) {
                String vstr = formats.get(i) == null ? this.getValue(j, i).toString() : String.format((String)formats.get(i), this.getValue(j, i));
                line = line.isEmpty() ? vstr : line + delimiter + vstr;
            }
            sw.newLine();
            sw.write(line);
        }
        sw.flush();
        sw.close();
    }

    public <V> DataFrame describe() {
        return Aggregation.describe(new Grouping().apply(this, new Aggregation.Describe()));
    }

    public DataFrame sortBy(List<String> cols, List<Boolean> ascendings) {
        LinkedHashMap<Integer, SortDirection> sortCols = new LinkedHashMap<Integer, SortDirection>();
        for (int i = 0; i < cols.size(); ++i) {
            String col = cols.get(i);
            boolean ascending = ascendings.get(i);
            SortDirection dir = ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            int c = this.columns.indexOfName(col);
            sortCols.put(c, dir);
        }
        return Sorting.sort(this, sortCols);
    }

    public DataFrame sortByIndex(boolean ascending) {
        SortDirection dir = ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING;
        return Sorting.sortIndex(this, dir);
    }

    public DataFrame sortBy(boolean ascending, Integer ... cols) {
        LinkedHashMap<Integer, SortDirection> sortCols = new LinkedHashMap<Integer, SortDirection>();
        Integer[] integerArray = cols;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int c = integerArray[i];
            SortDirection dir = ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            sortCols.put(Math.abs(c), dir);
        }
        return Sorting.sort(this, sortCols);
    }

    public <V> DataFrame sortBy(Comparator<List<V>> comparator) {
        return Sorting.sort(this, comparator);
    }

    public DataFrameGroupBy groupBy(KeyFunction function) {
        return new DataFrameGroupBy(new Grouping(this, function, new Integer[0]), this);
    }

    public DataFrameGroupBy groupBy(Integer ... columns) {
        return new DataFrameGroupBy(new Grouping(this, columns), this);
    }

    public DataFrameGroupBy groupBy(Object ... columns) {
        Integer[] iCols = (Integer[])Arrays.stream(this.columns.indices(columns)).boxed().toArray(Integer[]::new);
        return this.groupBy(iCols);
    }

    public DataFrameGroupBy groupBy(List<Object> columns) {
        Integer[] iCols = (Integer[])Arrays.stream(this.columns.indices(columns)).boxed().toArray(Integer[]::new);
        return this.groupBy(iCols);
    }

    public DataFrameGroupBy groupByIndex(WindowFunction function) {
        ((DateTimeIndex)this.index).setResamplPeriod(function.getPeriod());
        return new DataFrameGroupBy(new Grouping(this, function), this);
    }

    public DataFrameGroupBy groupByIndex(String pStr) {
        TemporalAmount period = JDateUtil.getPeriod((String)pStr);
        WindowFunction function = new WindowFunction(period);
        return this.groupByIndex(function);
    }

    public <V> DataFrame apply(Function<?, ?> function) {
        DataFrame r = new Grouping().apply(this, function);
        if (r.index instanceof DateTimeIndex) {
            ((DateTimeIndex)r.getIndex()).setPeriod(((DateTimeIndex)this.index).getResamplePeriod());
        }
        return r;
    }

    public DataFrame count() {
        DataFrame r = this.apply(new Aggregation.Count());
        return r;
    }

    public DataFrame sum() {
        DataFrame r = this.apply(new Aggregation.Sum());
        return r;
    }

    public DataFrame mean() {
        DataFrame r = this.apply(new Aggregation.Mean());
        return r;
    }

    public DataFrame min() {
        DataFrame r = this.apply(new Aggregation.Min());
        return r;
    }

    public DataFrame max() {
        DataFrame r = this.apply(new Aggregation.Max());
        return r;
    }

    public DataFrame median() {
        DataFrame r = this.apply(new Aggregation.Median());
        return r;
    }

    public DataFrame stdDev() {
        DataFrame r = this.apply(new Aggregation.StdDev());
        return r;
    }

    public Object clone() {
        Array rdata;
        if (this.array2D) {
            rdata = ((Array)this.data).copy();
        } else {
            rdata = new ArrayList();
            for (Array a : (List)this.data) {
                ((ArrayList)rdata).add(a.copy());
            }
        }
        Index rIndex = (Index)this.index.clone();
        ColumnIndex cols = (ColumnIndex)this.columns.clone();
        DataFrame df = rdata instanceof Array ? new DataFrame(rdata, rIndex, cols) : new DataFrame((List<Array>)((ArrayList)rdata), rIndex, cols);
        return df;
    }
}

