/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.dataframe.DateTimeIndex;
import org.meteoinfo.dataframe.IntIndex;
import org.meteoinfo.dataframe.StringIndex;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayMath;

public class Index<V>
implements Iterable<V> {
    protected List<V> data = new ArrayList<V>();
    protected String format = "%4s";
    protected String name = "Index";
    protected DataType dataType = DataType.STRING;

    public List<V> getValues() {
        return this.data;
    }

    public List<V> getData() {
        return this.data;
    }

    public void setData(List<V> value) {
        this.data = value;
        this.updateFormat();
    }

    @Override
    public Iterator iterator() {
        return this.data.iterator();
    }

    public int size() {
        return this.data.size();
    }

    public String getFormat() {
        return this.format;
    }

    public String getNameFormat() {
        return this.format.substring(0, this.format.length() - 1) + "s";
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public static Index factory(List data) {
        if (data.get(0) instanceof LocalDateTime) {
            return new DateTimeIndex(data);
        }
        if (data.get(0) instanceof Integer) {
            return new IntIndex(data);
        }
        if (data.get(0) instanceof String) {
            return new StringIndex(data);
        }
        return null;
    }

    public static Index factory(List data, String name) {
        Index index = Index.factory(data);
        index.name = name;
        return index;
    }

    public static Index factory(Array data) {
        List ndata = ArrayMath.asList((Array)data);
        return Index.factory(ndata);
    }

    public static Index factory(Array data, String name) {
        Index index = Index.factory(data);
        index.name = name;
        return index;
    }

    public static Index factory(int n) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            data.add(i + 1);
        }
        return Index.factory(data);
    }

    public void updateFormat() {
        if (this.data.get(0) instanceof Integer) {
            int max = MIMath.getMinMaxInt(this.data)[1];
            int len = String.valueOf(max).length();
            this.format = "%" + String.valueOf(len) + "s";
            this.dataType = DataType.INT;
        } else if (this.data.get(0) instanceof String) {
            int len = 0;
            for (String s : this.data) {
                if (len >= s.length()) continue;
                len = s.length();
            }
            this.format = "%" + String.valueOf(len) + "s";
            this.dataType = DataType.STRING;
        }
    }

    public void add(V v) {
        this.data.add(v);
    }

    public void add(int i, V v) {
        this.data.add(i, v);
    }

    public Index append(Index idx) {
        Index index = Index.factory(new ArrayList<V>(this.data));
        index.setFormat(this.format);
        index.setName(this.name);
        index.data.addAll(idx.data);
        return index;
    }

    public V get(int i) {
        return this.data.get(i);
    }

    public void set(int i, V value) {
        this.data.set(i, value);
    }

    public int[] indices(Object[] names) {
        return this.indices(Arrays.asList(names));
    }

    public int[] indices(List<Object> names) {
        int size = names.size();
        int[] indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = this.indexOf(names.get(i));
        }
        return indices;
    }

    public List<Integer> indexAll(Object k) {
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.data.get(i).equals(k)) continue;
            idx.add(i);
        }
        return idx;
    }

    public int indexOf(Object v) {
        return this.data.indexOf(v);
    }

    public List<Integer> indexOf(List<V> vs) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (V v : vs) {
            r.add(this.indexOf(v));
        }
        return r;
    }

    public boolean contains(V v) {
        return this.data.contains(v);
    }

    public Index subIndex() {
        Index r = Index.factory(this.data);
        r.setFormat(this.format);
        return r;
    }

    public Index subIndex(List<Integer> idx) {
        Index<V> r = new Index<V>();
        for (int i : idx) {
            r.add(this.data.get(i));
        }
        r.setFormat(this.format);
        return r;
    }

    public Index subIndex(int start, int end, int step) {
        ArrayList<V> rv = new ArrayList<V>();
        for (int i = start; i < end; i += step) {
            rv.add(this.data.get(i));
        }
        Index r = Index.factory(rv);
        r.setFormat(this.format);
        return r;
    }

    public Object[] getIndices(List<Object> labels) {
        ArrayList r = new ArrayList();
        ArrayList rIndex = new ArrayList();
        ArrayList<Integer> rData = new ArrayList<Integer>();
        ArrayList<Object> rrIndex = new ArrayList<Object>();
        for (Object l : labels) {
            Object[] rr = this.getIndices(l);
            ArrayList r1 = (ArrayList)rr[0];
            ArrayList rIndex1 = (ArrayList)rr[1];
            if (r1.isEmpty()) {
                rData.add(-1);
                rrIndex.add(l);
                continue;
            }
            r.addAll(r1);
            rIndex.addAll(rIndex1);
            Iterator it = r1.iterator();
            while (it.hasNext()) {
                int idx = (Integer)it.next();
                rData.add(idx);
                rrIndex.add(l);
            }
        }
        return new Object[]{r, rIndex, rData, rrIndex};
    }

    public List<Integer> filterIndices(Array arr) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (!arr.getBoolean(i)) continue;
            r.add(i);
        }
        return r;
    }

    public Object[] getIndices_bak(List<Object> labels) {
        ArrayList r = new ArrayList();
        ArrayList rIndex = new ArrayList();
        ArrayList<Integer> rData = new ArrayList<Integer>();
        ArrayList<Object> rrIndex = new ArrayList<Object>();
        for (Object l : labels) {
            Object[] rr = this.getIndices(l);
            ArrayList r1 = (ArrayList)rr[0];
            ArrayList rIndex1 = (ArrayList)rr[1];
            if (r1.isEmpty()) {
                rData.add(0);
                rrIndex.add(l);
                continue;
            }
            r.addAll(r1);
            rIndex.addAll(rIndex1);
            Iterator it = r1.iterator();
            while (it.hasNext()) {
                it.next();
                rData.add(1);
                rrIndex.add(l);
            }
        }
        return new Object[]{r, rIndex, rData, rrIndex};
    }

    public Object[] getIndices(Object label) {
        if (label instanceof Array) {
            return this.getIndices(ArrayMath.asList((Array)((Array)label)));
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        ArrayList<Object> rIndex = new ArrayList<Object>();
        List<Integer> idx = this.indexAll(label);
        for (int i : idx) {
            r.add(i);
            rIndex.add(label);
        }
        return new Object[]{r, rIndex};
    }

    public Object[] getIndices_s(Object label) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        ArrayList<Object> rIndex = new ArrayList<Object>();
        int idx = this.data.indexOf(label);
        if (idx >= 0) {
            r.add(idx);
            rIndex.add(label);
        } else {
            r.add(-1);
            rIndex.add(label);
        }
        return new Object[]{r, rIndex};
    }

    public static List subList(List list, List<Integer> index) {
        ArrayList r = new ArrayList();
        for (int i : index) {
            r.add(list.get(i));
        }
        return r;
    }

    public Array fillKeyList(Array data, List<Integer> rrdata) {
        Array kdata = Array.factory((DataType)data.getDataType(), (int[])new int[]{rrdata.size()});
        int idx = 0;
        int i = 0;
        for (int f : rrdata) {
            if (f == 0) {
                kdata.setObject(i, (Object)Double.NaN);
            } else {
                kdata.setObject(i, data.getObject(idx));
                ++idx;
            }
            ++i;
        }
        return kdata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Index([");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.toString_Index(i));
            if (i < 100) {
                if (i >= this.size() - 1) break;
            } else {
                sb.append(", ...");
                break;
            }
            sb.append(", ");
        }
        sb.append("])");
        return sb.toString();
    }

    public String toString_Index(int idx) {
        String s = String.valueOf(this.data.get(idx));
        switch (this.dataType) {
            case STRING: {
                s = "'" + s + "'";
            }
        }
        return s;
    }

    public String toString(int idx) {
        return String.format(this.format, this.data.get(idx));
    }

    public String toString(int idx, String format) {
        return String.format(format, this.data.get(idx));
    }

    public Object clone() {
        ArrayList<V> ndata = new ArrayList<V>(this.data);
        Index r = Index.factory(ndata, this.name);
        r.format = this.format;
        return r;
    }
}

