/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe.impl;

import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.dataframe.impl.Function;

public class WindowFunction
implements Function<LocalDateTime, Object> {
    TemporalAmount period;

    public WindowFunction(TemporalAmount period) {
        this.period = period;
    }

    public TemporalAmount getPeriod() {
        return this.period;
    }

    @Override
    public Object apply(LocalDateTime value) {
        LocalDateTime ndt = LocalDateTime.now();
        ChronoUnit cu = JDateUtil.getChronoUnit((TemporalAmount)this.period);
        switch (cu) {
            case SECONDS: {
                ndt = LocalDateTime.of(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), 0);
                break;
            }
            case MINUTES: {
                ndt = LocalDateTime.of(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), 0, 0);
                break;
            }
            case HOURS: {
                ndt = LocalDateTime.of(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), 0, 0, 0);
                break;
            }
            case DAYS: {
                ndt = LocalDateTime.of(value.getYear(), value.getMonthValue(), 1, 0, 0, 0);
                break;
            }
            case MONTHS: {
                ndt = LocalDateTime.of(value.getYear(), 1, 1, 0, 0, 0);
                break;
            }
            case YEARS: {
                int n = ((Period)this.period).getYears();
                ndt = LocalDateTime.of(value.getYear() - n, 1, 1, 0, 0, 0);
            }
        }
        while (ndt.isBefore(value)) {
            ndt = ndt.plus(this.period);
        }
        if (ndt.isAfter(value)) {
            ndt = ndt.minus(this.period);
        }
        return ndt;
    }
}

