/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.meteoinfo.dataframe.DateTimeColumn;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.util.DataTypeUtil;

public class Column {
    protected String name;
    protected DataType dataType;
    protected String format;
    protected DateTimeFormatter dateTimeFormatter;
    protected int formatLen;

    public Column() {
        this("Column", DataType.OBJECT);
    }

    public Column(String name) {
        this(name, DataType.OBJECT);
    }

    public Column(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
        this.updateFormat();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType value) {
        this.dataType = value;
    }

    public String getFormat() {
        return this.format;
    }

    public String getNameFormat() {
        return "%" + String.valueOf(this.formatLen) + "s";
    }

    public void setFormat(String value) {
        this.format = value;
        if (this.dataType == DataType.DATE) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(value);
        }
    }

    public int getFormatLen() {
        return this.formatLen;
    }

    public void setFormatLen(int value) {
        this.formatLen = value;
    }

    public static Column factory(String name, DataType dtype) {
        return new Column(name, dtype);
    }

    public static Column factory(String name, Array array) {
        DataType dtype = array.getDataType();
        switch (dtype) {
            case DATE: {
                DateTimeColumn col = new DateTimeColumn(name);
                col.updateFormat(array);
                return col;
            }
            case OBJECT: {
                if (!(array.getObject(0) instanceof LocalDateTime)) break;
                DateTimeColumn col = new DateTimeColumn(name);
                col.updateFormat(array);
                return col;
            }
        }
        return new Column(name, dtype);
    }

    public void updateFormat() {
        this.format = null;
        switch (this.dataType) {
            case FLOAT: 
            case DOUBLE: {
                this.format = "%f";
            }
        }
        this.formatLen = this.name.length();
    }

    public void updateFormat(Array data) {
        this.formatLen = this.name.length();
        switch (this.dataType) {
            case FLOAT: 
            case DOUBLE: {
                int ci;
                double dmax = ArrayMath.max((Array)data).doubleValue();
                DecimalFormat df = new DecimalFormat("0.0");
                df.setMaximumFractionDigits(6);
                int nf = 1;
                int i = 0;
                while ((long)i < data.getSize()) {
                    String str = df.format(data.getDouble(i));
                    ci = str.indexOf(".");
                    int nn = str.length() - ci - 1;
                    if (nf < nn && (nf = nn) == 6) break;
                    ++i;
                }
                String smax = df.format(dmax);
                ci = smax.indexOf(".");
                int len = ci + nf + 2;
                this.formatLen = Math.max(this.formatLen, len);
                this.format = "%" + String.valueOf(this.formatLen) + "." + String.valueOf(nf) + "f";
                break;
            }
            case INT: {
                int imax = (Integer)ArrayMath.max((Array)data);
                String smax = Integer.toString(imax);
                this.formatLen = Math.max(this.formatLen, smax.length());
                this.format = "%" + String.valueOf(this.formatLen) + "d";
                break;
            }
            default: {
                int i = 0;
                while ((long)i < data.getSize()) {
                    String v = data.getObject(i) == null ? "null" : data.getObject(i).toString();
                    if (this.formatLen < v.length()) {
                        this.formatLen = v.length();
                    }
                    ++i;
                }
                this.format = "%" + String.valueOf(this.formatLen) + "s";
            }
        }
    }

    public Object convertTo(Object value) {
        return DataTypeUtil.convertTo((Object)value, (DataType)this.dataType, (String)this.format);
    }

    public Object convertStringTo(String s) {
        return DataTypeUtil.convertStringTo((String)s, (DataType)this.dataType, (String)this.format);
    }

    public String toString() {
        return this.name;
    }

    public String toString(Object o) {
        if (this.format == null) {
            return o.toString();
        }
        if (this.dataType == DataType.DATE) {
            if (this.dateTimeFormatter == null) {
                this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.format);
            }
            return ((LocalDateTime)o).format(this.dateTimeFormatter);
        }
        return String.format(Locale.US, this.format, o);
    }

    public Object clone() {
        Column col = new Column(this.name, this.dataType);
        col.setFormat(this.format);
        col.setFormatLen(this.formatLen);
        return col;
    }
}

