/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.geoprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.BorderPoint;
import org.meteoinfo.geometry.geoprocess.ClipLine;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.geoprocess.RectPointTypes;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.Line;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZ;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class GeoComputation {
    private static final double EARTH_RADIUS = 6371.393;

    public static boolean isClockwise(List<? extends PointD> pointList) {
        double yMax = 0.0;
        int yMaxIdx = 0;
        for (int i = 0; i < pointList.size() - 1; ++i) {
            PointD aPoint = pointList.get(i);
            if (i == 0) {
                yMax = aPoint.Y;
                yMaxIdx = 0;
                continue;
            }
            if (!(yMax < aPoint.Y)) continue;
            yMax = aPoint.Y;
            yMaxIdx = i;
        }
        int p1Idx = yMaxIdx - 1;
        int p2Idx = yMaxIdx;
        int p3Idx = yMaxIdx + 1;
        if (yMaxIdx == 0) {
            p1Idx = pointList.size() - 2;
        }
        PointD p1 = pointList.get(p1Idx);
        PointD p2 = pointList.get(p2Idx);
        PointD p3 = pointList.get(p3Idx);
        return (p3.X - p1.X) * (p2.Y - p1.Y) - (p2.X - p1.X) * (p3.Y - p1.Y) > 0.0;
    }

    public static boolean isClockwise(PointD[] points) {
        List<PointD> pointList = Arrays.asList(points);
        return GeoComputation.isClockwise(pointList);
    }

    public static boolean pointInPolygon(List<? extends PointD> poly, PointD aPoint) {
        boolean inside = false;
        int nPoints = poly.size();
        if (nPoints < 3) {
            return false;
        }
        double xOld = poly.get((int)(nPoints - 1)).X;
        double yOld = poly.get((int)(nPoints - 1)).Y;
        for (int i = 0; i < nPoints; ++i) {
            double y2;
            double y1;
            double x2;
            double x1;
            double xNew = poly.get((int)i).X;
            double yNew = poly.get((int)i).Y;
            if (xNew > xOld) {
                x1 = xOld;
                x2 = xNew;
                y1 = yOld;
                y2 = yNew;
            } else {
                x1 = xNew;
                x2 = xOld;
                y1 = yNew;
                y2 = yOld;
            }
            if (xNew < aPoint.X == aPoint.X <= xOld && (aPoint.Y - y1) * (x2 - x1) < (y2 - y1) * (aPoint.X - x1)) {
                inside = !inside;
            }
            xOld = xNew;
            yOld = yNew;
        }
        return inside;
    }

    public static boolean pointInPolygon(PolygonShape aPolygon, PointD aPoint) {
        if (!MIMath.pointInExtent((PointD)aPoint, (Extent)aPolygon.getExtent())) {
            return false;
        }
        if (aPolygon instanceof CircleShape) {
            return ((CircleShape)aPolygon).contains(aPoint);
        }
        boolean isIn = false;
        for (int i = 0; i < aPolygon.getPolygons().size(); ++i) {
            Polygon aPRing = aPolygon.getPolygons().get(i);
            isIn = GeoComputation.pointInPolygon(aPRing.getOutLine(), aPoint);
            if (isIn && aPRing.hasHole()) {
                for (List<? extends PointD> aLine : aPRing.getHoleLines()) {
                    if (!GeoComputation.pointInPolygon(aLine, aPoint)) continue;
                    isIn = false;
                    break;
                }
            }
            if (!isIn) continue;
            return isIn;
        }
        return isIn;
    }

    public static boolean pointInPolygon(PolygonShape aPolygon, double x, double y) {
        return GeoComputation.pointInPolygon(aPolygon, new PointD(x, y));
    }

    public static boolean pointInPolygon(Polygon aPolygon, PointD aPoint) {
        if (!MIMath.pointInExtent((PointD)aPoint, (Extent)aPolygon.getExtent())) {
            return false;
        }
        if (aPolygon.hasHole()) {
            boolean isIn = GeoComputation.pointInPolygon(aPolygon.getOutLine(), aPoint);
            if (isIn) {
                for (List<? extends PointD> aLine : aPolygon.getHoleLines()) {
                    if (!GeoComputation.pointInPolygon(aLine, aPoint)) continue;
                    isIn = false;
                    break;
                }
            }
            return isIn;
        }
        return GeoComputation.pointInPolygon(aPolygon.getOutLine(), aPoint);
    }

    public static boolean pointInPolygons(List<PolygonShape> polygons, PointD aPoint) {
        boolean isIn = false;
        Extent ext = GeometryUtil.getExtent(polygons);
        if (MIMath.pointInExtent((PointD)aPoint, (Extent)ext)) {
            for (PolygonShape aPGS : polygons) {
                if (!GeoComputation.pointInPolygon(aPGS, aPoint)) continue;
                isIn = true;
                break;
            }
        }
        return isIn;
    }

    public static double dis_PointToLine(PointD point, PointD pt1, PointD pt2) {
        double dis;
        if (MIMath.doubleEquals((double)pt2.X, (double)pt1.X)) {
            dis = Math.abs(point.X - pt1.X);
        } else if (MIMath.doubleEquals((double)pt2.Y, (double)pt1.Y)) {
            dis = Math.abs(point.Y - pt1.Y);
        } else {
            double k = (pt2.Y - pt1.Y) / (pt2.X - pt1.X);
            double x = (k * k * pt1.X + k * (point.Y - pt1.Y) + point.X) / (k * k + 1.0);
            double y = k * (x - pt1.X) + pt1.Y;
            dis = GeoComputation.distance(point, new PointD(x, y));
        }
        return dis;
    }

    public static double distance(PointD pt1, PointD pt2) {
        return Math.sqrt((pt2.Y - pt1.Y) * (pt2.Y - pt1.Y) + (pt2.X - pt1.X) * (pt2.X - pt1.X));
    }

    public static Object selectPolylineShape(PointD sp, PolylineShape aPLS, double buffer) {
        Extent aExtent = new Extent();
        aExtent.minX = sp.X - buffer;
        aExtent.maxX = sp.X + buffer;
        aExtent.minY = sp.Y - buffer;
        aExtent.maxY = sp.Y + buffer;
        if (MIMath.isExtentCross((Extent)aExtent, (Extent)aPLS.getExtent()).booleanValue()) {
            for (int j = 0; j < aPLS.getPointNum(); ++j) {
                double dis;
                PointD aPoint = aPLS.getPoints().get(j);
                if (MIMath.pointInExtent((PointD)aPoint, (Extent)aExtent)) {
                    return GeoComputation.distance(sp, aPoint);
                }
                if (j >= aPLS.getPointNum() - 1) continue;
                PointD bPoint = aPLS.getPoints().get(j + 1);
                if (!(Math.abs(sp.Y - aPoint.Y) <= Math.abs(bPoint.Y - aPoint.Y)) && !(Math.abs(sp.X - aPoint.X) <= Math.abs(bPoint.X - aPoint.X)) || !((dis = GeoComputation.dis_PointToLine(sp, aPoint, bPoint)) < aExtent.getWidth())) continue;
                return dis;
            }
        }
        return null;
    }

    public static Object selectPolyline(PointD sp, List<PointD> points, double buffer) {
        Extent aExtent = new Extent();
        aExtent.minX = sp.X - buffer;
        aExtent.maxX = sp.X + buffer;
        aExtent.minY = sp.Y - buffer;
        aExtent.maxY = sp.Y + buffer;
        Extent bExtent = GeometryUtil.getPointsExtent(points);
        if (MIMath.isExtentCross((Extent)aExtent, (Extent)bExtent).booleanValue()) {
            for (int j = 0; j < points.size(); ++j) {
                double dis;
                PointD aPoint = points.get(j);
                if (MIMath.pointInExtent((PointD)aPoint, (Extent)aExtent)) {
                    return GeoComputation.distance(sp, aPoint);
                }
                if (j >= points.size() - 1) continue;
                PointD bPoint = points.get(j + 1);
                if (!(Math.abs(sp.Y - aPoint.Y) <= Math.abs(bPoint.Y - aPoint.Y)) && !(Math.abs(sp.X - aPoint.X) <= Math.abs(bPoint.X - aPoint.X)) || !((dis = GeoComputation.dis_PointToLine(sp, aPoint, bPoint)) < aExtent.getWidth())) continue;
                return new Object[]{j + 1, dis};
            }
        }
        return null;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static Array getGridArea(double xOrig, double xCell, int xNum, double yOrig, double yCell, int yNum, boolean isLonLat, boolean allCell) {
        return GeoComputation.getGridArea(xOrig, xCell, xNum, yOrig, yCell, yNum, isLonLat, allCell, 6371393.0);
    }

    public static Array getGridArea(double xOrig, double xCell, int xNum, double yOrig, double yCell, int yNum, boolean isLonLat, boolean allCell, double earthRadius) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        double[] xx = new double[5];
        double[] yy = new double[5];
        double dx = xCell * 0.5;
        double dy = yCell * 0.5;
        if (allCell) {
            for (int i = 0; i < yNum; ++i) {
                double y = yOrig + (double)i * yCell;
                for (int j = 0; j < xNum; ++j) {
                    double x = xOrig + (double)j * xCell;
                    xx = new double[]{x - dx, x + dx, x + dx, x - dx, x - dx};
                    yy = new double[]{y - dy, y - dy, y + dy, y + dy, y - dy};
                    double a = GeoComputation.getArea(xx, yy, isLonLat, earthRadius);
                    r.setDouble(i * xNum + j, a);
                }
            }
        } else {
            double x = xOrig;
            xx = new double[]{x - dx, x + dx, x + dx, x - dx, x - dx};
            for (int i = 0; i < yNum; ++i) {
                double y = yOrig + (double)i * yCell;
                yy = new double[]{y - dy, y - dy, y + dy, y + dy, y - dy};
                double a = GeoComputation.getArea(xx, yy, isLonLat, earthRadius);
                for (int j = 0; j < xNum; ++j) {
                    r.setDouble(i * xNum + j, a);
                }
            }
        }
        return r;
    }

    public static double getArea(List<Number> x, List<Number> y, boolean isLonLat) {
        double[] xx = new double[x.size()];
        double[] yy = new double[x.size()];
        for (int i = 0; i < x.size(); ++i) {
            xx[i] = x.get(i).doubleValue();
            yy[i] = y.get(i).doubleValue();
        }
        return GeoComputation.getArea(xx, yy, isLonLat);
    }

    public static double getArea(double[] x, double[] y, boolean isLonLat) {
        return GeoComputation.getArea(x, y, isLonLat, 6371393.0);
    }

    public static double getArea(double[] x, double[] y, boolean isLonLat, double earthRadius) {
        int n = x.length;
        if (n > 2) {
            double mtotalArea = 0.0;
            if (isLonLat) {
                double[] lon = new double[x.length];
                double[] lat = new double[y.length];
                for (int i = 0; i < x.length; ++i) {
                    lon[i] = Math.toRadians(x[i]);
                    lat[i] = Math.toRadians(y[i]);
                }
                return GeoComputation.sphericalPolygonArea(lat, lon, earthRadius);
            }
            int i = n - 1;
            int j = 0;
            while (j < n) {
                double p1x = x[i];
                double p1y = y[i];
                double p2x = x[j];
                double p2y = y[j];
                mtotalArea += p1x * p2y - p2x * p1y;
                i = j++;
            }
            if ((mtotalArea /= 2.0) < 0.0) {
                mtotalArea = -mtotalArea;
            }
            return mtotalArea;
        }
        return 0.0;
    }

    public static double getArea(List<? extends PointD> points, boolean isLonLat) {
        int Count = points.size();
        if (Count > 2) {
            double mtotalArea = 0.0;
            if (isLonLat) {
                return GeoComputation.sphericalPolygonArea(points);
            }
            int i = Count - 1;
            int j = 0;
            while (j < Count) {
                double p1x = points.get((int)i).X;
                double p1y = points.get((int)i).Y;
                double p2x = points.get((int)j).X;
                double p2y = points.get((int)j).Y;
                mtotalArea += p1x * p2y - p2x * p1y;
                i = j++;
            }
            if ((mtotalArea /= 2.0) < 0.0) {
                mtotalArea = -mtotalArea;
            }
            return mtotalArea;
        }
        return 0.0;
    }

    public static double getArea(List<? extends PointD> points) {
        return GeoComputation.getArea(points, false);
    }

    public static double calArea(List<PointD> points) {
        if (points.size() < 3) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            double bx = points.get((int)i).X;
            double by = points.get((int)i).Y;
            double cx = points.get((int)(i + 1)).X;
            double cy = points.get((int)(i + 1)).Y;
            sum += (bx + cx) * (cy - by);
        }
        return -sum / 2.0;
    }

    public static double sphericalPolygonArea(List<? extends PointD> points) {
        return GeoComputation.sphericalPolygonArea(points, 6371393.0);
    }

    public static double sphericalPolygonArea(List<? extends PointD> points, double r) {
        double[] lat = new double[points.size()];
        double[] lon = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            lon[i] = GeoComputation.rad(points.get((int)i).X);
            lat[i] = GeoComputation.rad(points.get((int)i).Y);
        }
        return GeoComputation.sphericalPolygonArea(lat, lon, r);
    }

    public static double haversine(double x) {
        return (1.0 - Math.cos(x)) / 2.0;
    }

    public static double sphericalPolygonArea(double[] lat, double[] lon, double r) {
        double lam2 = 0.0;
        double beta2 = 0.0;
        double cosB2 = 0.0;
        double sum = 0.0;
        for (int j = 0; j < lat.length; ++j) {
            double cosB1;
            double beta1;
            double lam1;
            if (j == 0) {
                lam1 = lon[j];
                beta1 = lat[j];
                lam2 = lon[j + 1];
                beta2 = lat[j + 1];
                cosB1 = Math.cos(beta1);
                cosB2 = Math.cos(beta2);
            } else {
                int k = (j + 1) % lat.length;
                lam1 = lam2;
                beta1 = beta2;
                lam2 = lon[k];
                beta2 = lat[k];
                cosB1 = cosB2;
                cosB2 = Math.cos(beta2);
            }
            if (lam1 == lam2) continue;
            double hav = GeoComputation.haversine(beta2 - beta1) + cosB1 * cosB2 * GeoComputation.haversine(lam2 - lam1);
            double a = 2.0 * Math.asin(Math.sqrt(hav));
            double b = 1.5707963267948966 - beta2;
            double c = 1.5707963267948966 - beta1;
            double s = 0.5 * (a + b + c);
            double t = Math.tan(s / 2.0) * Math.tan((s - a) / 2.0) * Math.tan((s - b) / 2.0) * Math.tan((s - c) / 2.0);
            double excess = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(t))));
            if (lam2 < lam1) {
                excess = -excess;
            }
            sum += excess;
        }
        return Math.abs(sum) * r * r;
    }

    public static double getDistance(List<? extends PointD> points, boolean isLonLat) {
        double tdis = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            double dist;
            double ax = points.get((int)i).X;
            double ay = points.get((int)i).Y;
            double bx = points.get((int)(i + 1)).X;
            double by = points.get((int)(i + 1)).Y;
            double dx = Math.abs(bx - ax);
            double dy = Math.abs(by - ay);
            if (isLonLat) {
                double y = (by + ay) / 2.0;
                double factor = Math.cos(y * Math.PI / 180.0);
                dist = Math.sqrt((dx *= factor) * dx + dy * dy);
                dist *= 111319.5;
            } else {
                dist = Math.sqrt(dx * dx + dy * dy);
            }
            tdis += dist;
        }
        return tdis;
    }

    public static double getDistance(List<Number> xx, List<Number> yy, boolean isLonLat) {
        double tdis = 0.0;
        for (int i = 0; i < xx.size() - 1; ++i) {
            double dist;
            double ax = xx.get(i).doubleValue();
            double ay = yy.get(i).doubleValue();
            double bx = xx.get(i + 1).doubleValue();
            double by = yy.get(i + 1).doubleValue();
            double dx = Math.abs(bx - ax);
            double dy = Math.abs(by - ay);
            if (isLonLat) {
                double y = (by + ay) / 2.0;
                double factor = Math.cos(y * Math.PI / 180.0);
                dist = Math.sqrt((dx *= factor) * dx + dy * dy);
                dist *= 111319.5;
            } else {
                dist = Math.sqrt(dx * dx + dy * dy);
            }
            tdis += dist;
        }
        return tdis;
    }

    public static Shape clipShape(Shape aShape, Object clipObj) {
        switch (aShape.getShapeType()) {
            case POINT: 
            case WEATHER_SYMBOL: 
            case WIND_ARROW: 
            case WIND_BARB: 
            case STATION_MODEL: {
                return GeoComputation.clipPointShape((PointShape)aShape, clipObj);
            }
            case POLYLINE: {
                return GeoComputation.clipPolylineShape((PolylineShape)aShape, clipObj);
            }
            case POLYGON: 
            case POLYGON_M: {
                return GeoComputation.clipPolygonShape((PolygonShape)aShape, clipObj);
            }
        }
        return null;
    }

    public static PointShape clipPointShape(PointShape aPS, Object clipObj) {
        if (GeoComputation.pointInClipObj(clipObj, aPS.getPoint())) {
            return aPS;
        }
        return null;
    }

    public static PolylineShape clipPolylineShape(PolylineShape aPLS, Object clipObj) {
        List<Polyline> polyLines = GeoComputation.clipPolylines(aPLS.getPolylines(), clipObj);
        if (polyLines.isEmpty()) {
            return null;
        }
        PolylineShape bPLS = (PolylineShape)aPLS.valueClone();
        bPLS.setPolylines(polyLines);
        return bPLS;
    }

    public static PolylineShape clipPolylineShape_Lon(PolylineShape aPLS, double lon) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(true);
        clipLine.setValue(lon - 1.0E-4);
        clipLine.setLeftOrTop(true);
        polylines.addAll(GeoComputation.clipPolylines(aPLS.getPolylines(), clipLine));
        clipLine.setValue(lon + 1.0E-4);
        clipLine.setLeftOrTop(false);
        polylines.addAll(GeoComputation.clipPolylines(aPLS.getPolylines(), clipLine));
        PolylineShape bPLS = (PolylineShape)aPLS.valueClone();
        bPLS.setPolylines(polylines);
        return bPLS;
    }

    public static PolylineShape clipPolylineShape_Lat(PolylineShape aPLS, double lat) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(false);
        clipLine.setValue(lat + 1.0E-4);
        clipLine.setLeftOrTop(true);
        polylines.addAll(GeoComputation.clipPolylines(aPLS.getPolylines(), clipLine));
        clipLine.setValue(lat - 1.0E-4);
        clipLine.setLeftOrTop(false);
        polylines.addAll(GeoComputation.clipPolylines(aPLS.getPolylines(), clipLine));
        PolylineShape bPLS = (PolylineShape)aPLS.valueClone();
        bPLS.setPolylines(polylines);
        return bPLS;
    }

    public static PolylineShape clipPolylineShape_Lat(PolylineShape aPLS, double lat, boolean isTop) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(false);
        clipLine.setValue(lat);
        clipLine.setLeftOrTop(isTop);
        polylines.addAll(GeoComputation.clipPolylines(aPLS.getPolylines(), clipLine));
        PolylineShape bPLS = (PolylineShape)aPLS.valueClone();
        bPLS.setPolylines(polylines);
        return bPLS;
    }

    private static List<Polyline> clipPolylines(List<? extends Polyline> polyLines, Object clipObj) {
        ArrayList<Polyline> newPolyLines = new ArrayList<Polyline>();
        for (Polyline polyline : polyLines) {
            newPolyLines.addAll(GeoComputation.clipPolyline(polyline, clipObj));
        }
        return newPolyLines;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<? extends Polyline> clipPolyline(Polyline inPolyLine, Object clipObj) {
        int i;
        ArrayList<Polyline> newPolylines = new ArrayList<Polyline>();
        List aPList = inPolyLine.getPointList();
        if (!GeoComputation.isExtentCross(inPolyLine.getExtent(), clipObj)) {
            return newPolylines;
        }
        if (clipObj instanceof List) {
            if (!GeoComputation.isClockwise((List)clipObj)) {
                Collections.reverse((List)clipObj);
            }
        } else if (clipObj.getClass() == ClipLine.class && ((ClipLine)clipObj).isExtentInside(inPolyLine.getExtent())) {
            newPolylines.add(inPolyLine);
            return newPolylines;
        }
        ArrayList<List> newLines = new ArrayList<List>();
        if (!GeoComputation.pointInClipObj(clipObj, aPList.get(0))) {
            newLines.add(aPList);
        } else {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (GeoComputation.pointInClipObj(clipObj, aPList.get(i))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (isAllIn) {
                newPolylines.add(inPolyLine);
                return newPolylines;
            }
            if (inPolyLine.isClosed()) {
                ArrayList<Object> bPList = new ArrayList<Object>();
                bPList.addAll(aPList.subList(notInIdx, aPList.size()));
                bPList.addAll(aPList.subList(0, notInIdx));
                bPList.add((PointD)bPList.get(0));
                newLines.add(bPList);
            } else {
                Collections.reverse(aPList);
                newLines.add(aPList);
            }
        }
        ArrayList<BorderPoint> borderList = new ArrayList<BorderPoint>();
        BorderPoint aBP = new BorderPoint();
        List<PointD> clipPList = GeoComputation.getClipPointList(clipObj);
        for (PointD aP : clipPList) {
            aBP = new BorderPoint();
            aBP.Point = aP;
            aBP.Id = -1;
            borderList.add(aBP);
        }
        int l = 0;
        block2: while (l < newLines.size()) {
            aPList = (List)newLines.get(l);
            boolean isInPolygon = GeoComputation.pointInClipObj(clipObj, (PointD)aPList.get(0));
            PointD IPoint = new PointD();
            ArrayList<PointD> newPlist = new ArrayList<PointD>();
            PointD p1 = (PointD)aPList.get(0);
            int inIdx = -1;
            int outIdx = -1;
            boolean newLine = true;
            int a1 = 0;
            i = 1;
            while (true) {
                PointD p2;
                block32: {
                    Line lineB;
                    PointD q2;
                    int j;
                    Polyline bLine;
                    PointD q1;
                    Line lineA;
                    block33: {
                        block30: {
                            block31: {
                                block28: {
                                    block29: {
                                        if (i >= aPList.size()) break block28;
                                        p2 = (PointD)aPList.get(i);
                                        if (!GeoComputation.pointInClipObj(clipObj, p2)) break block29;
                                        if (isInPolygon) break block30;
                                        lineA = new Line();
                                        lineA.P1 = p1;
                                        lineA.P2 = p2;
                                        q1 = ((BorderPoint)borderList.get((int)0)).Point;
                                        break block31;
                                    }
                                    if (!isInPolygon) break block32;
                                    lineA = new Line();
                                    lineA.P1 = p1;
                                    lineA.P2 = p2;
                                    q1 = ((BorderPoint)borderList.get((int)0)).Point;
                                    break block33;
                                }
                                if (isInPolygon && newPlist.size() > 1) {
                                    bLine = new Polyline();
                                    bLine.setPointList(new ArrayList(newPlist));
                                    newPolylines.add(bLine);
                                }
                                ++l;
                                continue block2;
                            }
                            for (j = 1; j < borderList.size(); ++j) {
                                q2 = ((BorderPoint)borderList.get((int)j)).Point;
                                lineB = new Line();
                                lineB.P1 = q1;
                                lineB.P2 = q2;
                                if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                                    IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                                    aBP = new BorderPoint();
                                    aBP.Id = newPolylines.size();
                                    aBP.Point = IPoint;
                                    borderList.add(j, aBP);
                                    inIdx = j;
                                    break;
                                }
                                q1 = q2;
                            }
                            newPlist.add(IPoint);
                        }
                        newPlist.add((PointD)aPList.get(i));
                        isInPolygon = true;
                        break block32;
                    }
                    for (j = 1; j < borderList.size(); ++j) {
                        q2 = ((BorderPoint)borderList.get((int)j)).Point;
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                            if (!newLine) {
                                if (inIdx - outIdx >= 1 && inIdx - outIdx <= 10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx, aBP);
                                    }
                                } else if (inIdx - outIdx <= -1 && inIdx - outIdx >= -10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx + 1, aBP);
                                    }
                                } else if (inIdx == outIdx && !GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(inIdx + 1, aBP);
                                }
                            }
                            IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                            aBP = new BorderPoint();
                            aBP.Id = newPolylines.size();
                            aBP.Point = IPoint;
                            borderList.add(j, aBP);
                            outIdx = j;
                            a1 = inIdx;
                            newLine = false;
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                    bLine = new Polyline();
                    bLine.setPointList(new ArrayList(newPlist));
                    newPolylines.add(bLine);
                    isInPolygon = false;
                    newPlist = new ArrayList();
                }
                p1 = p2;
                ++i;
            }
            break;
        }
        return newPolylines;
    }

    public static PolygonShape clipPolygonShape(PolygonShape aPGS, Object clipObj) {
        List<Polygon> polygons = GeoComputation.clipPolygons(aPGS.getPolygons(), clipObj);
        if (polygons.isEmpty()) {
            return null;
        }
        PolygonShape bPGS = aPGS.valueClone();
        bPGS.setPolygons(polygons);
        return bPGS;
    }

    public static PolygonShape clipPolygonShape_Lon(PolygonShape aPGS, double lon) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(true);
        clipLine.setValue(lon - 1.0E-4);
        clipLine.setLeftOrTop(true);
        polygons.addAll(GeoComputation.clipPolygons(aPGS.getPolygons(), clipLine));
        clipLine.setValue(lon + 1.0E-4);
        clipLine.setLeftOrTop(false);
        polygons.addAll(GeoComputation.clipPolygons(aPGS.getPolygons(), clipLine));
        PolygonShape bPGS = aPGS.valueClone();
        bPGS.setPolygons(polygons);
        return bPGS;
    }

    public static PolygonShape clipPolygonShape_Lat(PolygonShape aPGS, double lat) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(false);
        clipLine.setValue(lat + 1.0E-4);
        clipLine.setLeftOrTop(true);
        polygons.addAll(GeoComputation.clipPolygons(aPGS.getPolygons(), clipLine));
        clipLine.setValue(lat - 1.0E-4);
        clipLine.setLeftOrTop(false);
        polygons.addAll(GeoComputation.clipPolygons(aPGS.getPolygons(), clipLine));
        PolygonShape bPGS = aPGS.valueClone();
        bPGS.setPolygons(polygons);
        return bPGS;
    }

    public static PolygonShape clipPolygonShape_Lat(PolygonShape aPGS, double lat, boolean isTop) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ClipLine clipLine = new ClipLine();
        clipLine.setLongitude(false);
        clipLine.setValue(lat);
        clipLine.setLeftOrTop(isTop);
        polygons.addAll(GeoComputation.clipPolygons(aPGS.getPolygons(), clipLine));
        PolygonShape bPGS = aPGS.valueClone();
        bPGS.setPolygons(polygons);
        return bPGS;
    }

    private static List<Polygon> clipPolygons(List<? extends Polygon> polygons, Object clipObj) {
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon aPolygon = polygons.get(i);
            if (clipObj instanceof Extent) {
                newPolygons.addAll(GeoComputation.clipPolygon_Extent(aPolygon, (Extent)clipObj));
                continue;
            }
            newPolygons.addAll(GeoComputation.clipPolygon(aPolygon, clipObj));
        }
        return newPolygons;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Polygon> clipPolygon(Polygon inPolygon, Object clipObj) {
        int i;
        List<Polygon> newPolygons = new ArrayList<Polygon>();
        ArrayList<Polyline> newPolylines = new ArrayList<Polyline>();
        List aPList = inPolygon.getOutLine();
        if (!GeoComputation.isExtentCross(inPolygon.getExtent(), clipObj)) {
            return newPolygons;
        }
        if (clipObj instanceof List) {
            if (!GeoComputation.isClockwise((List)clipObj)) {
                Collections.reverse((List)clipObj);
            }
        } else if (clipObj.getClass() == ClipLine.class && ((ClipLine)clipObj).isExtentInside(inPolygon.getExtent())) {
            newPolygons.add(inPolygon);
            return newPolygons;
        }
        ArrayList<List<? extends PointD>> newLines = new ArrayList<List<? extends PointD>>();
        if (!GeoComputation.pointInClipObj(clipObj, aPList.get(0))) {
            newLines.add(aPList);
        } else {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (GeoComputation.pointInClipObj(clipObj, aPList.get(i))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (isAllIn) {
                newPolygons.add(inPolygon);
                return newPolygons;
            }
            ArrayList<Object> bPList = new ArrayList<Object>();
            bPList.addAll(aPList.subList(notInIdx, aPList.size()));
            bPList.addAll(aPList.subList(1, notInIdx));
            bPList.add((PointD)bPList.get(0));
            newLines.add(bPList);
        }
        ArrayList<List<PointD>> holeLines = new ArrayList<List<PointD>>();
        if (inPolygon.hasHole()) {
            for (int h = 0; h < inPolygon.getHoleLines().size(); ++h) {
                int notInIdx;
                boolean isAllIn;
                List<? extends PointD> holePList = inPolygon.getHoleLines().get(h);
                Extent plExtent = GeometryUtil.getPointsExtent(holePList);
                if (!GeoComputation.isExtentCross(plExtent, clipObj)) continue;
                if (GeoComputation.pointInClipObj(clipObj, holePList.get(0))) {
                    isAllIn = true;
                    notInIdx = 0;
                } else {
                    newLines.add(holePList);
                    continue;
                }
                for (i = 0; i < holePList.size(); ++i) {
                    if (GeoComputation.pointInClipObj(clipObj, holePList.get(i))) continue;
                    notInIdx = i;
                    isAllIn = false;
                    break;
                }
                if (!isAllIn) {
                    ArrayList<Object> bPList = new ArrayList<Object>();
                    bPList.addAll(holePList.subList(notInIdx, holePList.size()));
                    bPList.addAll(holePList.subList(1, notInIdx));
                    bPList.add((PointD)bPList.get(0));
                    newLines.add(bPList);
                    continue;
                }
                holeLines.add(inPolygon.getHoleLines().get(h));
            }
        }
        ArrayList<BorderPoint> borderList = new ArrayList<BorderPoint>();
        BorderPoint aBP = new BorderPoint();
        List<PointD> clipPList = GeoComputation.getClipPointList(clipObj, inPolygon instanceof PolygonZ);
        for (PointD aP : clipPList) {
            aBP = new BorderPoint();
            aBP.Point = (PointD)aP.clone();
            aBP.Id = -1;
            borderList.add(aBP);
        }
        int l = 0;
        block4: while (true) {
            if (l >= newLines.size()) {
                if (newPolylines.size() > 0) {
                    if (aBP.Id >= newPolylines.size()) {
                        return newPolygons;
                    }
                    newPolygons = GeoComputation.tracingClipPolygons(inPolygon, newPolylines, borderList);
                } else if (clipObj.getClass() != ClipLine.class && GeoComputation.pointInPolygon(aPList, clipPList.get(0))) {
                    if (!GeoComputation.isClockwise(clipPList)) {
                        Collections.reverse(clipPList);
                    }
                    Polygon aPolygon = new Polygon();
                    aPolygon.setOutLine(new ArrayList<PointD>(clipPList));
                    newPolygons.add(aPolygon);
                }
                if (holeLines.size() > 0) {
                    GeoComputation.addHoles_Ring(newPolygons, holeLines);
                }
                return newPolygons;
            }
            aPList = (List)newLines.get(l);
            boolean isInPolygon = false;
            PointD IPoint = new PointD();
            ArrayList<PointD> newPlist = new ArrayList<PointD>();
            PointD p1 = (PointD)((PointD)aPList.get(0)).clone();
            int inIdx = -1;
            int outIdx = -1;
            boolean newLine = true;
            int a1 = 0;
            i = 1;
            while (true) {
                PointD p2;
                block41: {
                    Line lineB;
                    PointD q2;
                    int j;
                    PointD q1;
                    Line lineA;
                    block42: {
                        block39: {
                            block40: {
                                block37: {
                                    block38: {
                                        if (i >= aPList.size()) break block37;
                                        p2 = (PointD)((PointD)aPList.get(i)).clone();
                                        if (!GeoComputation.pointInClipObj(clipObj, p2)) break block38;
                                        if (isInPolygon) break block39;
                                        lineA = new Line();
                                        lineA.P1 = p1;
                                        lineA.P2 = p2;
                                        q1 = (PointD)((BorderPoint)borderList.get((int)0)).Point.clone();
                                        break block40;
                                    }
                                    if (!isInPolygon) break block41;
                                    lineA = new Line();
                                    lineA.P1 = p1;
                                    lineA.P2 = p2;
                                    q1 = (PointD)((BorderPoint)borderList.get((int)0)).Point.clone();
                                    break block42;
                                }
                                ++l;
                                continue block4;
                            }
                            for (j = 1; j < borderList.size(); ++j) {
                                q2 = (PointD)((BorderPoint)borderList.get((int)j)).Point.clone();
                                lineB = new Line();
                                lineB.P1 = q1;
                                lineB.P2 = q2;
                                if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                                    IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                                    aBP = new BorderPoint();
                                    aBP.Id = newPolylines.size();
                                    aBP.Point = (PointD)IPoint.clone();
                                    borderList.add(j, aBP);
                                    inIdx = j;
                                    break;
                                }
                                q1 = q2;
                            }
                            newPlist.add(IPoint);
                        }
                        newPlist.add((PointD)aPList.get(i));
                        isInPolygon = true;
                        break block41;
                    }
                    for (j = 1; j < borderList.size(); ++j) {
                        q2 = (PointD)((BorderPoint)borderList.get((int)j)).Point.clone();
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                            if (!newLine) {
                                if (inIdx - outIdx >= 1 && inIdx - outIdx <= 10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx, aBP);
                                    }
                                } else if (inIdx - outIdx <= -1 && inIdx - outIdx >= -10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx + 1, aBP);
                                    }
                                } else if (inIdx == outIdx && !GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(inIdx + 1, aBP);
                                }
                            }
                            IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                            aBP = new BorderPoint();
                            aBP.Id = newPolylines.size();
                            aBP.Point = (PointD)IPoint.clone();
                            borderList.add(j, aBP);
                            outIdx = j;
                            a1 = inIdx;
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                    Polyline bLine = new Polyline();
                    bLine.setPointList(new ArrayList(newPlist));
                    newPolylines.add(bLine);
                    isInPolygon = false;
                    newPlist = new ArrayList();
                }
                p1 = p2;
                ++i;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static List<Polygon> clipPolygon_Extent(Polygon inPolygon, Extent extent) {
        newPolygons = new ArrayList<Polygon>();
        newPolylines = new ArrayList<Polyline>();
        aPList = inPolygon.getOutLine();
        if (!GeoComputation.isExtentCross(inPolygon.getExtent(), extent)) {
            return newPolygons;
        }
        newLines = new ArrayList<List<? extends PointD>>();
        if (!GeoComputation.pointInClipObj(extent, aPList.get(0))) ** GOTO lbl29
        isAllIn = true;
        notInIdx = 0;
        for (i = 0; i < aPList.size(); ++i) {
            if (GeoComputation.pointInClipObj(extent, aPList.get(i))) continue;
            notInIdx = i;
            isAllIn = false;
            break;
        }
        if (!isAllIn) {
            bPList = new ArrayList<Object>();
            bPList.addAll(aPList.subList(notInIdx, aPList.size()));
            bPList.addAll(aPList.subList(1, notInIdx));
            bPList.add((PointD)bPList.get(0));
            newLines.add(bPList);
        } else {
            newPolygons.add(inPolygon);
            return newPolygons;
lbl29:
            // 1 sources

            newLines.add(aPList);
        }
        holeLines = new ArrayList<List<PointD>>();
        if (inPolygon.hasHole()) {
            for (h = 0; h < inPolygon.getHoleLines().size(); ++h) {
                holePList = inPolygon.getHoleLines().get(h);
                plExtent = GeometryUtil.getPointsExtent(holePList);
                if (!GeoComputation.isExtentCross(plExtent, extent)) continue;
                if (GeoComputation.pointInClipObj(extent, holePList.get(0))) {
                    isAllIn = true;
                    notInIdx = 0;
                    for (i = 0; i < holePList.size(); ++i) {
                        if (GeoComputation.pointInClipObj(extent, holePList.get(i))) continue;
                        notInIdx = i;
                        isAllIn = false;
                        break;
                    }
                    if (!isAllIn) {
                        bPList = new ArrayList<Object>();
                        bPList.addAll(holePList.subList(notInIdx, holePList.size()));
                        bPList.addAll(holePList.subList(1, notInIdx));
                        bPList.add((PointD)bPList.get(0));
                        newLines.add(bPList);
                        continue;
                    }
                    holeLines.add(inPolygon.getHoleLines().get(h));
                    continue;
                }
                newLines.add(holePList);
            }
        }
        borderList = new ArrayList<BorderPoint>();
        aBP = new BorderPoint();
        clipPList = GeoComputation.getClipPointList(extent);
        for (i = 0; i < clipPList.size(); ++i) {
            aBP = new BorderPoint();
            aBP.Point = (PointD)clipPList.get(i).clone();
            aBP.Id = -1;
            switch (i) {
                case 0: {
                    aBP.rectPointType = RectPointTypes.LeftBottom;
                    break;
                }
                case 1: {
                    aBP.rectPointType = RectPointTypes.LeftTop;
                    break;
                }
                case 2: {
                    aBP.rectPointType = RectPointTypes.RightTop;
                    break;
                }
                case 3: {
                    aBP.rectPointType = RectPointTypes.RightBottom;
                    break;
                }
                case 4: {
                    aBP.rectPointType = RectPointTypes.LeftBottom;
                }
            }
            borderList.add(aBP);
        }
        for (l = 0; l < newLines.size(); ++l) {
            aPList = (List)newLines.get(l);
            isInPolygon = false;
            IPoint = new PointD();
            newPlist = new ArrayList<PointD>();
            p1 = (PointD)((PointD)aPList.get(0)).clone();
            inIdx = -1;
            outIdx = -1;
            newLine = true;
            a1 = 0;
            for (i = 1; i < aPList.size(); ++i) {
                p2 = (PointD)((PointD)aPList.get(i)).clone();
                if (GeoComputation.pointInClipObj(extent, p2)) {
                    if (!isInPolygon) {
                        lineA = new Line();
                        lineA.P1 = p1;
                        lineA.P2 = p2;
                        q1 = (PointD)((BorderPoint)borderList.get((int)0)).Point.clone();
                        for (j = 1; j < borderList.size(); ++j) {
                            q2 = (PointD)((BorderPoint)borderList.get((int)j)).Point.clone();
                            lineB = new Line();
                            lineB.P1 = q1;
                            lineB.P2 = q2;
                            if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                                IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                                aBP = new BorderPoint();
                                aBP.Id = newPolylines.size();
                                aBP.Point = (PointD)IPoint.clone();
                                borderList.add(j, aBP);
                                inIdx = j;
                                break;
                            }
                            q1 = q2;
                        }
                        newPlist.add(IPoint);
                    }
                    newPlist.add((PointD)aPList.get(i));
                    isInPolygon = true;
                } else if (isInPolygon) {
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    q1 = (PointD)((BorderPoint)borderList.get((int)0)).Point.clone();
                    for (j = 1; j < borderList.size(); ++j) {
                        q2 = (PointD)((BorderPoint)borderList.get((int)j)).Point.clone();
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (GeoComputation.isLineSegmentCross(lineA, lineB)) {
                            if (!newLine) {
                                if (inIdx - outIdx >= 1 && inIdx - outIdx <= 10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx, aBP);
                                    }
                                } else if (inIdx - outIdx <= -1 && inIdx - outIdx >= -10) {
                                    if (!GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx + 1, aBP);
                                    }
                                } else if (inIdx == outIdx && !GeoComputation.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(inIdx + 1, aBP);
                                }
                            }
                            IPoint = GeoComputation.getCrossPoint(lineA, lineB);
                            aBP = new BorderPoint();
                            aBP.Id = newPolylines.size();
                            aBP.Point = (PointD)IPoint.clone();
                            borderList.add(j, aBP);
                            outIdx = j;
                            a1 = inIdx;
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                    bLine = new Polyline();
                    bLine.setPointList(new ArrayList<E>(newPlist));
                    newPolylines.add(bLine);
                    isInPolygon = false;
                    newPlist = new ArrayList<E>();
                } else {
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    clippedBPs = GeoComputation.getCrossPoints(lineA, extent);
                    v0 = isOK = clippedBPs.size() > 1;
                    if (clippedBPs.size() == 2 && clippedBPs.get((int)0).rectPointType == clippedBPs.get((int)1).rectPointType) {
                        isOK = false;
                    }
                    if (isOK) {
                        newPlist = new ArrayList<E>();
                        block21: for (j = 0; j < clippedBPs.size(); ++j) {
                            cBP = clippedBPs.get(j);
                            cBP.Id = newPolylines.size();
                            newPlist.add((PointD)cBP.Point.clone());
                            switch (1.$SwitchMap$org$meteoinfo$geometry$geoprocess$RectPointTypes[cBP.rectPointType.ordinal()]) {
                                case 1: {
                                    for (k = 0; k < borderList.size(); ++k) {
                                        if (((BorderPoint)borderList.get((int)k)).rectPointType != RectPointTypes.LeftBottom) continue;
                                        for (m = k; m < borderList.size(); ++m) {
                                            if (!(cBP.Point.Y <= ((BorderPoint)borderList.get((int)m)).Point.Y)) continue;
                                            borderList.add(m, cBP);
                                            continue block21;
                                        }
                                        continue block21;
                                    }
                                    continue block21;
                                }
                                case 2: {
                                    for (k = 0; k < borderList.size(); ++k) {
                                        if (((BorderPoint)borderList.get((int)k)).rectPointType != RectPointTypes.LeftTop) continue;
                                        for (m = k; m < borderList.size(); ++m) {
                                            if (!(cBP.Point.X <= ((BorderPoint)borderList.get((int)m)).Point.X)) continue;
                                            borderList.add(m, cBP);
                                            continue block21;
                                        }
                                        continue block21;
                                    }
                                    continue block21;
                                }
                                case 3: {
                                    for (k = 0; k < borderList.size(); ++k) {
                                        if (((BorderPoint)borderList.get((int)k)).rectPointType != RectPointTypes.RightTop) continue;
                                        for (m = k; m < borderList.size(); ++m) {
                                            if (!(((BorderPoint)borderList.get((int)m)).Point.Y <= cBP.Point.Y)) continue;
                                            borderList.add(m, cBP);
                                            continue block21;
                                        }
                                        continue block21;
                                    }
                                    continue block21;
                                }
                                case 4: {
                                    for (k = 0; k < borderList.size(); ++k) {
                                        if (((BorderPoint)borderList.get((int)k)).rectPointType != RectPointTypes.RightBottom) continue;
                                        for (m = k; m < borderList.size(); ++m) {
                                            if (!(((BorderPoint)borderList.get((int)m)).Point.X <= cBP.Point.X)) continue;
                                            borderList.add(m, cBP);
                                            continue block21;
                                        }
                                        continue block21;
                                    }
                                    continue block21;
                                }
                            }
                        }
                        bLine = new Polyline();
                        bLine.setPointList(new ArrayList<E>(newPlist));
                        newPolylines.add(bLine);
                        isInPolygon = false;
                        newPlist = new ArrayList<E>();
                    }
                }
                p1 = p2;
            }
        }
        if (newPolylines.size() > 0) {
            if (aBP.Id >= newPolylines.size()) {
                return newPolygons;
            }
            newPolygons = GeoComputation.tracingClipPolygons(inPolygon, newPolylines, borderList);
        } else if (GeoComputation.pointInClipObj(aPList, clipPList.get(0))) {
            if (!GeoComputation.isClockwise(clipPList)) {
                Collections.reverse(clipPList);
            }
            aPolygon = new Polygon();
            aPolygon.setOutLine(new ArrayList<PointD>(clipPList));
            newPolygons.add(aPolygon);
        }
        if (holeLines.size() > 0) {
            GeoComputation.addHoles_Ring(newPolygons, holeLines);
        }
        return newPolygons;
    }

    private static List<Polygon> tracingClipPolygons(Polygon inPolygon, List<Polyline> LineList, List<BorderPoint> borderList) {
        int i;
        if (LineList.isEmpty()) {
            return new ArrayList<Polygon>();
        }
        ArrayList<Polygon> aPolygonList = new ArrayList<Polygon>();
        ArrayList<Polyline> aLineList = new ArrayList<Polyline>(LineList);
        ArrayList<Object> aPList = new ArrayList<Object>();
        int[] timesArray = new int[borderList.size() - 1];
        for (i = 0; i < timesArray.length; ++i) {
            timesArray[i] = 0;
        }
        int pNum = borderList.size() - 1;
        block1: for (i = 0; i < pNum; ++i) {
            Polygon aPolygon;
            int j;
            PointD aPoint;
            ArrayList<? extends PointD> newPList;
            Polyline aLine;
            BorderPoint bP;
            PointD bPoint;
            if (borderList.get((int)i).Id == -1) continue;
            int pIdx = i;
            aPList.clear();
            PointD b1Point = borderList.get((int)pIdx).Point;
            if (timesArray[pIdx] < 1) {
                aPList.add(borderList.get((int)pIdx).Point);
                if (++pIdx == pNum) {
                    pIdx = 0;
                }
                bPoint = (PointD)borderList.get((int)pIdx).Point.clone();
                if (borderList.get((int)pIdx).Id > -1) {
                    bPoint.X = (bPoint.X + b1Point.X) / 2.0;
                    bPoint.Y = (bPoint.Y + b1Point.Y) / 2.0;
                }
                if (GeoComputation.pointInPolygon(inPolygon, bPoint)) {
                    while (true) {
                        bP = borderList.get(pIdx);
                        if (bP.Id == -1) {
                            if (timesArray[pIdx] == 1) break;
                            aPList.add(bP.Point);
                            int n = pIdx;
                            timesArray[n] = timesArray[n] + 1;
                        } else {
                            if (timesArray[pIdx] == 1) break;
                            int n = pIdx;
                            timesArray[n] = timesArray[n] + 1;
                            aLine = (Polyline)aLineList.get(bP.Id);
                            newPList = new ArrayList<PointD>(aLine.getPointList());
                            aPoint = (PointD)newPList.get(0);
                            if (!MIMath.doubleEquals((double)bP.Point.X, (double)aPoint.X) || !MIMath.doubleEquals((double)bP.Point.Y, (double)aPoint.Y)) {
                                Collections.reverse(newPList);
                            }
                            aPList.addAll(newPList);
                            for (j = 0; j < borderList.size() - 1; ++j) {
                                if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                                int n2 = pIdx = j;
                                timesArray[n2] = timesArray[n2] + 1;
                                break;
                            }
                        }
                        if (pIdx == i) {
                            if (aPList.size() <= 0) break;
                            aPolygon = new Polygon();
                            aPolygon.setOutLine(new ArrayList(aPList));
                            aPolygonList.add(aPolygon);
                            break;
                        }
                        if (++pIdx != pNum) continue;
                        pIdx = 0;
                    }
                }
            }
            if (timesArray[pIdx = i] >= 1) continue;
            aPList.clear();
            aPList.add(borderList.get((int)pIdx).Point);
            if (--pIdx == -1) {
                pIdx = pNum - 1;
            }
            bPoint = (PointD)borderList.get((int)pIdx).Point.clone();
            if (borderList.get((int)pIdx).Id > -1) {
                bPoint.X = (bPoint.X + b1Point.X) / 2.0;
                bPoint.Y = (bPoint.Y + b1Point.Y) / 2.0;
            }
            if (!GeoComputation.pointInPolygon(inPolygon, bPoint)) continue;
            while (true) {
                bP = borderList.get(pIdx);
                if (bP.Id == -1) {
                    if (timesArray[pIdx] == 1) continue block1;
                    aPList.add(bP.Point);
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                } else {
                    if (timesArray[pIdx] == 1) continue block1;
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                    aLine = (Polyline)aLineList.get(bP.Id);
                    newPList = new ArrayList<PointD>(aLine.getPointList());
                    aPoint = (PointD)newPList.get(0);
                    if (!MIMath.doubleEquals((double)bP.Point.X, (double)aPoint.X) || !MIMath.doubleEquals((double)bP.Point.Y, (double)aPoint.Y)) {
                        Collections.reverse(newPList);
                    }
                    aPList.addAll(newPList);
                    for (j = 0; j < borderList.size() - 1; ++j) {
                        if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                        int n3 = pIdx = j;
                        timesArray[n3] = timesArray[n3] + 1;
                        break;
                    }
                }
                if (pIdx == i) {
                    if (aPList.size() <= 0) continue block1;
                    aPolygon = new Polygon();
                    Collections.reverse(aPList);
                    aPolygon.setOutLine(new ArrayList(aPList));
                    aPolygonList.add(aPolygon);
                    continue block1;
                }
                if (--pIdx != -1) continue;
                pIdx = pNum - 1;
            }
        }
        ArrayList<Polygon> newPolygonlist = new ArrayList<Polygon>(aPolygonList);
        return newPolygonlist;
    }

    private static void addHoles_Ring(List<Polygon> polygonList, List<List<PointD>> holeList) {
        block0: for (int i = 0; i < holeList.size(); ++i) {
            List<PointD> holePs = holeList.get(i);
            Extent aExtent = GeometryUtil.getPointsExtent(holePs);
            for (int j = 0; j < polygonList.size(); ++j) {
                Polygon aPolygon = polygonList.get(j);
                if (!aPolygon.getExtent().include(aExtent)) continue;
                boolean isHole = true;
                for (PointD aP : holePs) {
                    if (GeoComputation.pointInPolygon(aPolygon.getOutLine(), aP)) continue;
                    isHole = false;
                    break;
                }
                if (!isHole) continue;
                aPolygon.addHole(holePs);
                continue block0;
            }
        }
    }

    protected static boolean isExtentCross(Extent aExtent, Object clipObj) {
        if (clipObj instanceof List) {
            Extent bExtent = GeometryUtil.getPointsExtent((List)clipObj);
            return MIMath.isExtentCross((Extent)aExtent, (Extent)bExtent);
        }
        if (clipObj.getClass() == ClipLine.class) {
            return ((ClipLine)clipObj).isExtentCross(aExtent);
        }
        if (clipObj instanceof Extent) {
            return MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)clipObj));
        }
        return false;
    }

    protected static boolean pointInClipObj(Object clipObj, PointD aPoint) {
        if (clipObj instanceof List) {
            return GeoComputation.pointInPolygon((List)clipObj, aPoint);
        }
        if (clipObj.getClass() == ClipLine.class) {
            return ((ClipLine)clipObj).isInside(aPoint);
        }
        if (clipObj instanceof Extent) {
            return MIMath.pointInExtent((PointD)aPoint, (Extent)((Extent)clipObj));
        }
        return false;
    }

    protected static List<PointD> getClipPointList(Object clipObj) {
        ArrayList<PointD> clipPList = new ArrayList();
        if (clipObj instanceof List) {
            clipPList = (List)clipObj;
        }
        if (clipObj.getClass() == ClipLine.class) {
            ClipLine clipLine = (ClipLine)clipObj;
            if (clipLine.isLongitude()) {
                for (int i = -100; i <= 100; ++i) {
                    clipPList.add(new PointD(clipLine.getValue(), (double)i));
                }
            } else {
                for (int i = -370; i <= 370; ++i) {
                    clipPList.add(new PointD((double)i, clipLine.getValue()));
                }
            }
        }
        if (clipObj instanceof Extent) {
            Extent aExtent = (Extent)clipObj;
            clipPList.add(new PointD(aExtent.minX, aExtent.minY));
            clipPList.add(new PointD(aExtent.minX, aExtent.maxY));
            clipPList.add(new PointD(aExtent.maxX, aExtent.maxY));
            clipPList.add(new PointD(aExtent.maxX, aExtent.minY));
            clipPList.add((PointD)((PointD)clipPList.get(0)).clone());
        }
        return clipPList;
    }

    protected static List<PointD> getClipPointList(Object clipObj, boolean z) {
        ArrayList<PointD> clipPList = new ArrayList();
        if (clipObj instanceof List) {
            clipPList = (List)clipObj;
        }
        if (clipObj.getClass() == ClipLine.class) {
            ClipLine clipLine = (ClipLine)clipObj;
            if (z) {
                if (clipLine.isLongitude()) {
                    for (int i = -100; i <= 100; ++i) {
                        clipPList.add(new PointZ(clipLine.getValue(), i, 0.0));
                    }
                } else {
                    for (int i = -370; i <= 370; ++i) {
                        clipPList.add(new PointZ(i, clipLine.getValue(), 0.0));
                    }
                }
            } else if (clipLine.isLongitude()) {
                for (int i = -100; i <= 100; ++i) {
                    clipPList.add(new PointD(clipLine.getValue(), (double)i));
                }
            } else {
                for (int i = -370; i <= 370; ++i) {
                    clipPList.add(new PointD((double)i, clipLine.getValue()));
                }
            }
        }
        if (clipObj instanceof Extent) {
            Extent aExtent = (Extent)clipObj;
            if (z) {
                clipPList.add(new PointZ(aExtent.minX, aExtent.minY, 0.0));
                clipPList.add(new PointZ(aExtent.minX, aExtent.maxY, 0.0));
                clipPList.add(new PointZ(aExtent.maxX, aExtent.maxY, 0.0));
                clipPList.add(new PointZ(aExtent.maxX, aExtent.minY, 0.0));
                clipPList.add((PointZ)((PointD)clipPList.get(0)).clone());
            } else {
                clipPList.add(new PointD(aExtent.minX, aExtent.minY));
                clipPList.add(new PointD(aExtent.minX, aExtent.maxY));
                clipPList.add(new PointD(aExtent.maxX, aExtent.maxY));
                clipPList.add(new PointD(aExtent.maxX, aExtent.minY));
                clipPList.add((PointD)((PointD)clipPList.get(0)).clone());
            }
        }
        return clipPList;
    }

    private static boolean isLineSegmentCross_old(Line lineA, Line lineB) {
        ArrayList<PointD> PListA = new ArrayList<PointD>();
        ArrayList<PointD> PListB = new ArrayList<PointD>();
        PListA.add(lineA.P1);
        PListA.add(lineA.P2);
        PListB.add(lineB.P1);
        PListB.add(lineB.P2);
        Extent boundA = GeometryUtil.getPointsExtent(PListA);
        Extent boundB = GeometryUtil.getPointsExtent(PListB);
        if (!MIMath.isExtentCross((Extent)boundA, (Extent)boundB).booleanValue()) {
            return false;
        }
        double XP1 = (lineB.P1.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P1.Y - lineA.P1.Y);
        double XP2 = (lineB.P2.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P2.Y - lineA.P1.Y);
        return !(XP1 * XP2 > 0.0);
    }

    protected static boolean isLineSegmentCross(Line lineA, Line lineB) {
        ArrayList<PointD> PListA = new ArrayList<PointD>();
        ArrayList<PointD> PListB = new ArrayList<PointD>();
        PListA.add(lineA.P1);
        PListA.add(lineA.P2);
        PListB.add(lineB.P1);
        PListB.add(lineB.P2);
        Extent boundA = new Extent(Math.min(lineA.P1.X, lineA.P2.X), Math.max(lineA.P1.X, lineA.P2.X), Math.min(lineA.P1.Y, lineA.P2.Y), Math.max(lineA.P1.Y, lineA.P2.Y));
        Extent boundB = new Extent(Math.min(lineB.P1.X, lineB.P2.X), Math.max(lineB.P1.X, lineB.P2.X), Math.min(lineB.P1.Y, lineB.P2.Y), Math.max(lineB.P1.Y, lineB.P2.Y));
        if (!MIMath.isExtentCross((Extent)boundA, (Extent)boundB).booleanValue()) {
            return false;
        }
        double d1 = GeoComputation.crossProduct(lineA.P1, lineA.P2, lineB.P1);
        double d2 = GeoComputation.crossProduct(lineA.P1, lineA.P2, lineB.P2);
        double d3 = GeoComputation.crossProduct(lineB.P1, lineB.P2, lineA.P1);
        double d4 = GeoComputation.crossProduct(lineB.P1, lineB.P2, lineA.P2);
        if (d1 * d2 < 0.0 && d3 * d4 < 0.0) {
            return true;
        }
        if (d1 == 0.0 && GeoComputation.pointProduct(lineB.P1, lineA.P1, lineA.P2) <= 0.0) {
            return true;
        }
        if (d2 == 0.0 && GeoComputation.pointProduct(lineB.P2, lineA.P1, lineA.P2) <= 0.0) {
            return true;
        }
        if (d3 == 0.0 && GeoComputation.pointProduct(lineA.P1, lineB.P1, lineB.P2) <= 0.0) {
            return true;
        }
        return d4 == 0.0 && GeoComputation.pointProduct(lineA.P2, lineB.P1, lineB.P2) <= 0.0;
    }

    public static double crossProduct(PointD p1, PointD p2, PointD p3) {
        return (p2.X - p1.X) * (p3.Y - p1.Y) - (p3.X - p1.X) * (p2.Y - p1.Y);
    }

    public static double pointProduct(PointD p1, PointD p2, PointD p3) {
        return (p2.X - p1.X) * (p3.X - p1.X) + (p2.Y - p1.Y) * (p3.Y - p1.Y);
    }

    private static boolean lineIntersectRect(Line line, Extent extent) {
        boolean result = false;
        result |= GeoComputation.checkRectLineH(line.P1, line.P2, extent.minY, extent.minX, extent.maxX);
        result |= GeoComputation.checkRectLineH(line.P1, line.P2, extent.maxY, extent.minX, extent.maxX);
        result |= GeoComputation.checkRectLineV(line.P1, line.P2, extent.minX, extent.minY, extent.maxY);
        return result |= GeoComputation.checkRectLineV(line.P1, line.P2, extent.maxX, extent.minY, extent.maxY);
    }

    private static boolean checkRectLineH(PointD start, PointD end, double y0, double x1, double x2) {
        if (y0 < start.Y && y0 < end.Y) {
            return false;
        }
        if (y0 > start.Y && y0 > end.Y) {
            return false;
        }
        if (start.Y == end.Y) {
            if (y0 == start.Y) {
                if (start.X < x1 && end.X < x1) {
                    return false;
                }
                return !(start.X > x2) || !(end.X > x2);
            }
            return false;
        }
        double x = (end.X - start.X) * (y0 - start.Y) / (end.Y - start.Y) + start.X;
        return x >= x1 && x <= x2;
    }

    private static boolean checkRectLineV(PointD start, PointD end, double x0, double y1, double y2) {
        if (x0 < start.X && x0 < end.X) {
            return false;
        }
        if (x0 > start.X && x0 > end.X) {
            return false;
        }
        if (start.X == end.X) {
            if (x0 == start.X) {
                if (start.Y < y1 && end.Y < y1) {
                    return false;
                }
                return !(start.Y > y2) || !(end.Y > y2);
            }
            return false;
        }
        double y = (end.Y - start.Y) * (x0 - start.X) / (end.X - start.X) + start.Y;
        return y >= y1 && y <= y2;
    }

    private static List<BorderPoint> getCrossPoints(Line line, Extent extent) {
        double x;
        BorderPoint bp;
        double y;
        ArrayList<BorderPoint> crossPoints = new ArrayList<BorderPoint>();
        if (line.P1.X <= extent.minX && line.P2.X <= extent.minX) {
            return crossPoints;
        }
        if (line.P1.X >= extent.maxX && line.P2.X >= extent.maxX) {
            return crossPoints;
        }
        if (line.P1.Y <= extent.minY && line.P2.Y <= extent.minY) {
            return crossPoints;
        }
        if (line.P1.Y >= extent.maxY && line.P2.Y >= extent.maxY) {
            return crossPoints;
        }
        if (Math.abs(line.P1.X - line.P2.X) - Math.abs(line.P1.X - extent.minX) > 0.0 && (y = (line.P2.Y - line.P1.Y) * (extent.minX - line.P1.X) / (line.P2.X - line.P1.X) + line.P1.Y) >= extent.minY && y <= extent.maxY) {
            bp = new BorderPoint();
            bp.rectPointType = RectPointTypes.Left;
            bp.Point = new PointD(extent.minX, y);
            crossPoints.add(bp);
        }
        if (Math.abs(line.P1.Y - line.P2.Y) - Math.abs(line.P1.Y - extent.maxY) > 0.0 && (x = (extent.maxY - line.P1.Y) * (line.P2.X - line.P1.X) / (line.P2.Y - line.P1.Y) + line.P1.X) >= extent.minX && x <= extent.maxX) {
            bp = new BorderPoint();
            bp.rectPointType = RectPointTypes.Top;
            bp.Point = new PointD(x, extent.maxY);
            crossPoints.add(bp);
        }
        if (Math.abs(line.P1.X - line.P2.X) - Math.abs(line.P1.X - extent.maxX) > 0.0 && (y = (line.P2.Y - line.P1.Y) * (extent.maxX - line.P1.X) / (line.P2.X - line.P1.X) + line.P1.Y) >= extent.minY && y <= extent.maxY) {
            bp = new BorderPoint();
            bp.rectPointType = RectPointTypes.Right;
            bp.Point = new PointD(extent.maxX, y);
            crossPoints.add(bp);
        }
        if (Math.abs(line.P1.Y - line.P2.Y) - Math.abs(line.P1.Y - extent.minY) > 0.0 && (x = (extent.minY - line.P1.Y) * (line.P2.X - line.P1.X) / (line.P2.Y - line.P1.Y) + line.P1.X) >= extent.minX && x <= extent.maxX) {
            bp = new BorderPoint();
            bp.rectPointType = RectPointTypes.Bottom;
            bp.Point = new PointD(x, extent.minY);
            crossPoints.add(bp);
        }
        return crossPoints;
    }

    protected static PointD getCrossPoint(Line lineA, Line lineB) {
        PointD IPoint = new PointD();
        double XP1 = (lineB.P1.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P1.Y - lineA.P1.Y);
        double XP2 = (lineB.P2.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P2.Y - lineA.P1.Y);
        if (XP1 == 0.0) {
            IPoint = lineB.P1;
        } else if (XP2 == 0.0) {
            IPoint = lineB.P2;
        } else {
            PointD p1 = lineA.P1;
            PointD p2 = lineA.P2;
            PointD q1 = lineB.P1;
            PointD q2 = lineB.P2;
            double tempLeft = (q2.X - q1.X) * (p1.Y - p2.Y) - (p2.X - p1.X) * (q1.Y - q2.Y);
            double tempRight = (p1.Y - q1.Y) * (p2.X - p1.X) * (q2.X - q1.X) + q1.X * (q2.Y - q1.Y) * (p2.X - p1.X) - p1.X * (p2.Y - p1.Y) * (q2.X - q1.X);
            IPoint.X = tempRight / tempLeft;
            tempLeft = (p1.X - p2.X) * (q2.Y - q1.Y) - (p2.Y - p1.Y) * (q1.X - q2.X);
            tempRight = p2.Y * (p1.X - p2.X) * (q2.Y - q1.Y) + (q2.X - p2.X) * (q2.Y - q1.Y) * (p1.Y - p2.Y) - q2.Y * (q1.X - q2.X) * (p2.Y - p1.Y);
            IPoint.Y = tempRight / tempLeft;
        }
        if (lineA.P1 instanceof PointZ) {
            return new PointZ(IPoint.X, IPoint.Y, ((PointZ)lineA.P1).Z, ((PointZ)lineA.P1).M);
        }
        return IPoint;
    }

    private static boolean twoPointsInside(int a1, int a2, int b1, int b2) {
        if (a2 < a1) {
            int c = a1;
            a1 = a2;
            a2 = c;
        }
        if (b1 >= a1 && b1 <= a2) {
            return b2 >= a1 && b2 <= a2;
        }
        return b2 < a1 || b2 > a2;
    }
}

