/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class CubicShape
extends Shape {
    private List<PointZ> points;
    private int[][] index = new int[][]{{0, 2, 3, 1}, {0, 4, 6, 2}, {0, 1, 5, 4}, {4, 5, 7, 6}, {1, 3, 7, 5}, {2, 6, 7, 3}};
    private int[][] lineIndex = new int[][]{{0, 1}, {0, 2}, {0, 4}, {1, 3}, {1, 5}, {2, 3}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};

    public CubicShape() {
        this.points = new ArrayList<PointZ>();
        for (int i = 0; i < 8; ++i) {
            this.points.add(new PointZ());
        }
        this.setExtent(GeometryUtil.getPointsExtent(this.points));
    }

    public CubicShape(List<PointZ> points) {
        this.points = points;
        this.setExtent(GeometryUtil.getPointsExtent(this.points));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.CUBIC;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        return null;
    }

    public List<PointZ> getPoints() {
        return this.points;
    }

    @Override
    public void setPoints(List<? extends PointD> value) {
        this.points = value;
        this.setExtent(GeometryUtil.getPointsExtent(this.points));
    }

    public int[][] getIndex() {
        return this.index;
    }

    public int[] getIndex(int i) {
        return this.index[i];
    }

    public void setIndex(int[][] value) {
        this.index = value;
    }

    public int[][] getLineIndex() {
        return this.lineIndex;
    }

    public int[] getLineIndex(int i) {
        return this.lineIndex[i];
    }
}

