/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class WindArrow3D
extends PointZShape {
    public double u;
    public double v;
    public double w;
    public float scale = 1.0f;
    private float headWith = 1.0f;
    private float headLength = 2.5f;

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.WIND_ARROW;
    }

    public float getHeadWith() {
        return this.headWith;
    }

    public void setHeadWith(float value) {
        this.headWith = value;
    }

    public float getHeadLength() {
        return this.headLength;
    }

    public void setHeadLength(float value) {
        this.headLength = value;
    }

    public PointZ getEndPoint() {
        PointZ sp = (PointZ)this.getPoint();
        PointZ ed = new PointZ();
        ed.X = sp.X + this.u * (double)this.scale;
        ed.Y = sp.Y + this.v * (double)this.scale;
        ed.Z = sp.Z + this.w * (double)this.scale;
        return ed;
    }

    @Override
    public Object clone() {
        WindArrow3D aWA = new WindArrow3D();
        aWA.u = this.u;
        aWA.v = this.v;
        aWA.w = this.w;
        aWA.scale = this.scale;
        aWA.setPoint(this.getPoint());
        aWA.setValue(this.getValue());
        return aWA;
    }
}

