/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class CircleShape
extends PolygonShape {
    public CircleShape() {
    }

    public CircleShape(double x, double y, double radius) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x - radius, y));
        points.add(new PointD(x, y - radius));
        points.add(new PointD(x + radius, y));
        points.add(new PointD(x, y + radius));
        super.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.CIRCLE;
    }

    public PointD getCenter() {
        return this.getExtent().getCenterPoint();
    }

    public double getRadius() {
        return this.getExtent().getHeight() / 2.0;
    }

    @Override
    public boolean contains(Shape other) {
        if (other instanceof PointShape) {
            return this.contains(((PointShape)other).point);
        }
        PointD center = this.getCenter();
        double radius = this.getRadius();
        boolean isIn = true;
        for (PointD pointD : other.getPoints()) {
            if (!(GeoComputation.distance(pointD, center) > radius)) continue;
            isIn = false;
            break;
        }
        return isIn;
    }

    public boolean contains(PointD p) {
        PointD center = this.getCenter();
        double radius = this.getRadius();
        return GeoComputation.distance(p, center) <= radius;
    }

    @Override
    public Object clone() {
        CircleShape aPGS = new CircleShape();
        aPGS.setExtent(this.getExtent());
        aPGS.setPoints(this.getPoints());
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        return aPGS;
    }
}

