/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.geometry.legend.ArrowBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.HatchStyle;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.MarkerType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LegendScheme {
    private String fieldName = "";
    private LegendType legendType = LegendType.SINGLE_SYMBOL;
    private ShapeTypes shapeType;
    private List<ColorBreak> legendBreaks;
    private boolean hasNoData;
    private double minValue;
    private double maxValue;
    private double undef;
    private Map<Object, ColorBreak> uniqueValueMap;

    public LegendScheme() {
        this.shapeType = ShapeTypes.IMAGE;
        this.legendBreaks = new ArrayList<ColorBreak>();
    }

    public LegendScheme(ShapeTypes aShapeType) {
        this.shapeType = aShapeType;
        this.legendBreaks = new ArrayList<ColorBreak>();
    }

    public LegendScheme(ShapeTypes aShapeType, int n) {
        this.shapeType = aShapeType;
        this.legendBreaks = new ArrayList<ColorBreak>();
        for (int i = 0; i < n; ++i) {
            ColorBreak cb;
            switch (aShapeType) {
                case POINT: {
                    cb = new PointBreak();
                    this.legendBreaks.add(cb);
                    break;
                }
                case POLYLINE: {
                    cb = new PolylineBreak();
                    this.legendBreaks.add(cb);
                    break;
                }
                case POLYGON: {
                    cb = new PolygonBreak();
                    this.legendBreaks.add(cb);
                    break;
                }
                default: {
                    cb = new ColorBreak();
                    this.legendBreaks.add(cb);
                }
            }
            cb.setColor(ColorUtil.getCommonColor((int)i));
        }
    }

    public LegendScheme(List<ColorBreak> lbs) {
        this.legendBreaks = lbs;
        ColorBreak lb = lbs.get(0);
        switch (lb.getBreakType()) {
            case POINT_BREAK: {
                this.shapeType = ShapeTypes.POINT;
                break;
            }
            case POLYLINE_BREAK: {
                this.shapeType = ShapeTypes.POLYLINE;
                break;
            }
            case POLYGON_BREAK: {
                this.shapeType = ShapeTypes.POLYGON;
                break;
            }
            default: {
                this.shapeType = ShapeTypes.IMAGE;
            }
        }
        this.legendType = lbs.size() == 1 ? LegendType.SINGLE_SYMBOL : (lbs.get(0).getStartValue() == lbs.get(0).getEndValue() ? LegendType.UNIQUE_VALUE : LegendType.GRADUATED_COLOR);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fn) {
        this.fieldName = fn;
    }

    public boolean isGeometry() {
        return this.fieldName.equals("Geometry_M") || this.fieldName.equals("Geometry_Z");
    }

    public LegendType getLegendType() {
        return this.legendType;
    }

    public void setLegendType(LegendType lt) {
        this.legendType = lt;
        if (lt == LegendType.UNIQUE_VALUE) {
            this.updateUniqueValueMap();
        }
    }

    public ShapeTypes getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeTypes st) {
        this.shapeType = st;
    }

    public BreakTypes getBreakType() {
        BreakTypes breakType = BreakTypes.COLOR_BREAK;
        switch (this.shapeType) {
            case POINT: 
            case POINT_M: 
            case POINT_Z: {
                breakType = BreakTypes.POINT_BREAK;
                break;
            }
            case POLYLINE: 
            case POLYLINE_M: 
            case POLYLINE_Z: {
                breakType = BreakTypes.POLYLINE_BREAK;
                break;
            }
            case POLYGON: 
            case POLYGON_M: 
            case POLYGON_Z: {
                breakType = BreakTypes.POLYGON_BREAK;
            }
        }
        return breakType;
    }

    public List<ColorBreak> getLegendBreaks() {
        return this.legendBreaks;
    }

    public ColorBreak getLegendBreak(int i) {
        return this.legendBreaks.get(i);
    }

    public void setLegendBreaks(List<ColorBreak> breaks) {
        this.legendBreaks = breaks;
        if (this.legendType == LegendType.UNIQUE_VALUE) {
            this.updateUniqueValueMap();
        }
    }

    public void setLegendBreak(int i, ColorBreak value) {
        this.legendBreaks.set(i, value);
    }

    public boolean getHasNoData() {
        return this.hasNoData;
    }

    public void setHasNoData(boolean istrue) {
        this.hasNoData = istrue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double min) {
        this.minValue = min;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
    }

    public double getUndefValue() {
        return this.undef;
    }

    public void setUndefValue(double uv) {
        this.undef = uv;
    }

    public int getBreakNum() {
        return this.legendBreaks.size();
    }

    public int getVisibleBreakNum() {
        int n = 0;
        for (ColorBreak aCB : this.legendBreaks) {
            if (!aCB.isDrawShape()) continue;
            ++n;
        }
        return n;
    }

    public int VisibleBreakNum() {
        int n = 0;
        for (ColorBreak aCB : this.legendBreaks) {
            if (!aCB.isDrawShape()) continue;
            ++n;
        }
        return n;
    }

    public void addLegendBreak(ColorBreak lb) {
        this.legendBreaks.add(lb);
        if (this.legendType == LegendType.UNIQUE_VALUE) {
            this.updateUniqueValueMap();
        }
    }

    public void addLegendBreak(List<ColorBreak> lb) {
        this.legendBreaks.addAll(lb);
        if (this.legendType == LegendType.UNIQUE_VALUE) {
            this.updateUniqueValueMap();
        }
    }

    public List<ColorBreak> findBreaks(List<Double> values) {
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        for (double v : values) {
            cbs.add(this.findLegendBreak(v));
        }
        return cbs;
    }

    public ColorBreak findLegendBreak(Number v) {
        switch (this.legendType) {
            case SINGLE_SYMBOL: {
                return this.legendBreaks.get(0);
            }
            case UNIQUE_VALUE: {
                if (this.uniqueValueMap == null || this.uniqueValueMap.size() != this.legendBreaks.size()) {
                    this.updateUniqueValueMap();
                }
                if (this.uniqueValueMap.containsKey(v)) {
                    return this.uniqueValueMap.get(v);
                }
                return this.legendBreaks.get(0);
            }
        }
        for (ColorBreak cb : this.legendBreaks) {
            double ev;
            double sv = Double.parseDouble(cb.getStartValue().toString());
            if (!(sv == (ev = Double.parseDouble(cb.getEndValue().toString())) ? v.doubleValue() == sv : v.doubleValue() >= sv && v.doubleValue() < ev)) continue;
            return cb;
        }
        if (v.doubleValue() >= this.getMaxValue()) {
            return this.legendBreaks.get(this.getBreakNum() - 1);
        }
        return this.legendBreaks.get(0);
    }

    public int legendBreakIndex(double v) {
        for (int i = 0; i < this.legendBreaks.size(); ++i) {
            double ev;
            ColorBreak cb = this.legendBreaks.get(i);
            double sv = Double.parseDouble(cb.getStartValue().toString());
            if (!(sv == (ev = Double.parseDouble(cb.getEndValue().toString())) ? v == sv : v >= sv && v < ev)) continue;
            return i;
        }
        if (v >= this.getMaxValue()) {
            return this.getBreakNum() - 1;
        }
        return 0;
    }

    public double[] getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.legendBreaks.size(); ++i) {
            ColorBreak cb = this.legendBreaks.get(i);
            if (cb.isNoData()) continue;
            if (values.isEmpty()) {
                if (this.legendType == LegendType.UNIQUE_VALUE) {
                    values.add(Double.parseDouble(cb.getEndValue().toString()));
                    continue;
                }
                values.add(Double.parseDouble(cb.getStartValue().toString()));
                values.add(Double.parseDouble(cb.getEndValue().toString()));
                continue;
            }
            values.add(Double.parseDouble(cb.getEndValue().toString()));
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            vs[i] = (Double)values.get(i);
        }
        return vs;
    }

    public List<Color> getColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < this.legendBreaks.size(); ++i) {
            colors.add(this.legendBreaks.get(i).getColor());
        }
        return colors;
    }

    private void updateUniqueValueMap() {
        this.uniqueValueMap = new HashMap<Object, ColorBreak>();
        boolean isDouble = true;
        for (ColorBreak cb : this.legendBreaks) {
            if (DataConvert.isDouble((String)cb.getStartValue().toString())) continue;
            isDouble = false;
            break;
        }
        if (isDouble) {
            for (ColorBreak cb : this.legendBreaks) {
                this.uniqueValueMap.put(Double.parseDouble(cb.getStartValue().toString()), cb);
            }
        } else {
            for (ColorBreak cb : this.legendBreaks) {
                this.uniqueValueMap.put(cb.getStartValue(), cb);
            }
        }
    }

    public void updateColors(ColorMap colorMap) {
        int n = this.legendBreaks.size();
        for (ColorBreak lb : this.legendBreaks) {
            if (!lb.isNoData()) continue;
            --n;
        }
        Color[] colors = colorMap.getColors(n);
        int i = 0;
        for (ColorBreak lb : this.legendBreaks) {
            if (lb.isNoData()) continue;
            lb.setColor(colors[i]);
            ++i;
        }
    }

    public void setFillColor(Color color) {
        for (ColorBreak lb : this.legendBreaks) {
            if (!lb.isNoData()) continue;
            lb.setColor(color);
        }
    }

    public LegendScheme convertTo(ShapeTypes shapeType) {
        if (this.shapeType == shapeType) {
            return this;
        }
        LegendScheme ls = new LegendScheme(shapeType);
        ls.fieldName = this.fieldName;
        ls.hasNoData = this.hasNoData;
        ls.legendType = this.legendType;
        ls.minValue = this.minValue;
        ls.maxValue = this.maxValue;
        ls.undef = this.undef;
        for (ColorBreak cb : this.legendBreaks) {
            switch (shapeType) {
                case POINT: {
                    PointBreak pb = new PointBreak();
                    pb.setColor(cb.getColor());
                    pb.setStartValue(cb.getStartValue());
                    pb.setEndValue(cb.getEndValue());
                    pb.setCaption(cb.getCaption());
                    pb.setNoData(cb.isNoData());
                    pb.setDrawShape(cb.isDrawShape());
                    pb.setTag(cb.getTag());
                    ls.legendBreaks.add(pb);
                    break;
                }
                case POLYLINE: {
                    PolylineBreak plb = new PolylineBreak();
                    plb.setColor(cb.getColor());
                    plb.setStartValue(cb.getStartValue());
                    plb.setEndValue(cb.getEndValue());
                    plb.setCaption(cb.getCaption());
                    plb.setNoData(cb.isNoData());
                    plb.setDrawShape(cb.isDrawShape());
                    plb.setTag(cb.getTag());
                    ls.legendBreaks.add(plb);
                    break;
                }
                case POLYGON: {
                    PolygonBreak pgb = new PolygonBreak();
                    pgb.setColor(cb.getColor());
                    pgb.setStartValue(cb.getStartValue());
                    pgb.setEndValue(cb.getEndValue());
                    pgb.setCaption(cb.getCaption());
                    pgb.setNoData(cb.isNoData());
                    pgb.setDrawShape(cb.isDrawShape());
                    pgb.setDrawOutline(false);
                    pgb.setTag(cb.getTag());
                    ls.legendBreaks.add(pgb);
                    break;
                }
                case IMAGE: {
                    ColorBreak ncb = new ColorBreak();
                    ncb.setColor(cb.getColor());
                    ncb.setStartValue(cb.getStartValue());
                    ncb.setEndValue(cb.getEndValue());
                    ncb.setCaption(cb.getCaption());
                    ncb.setNoData(cb.isNoData());
                    ncb.setDrawShape(cb.isDrawShape());
                    ncb.setTag(cb.getTag());
                    ls.legendBreaks.add(ncb);
                }
            }
        }
        return ls;
    }

    public LegendScheme convertTo(ShapeTypes shapeType, boolean edgeColor) {
        if (this.shapeType == shapeType) {
            return this;
        }
        LegendScheme ls = new LegendScheme(shapeType);
        ls.fieldName = this.fieldName;
        ls.hasNoData = this.hasNoData;
        ls.legendType = this.legendType;
        ls.minValue = this.minValue;
        ls.maxValue = this.maxValue;
        ls.undef = this.undef;
        for (ColorBreak cb : this.legendBreaks) {
            switch (shapeType) {
                case POINT: {
                    PointBreak pb = new PointBreak();
                    if (edgeColor) {
                        pb.setOutlineColor(cb.getColor());
                    } else {
                        pb.setColor(cb.getColor());
                    }
                    pb.setStartValue(cb.getStartValue());
                    pb.setEndValue(cb.getEndValue());
                    pb.setCaption(cb.getCaption());
                    pb.setNoData(cb.isNoData());
                    pb.setDrawShape(cb.isDrawShape());
                    pb.setTag(cb.getTag());
                    ls.legendBreaks.add(pb);
                    break;
                }
                case POLYLINE: {
                    PolylineBreak plb = new PolylineBreak();
                    plb.setColor(cb.getColor());
                    plb.setStartValue(cb.getStartValue());
                    plb.setEndValue(cb.getEndValue());
                    plb.setCaption(cb.getCaption());
                    plb.setNoData(cb.isNoData());
                    plb.setDrawShape(cb.isDrawShape());
                    plb.setTag(cb.getTag());
                    ls.legendBreaks.add(plb);
                    break;
                }
                case POLYGON: {
                    PolygonBreak pgb = new PolygonBreak();
                    if (edgeColor) {
                        pgb.setOutlineColor(cb.getColor());
                    } else {
                        pgb.setColor(cb.getColor());
                    }
                    pgb.setStartValue(cb.getStartValue());
                    pgb.setEndValue(cb.getEndValue());
                    pgb.setCaption(cb.getCaption());
                    pgb.setNoData(cb.isNoData());
                    pgb.setDrawShape(cb.isDrawShape());
                    pgb.setDrawOutline(true);
                    pgb.setTag(cb.getTag());
                    ls.legendBreaks.add(pgb);
                    break;
                }
                case IMAGE: {
                    ColorBreak ncb = new ColorBreak();
                    ncb.setColor(cb.getColor());
                    switch (this.shapeType) {
                        case POINT: {
                            if (!edgeColor) break;
                            ncb.setColor(((PointBreak)cb).getOutlineColor());
                            break;
                        }
                        case POLYGON: {
                            if (!edgeColor) break;
                            ncb.setColor(((PolygonBreak)cb).getOutlineColor());
                        }
                    }
                    ncb.setStartValue(cb.getStartValue());
                    ncb.setEndValue(cb.getEndValue());
                    ncb.setCaption(cb.getCaption());
                    ncb.setNoData(cb.isNoData());
                    ncb.setDrawShape(cb.isDrawShape());
                    ncb.setTag(cb.getTag());
                    ls.legendBreaks.add(ncb);
                }
            }
        }
        return ls;
    }

    public void asArrow() {
        if (this.getShapeType() != ShapeTypes.POINT) {
            return;
        }
        if (this.legendBreaks.get(0) instanceof ArrowBreak) {
            return;
        }
        for (int i = 0; i < this.legendBreaks.size(); ++i) {
            this.legendBreaks.set(i, new ArrowBreak((PointBreak)this.legendBreaks.get(i)));
        }
    }

    public void exportToXML(Document doc, Element parent) {
        Element root = doc.createElement("LegendScheme");
        Attr fieldNameAttr = doc.createAttribute("FieldName");
        Attr legendTypeAttr = doc.createAttribute("LegendType");
        Attr shapeTypeAttr = doc.createAttribute("ShapeType");
        Attr breakNumAttr = doc.createAttribute("BreakNum");
        Attr hasNoDataAttr = doc.createAttribute("HasNoData");
        Attr minValueAttr = doc.createAttribute("MinValue");
        Attr maxValueAttr = doc.createAttribute("MaxValue");
        Attr undefAttr = doc.createAttribute("UNDEF");
        fieldNameAttr.setValue(this.fieldName);
        legendTypeAttr.setValue(this.legendType.toString());
        shapeTypeAttr.setValue(this.shapeType.toString());
        breakNumAttr.setValue(String.valueOf(this.getBreakNum()));
        hasNoDataAttr.setValue(String.valueOf(this.hasNoData));
        minValueAttr.setValue(String.valueOf(this.minValue));
        maxValueAttr.setValue(String.valueOf(this.maxValue));
        undefAttr.setValue(String.valueOf(this.undef));
        root.setAttributeNode(fieldNameAttr);
        root.setAttributeNode(legendTypeAttr);
        root.setAttributeNode(shapeTypeAttr);
        root.setAttributeNode(breakNumAttr);
        root.setAttributeNode(hasNoDataAttr);
        root.setAttributeNode(minValueAttr);
        root.setAttributeNode(maxValueAttr);
        root.setAttributeNode(undefAttr);
        Element breaks = doc.createElement("Breaks");
        switch (this.shapeType) {
            case POINT: 
            case POINT_Z: {
                for (ColorBreak aCB : this.legendBreaks) {
                    PointBreak aPB = (PointBreak)aCB;
                    Element brk = doc.createElement("Break");
                    Attr caption = doc.createAttribute("Caption");
                    Attr startValue = doc.createAttribute("StartValue");
                    Attr endValue = doc.createAttribute("EndValue");
                    Attr color = doc.createAttribute("Color");
                    Attr drawShape = doc.createAttribute("DrawShape");
                    Attr outlineColor = doc.createAttribute("OutlineColor");
                    Attr outlineSize = doc.createAttribute("OutlineSize");
                    Attr size = doc.createAttribute("Size");
                    Attr style = doc.createAttribute("Style");
                    Attr drawOutline = doc.createAttribute("DrawOutline");
                    Attr drawFill = doc.createAttribute("DrawFill");
                    Attr isNoData = doc.createAttribute("IsNoData");
                    Attr markerType = doc.createAttribute("MarkerType");
                    Attr fontName = doc.createAttribute("FontName");
                    Attr charIndex = doc.createAttribute("CharIndex");
                    Attr imagePath = doc.createAttribute("ImagePath");
                    Attr angle = doc.createAttribute("Angle");
                    Attr tagAttr = doc.createAttribute("Tag");
                    caption.setValue(aPB.getCaption());
                    startValue.setValue(String.valueOf(aPB.getStartValue()));
                    endValue.setValue(String.valueOf(aPB.getEndValue()));
                    color.setValue(ColorUtil.toHexEncoding((Color)aPB.getColor()));
                    drawShape.setValue(String.valueOf(aPB.isDrawShape()));
                    outlineColor.setValue(ColorUtil.toHexEncoding((Color)aPB.getOutlineColor()));
                    outlineSize.setValue(String.valueOf(aPB.getOutlineSize()));
                    size.setValue(String.valueOf(aPB.getSize()));
                    style.setValue(aPB.getStyle().toString());
                    drawOutline.setValue(String.valueOf(aPB.isDrawOutline()));
                    drawFill.setValue(String.valueOf(aPB.isDrawFill()));
                    isNoData.setValue(String.valueOf(aPB.isNoData()));
                    markerType.setValue(aPB.getMarkerType().toString());
                    fontName.setValue(aPB.getFontName());
                    charIndex.setValue(String.valueOf(aPB.getCharIndex()));
                    imagePath.setValue(aPB.getImagePath());
                    angle.setValue(String.valueOf(aPB.getAngle()));
                    tagAttr.setValue(aPB.getTag());
                    brk.setAttributeNode(caption);
                    brk.setAttributeNode(startValue);
                    brk.setAttributeNode(endValue);
                    brk.setAttributeNode(color);
                    brk.setAttributeNode(drawShape);
                    brk.setAttributeNode(outlineColor);
                    brk.setAttributeNode(outlineSize);
                    brk.setAttributeNode(size);
                    brk.setAttributeNode(style);
                    brk.setAttributeNode(drawOutline);
                    brk.setAttributeNode(drawFill);
                    brk.setAttributeNode(isNoData);
                    brk.setAttributeNode(markerType);
                    brk.setAttributeNode(fontName);
                    brk.setAttributeNode(charIndex);
                    brk.setAttributeNode(imagePath);
                    brk.setAttributeNode(angle);
                    brk.setAttributeNode(tagAttr);
                    breaks.appendChild(brk);
                }
                break;
            }
            case POLYLINE: 
            case POLYLINE_Z: {
                for (ColorBreak aCB : this.legendBreaks) {
                    PolylineBreak aPLB = (PolylineBreak)aCB;
                    Element brk = doc.createElement("Break");
                    Attr caption = doc.createAttribute("Caption");
                    Attr startValue = doc.createAttribute("StartValue");
                    Attr endValue = doc.createAttribute("EndValue");
                    Attr color = doc.createAttribute("Color");
                    Attr drawShape = doc.createAttribute("DrawShape");
                    Attr size = doc.createAttribute("Size");
                    Attr style = doc.createAttribute("Style");
                    Attr drawSymbol = doc.createAttribute("DrawSymbol");
                    Attr symbolSize = doc.createAttribute("SymbolSize");
                    Attr symbolStyle = doc.createAttribute("SymbolStyle");
                    Attr symbolColor = doc.createAttribute("SymbolColor");
                    Attr symbolInterval = doc.createAttribute("SymbolInterval");
                    Attr fillSymbol = doc.createAttribute("FillSymbol");
                    Attr symbolFillColor = doc.createAttribute("SymbolFillColor");
                    Attr tagAttr = doc.createAttribute("Tag");
                    caption.setValue(aPLB.getCaption());
                    startValue.setValue(String.valueOf(aPLB.getStartValue()));
                    endValue.setValue(String.valueOf(aPLB.getEndValue()));
                    color.setValue(ColorUtil.toHexEncoding((Color)aPLB.getColor()));
                    drawShape.setValue(String.valueOf(aPLB.isDrawShape()));
                    size.setValue(String.valueOf(aPLB.getWidth()));
                    style.setValue(aPLB.getStyle().toString());
                    drawSymbol.setValue(String.valueOf(aPLB.getDrawSymbol()));
                    symbolSize.setValue(String.valueOf(aPLB.getSymbolSize()));
                    symbolStyle.setValue(aPLB.getSymbolStyle().toString());
                    symbolColor.setValue(ColorUtil.toHexEncoding((Color)aPLB.getSymbolColor()));
                    symbolInterval.setValue(String.valueOf(aPLB.getSymbolInterval()));
                    fillSymbol.setValue(String.valueOf(aPLB.isFillSymbol()));
                    symbolFillColor.setValue(ColorUtil.toHexEncoding((Color)aPLB.getSymbolFillColor()));
                    tagAttr.setValue(aPLB.getTag());
                    brk.setAttributeNode(caption);
                    brk.setAttributeNode(startValue);
                    brk.setAttributeNode(endValue);
                    brk.setAttributeNode(color);
                    brk.setAttributeNode(drawShape);
                    brk.setAttributeNode(size);
                    brk.setAttributeNode(style);
                    brk.setAttributeNode(drawSymbol);
                    brk.setAttributeNode(symbolSize);
                    brk.setAttributeNode(symbolStyle);
                    brk.setAttributeNode(symbolColor);
                    brk.setAttributeNode(symbolInterval);
                    brk.setAttributeNode(fillSymbol);
                    brk.setAttributeNode(symbolFillColor);
                    brk.setAttributeNode(tagAttr);
                    breaks.appendChild(brk);
                }
                break;
            }
            case POLYGON: 
            case POLYGON_M: 
            case POLYGON_Z: {
                for (ColorBreak aCB : this.legendBreaks) {
                    PolygonBreak aPGB = (PolygonBreak)aCB;
                    Element brk = doc.createElement("Break");
                    Attr caption = doc.createAttribute("Caption");
                    Attr startValue = doc.createAttribute("StartValue");
                    Attr endValue = doc.createAttribute("EndValue");
                    Attr color = doc.createAttribute("Color");
                    Attr drawShape = doc.createAttribute("DrawShape");
                    Attr outlineColor = doc.createAttribute("OutlineColor");
                    Attr drawOutline = doc.createAttribute("DrawOutline");
                    Attr drawFill = doc.createAttribute("DrawFill");
                    Attr outlineSize = doc.createAttribute("OutlineSize");
                    Attr style = doc.createAttribute("Style");
                    Attr styleSize = doc.createAttribute("StyleSize");
                    Attr backColor = doc.createAttribute("BackColor");
                    Attr tagAttr = doc.createAttribute("Tag");
                    caption.setValue(aPGB.getCaption());
                    startValue.setValue(String.valueOf(aPGB.getStartValue()));
                    endValue.setValue(String.valueOf(aPGB.getEndValue()));
                    color.setValue(ColorUtil.toHexEncoding((Color)aPGB.getColor()));
                    drawShape.setValue(String.valueOf(aPGB.isDrawShape()));
                    outlineColor.setValue(ColorUtil.toHexEncoding((Color)aPGB.getOutlineColor()));
                    drawOutline.setValue(String.valueOf(aPGB.isDrawOutline()));
                    drawFill.setValue(String.valueOf(aPGB.isDrawFill()));
                    outlineSize.setValue(String.valueOf(aPGB.getOutlineSize()));
                    style.setValue(aPGB.getStyle().toString());
                    styleSize.setValue(String.valueOf(aPGB.getStyleSize()));
                    backColor.setValue(ColorUtil.toHexEncoding((Color)aPGB.getBackColor()));
                    tagAttr.setValue(aPGB.getTag());
                    brk.setAttributeNode(caption);
                    brk.setAttributeNode(startValue);
                    brk.setAttributeNode(endValue);
                    brk.setAttributeNode(color);
                    brk.setAttributeNode(drawShape);
                    brk.setAttributeNode(outlineColor);
                    brk.setAttributeNode(drawOutline);
                    brk.setAttributeNode(drawFill);
                    brk.setAttributeNode(outlineSize);
                    brk.setAttributeNode(style);
                    brk.setAttributeNode(styleSize);
                    brk.setAttributeNode(backColor);
                    brk.setAttributeNode(tagAttr);
                    breaks.appendChild(brk);
                }
                break;
            }
            case IMAGE: {
                for (ColorBreak aCB : this.legendBreaks) {
                    Element brk = doc.createElement("Break");
                    Attr caption = doc.createAttribute("Caption");
                    Attr startValue = doc.createAttribute("StartValue");
                    Attr endValue = doc.createAttribute("EndValue");
                    Attr color = doc.createAttribute("Color");
                    Attr isNoData = doc.createAttribute("IsNoData");
                    Attr tagAttr = doc.createAttribute("Tag");
                    caption.setValue(aCB.getCaption());
                    startValue.setValue(String.valueOf(aCB.getStartValue()));
                    endValue.setValue(String.valueOf(aCB.getEndValue()));
                    color.setValue(ColorUtil.toHexEncoding((Color)aCB.getColor()));
                    isNoData.setValue(String.valueOf(aCB.isNoData()));
                    tagAttr.setValue(aCB.getTag());
                    brk.setAttributeNode(caption);
                    brk.setAttributeNode(startValue);
                    brk.setAttributeNode(endValue);
                    brk.setAttributeNode(color);
                    brk.setAttributeNode(isNoData);
                    brk.setAttributeNode(tagAttr);
                    breaks.appendChild(brk);
                }
                break;
            }
        }
        root.appendChild(breaks);
        parent.appendChild(root);
    }

    public void exportToXMLFile(String aFile) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("MeteoInfo");
        File af = new File(aFile);
        Attr fn = doc.createAttribute("File");
        Attr type = doc.createAttribute("Type");
        fn.setValue(af.getName());
        type.setValue("LegendScheme");
        root.setAttributeNode(fn);
        root.setAttributeNode(type);
        doc.appendChild(root);
        this.exportToXML(doc, root);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            PrintWriter pw = new PrintWriter(new FileOutputStream(aFile));
            StreamResult result = new StreamResult(pw);
            transformer.transform(source, result);
        }
        catch (IOException | TransformerException exception) {
            // empty catch block
        }
    }

    public void importFromXML(Node LSNode) {
        this.importFromXML(LSNode, true);
    }

    public void importFromXML(Node LSNode, boolean keepShape) {
        this.legendBreaks = new ArrayList<ColorBreak>();
        if (LSNode.getAttributes().getNamedItem("FieldName") != null) {
            this.fieldName = LSNode.getAttributes().getNamedItem("FieldName").getNodeValue();
        }
        this.legendType = LegendType.valueOfBack(LSNode.getAttributes().getNamedItem("LegendType").getNodeValue());
        ShapeTypes aShapeType = ShapeTypes.valueOfBack(LSNode.getAttributes().getNamedItem("ShapeType").getNodeValue());
        this.hasNoData = Boolean.parseBoolean(LSNode.getAttributes().getNamedItem("HasNoData").getNodeValue());
        this.minValue = Double.parseDouble(LSNode.getAttributes().getNamedItem("MinValue").getNodeValue());
        this.maxValue = Double.parseDouble(LSNode.getAttributes().getNamedItem("MaxValue").getNodeValue());
        this.undef = Double.parseDouble(LSNode.getAttributes().getNamedItem("UNDEF").getNodeValue());
        if (!keepShape) {
            this.shapeType = aShapeType;
        }
        boolean sameShapeType = this.shapeType.isSameLegendType(aShapeType);
        this.importBreaks(LSNode, sameShapeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importBreaks(Node parent, boolean sameShapeType) {
        block64: {
            NodeList breaks;
            block63: {
                Node breaksNode = ((Element)parent).getElementsByTagName("Breaks").item(0);
                breaks = ((Element)breaksNode).getElementsByTagName("Break");
                if (!sameShapeType) break block63;
                switch (this.shapeType) {
                    case POINT: {
                        for (int i = 0; i < breaks.getLength(); ++i) {
                            Node brk = breaks.item(i);
                            PointBreak aPB = new PointBreak();
                            try {
                                aPB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                                aPB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                                aPB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                                aPB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                                aPB.setDrawShape(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                                aPB.setDrawFill(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawFill").getNodeValue()));
                                aPB.setDrawOutline(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawOutline").getNodeValue()));
                                aPB.setNoData(Boolean.parseBoolean(brk.getAttributes().getNamedItem("IsNoData").getNodeValue()));
                                aPB.setOutlineColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("OutlineColor").getNodeValue()));
                                aPB.setSize(Float.parseFloat(brk.getAttributes().getNamedItem("Size").getNodeValue()));
                                aPB.setStyle(PointStyle.valueOfBack(brk.getAttributes().getNamedItem("Style").getNodeValue()));
                                aPB.setMarkerType(MarkerType.valueOfBack(brk.getAttributes().getNamedItem("MarkerType").getNodeValue()));
                                aPB.setFontName(brk.getAttributes().getNamedItem("FontName").getNodeValue());
                                aPB.setCharIndex(Integer.parseInt(brk.getAttributes().getNamedItem("CharIndex").getNodeValue()));
                                aPB.setImagePath(brk.getAttributes().getNamedItem("ImagePath").getNodeValue());
                                aPB.setAngle(Float.parseFloat(brk.getAttributes().getNamedItem("Angle").getNodeValue()));
                                if (brk.getAttributes().getNamedItem("Tag") != null) {
                                    aPB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                                }
                                if (brk.getAttributes().getNamedItem("OutlineSize") == null) continue;
                                aPB.setOutlineSize(Float.parseFloat(brk.getAttributes().getNamedItem("OutlineSize").getNodeValue()));
                                continue;
                            }
                            catch (NumberFormatException | DOMException runtimeException) {
                                continue;
                            }
                            finally {
                                this.legendBreaks.add(aPB);
                            }
                        }
                        break block64;
                    }
                    case POLYLINE: 
                    case POLYLINE_Z: {
                        for (int i = 0; i < breaks.getLength(); ++i) {
                            Node brk = breaks.item(i);
                            PolylineBreak aPLB = new PolylineBreak();
                            try {
                                aPLB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                                aPLB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                                aPLB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                                aPLB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                                aPLB.setDrawPolyline(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                                aPLB.setWidth(Float.parseFloat(brk.getAttributes().getNamedItem("Size").getNodeValue()));
                                aPLB.setStyle(LineStyles.valueOfBack(brk.getAttributes().getNamedItem("Style").getNodeValue().toUpperCase()));
                                aPLB.setDrawSymbol(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawSymbol").getNodeValue()));
                                aPLB.setSymbolSize(Float.parseFloat(brk.getAttributes().getNamedItem("SymbolSize").getNodeValue()));
                                aPLB.setSymbolStyle(PointStyle.valueOfBack(brk.getAttributes().getNamedItem("SymbolStyle").getNodeValue()));
                                aPLB.setSymbolColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("SymbolColor").getNodeValue()));
                                aPLB.setSymbolInterval(Integer.parseInt(brk.getAttributes().getNamedItem("SymbolInterval").getNodeValue()));
                                if (brk.getAttributes().getNamedItem("FillSymbol") != null) {
                                    aPLB.setFillSymbol(Boolean.parseBoolean(brk.getAttributes().getNamedItem("FillSymbol").getNodeValue()));
                                    aPLB.setSymbolFillColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("SymbolFillColor").getNodeValue()));
                                }
                                if (brk.getAttributes().getNamedItem("Tag") == null) continue;
                                aPLB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            finally {
                                this.legendBreaks.add(aPLB);
                            }
                        }
                        break block64;
                    }
                    case POLYGON: 
                    case POLYGON_M: 
                    case POLYGON_Z: {
                        for (int i = 0; i < breaks.getLength(); ++i) {
                            Node brk = breaks.item(i);
                            PolygonBreak aPGB = new PolygonBreak();
                            try {
                                aPGB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                                aPGB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                                aPGB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                                aPGB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                                aPGB.setDrawShape(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                                aPGB.setDrawFill(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawFill").getNodeValue()));
                                aPGB.setDrawOutline(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawOutline").getNodeValue()));
                                aPGB.setOutlineSize(Float.parseFloat(brk.getAttributes().getNamedItem("OutlineSize").getNodeValue()));
                                aPGB.setOutlineColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("OutlineColor").getNodeValue()));
                                aPGB.setStyle(HatchStyle.valueOf(brk.getAttributes().getNamedItem("Style").getNodeValue()));
                                aPGB.setBackColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("BackColor").getNodeValue()));
                                if (brk.getAttributes().getNamedItem("Tag") != null) {
                                    aPGB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                                }
                                aPGB.setStyleSize(Integer.parseInt(brk.getAttributes().getNamedItem("StyleSize").getNodeValue()));
                                continue;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            finally {
                                this.legendBreaks.add(aPGB);
                            }
                        }
                        break block64;
                    }
                    case IMAGE: {
                        for (int i = 0; i < breaks.getLength(); ++i) {
                            Node brk = breaks.item(i);
                            ColorBreak aCB = new ColorBreak();
                            try {
                                aCB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                                aCB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                                aCB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                                aCB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                                aCB.setDrawShape(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                                aCB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                                continue;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            finally {
                                this.legendBreaks.add(aCB);
                            }
                        }
                        break;
                    }
                }
                break block64;
            }
            switch (this.shapeType) {
                case POINT: {
                    for (int i = 0; i < breaks.getLength(); ++i) {
                        Node brk = breaks.item(i);
                        PointBreak aPB = new PointBreak();
                        try {
                            aPB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                            aPB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                            aPB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                            aPB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                            aPB.setDrawShape(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                            aPB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        finally {
                            this.legendBreaks.add(aPB);
                        }
                    }
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: {
                    for (int i = 0; i < breaks.getLength(); ++i) {
                        Node brk = breaks.item(i);
                        PolylineBreak aPLB = new PolylineBreak();
                        try {
                            if ("NoData".equals(brk.getAttributes().getNamedItem("Caption").getNodeValue())) continue;
                            aPLB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                            aPLB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                            aPLB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                            aPLB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                            aPLB.setDrawPolyline(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                            aPLB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        finally {
                            this.legendBreaks.add(aPLB);
                        }
                    }
                    break;
                }
                case POLYGON: {
                    for (int i = 0; i < breaks.getLength(); ++i) {
                        Node brk = breaks.item(i);
                        PolygonBreak aPGB = new PolygonBreak();
                        try {
                            if ("NoData".equals(brk.getAttributes().getNamedItem("Caption").getNodeValue())) continue;
                            aPGB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                            aPGB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                            aPGB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                            aPGB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                            aPGB.setDrawShape(Boolean.parseBoolean(brk.getAttributes().getNamedItem("DrawShape").getNodeValue()));
                            aPGB.setDrawFill(true);
                            aPGB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        finally {
                            this.legendBreaks.add(aPGB);
                        }
                    }
                    break;
                }
                case IMAGE: {
                    for (int i = 0; i < breaks.getLength(); ++i) {
                        Node brk = breaks.item(i);
                        ColorBreak aCB = new ColorBreak();
                        try {
                            aCB.setCaption(brk.getAttributes().getNamedItem("Caption").getNodeValue());
                            aCB.setStartValue(brk.getAttributes().getNamedItem("StartValue").getNodeValue());
                            aCB.setEndValue(brk.getAttributes().getNamedItem("EndValue").getNodeValue());
                            aCB.setColor(ColorUtil.parseToColor((String)brk.getAttributes().getNamedItem("Color").getNodeValue()));
                            aCB.setTag(brk.getAttributes().getNamedItem("Tag").getNodeValue());
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        finally {
                            this.legendBreaks.add(aCB);
                        }
                    }
                    break;
                }
            }
        }
    }

    public void importFromXMLFile(String aFile) throws ParserConfigurationException, SAXException, IOException {
        this.importFromXMLFile(aFile, true);
    }

    public void importFromXMLFile(String aFile, boolean keepShape) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(aFile));
        Element root = doc.getDocumentElement();
        Node LSNode = "MeteoInfo".equals(root.getNodeName()) ? root.getElementsByTagName("LegendScheme").item(0) : root;
        this.importFromXML(LSNode, keepShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromPaletteFile_Unique(String filePath) {
        BufferedReader sr = null;
        try {
            File aFile = new File(filePath);
            sr = new BufferedReader(new FileReader(aFile));
            this.shapeType = ShapeTypes.IMAGE;
            this.legendType = LegendType.UNIQUE_VALUE;
            this.legendBreaks = new ArrayList<ColorBreak>();
            sr.readLine();
            String aLine = sr.readLine();
            while (aLine != null) {
                if ((aLine = aLine.trim()).isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                String[] dataArray = aLine.split("\\s+");
                Color aColor = new Color(Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[1]));
                ColorBreak aCB = new ColorBreak();
                aCB.setColor(aColor);
                aCB.setStartValue(dataArray[0]);
                aCB.setEndValue(dataArray[0]);
                aCB.setCaption(String.valueOf(aCB.getStartValue()));
                this.legendBreaks.add(aCB);
                aLine = sr.readLine();
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(LegendScheme.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LegendScheme.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromPaletteFile_Graduated(String filePath) {
        BufferedReader sr = null;
        try {
            ColorBreak aCB;
            File aFile = new File(filePath);
            sr = new BufferedReader(new FileReader(aFile));
            this.shapeType = ShapeTypes.IMAGE;
            this.legendType = LegendType.GRADUATED_COLOR;
            this.legendBreaks = new ArrayList<ColorBreak>();
            ArrayList<Color> colorList = new ArrayList<Color>();
            ArrayList<Integer> values = new ArrayList<Integer>();
            sr.readLine();
            String aLine = sr.readLine();
            while (aLine != null) {
                String[] dataArray = aLine.split("\\s+");
                Color aColor = new Color(Integer.parseInt(dataArray[3]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[1]));
                if (colorList.isEmpty()) {
                    colorList.add(aColor);
                } else if (!colorList.contains(aColor)) {
                    aCB = new ColorBreak();
                    aCB.setColor(aColor);
                    aCB.setStartValue(Collections.min(values));
                    aCB.setEndValue(Collections.max(values));
                    if (String.valueOf(aCB.getStartValue()).equals(String.valueOf(aCB.getEndValue()))) {
                        aCB.setCaption(String.valueOf(aCB.getStartValue()));
                    } else if (this.legendBreaks.isEmpty()) {
                        aCB.setCaption("< " + String.valueOf(aCB.getEndValue()));
                    } else {
                        aCB.setCaption(String.valueOf(aCB.getStartValue()) + " - " + String.valueOf(aCB.getEndValue()));
                    }
                    this.legendBreaks.add(aCB);
                    values.clear();
                    colorList.add(aColor);
                }
                values.add(Integer.parseInt(dataArray[0]));
                aLine = sr.readLine();
            }
            sr.close();
            aCB = new ColorBreak();
            aCB.setColor((Color)colorList.get(colorList.size() - 1));
            aCB.setStartValue(Collections.min(values));
            aCB.setEndValue(Collections.max(values));
            aCB.setCaption("> " + String.valueOf(aCB.getStartValue()));
            this.legendBreaks.add(aCB);
        }
        catch (IOException ex) {
            Logger.getLogger(LegendScheme.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LegendScheme.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Object clone() {
        LegendScheme bLS = new LegendScheme(this.shapeType);
        bLS.setFieldName(this.fieldName);
        bLS.setHasNoData(this.hasNoData);
        bLS.setLegendType(this.legendType);
        bLS.setMinValue(this.minValue);
        bLS.setMaxValue(this.maxValue);
        bLS.setUndefValue(this.undef);
        for (ColorBreak aCB : this.legendBreaks) {
            bLS.getLegendBreaks().add((ColorBreak)aCB.clone());
        }
        return bLS;
    }
}

