/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class RectangleShape
extends PolygonShape {
    private boolean round = false;
    private double roundX = 0.0;
    private double roundY = 0.0;
    private double angle = 0.0;

    public RectangleShape() {
    }

    public RectangleShape(double x, double y, double width, double height) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x, y));
        points.add(new PointD(x, y + height));
        points.add(new PointD(x + width, y + height));
        points.add(new PointD(x + width, y));
        this.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.RECTANGLE;
    }

    public boolean isRound() {
        return this.round;
    }

    public double getRoundX() {
        return this.roundX;
    }

    public void setRoundX(double value) {
        this.roundX = value;
        this.round = true;
    }

    public double getRoundY() {
        return this.roundY;
    }

    public void setRoundY(double value) {
        this.roundY = value;
        this.round = true;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double value) {
        this.angle = value;
    }

    @Override
    public Object clone() {
        RectangleShape aPGS = new RectangleShape();
        aPGS.setExtent(this.getExtent());
        aPGS.setPoints(new ArrayList<PointD>(this.getPoints()));
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        aPGS.round = this.round;
        aPGS.roundX = this.roundX;
        aPGS.roundY = this.roundY;
        return aPGS;
    }
}

