/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import org.meteoinfo.geometry.colors.ExtendType;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class BoundaryNorm
extends Normalize {
    private Array boundaries;
    private int nColors;
    private int size;
    private int nRegions;
    private int offset;
    private ExtendType extendType;

    public BoundaryNorm(Array boundaries, int nColors, ExtendType extendType) {
        boundaries = boundaries.copyIfView();
        this.setMinValue(boundaries.getDouble(0));
        this.setMaxValue(boundaries.getDouble((int)boundaries.getSize() - 1));
        this.boundaries = boundaries;
        this.nColors = nColors;
        this.size = (int)this.boundaries.getSize();
        this.extendType = extendType;
        this.nRegions = this.size - 1;
        this.offset = 0;
        switch (this.extendType) {
            case MIN: {
                ++this.nRegions;
                this.offset = 1;
                break;
            }
            case MAX: {
                ++this.nRegions;
                break;
            }
            case BOTH: {
                this.nRegions += 2;
                this.offset = 1;
            }
        }
    }

    public int getNRegions() {
        return this.nRegions;
    }

    @Override
    public Number apply(double v) {
        int idx = ArrayUtil.searchSorted((Array)this.boundaries, (Number)v, (boolean)true) - 1 + this.offset;
        return idx;
    }

    @Override
    public Array apply(Array a) {
        Array r = ArrayUtil.searchSorted((Array)this.boundaries, (Array)a, (boolean)false);
        r = ArrayMath.add((Array)r, (Number)(this.offset - 1));
        return r;
    }

    @Override
    public double inverse(double v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array inverse(Array a) {
        throw new UnsupportedOperationException();
    }
}

