/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.EllipseShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class ArcShape
extends EllipseShape {
    private float startAngle;
    private float sweepAngle;
    private float explode = 0.0f;
    private Float wedgeWidth = null;

    public ArcShape() {
    }

    public ArcShape(double x, double y, double width, double height) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x - width * 0.5, y - height * 0.5));
        points.add(new PointD(x - width * 0.5, y + height * 0.5));
        points.add(new PointD(x + width * 0.5, y + height * 0.5));
        points.add(new PointD(x + width * 0.5, y - height * 0.5));
        super.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.ARC;
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(float value) {
        this.startAngle = value;
    }

    public float getSweepAngle() {
        return this.sweepAngle;
    }

    public void setSweepAngle(float value) {
        this.sweepAngle = value;
    }

    public float getExplode() {
        return this.explode;
    }

    public void setExplode(float value) {
        this.explode = value;
    }

    public Float getWedgeWidth() {
        return this.wedgeWidth;
    }

    public void setWedgeWidth(Float value) {
        this.wedgeWidth = value;
    }

    @Override
    public boolean contains(PointD p) {
        PointD center = this.getCenter();
        double a = this.getA();
        double b = this.getB();
        double r = Math.pow(p.X - center.X, 2.0) / Math.pow(a, 2.0) + Math.pow(p.Y - center.Y, 2.0) / Math.pow(b, 2.0);
        if (r > 1.0) {
            return false;
        }
        double angle = Math.toDegrees(Math.atan2(p.Y - center.Y, p.X - center.X));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle >= (double)this.startAngle && angle <= (double)(this.startAngle + this.sweepAngle);
    }

    @Override
    public Object clone() {
        ArcShape aPGS = new ArcShape();
        aPGS.setExtent(this.getExtent());
        aPGS.setPoints(new ArrayList<PointD>(this.getPoints()));
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        return aPGS;
    }
}

