/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PointShape
extends Shape
implements Cloneable {
    protected PointD point = new PointD();

    public PointShape() {
    }

    public PointShape(PointD point) {
        this.setPoint(point);
    }

    public PointShape(Geometry geometry) {
        Coordinate c = geometry.getCoordinate();
        this.setPoint(new PointD(c.x, c.y));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POINT;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        Coordinate c = new Coordinate(this.point.X, this.point.Y);
        return factory.createPoint(c);
    }

    public PointD getPoint() {
        return this.point;
    }

    public void setPoint(PointD aPoint) {
        this.point = aPoint;
        Extent aExtent = new Extent();
        aExtent.minX = this.point.X;
        aExtent.maxX = this.point.X;
        aExtent.minY = this.point.Y;
        aExtent.maxY = this.point.Y;
        this.setExtent(aExtent);
    }

    public List<PointD> getPoints() {
        ArrayList<PointD> pList = new ArrayList<PointD>();
        pList.add(this.point);
        return pList;
    }

    @Override
    public void setPoints(List<? extends PointD> points) {
        this.setPoint(points.get(0));
    }

    public Object clone_back() {
        PointShape o = (PointShape)super.clone();
        return o;
    }

    @Override
    public Object clone() {
        PointShape ps = new PointShape();
        ps.setValue(this.getValue());
        ps.setPoint((PointD)this.point.clone());
        ps.setVisible(this.isVisible());
        ps.setSelected(this.isSelected());
        ps.setLegendIndex(this.getLegendIndex());
        return ps;
    }
}

