/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;

public class Polygon {
    private List<? extends PointD> _outLine = new ArrayList<PointD>();
    private List<List<? extends PointD>> _holeLines = new ArrayList<List<? extends PointD>>();
    private Extent _extent;

    public List<? extends PointD> getOutLine() {
        return this._outLine;
    }

    public void setOutLine(List<? extends PointD> outLine) {
        this._outLine = outLine;
        this._extent = GeometryUtil.getPointsExtent(outLine);
    }

    public List<List<? extends PointD>> getHoleLines() {
        return this._holeLines;
    }

    public List<List<? extends PointD>> getHoleLines_bak() {
        ArrayList<List<? extends PointD>> hlines = new ArrayList<List<? extends PointD>>();
        for (List<? extends PointD> hline : this._holeLines) {
            hlines.add(hline);
        }
        return hlines;
    }

    public List<? extends PointD> getHoleLine(int idx) {
        return this._holeLines.get(idx);
    }

    public void setHoleLines(List<List<? extends PointD>> holeLines) {
        this._holeLines = holeLines;
    }

    public void setHoleLine(int idx, List<? extends PointD> holeLine) {
        if (GeoComputation.isClockwise(holeLine)) {
            Collections.reverse(holeLine);
        }
        this._holeLines.set(idx, holeLine);
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(Extent extent) {
        this._extent = extent;
    }

    public List<List<? extends PointD>> getRings() {
        ArrayList<List<? extends PointD>> rings = new ArrayList<List<? extends PointD>>();
        rings.add(this._outLine);
        if (this.hasHole()) {
            rings.addAll(this.getHoleLines());
        }
        return rings;
    }

    public boolean hasHole() {
        return this._holeLines.size() > 0;
    }

    public int getHoleLineNumber() {
        return this._holeLines.size();
    }

    public int getRingNumber() {
        return this._holeLines.size() + 1;
    }

    public void addHole(List<? extends PointD> points) {
        if (GeoComputation.isClockwise(points)) {
            Collections.reverse(points);
        }
        this._holeLines.add(points);
    }

    public void removeHole(int holeIdx) {
        this._holeLines.remove(holeIdx);
    }

    public Geometry toGeometry(GeometryFactory factory) {
        PointD p;
        Coordinate[] cs = new Coordinate[this._outLine.size()];
        for (int i = 0; i < cs.length; ++i) {
            p = this._outLine.get(i);
            cs[i] = new Coordinate(p.X, p.Y);
        }
        if (!cs[0].equals((Object)cs[cs.length - 1])) {
            cs = (Coordinate[])DataConvert.resizeArray((Object)cs, (int)(cs.length + 1));
            cs[cs.length - 1] = (Coordinate)cs[0].clone();
        }
        LinearRing shell = factory.createLinearRing(cs);
        LinearRing[] holes = new LinearRing[this._holeLines.size()];
        for (int j = 0; j < holes.length; ++j) {
            List<? extends PointD> hole = this._holeLines.get(j);
            cs = new Coordinate[hole.size()];
            for (int i = 0; i < hole.size(); ++i) {
                p = hole.get(i);
                cs[i] = new Coordinate(p.X, p.Y);
            }
            if (!cs[0].equals((Object)cs[cs.length - 1])) {
                cs = (Coordinate[])DataConvert.resizeArray((Object)cs, (int)(cs.length + 1));
                cs[cs.length - 1] = (Coordinate)cs[0].clone();
            }
            holes[j] = factory.createLinearRing(cs);
        }
        return factory.createPolygon(shell, holes);
    }
}

